<?php

/******************************************************************************
 *  
 *  PROJECT: Flynax Classifieds Software
 *  VERSION: 4.10.1
 *  LICENSE: FL08NX2XACC0 - https://www.flynax.com/flynax-software-eula.html
 *  PRODUCT: Real Estate Classifieds
 *  DOMAIN: saikunghouse.com
 *  FILE: RLYOOMONEY.CLASS.PHP
 *  
 *  The software is a commercial product delivered under single, non-exclusive,
 *  non-transferable license for one domain or IP address. Therefore distribution,
 *  sale or transfer of the file in whole or in part without permission of Flynax
 *  respective owners is considered to be illegal and breach of Flynax License End
 *  User Agreement.
 *  
 *  You are not allowed to remove this information from the file without permission
 *  of Flynax respective owners.
 *  
 *  Flynax Classifieds Software 2026 | All copyrights reserved.
 *  
 *  https://www.flynax.com
 ******************************************************************************/

/**
 * YooMoney payment gateway class
 * @since 4.9.2
 */
class rlYoomoney extends rlGateway
{
    /**
     * API host
     *
     * @var string
     */
    protected $api_host;

    /**
     * Class constructor
     */
    public function __construct()
    {
        $this->api_host = 'https://yoomoney.ru/quickpay/confirm.xml';
    }

    /**
     * Start payment process
     */
    public function call()
    {
        global $rlPayment, $config;

        $this->setOption('receiver', $config['yoomoney_receiver_id']);
        $this->setOption('quickpay-form', 'button');
        $this->setOption('paymentType', 'AC');
        $this->setOption('label', $rlPayment->buildItemData(false, false));
        $this->setOption('sum', $rlPayment->getOption('total'));

        $success_url = $rlPayment->getOption('success_url');
        $success_url = $success_url ?: $rlPayment->getDefaultSuccessURL();
        $this->setOption('successURL', $success_url);

        $this->buildPage();
    }

    /**
     * Complete payment process
     */
    public function callBack()
    {
        global $rlValid, $rlPayment, $rlDebug;

        if (!$_REQUEST['sha1_hash']) {
            $rlDebug->logger('YooMoney: There is no sha1_hash parameter found in the response');
            return;
        }

        if (!$_REQUEST['label']) {
            $rlDebug->logger('YooMoney: There is no label parameter found in the response');
            return;
        }

        $sha1 = $_REQUEST['notification_type']
            . '&' . $_REQUEST['operation_id']
            . '&' . $_REQUEST['amount']
            . '&' . $_REQUEST['currency']
            . '&' . $_REQUEST['datetime']
            . '&' . $_REQUEST['sender']
            . '&' . $_REQUEST['codepro']
            . '&' . $GLOBALS['config']['yoomoney_secret']
            . '&' . $_REQUEST['label'];

        if ($_REQUEST['sha1_hash'] == sha1($sha1)) {
            $items = explode('|', $_REQUEST['label']);
            $txn_id = (int) $items[10];
            $total = (float) $_REQUEST['withdraw_amount'];
            $txn_gateway = $rlValid->xSql($_REQUEST['operation_id']);

            $response = array(
                'plan_id'     => $rlValid->xSql($items[0]),
                'item_id'     => $rlValid->xSql($items[1]),
                'account_id'  => $rlValid->xSql($items[2]),
                'total'       => $total,
                'txn_id'      => $txn_id,
                'txn_gateway' => $txn_gateway,
                'params'      => $items[12],
            );

            $rlPayment->complete($response, $items[4], $items[5], $items[9] ?: false);
        } else {
            $rlDebug->logger('YooMoney: Parameter sha1_hash does not equal the sha1 hash generated by us');
        }
    }

    /**
     * Check if yoomoney is configured
     *
     * @return boolean
     */
    public function isConfigured()
    {
        global $config;

        return ($config['yoomoney_receiver_id'] && $config['yoomoney_secret']);
    }
}
