DROP TABLE IF EXISTS `{db_prefix}accounts`;
CREATE TABLE `{db_prefix}accounts` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `Type` varchar(100) NOT NULL DEFAULT '',
  `Plan_ID` int(11) NOT NULL DEFAULT 0,
  `Agency_ID` INT NOT NULL DEFAULT 0,
  `Pay_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `Featured` enum('0','1') NOT NULL DEFAULT '0',
  `Quick` enum('0','1') NOT NULL DEFAULT '0',
  `Username` varchar(255) NOT NULL DEFAULT '',
  `Own_address` varchar(30) NOT NULL,
  `Password` varchar(255) NOT NULL DEFAULT '',
  `Password_hash` varchar(32) NOT NULL,
  `Password_tmp` varchar(50) NOT NULL,
  `Lang` varchar(2) NOT NULL,
  `First_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `Last_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `company_name` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `Mail` varchar(255) NOT NULL DEFAULT '',
  `Mail_tmp` varchar(100) NOT NULL DEFAULT '',
  `Display_email` enum('0','1') NOT NULL DEFAULT '0',
  `Loc_latitude` double NOT NULL,
  `Loc_longitude` double NOT NULL,
  `Loc_address` varchar(150) NOT NULL,
  `Photo` varchar(80) NOT NULL DEFAULT '',
  `Photo_x2` varchar(80) NOT NULL DEFAULT '',
  `Photo_original` VARCHAR(80) NOT NULL DEFAULT '',
  `Listings_count` int(11) NOT NULL DEFAULT 0,
  `Confirm_code` varchar(32) NOT NULL DEFAULT '',
  `Date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `Status` enum('active','approval','incomplete','pending','trash','expired') NOT NULL DEFAULT 'active',
  `country` varchar(255) NOT NULL DEFAULT '',
  `country_level1` varchar(255) NOT NULL,
  `country_level2` varchar(255) NOT NULL,
  `about_me` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `additional_e_mail` varchar(56) NOT NULL,
  `police` enum('0','1') NOT NULL DEFAULT '0',
  `phone` varchar(45) NOT NULL DEFAULT '',
  `website` varchar(50) NOT NULL DEFAULT '',
  `docs` varchar(255) NOT NULL DEFAULT '',
  `zip_code` varchar(8) NOT NULL DEFAULT '',
  `address` varchar(50) NOT NULL DEFAULT '',
  `Last_show` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `Cron` enum('0','1') NOT NULL DEFAULT '0',
  `Cron_notified` enum('0','1') NOT NULL DEFAULT '0',
  `Last_step` varchar(50) NOT NULL DEFAULT '',
  PRIMARY KEY  (`ID`),
  INDEX (`Agency_ID`),
  INDEX (`Username`),
  INDEX (`Mail`),
  INDEX (`Own_address`),
  INDEX (`Type`),
  INDEX (`Date`),
  INDEX (`Status`)
) ENGINE=InnoDB CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `{db_prefix}accounts` (`ID`, `Type`, `Username`, `Own_address`, `Password`, `Lang`, `First_name`, `Last_name`, `Mail`, `Display_email`, `Photo`, `Confirm_code`, `Date`, `Status`) VALUES
(1, 'dealer', '{admin_user}', 'administrator', '{admin_password}', 'en', 'Administrator', '', '{admin_email}', '1', '', '', NOW(), 'active');

DROP TABLE IF EXISTS `{db_prefix}account_fields`;
CREATE TABLE `{db_prefix}account_fields` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `Key` varchar(255) NOT NULL DEFAULT '',
  `Type` enum('bool','text','textarea','number','phone','date','mixed','price','select','radio','checkbox','file','accept','image') NOT NULL DEFAULT 'text',
  `Default` varchar(255) NOT NULL DEFAULT '',
  `Values` mediumtext NOT NULL,
  `Condition` varchar(50) NOT NULL,
  `Multilingual` enum('0','1') NOT NULL DEFAULT '0',
  `Details_page` enum('0','1') NOT NULL DEFAULT '1',
  `Add_page` enum('0','1') NOT NULL DEFAULT '1',
  `Required` enum('0','1') NOT NULL DEFAULT '0',
  `Map` enum('0','1') NOT NULL DEFAULT '0',
  `Opt1` enum('0','1') NOT NULL DEFAULT '0',
  `Opt2` varchar(255) NOT NULL DEFAULT '',
  `Opt3` VARCHAR(255) NOT NULL DEFAULT '0',
  `Autocomplete` enum('0','1') NOT NULL DEFAULT '0',
  `Status` enum('active','approval','trash') NOT NULL DEFAULT 'active',
  `Readonly` enum('0','1') NOT NULL DEFAULT '0',
  `Contact` enum('0','1') NOT NULL DEFAULT '0',
  `Hidden` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `Key` (`Key`),
  KEY `Status` (`Status`),
  KEY `Map` (`Map`)
) ENGINE=InnoDB CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `{db_prefix}account_fields` (`ID`, `Key`, `Type`, `Default`, `Values`, `Condition`, `Multilingual`, `Details_page`, `Add_page`, `Required`, `Map`, `Opt1`, `Opt2`, `Opt3`, `Autocomplete`, `Status`, `Readonly`) VALUES
(1, 'country', 'select', '1', '', 'countries', '0', '1', '1', '0', '1', '0', 0, 0, '1', 'active', '0'),
(3, 'about_me', 'textarea', '', '500', '', '0', '1', '1', '0', '0', '0', 0, 0, '0', 'active', '0'),
(9, 'police', 'accept', 'privacy_policy', '', '', '0', '1', '1', '1', '0', '0', 0, 0, '0', 'active', '0'),
(51, 'country_level1', 'select', '', '', 'countries', '0', '1', '1', '0', '1', '0', 0, 0, '1', 'active', '0'),
(52, 'country_level2', 'select', '', '', 'countries', '0', '1', '1', '0', '1', '0', 0, 0, '1', 'active', '0'),
(16, 'docs', 'file', 'zip', '', '', '0', '1', '1', '0', '0', '0', 0, 0, '0', 'active', '0'),
(25, 'zip_code', 'text', '1', '8', '', '0', '1', '1', '0', '0', '0', 0, 0, '0', 'active', '0'),
(27, 'address', 'text', '1', '50', '', '0', '1', '1', '0', '1', '0', 0, 0, '0', 'active', '0'),
(28, 'phone', 'phone', '3', '7', '1', '0', '1', '1', '1', '0', '1', '', 1, '0', 'active', '0'),
(29, 'additional_e_mail', 'text', '1', '56', 'isEmail', '0', '1', '1', '0', '0', '0', 0, 0, '0', 'active', '0'),
(30, 'website', 'text', '1', '50', 'isUrl', '0', '1', '1', '0', '0', '0', 0, 0, '0', 'active', '0'),
(46, 'First_name', 'text', '1', '50', '', '0', '1', '1', '1', '0', '0', 0, 0, '0', 'active', '1'),
(47, 'Last_name', 'text', '1', '50', '', '0', '1', '1', '1', '0', '0', 0, 0, '0', 'active', '1'),
(48, 'company_name', 'text', '', '50', '', '0', '1', '1', '0', '0', '0', 0, 0, '0', 'active', '1');

DROP TABLE IF EXISTS `{db_prefix}account_search_relations`;
CREATE TABLE `{db_prefix}account_search_relations` (
  `ID` int(6) NOT NULL AUTO_INCREMENT,
  `Position` int(6) NOT NULL,
  `Category_ID` int(3) NOT NULL,
  `Group_ID` int(3) NOT NULL,
  `Field_ID` int(6) NOT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB CHARSET=utf8 COLLATE=utf8_general_ci;

/* Added in 4.9.1 */
DROP TABLE IF EXISTS `{db_prefix}account_grid_form`;
CREATE TABLE `{db_prefix}account_grid_form` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `Position` int(5) NOT NULL,
  `Category_ID` int(3) NOT NULL,
  `Group_ID` int(3) NOT NULL,
  `Field_ID` int(5) NOT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB CHARSET=utf8 COLLATE=utf8_general_ci;

DROP TABLE IF EXISTS `{db_prefix}account_short_form`;
CREATE TABLE `{db_prefix}account_short_form` (
  `ID` int(5) NOT NULL AUTO_INCREMENT,
  `Position` int(5) NOT NULL,
  `Category_ID` int(3) NOT NULL,
  `Group_ID` int(3) NOT NULL,
  `Field_ID` int(5) NOT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB CHARSET=utf8 COLLATE=utf8_general_ci;

DROP TABLE IF EXISTS `{db_prefix}account_submit_form`;
CREATE TABLE `{db_prefix}account_submit_form` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `Position` int(3) NOT NULL,
  `Category_ID` int(5) NOT NULL,
  `Group_ID` int(3) NOT NULL,
  `Field_ID` int(5) NOT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB CHARSET=utf8 COLLATE=utf8_general_ci;

DROP TABLE IF EXISTS `{db_prefix}admins`;
CREATE TABLE `{db_prefix}admins` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `User` varchar(100) NOT NULL DEFAULT '',
  `Name` varchar(100) NOT NULL DEFAULT '',
  `Pass` varchar(200) NOT NULL DEFAULT '',
  `Email` varchar(100) NOT NULL DEFAULT '',
  `Type` enum('super','limited') NOT NULL DEFAULT 'super',
  `Rights` mediumtext NOT NULL,
  `Status` enum('active','approval','trash') NOT NULL DEFAULT 'approval',
  PRIMARY KEY (`ID`),
  KEY `User` (`User`)
) ENGINE=InnoDB CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `{db_prefix}admins` (`ID`, `User`, `Name`, `Pass`, `Email`, `Type`, `Rights`, `Status`) VALUES
(1, '{admin_user}', 'Administrator', '{admin_password}', '{admin_email}', 'super', '', 'active');

DROP TABLE IF EXISTS `{db_prefix}admin_blocks`;
CREATE TABLE `{db_prefix}admin_blocks` (
  `ID` int(5) NOT NULL AUTO_INCREMENT,
  `Column` varchar(255) NOT NULL DEFAULT '',
  `Position` int(3) NOT NULL DEFAULT '0',
  `Key` varchar(100) NOT NULL DEFAULT '',
  `Ajax` enum('0','1') NOT NULL DEFAULT '0',
  `Fixed` enum('0','1') NOT NULL DEFAULT '1',
  `Content` mediumtext NOT NULL,
  `Plugin` varchar(100) NOT NULL DEFAULT '',
  `Status` enum('active','approval') NOT NULL DEFAULT 'active',
  PRIMARY KEY (`ID`),
  KEY `Column` (`Column`)
) ENGINE=InnoDB CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `{db_prefix}admin_blocks` (`ID`, `Column`, `Position`, `Key`, `Ajax`, `Fixed`, `Content`, `Plugin`, `Status`) VALUES
(1, 'column1', 1, 'flynax_news', '1', '1', 'echo <<<VS\n<script>$(function(){ flynax.adminBoxesHandler(\'flynax_news\', xajax_getFlynaxRss); });</script>\nVS;\n', '', 'active'),
(2, 'column3', 1, 'statistics', '0', '1', '$GLOBALS[\'rlSmarty\']->display(\'blocks/statistics.block.tpl\');', '', 'active'),
(3, 'column2', 1, 'plugins_log', '1', '1', '$GLOBALS[\'rlSmarty\']->display(\'blocks/plugins_changelog.tpl\');', '', 'active');

DROP TABLE IF EXISTS `{db_prefix}admin_controllers`;
CREATE TABLE `{db_prefix}admin_controllers` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `Parent_ID` int(11) NOT NULL DEFAULT '0',
  `Position` int(11) NOT NULL DEFAULT '0',
  `Key` varchar(255) NOT NULL DEFAULT '',
  `Controller` varchar(200) NOT NULL DEFAULT '',
  `Vars` varchar(200) NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `Parent_ID` (`Parent_ID`)
) ENGINE=InnoDB CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `{db_prefix}admin_controllers` (`ID`, `Parent_ID`, `Position`, `Key`, `Controller`, `Vars`) VALUES
(1, 0, 1, 'common', '', ''),
(2, 0, 2, 'listings', '', ''),
(3, 1, 1, 'home', 'home', ''),
(4, 1, 2, 'config', 'settings', ''),
(5, 1, 4, 'languages', 'languages', ''),
(6, 100, 5, 'statistics', 'statistics', ''),
(7, 1, 25, 'trash', 'trash', ''),
(8, 2, 1, 'listings', 'listings', ''),
(9, 2, 9, 'listing_fields', 'listing_fields', ''),
(48, 1000, 0, 'messages', 'messages', ''),
(11, 38, 2, 'categories', 'categories', ''),
(12, 2, 8, 'listing_groups', 'listing_groups', ''),
(13, 1, 6, 'data_formats', 'data_formats', ''),
(14, 0, 7, 'content', '', ''),
(15, 14, 1, 'pages', 'pages', ''),
(16, 14, 2, 'blocks', 'blocks', ''),
(17, 1, 3, 'admins', 'admins', ''),
(18, 46, 2, 'listing_plans', 'listing_plans', ''),
(19, 1, 9, 'email_templates', 'email_templates', ''),
(20, 0, 6, 'account', '', ''),
(21, 20, 1, 'all_accounts', 'accounts', ''),
(22, 20, 5, 'account_fields', 'account_fields', ''),
(49, 20, 6, 'saved_searches', 'saved_searches', ''),
(24, 20, 4, 'pending_accounts', 'accounts', 'status=pending'),
(25, 0, 5, 'forms', '', ''),
(27, 25, 2, 'search_forms', 'search_forms', ''),
(28, 14, 3, 'news', 'news', ''),
(29, 14, 8, 'contacts', 'contacts', ''),
(30, 20, 2, 'new_accounts', 'accounts', 'status=new'),
(31, 1, 7, 'controls', 'controls', ''),
(32, 0, 4, 'plugins', '', ''),
(33, 32, 1, 'plugins', 'plugins', ''),
(34, 2, 2, 'new_listings', 'listings', 'status=new'),
(47, 1002, 10, 'map_amenities', 'map_amenities', ''),
(36, 2, 4, 'pending_listings', 'listings', 'status=pending'),
(37, 46, 5, 'transactions', 'transactions', ''),
(38, 0, 3, 'categories', '', ''),
(39, 38, 1, 'add_category', 'categories', 'action=add'),
(40, 38, 3, 'browse', 'browse', ''),
(41, 1, 5, 'database', 'database', ''),
(42, 38, 4, 'custom_categories', 'custom_categories', ''),
(43, 46, 3, 'plans_using', 'plans_using', ''),
(44, 20, 6, 'account_types', 'account_types', ''),
(45, 2, 4, 'listing_types', 'listing_types', ''),
(46, 0, 1, 'finances', '', ''),
(50, 46, 1, 'payment_gateways', 'payment_gateways', ''),
(51, 46, 3, 'subscriptions', 'subscriptions', ''),
(52, 46, 5, 'membership_plans', 'membership_plans', ''),
(53, 46, 6, 'membership_services', 'membership_services', ''),
(54, 14, 4, 'slides', 'slides', '');

DROP TABLE IF EXISTS `{db_prefix}agency_invites`;
CREATE TABLE `{db_prefix}agency_invites` (
    `ID` INT NOT NULL AUTO_INCREMENT,
    `Agency_ID` INT NOT NULL,
    `Agent_ID` INT NOT NULL,
    `Invite_Code` VARCHAR(32) NOT NULL,
    `Agent_Email` VARCHAR(128) NOT NULL,
    `Created_Date` DATETIME NOT NULL,
    `Accepted_Date` DATETIME NOT NULL,
    `Declined_Date` DATETIME NOT NULL,
    `Status` ENUM('pending','accepted','declined') NOT NULL DEFAULT 'pending',
    PRIMARY KEY (`ID`),
    INDEX (`Agency_ID`),
    INDEX (`Agent_ID`),
    INDEX (`Invite_Code`),
    INDEX (`Agent_Email`)
) ENGINE=InnoDB CHARSET=utf8 COLLATE=utf8_general_ci;

DROP TABLE IF EXISTS `{db_prefix}blocks`;
CREATE TABLE `{db_prefix}blocks` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `Page_ID` text NOT NULL,
  `Category_ID` text NOT NULL,
  `Subcategories` enum('0','1') NOT NULL DEFAULT '0',
  `Sticky` enum('0','1') NOT NULL DEFAULT '1',
  `Cat_sticky` enum('0','1') NOT NULL DEFAULT '0',
  `Key` varchar(255) NOT NULL DEFAULT '',
  `Position` int(2) NOT NULL DEFAULT '0',
  `Side` set('left','top','bottom','middle','middle_left','middle_right','header_banner','long_top','integrated_banner') NOT NULL,
  `Type` enum('html','php','smarty') NOT NULL DEFAULT 'html',
  `Content` mediumtext NOT NULL,
  `Tpl` enum('0','1') NOT NULL DEFAULT '1',
  `Header` enum('0','1') NOT NULL DEFAULT '1',
  `Options` text NOT NULL,
  `Plugin` varchar(100) NOT NULL DEFAULT '',
  `Status` enum('active','approval','trash') NOT NULL DEFAULT 'active',
  `Readonly` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `Key` (`Key`,`Position`,`Side`,`Type`,`Status`),
  KEY `Subcategories` (`Subcategories`)
) ENGINE=InnoDB CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `{db_prefix}blocks` (`Page_ID`, `Category_ID`, `Subcategories`, `Sticky`, `Cat_sticky`, `Key`, `Position`, `Side`, `Type`, `Content`, `Tpl`, `Header`, `Plugin`, `Status`, `Readonly`) VALUES
('24,27,35,310,312,15,330,328,37', '', '0', '0', '0', 'account_area', 1, 'left', 'smarty', '{include file=''menus''|cat:$smarty.const.RL_DS|cat:''account_menu.tpl''}', '1', '1', '', 'approval', '1'),
('12,2,8', '', '0', '0', '0', 'news', 13, 'left', 'php', 'global $reefless;\r\nglobal $rlSmarty;\r\n\r\n$reefless -> loadClass( ''News'' );\r\nglobal $rlNews;\r\n$all_news = $rlNews -> get();\r\n\r\n$rlSmarty -> assign_by_ref( ''all_news'', $all_news );\r\n$rlSmarty -> display(FL_TPL_CONTROLLER_DIR . ''news/news_block.tpl'');', '1', '1', '', 'active', '1'),
('1,2', '', '0', '0', '0', 'statistics', 26, 'bottom', 'smarty', '{include file=$componentDir|cat:''statistics/_statistics.tpl''}', '0', '0', '', 'active', '1'),
('42', '', '0', '0', '0', 'keyword_search', 8, 'left', 'smarty', '{include file=''blocks''|cat:$smarty.const.RL_DS|cat:''keyword_search.tpl''}', '1', '1', '', 'active', '1'),
('309', '', '0', '0', '0', 'account_alphabetic_filter', 1, 'left', 'smarty', '{include file=''blocks''|cat:$smarty.const.RL_DS|cat:''account_alphabetic_filter.tpl''}', '1', '1', '', 'active', '1'),
('309', '', '0', '0', '0', 'account_search', 2, 'left', 'smarty', '{include file=''blocks''|cat:$smarty.const.RL_DS|cat:''account_search.tpl''}', '1', '1', '', 'active', '1'),
('40,309', '', '0', '0', '0', 'account_page_info', 1, 'left', 'smarty', '{include file=''blocks''|cat:$smarty.const.RL_DS|cat:''listing_details_seller.tpl'' sidebar=true owner_page=true seller_info=$account}', '1', '1', '', 'active', '1'),
('309', '', '0', '0', '0', 'account_page_search_listings', 2, 'left', 'smarty', '{include file=''blocks''|cat:$smarty.const.RL_DS|cat:''account_page_search.tpl''}', '1', '1', '', 'active', '1'),
('40,309', '', '0', '0', '0', 'account_page_location', 3, 'left', 'smarty', '{include file=''blocks''|cat:$smarty.const.RL_DS|cat:''account_page_location.tpl''}', '1', '1', '', 'active', '1'),
('15', '', '0', '0', '0', 'my_profile_sidebar', 1, 'left', 'smarty', '{include file=$smarty.const.FL_TPL_CONTROLLER_DIR|cat:''profile''|cat:$smarty.const.RL_DS|cat:''manage_thumbnail.tpl''}', '1', '1', '', 'active', '1'),
('25', '', '0', '0', '0', 'get_more_details', 10, 'middle', 'smarty', '{include file=''blocks''|cat:$smarty.const.RL_DS|cat:''listing_details_seller.tpl''}', '1', '1', '', 'active', '1'),
('3', '', '0', '0', '0', 'search_in_my_ads', 57, 'left', 'smarty', '{include file=''blocks''|cat:$smarty.const.RL_DS|cat:''my_search_block.tpl''}', '1', '1', '', 'active', '1'),
('340', '', '0', '0', '0', 'invite_search', 60, 'left', 'smarty', '{include file=\'blocks/account_search.tpl\'}', '1', '1', '', 'active', '0'),

/* Added in 4.9.3 */
('30', '', '0', '0', '0', 'news_categories', 1, 'left', 'php', '$GLOBALS[''reefless'']->loadClass(''News'');\r\n$newsCategories = $GLOBALS[''rlNews'']->getCategories();\r\n$GLOBALS[''rlSmarty'']->assign_by_ref(''newsCategories'', $newsCategories);\r\n$GLOBALS[''rlSmarty'']->display(FL_TPL_CONTROLLER_DIR . ''news/news_categories_block.tpl'');', '1', '1', '', 'active', '1'),
('30', '', '0', '0', '0', 'more_news_block', 1, 'bottom', 'php', '$GLOBALS[''reefless'']->loadClass(''News'');\r\n$otherArticles = $GLOBALS[''rlNews'']->getMoreNews($GLOBALS[''newsCategoryID''], (int) $GLOBALS[''article''][''ID'']);\r\n$GLOBALS[''rlSmarty'']->assign_by_ref(''otherArticles'', $otherArticles);\r\n$GLOBALS[''rlSmarty'']->display(FL_TPL_CONTROLLER_DIR . ''news/more_news_block.tpl'');', '1', '1', '', 'active', '1');

DROP TABLE IF EXISTS `{db_prefix}config`;
CREATE TABLE `{db_prefix}config` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `Group_ID` int(11) NOT NULL DEFAULT '0',
  `Position` int(3) NOT NULL DEFAULT '0',
  `Key` varchar(255) NOT NULL DEFAULT '',
  `Default` varchar(255) NOT NULL DEFAULT '',
  `Values` mediumtext NOT NULL,
  `Type` enum('bool','text','textarea','select','radio','checkbox','divider', 'color') NOT NULL DEFAULT 'text',
  `Data_type` enum('int','varchar') NOT NULL DEFAULT 'varchar',
  `Plugin` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `{db_prefix}config` (`Group_ID`, `Position`, `Key`, `Default`, `Values`, `Type`, `Data_type`, `Plugin`) VALUES
(1, 1, 'general_common', '', '', 'divider', '', ''),
(1, 2, 'timezone', '{timezone}', '', 'select', 'varchar', ''),
(1, 10, 'template', 'realty_map', '', 'select', 'varchar', ''),
(1, 33, 'mod_rewrite', '1', '', 'bool', 'varchar', ''),
(1, 12, 'encoding', 'utf-8', '', 'text', 'varchar', ''),
(1, 13, 'trash', '0', '', 'bool', 'varchar', ''),
(1, 21, 'lang', 'en', '', 'select', 'varchar', ''),
(1, 22, 'expire_languages', '12', '', 'text', 'int', ''),
(1, 20, 'general_languages', '', '', 'divider', '', ''),
(1, 40, 'miscellaneous', '', '', 'divider', '', ''),
(5, 31, 'new_period', '2', '', 'text', 'int', ''),
(1, 42, 'system_currency', '$', '', 'text', 'varchar', ''),
(1, 43, 'system_currency_code', 'USD', '', 'text', 'varchar', ''),
(1, 44, 'system_currency_position', 'before', 'before,after', 'select', '', ''),
(1, 45, 'transactions_per_page', '12', '', 'text', 'int', ''),
(0, 0, 'rl_version', '4.10.1', '', 'text', 'varchar', ''),
(0, 0, 'security_key', 'lsWoi2Bxao8#4', '', '', 'varchar', ''),
(3, 1, 'security_img_devider', '', '', 'divider', '', ''),
(3, 2, 'security_code_length', '5', '', 'text', 'int', ''),
(3, 3, 'security_img_registration', '1', '', 'bool', 'varchar', ''),
(3, 4, 'security_img_add_listing', '0', '', 'bool', 'varchar', ''),
(3, 5, 'security_img_tell_friend', '1', '', 'bool', '', ''),
(3, 6, 'security_img_contact_us', '1', '', 'bool', '', ''),
(3, 7, 'security_img_contact_seller', '1', '', 'bool', '', ''),
(3, 10, 'security_login_attempt_admin_divider', '', '', 'divider', '', ''),
(3, 11, 'security_login_attempt_admin_module', '1', '', 'bool', '', ''),
(3, 12, 'security_login_attempt_admin_attempts', '5', '', 'text', 'int', ''),
(3, 13, 'security_login_attempt_admin_period', '1', '', 'text', 'int', ''),
(3, 14, 'security_login_attempt_user_divider', '', '', 'divider', '', ''),
(3, 15, 'security_login_attempt_user_module', '0', '', 'bool', '', ''),
(3, 16, 'security_login_attempt_user_attempts', '5', '', 'text', 'int', ''),
(3, 17, 'security_login_attempt_user_period', '1', '', 'text', 'int', ''),
(4, 1, 'img_common', '', '', 'divider', '', ''),
(4, 2, 'img_quality', '70', '', 'text', 'int', ''),
(4, 3, 'img_auto_upload', '1', '', 'bool', '', ''),
(4, 10, 'pg_upload_divider', '', '', 'divider', 'varchar', ''),
(4, 11, 'pg_upload_thumbnail_width', '270', '', 'text', 'int', ''),
(4, 12, 'pg_upload_thumbnail_height', '180', '', 'text', 'int', ''),
(4, 13, 'pg_upload_large_width', '900', '', 'text', 'int', ''),
(4, 14, 'pg_upload_large_height', '600', '', 'text', 'int', ''),
(4, 20, 'img_watermark_devider', '', '', 'divider', '', ''),
(4, 21, 'watermark_using', '0', '', 'bool', '', ''),
(4, 22, 'watermark_type', 'text', 'text,image', 'select', '', ''),
(4, 23, 'watermark_position', 'bottom-right', 'top-left,top,top-right,left,center,right,bottom-left,bottom,bottom-right,tiled', 'select', '', ''),
(4, 24, 'watermark_image_url', '', '', 'textarea', 'varchar', ''),
(4, 25, 'watermark_image_width', '100', '', 'text', 'int', ''),
(4, 27, 'watermark_text', 'Flynax', '', 'text', 'varchar', ''),
(4, 28, 'watermark_text_font', 'OpenSans-Regular.ttf', '', 'select', 'varchar', ''),
(4, 29, 'watermark_text_size', '24', '', 'text', 'int', ''),
(4, 30, 'watermark_text_color', '255,255,255', '', 'color', 'varchar', ''),
(4, 31, 'watermark_angle', '0', '', 'text', 'int', ''),
(4, 32, 'watermark_opacity', '100', '', 'text', 'int', ''),
(4, 40, 'img_crop_devider', '', '', 'divider', 'varchar', ''),
(4, 41, 'img_crop_module', '0', '', 'bool', '', ''),
(4, 42, 'img_crop_thumbnail', '0', '', 'bool', '', ''),
(4, 43, 'img_crop_interface', '1', '', 'bool', '', ''),
(4, 44, 'img_account_crop_divider', '', '', 'divider', 'varchar', ''),
(4, 45, 'img_account_crop_thumbnail', '0', '', 'bool', '', ''),
(4, 46, 'img_account_crop_interface', '1', '', 'bool', '', ''),
(6, 3, 'paypal_sandbox', '0', '', 'bool', '', ''),
(6, 4, 'paypal_account_email', '', '', 'text', '', ''),
(6, 5, 'paypal_merchant_id', '', '', 'text', '', ''),
(6, 12, '2co_testmode', '1', '', 'bool', '', ''),
(6, 13, '2co_id', '', '', 'text', 'varchar', ''),
(6, 14, '2co_secret_word', '', '', 'text', 'varchar', ''),
(7, 1, 'general_email', '', '', 'divider', 'varchar', ''),
(7, 5, 'site_main_email', '{advanced_site_email}', '', 'text', 'varchar', ''),
(7, 7, 'owner_name', '{advanced_site_owner}', '', 'text', '', ''),
(7, 8, 'mail_method', 'phpmail', 'phpmail,smtp', 'select', 'varchar', ''),
(7, 9, 'async_mail', '0', '', 'bool', '', ''),
(7, 10, 'smtp_divider', '', '', 'divider', '', ''),
(7, 11, 'smtp_server', '', '', 'text', '', ''),
(7, 12, 'smtp_username', '', '', 'text', '', ''),
(7, 13, 'smtp_password', '', '', 'text', '', ''),
(0, 0, 'paypal_secret_word', 'a0c75d1cf9bb43a17ab1cfa7d107f576', '', 'text', 'varchar', ''),
(8, 4, 'video_width', '480', '', 'text', 'int', ''),
(8, 5, 'video_height', '310', '', 'text', 'int', ''),
(8, 6, 'video_autostart', '0', '', 'bool', 'varchar', ''),
(8, 7, 'video_bufferlength', '5', '', 'text', 'int', ''),
(0, 0, 'cache_categories_by_parent', '', '', 'text', '', ''),
(8, 8, 'video_volume', '100', '', 'text', 'int', ''),
(5, 1, 'general_common', '', '', 'divider', 'varchar', ''),
(5, 2, 'listing_auto_approval', '1', '', 'bool', 'int', ''),
(5, 3, 'edit_listing_auto_approval', '1', '', 'bool', '', ''),
(5, 5, 'view_details_new_window', '0', '', 'bool', '', ''),
(5, 6, 'listings_per_page', '15', '', 'text', 'int', ''),
(5, 7, 'banner_in_grid_position_option', '1', '', 'bool', 'int', ''),
(5, 8, 'banner_in_grid_position', '10', '', 'select', 'int', ''),
(5, 9, 'listings_per_rss', '10', '', 'text', 'int', ''),
(5, 10, 'listings_per_print_page', '20', '', 'text', 'int', ''),
(5, 12, 'add_listing_single_step', '1', '', 'bool', '', ''),
(5, 13, 'lisitng_get_children', '1', '', 'bool', '', ''),
(5, 14, 'show_cents', '1', '', 'bool', 'varchar', ''),
(5, 15, 'price_delimiter', ',', '', 'text', 'varchar', ''),
(5, 16, 'crossed_categories_by_type', '0', '', 'bool', '', ''),
(5, 17, 'posting_date_update', '1', '', 'bool', '', ''),
(5, 21, 'featured', '', '', 'divider', '', ''),
(5, 23, 'featured_new_window', '0', '', 'bool', '', ''),
(5, 24, 'random_block_slideshow_delay', '10', '', 'text', 'int', ''),
(5, 30, 'short_form_divider', '', '', 'divider', 'varchar', ''),
(5, 31, 'sf_display_fields', '0', '', 'bool', 'varchar', ''),
(5, 40, 'listing_statistics', '', '', 'divider', '', ''),
(5, 41, 'count_listing_visits', '1', '', 'bool', '', ''),
(5, 42, 'grid_photos_count', '1', '', 'bool', '', ''),
(5, 43, 'display_posted_date', '1', '', 'bool', '', ''),
(9, 3, 'news_block_content_length', '100', '', 'text', 'int', ''),
(9, 2, 'news_block_news_in_block', '3', '', 'text', 'int', ''),
(9, 5, 'news_page_content_length', '250', '', 'text', 'int', ''),
(9, 6, 'news_image_width', '676', '', 'text', 'int', ''),
(9, 7, 'news_image_height', '446', '', 'text', 'int', ''),
(9, 4, 'news_at_page', '16', '', 'text', 'int', ''),
(12, 1, 'messages_module', '1', '', 'bool', '', ''),
(12, 2, 'messages_length', '250', '', 'text', 'int', ''),
(12, 3, 'messages_refresh', '20', '', 'text', 'int', ''),
(0, 0, 'cache_categories_by_type', '', '', 'text', '', ''),
(0, 0, 'flynax_news_feed', 'https://www.flynax.com/index.php?page=rss', '', 'text', 'varchar', ''),
(13, 2, 'flynax_news_number', '5', '', 'text', 'int', ''),
(0, 0, 'cache_listing_statistics', '', '', 'text', '', ''),
(2, 6, 'address_on_map', '1', '', 'bool', '', ''),
(14, 1, 'map_module', '1', '', 'bool', '', ''),
(14, 2, 'map_provider', 'google', 'openstreetmap,google,alternative,yandex', 'select', '', ''),
(14, 3, 'map_default_zoom', '14', '', 'select', '', ''),
(14, 30, 'map_static', '0', '', 'divider', '', ''),
(14, 31, 'static_map_provider', 'yandex', 'google,yandex', 'select', '', ''),
(14, 32, 'google_map_key', '', '', 'textarea', '', ''),
(14, 40, 'geocoding', '0', '', 'divider', '', ''),
(14, 41, 'geocoding_provider', 'arcgis', 'arcgis,nominatim,google,yandex', 'select', '', ''),
(14, 42, 'google_server_map_key', '', '', 'textarea', '', ''),
(14, 43, 'yandex_geocoder_api_key', '', '', 'textarea', '', ''),
(14, 44, 'geocoding_restrict_by_country', '', '', 'select', '', ''),
(1014, 51, 'map_amenities', '1', '', 'bool', '', ''),
(2, 3, 'dealers_per_page', '10', '', 'text', 'int', ''),
(15, 1, 'listings_checking', '', '', 'divider', '', ''),
(15, 2, 'listings_number', '100', '', 'text', 'int', ''),
(15, 3, 'pre_days', '5', '', 'text', 'int', ''),
(15, 10, 'check_search', '', '', 'divider', '', ''),
(15, 11, 'searches_per_run', '10', '', 'text', 'int', ''),
(15, 4, 'listings_checking_notification', '1', '', 'bool', '', ''),
(7, 2, 'notifications_email', '{admin_email}', '', 'text', 'varchar', ''),
(4, 47, 'gallery_slideshow_divider', '', '', 'divider', '', ''),
(4, 48, 'gallery_slideshow', '1', '', 'bool', '', ''),
(4, 49, 'gallery_slideshow_delay', '5', '', 'text', 'int', ''),
(2, 2, 'account_password_strength', '1', '', 'bool', 'varchar', ''),
(12, 5, 'messages_allow_free', '1', '', 'bool', '', ''),
(0, 0, 'cache_search_fields', '', '', 'text', '', ''),
(0, 0, 'cache_search_forms', '', '', 'text', '', ''),
(0, 0, 'cache_submit_forms', '', '', 'text', '', ''),
(17, 1, 'cache', '1', '', 'bool', '', ''),
(13, 3, 'admin_hide_denied_items', '1', '', 'bool', '', ''),
(12, 5, 'messages_notification', '1', '', 'bool', '', ''),
(13, 4, 'fckeditor_bar', 'Basic', 'Basic,Default', 'select', '', ''),
(0, 0, 'cache_featured_form_fields', '', '', 'text', '', ''),
(0, 0, 'cache_listing_titles_fields', '', '', 'text', '', ''),
(2, 4, 'account_edit_email_confirmation', '1', '', 'bool', 'varchar', ''),
(2, 22, 'account_wildcard_deny', '', '', 'textarea', '', ''),
(0, 0, 'cache_short_forms_fields', '', '', 'text', '', ''),
(0, 0, 'cache_data_formats', '', '', 'text', '', ''),
(8, 1, 'video_display_type', 'preview', 'preview,lightBox', 'select', '', ''),
(8, 2, 'video_thumbnail_position', 'left', 'left,right,top,bottom', 'select', '', ''),
(2, 1, 'account_common_divider', '', '', 'divider', '', ''),
(2, 20, 'account_wildcard_divider', '', '', 'divider', '', ''),
(2, 21, 'account_wildcard', '0', '', 'bool', '', ''),
(0, 0, 'flynax_plugins_log_feed', 'https://www.flynax.com/plugins/changelog_rss.xml', '', 'text', 'varchar', ''),
(0, 0, 'flynax_plugins_browse_feed', 'https://www.flynax.com/plugins/browse_rss.xml', '', 'text', 'varchar', ''),
(15, 20, 'cron_messages_divider', '', '', 'divider', '', ''),
(15, 21, 'cron_messages_remove', '1', '', 'bool', '', ''),
(15, 5, 'cron_incomplete_listing_days', '7', '', 'text', 'int', ''),
(5, 15, 'ld_keep_alive', '1', '', 'bool', 'int', '' ),
(5, 16, 'ld_keep_hiddenfields', 'phone,mobile', '', 'textarea', 'varchar', '' ),
(5, 16, 'tell_a_friend_tab', '0', '', 'bool', '', '' ),
/*added in 4.4*/
(15, 22, 'cron_expired_remove_divider', '', '', 'divider', 'varchar', ''),
(15, 23, 'cron_expired_remove', '0', '', 'bool', '', ''),
(15, 24, 'cron_expired_listing_days', '7', '', 'text', 'int', ''),
(1, 46, 'header_banner_space', '1', '', 'bool', '', ''),
(1, 48, 'main_menu_home_page', '1', '', 'bool', '', ''),
(1, 49, 'facebook_page', 'https://www.facebook.com/ClassifiedsSoftware', '', 'text', 'varchar', ''),
(1, 50, 'twitter_page', 'https://twitter.com/Flynax', '', 'text', 'varchar', ''),
(1, 51, 'instagram_page', '', '', 'text', 'varchar', ''),
(1, 52, 'whatsapp_page', 'https://wa.me/19548897844', '', 'text', 'varchar', ''),
(1, 53, 'telegram_page', '', '', 'text', 'varchar', ''),
(1, 54, 'vk_page', '', '', 'text', 'varchar', ''),
(2, 7, 'account_login_mode', 'username', 'username,email', 'select', '', ''),
(12, 5, 'messages_save_visitor_message', '1', '', 'bool', '', ''),
(7, 14, 'smtp_method', 'none', 'none,tls,ssl', 'select', '', ''),
(5, 17, 'recently_added_order_field', 'Date', 'Date,Pay_date', 'select', '', ''),
(5, 18, 'price_tag_field', 'price', '', 'select', '', ''),
(0, 0, 'cron_last_run', '', '', 'text', 'int', ''),
/*added in 4.5*/
(1, 47, 'category_alphabet_box', '1', '', 'bool', 'int', ''),
(17, 3,  'cache_method',  'file',  'file,memcached,apcu,redis',  'select',  'varchar',  ''),
(17, 4,  'cache_divided',  '0',  '0,1',  'bool',  'int',  ''),
(1, 32, 'home_page_h1', '0', '', 'bool', 'int', ''),
(5, 13, 'price_separator', '.', '', 'text', 'varchar', ''),
(1, 29,  'url_transliteration',  '1',  '0,1',  'bool',  'int',  ''),
(2, 111, 'membership_divider', '', '', 'divider', 'int', ''),
(2, 112, 'membership_module', '0', '0,1', 'bool', 'int', ''),
(2, 113, 'allow_listing_plans', '0', '0,1', 'bool', 'int', ''),
(0, 0, 'cache_js_code', '', '', 'text', 'varchar', ''),
(2, 104, 'base_listing_plan', '', '', 'select', '', ''),
(2, 8, 'featured_accounts_in_box', '4', '', 'text', 'int', ''),
(0, 0, 'responsive_42', '1', '', 'text', '', ''),
/*added in 4.5.1*/
(2, 2, 'remember_me', '', '', 'bool', 'int', ''),
(15, 5, 'cron_incompl_listings_notify_days', '2', '', 'text', 'int', ''),
/* added in 4.5.2 */
(1, 22, 'preffered_lang_redirect', '1',  '',  'bool',  'int',  ''),
(0, 0, 'cache_sorting_forms_fields', '', '', 'text', '', ''),
(0, 0, 'geocode_request_limit_reached', '', '', 'text', 'int', ''),
(4, 4, 'thumbnails_x2', '1', '', 'bool', '', ''),
(4, 5, 'output_image_format', 'jpg', '', 'select', '', ''),
(15, 25, 'accounts_checking', '', '', 'divider', '', ''),
(15, 26, 'cron_incomplete_account_days', '7', '', 'text', '', ''),
(15, 27, 'cron_incompl_accounts_notify_days', '2', '', 'text', '', ''),
(15, 28, 'accounts_number', '100', '', 'text', '', ''),

/* added in 4.6.0 */
(2, 9, 'one_my_listings_page', '1', '', 'bool', 'int', ''),
(5, 19, 'default_grid_in_tab', 'list', 'list,grid,map', 'select', '', ''),
(12, 6, 'messages_notification_in_chat', '0', '', 'bool', 'int', ''),

/* added in 4.7.0 */
(0, 0, 'minimal_required_php_version', '7.3', '', 'text', 'varchar', ''),
(2, 10, 'account_removing', '1', '', 'bool', 'int', ''),

/* added in 4.7.2 */
(2, 11, 'sending_account_password', '0', '', 'bool', 'int', ''),

/* added in 4.8.0 */
(1, 30, 'multilingual_paths',  '0',  '0,1',  'bool',  'int',  ''),

/* added in 4.8.1 */
(2, 99, 'amp_divider', '', '', 'divider', 'varchar', ''),
(2, 100, 'address_on_map_country', 'country', '', 'select', 'varchar', ''),
(2, 100, 'address_on_map_address', 'address', '', 'select', 'varchar', ''),
(2, 100, 'address_on_map_zip', 'zip_code', '', 'select', 'varchar', ''),
(2, 100, 'address_on_map_country_level1', 'country_level1', '', 'select', 'varchar', ''),
(2, 100, 'address_on_map_country_level2', 'country_level2', '', 'select', 'varchar', ''),

/* added in 4.8.2 */
(6, 16, '2co_method', 'simple', 'simple,direct', 'select', 'varchar', ''),
(6, 15, '2co_secret_key', '', '', 'text', 'varchar', ''),
(1, 43, 'home_special_box', '', '', 'select', '', ''),
(15, 3, 'pre_days_membership', '5', '', 'text', 'int', ''),
(1, 31, 'force_canonical',  '0',  '',  'bool',  '',  ''),

/* Added in 4.9.0 */
(5, 20, 'keyword_search_type', '1', '1,2,3', 'select', 'int', ''),
(1, 55, 'hidden_phone_numbers',  '5',  '',  'text',  'int',  ''),
(5, 16, 'show_call_owner_button', '1', '', 'bool', '', '' ),

/* Added in 4.9.1 */
(0, 0, 'static_files_revision', '1', '', 'text', 'int', ''),
(1, 24, 'google_translation_api_key', '',  '',  'text',  'varchar',  ''),

/* Added in 4.9.2 */
(1, 60, 'ios_app_url', 'https://itunes.apple.com/us/app/iflynax/id424570449?mt=8', '', 'text', 'varchar', ''),
(1, 60, 'android_app_url', 'https://play.google.com/store/apps/details?id=com.flynax.flydroid&hl=en_US', '', 'text', 'varchar', ''),
(12, 7, 'phone_messengers_icons', '', '', 'divider', '', ''),
(12, 8, 'whatsapp_phone_icon', '1', '', 'bool', 'int', ''),
(12, 9, 'viber_phone_icon', '1', '', 'bool', 'int', ''),
(12, 10, 'telegram_phone_icon', '1', '', 'bool', 'int', ''),

/* Added in 4.9.3 */
(1, 23, 'translation_api', 'google', 'google,deepl', 'select', 'varchar', ''),
(1, 25, 'deepl_translation_api_key', '',  '',  'text',  'varchar',  ''),
(4, 50, 'gallery_max_zoom_level', '3', '', 'text', 'int', ''),

/* Added in 4.10.0 */
(17, 2, 'cache_phrases', '1', '', 'bool', '', ''),

/* Added in 4.10.1 */
(1, 26, 'seo', '', '', 'divider', '', ''),
(1, 27, 'html_in_pages',  '0',  '0,1',  'bool',  'int',  ''),
(1, 28, 'html_in_categories',  '0',  '0,1',  'bool',  'int',  '');

DROP TABLE IF EXISTS `{db_prefix}config_groups`;
CREATE TABLE `{db_prefix}config_groups` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `Key` varchar(255) DEFAULT NULL,
  `Position` int(11) NOT NULL DEFAULT '0',
  `Plugin` varchar(100) NOT NULL DEFAULT '',
  KEY `ID` (`ID`)
) ENGINE=InnoDB CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `{db_prefix}config_groups` (`ID`, `Key`, `Position`, `Plugin`) VALUES
(1, 'general', 1, ''),
(2, 'accounts', 2, ''),
(3, 'security_img', 3, ''),
(4, 'images', 4, ''),
(5, 'listings', 5, ''),
(7, 'mail', 7, ''),
(8, 'video', 8, ''),
(9, 'news', 9, ''),
(12, 'messages', 12, ''),
(13, 'admin_panel', 13, ''),
(14, 'google_map', 14, ''),
(15, 'cron', 15, ''),
(17, 'cache', 17, '');

DROP TABLE IF EXISTS `{db_prefix}contacts`;
CREATE TABLE `{db_prefix}contacts` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `Name` varchar(255) NOT NULL DEFAULT '',
  `Email` varchar(255) NOT NULL DEFAULT '',
  `Message` text NOT NULL,
  `Date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `Status` enum('new','reviewed','replied','trash') NOT NULL DEFAULT 'new',
  PRIMARY KEY (`ID`),
  KEY `Email` (`Email`,`Status`)
) ENGINE=InnoDB CHARSET=utf8 COLLATE=utf8_general_ci;

DROP TABLE IF EXISTS `{db_prefix}data_formats`;
CREATE TABLE `{db_prefix}data_formats` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `Parent_ID` int(11) NOT NULL DEFAULT '0',
  `Order_type` enum('alphabetic','position') NOT NULL DEFAULT 'alphabetic',
  `Position` int(5) NOT NULL DEFAULT '0',
  `Key` varchar(100) NOT NULL DEFAULT '',
  `Default` enum('0','1') NOT NULL DEFAULT '0',
  `Conversion` enum('0','1') DEFAULT '0',
  `Rate` float DEFAULT 1,
  `Plugin` varchar(100) NOT NULL DEFAULT '',
  `Status` enum('active','approval','trash') NOT NULL DEFAULT 'active',
  PRIMARY KEY (`ID`),
  KEY `Parent_ID` (`Parent_ID`,`Position`),
  KEY `Key` (`Key`)
) ENGINE=InnoDB CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `{db_prefix}data_formats` (`ID`, `Parent_ID`, `Order_type`, `Position`, `Key`, `Default`, `Plugin`, `Status`) VALUES
(1, 0, 'alphabetic', 1, 'currency', '0', '', 'active'),
(2, 0, 'alphabetic', 3, 'countries', '0', '', 'active'),
(3, 0, 'alphabetic', 4, 'us_states', '0', '', 'active'),
(5, 0, 'alphabetic', 7, 'years', '0', '', 'active'),
(6, 0, 'position', 2, 'price_options', '0', '', 'active'),
(338, 3, 'alphabetic', 0, 'alaska', '0', '', 'active'),
(339, 3, 'alphabetic', 0, 'alberta', '0', '', 'active'),
(341, 3, 'alphabetic', 0, 'arizona', '0', '', 'active'),
(342, 3, 'alphabetic', 0, 'arkansas', '0', '', 'active'),
(346, 3, 'alphabetic', 0, 'british_columbia', '0', '', 'active'),
(347, 3, 'alphabetic', 0, 'california', '0', '', 'active'),
(348, 3, 'alphabetic', 0, 'colorado', '0', '', 'active'),
(349, 3, 'alphabetic', 0, 'connecticut', '0', '', 'active'),
(350, 3, 'alphabetic', 0, 'delaware', '0', '', 'active'),
(351, 3, 'alphabetic', 0, 'district_of_columbia', '0', '', 'active'),
(353, 3, 'alphabetic', 0, 'florida', '0', '', 'active'),
(354, 3, 'alphabetic', 0, 'us_states_georgia', '0', '', 'active'),
(356, 3, 'alphabetic', 0, 'hawaii', '0', '', 'active'),
(357, 3, 'alphabetic', 0, 'idaho', '0', '', 'active'),
(358, 3, 'alphabetic', 0, 'illinois', '0', '', 'active'),
(359, 3, 'alphabetic', 0, 'indiana', '0', '', 'active'),
(360, 3, 'alphabetic', 0, 'iowa', '0', '', 'active'),
(361, 3, 'alphabetic', 0, 'kansas', '0', '', 'active'),
(362, 3, 'alphabetic', 0, 'kentucky', '0', '', 'active'),
(363, 3, 'alphabetic', 0, 'louisiana', '0', '', 'active'),
(364, 3, 'alphabetic', 0, 'maine', '0', '', 'active'),
(365, 3, 'alphabetic', 0, 'manitoba', '0', '', 'active'),
(367, 3, 'alphabetic', 0, 'maryland', '0', '', 'active'),
(368, 3, 'alphabetic', 0, 'massachusetts', '0', '', 'active'),
(369, 3, 'alphabetic', 0, 'michigan', '0', '', 'active'),
(370, 3, 'alphabetic', 0, 'minnesota', '0', '', 'active'),
(371, 3, 'alphabetic', 0, 'mississippi', '0', '', 'active'),
(372, 3, 'alphabetic', 0, 'missouri', '0', '', 'active'),
(373, 3, 'alphabetic', 0, 'montana', '0', '', 'active'),
(374, 3, 'alphabetic', 0, 'nebraska', '0', '', 'active'),
(375, 3, 'alphabetic', 0, 'nevada', '0', '', 'active'),
(376, 3, 'alphabetic', 0, 'new_brunswick', '0', '', 'active'),
(377, 3, 'alphabetic', 0, 'new_hampshire', '0', '', 'active'),
(378, 3, 'alphabetic', 0, 'new_jersey', '0', '', 'active'),
(379, 3, 'alphabetic', 0, 'new_mexico', '0', '', 'active'),
(380, 3, 'alphabetic', 0, 'new_york', '0', '', 'active'),
(381, 3, 'alphabetic', 0, 'newfoundland', '0', '', 'active'),
(382, 3, 'alphabetic', 0, 'north_carolina', '0', '', 'active'),
(383, 3, 'alphabetic', 0, 'north_dakota', '0', '', 'active'),
(386, 3, 'alphabetic', 0, 'northwest_territories', '0', '', 'active'),
(387, 3, 'alphabetic', 0, 'nova_scotia', '0', '', 'active'),
(389, 3, 'alphabetic', 0, 'ohio', '0', '', 'active'),
(391, 3, 'alphabetic', 0, 'oklahoma', '0', '', 'active'),
(392, 3, 'alphabetic', 0, 'ontario', '0', '', 'active'),
(393, 3, 'alphabetic', 0, 'oregon', '0', '', 'active'),
(395, 3, 'alphabetic', 0, 'pennsylvania', '0', '', 'active'),
(398, 3, 'alphabetic', 0, 'quebec', '0', '', 'active'),
(399, 3, 'alphabetic', 0, 'rhode_island', '0', '', 'active'),
(401, 3, 'alphabetic', 0, 'south_carolina', '0', '', 'active'),
(402, 3, 'alphabetic', 0, 'south_dakota', '0', '', 'active'),
(403, 3, 'alphabetic', 0, 'tennessee', '0', '', 'active'),
(404, 3, 'alphabetic', 0, 'texas', '0', '', 'active'),
(405, 3, 'alphabetic', 0, 'us_virgin_isles', '0', '', 'active'),
(406, 3, 'alphabetic', 0, 'utah', '0', '', 'active'),
(407, 3, 'alphabetic', 0, 'vermont', '0', '', 'active'),
(408, 3, 'alphabetic', 0, 'virginia', '0', '', 'active'),
(409, 3, 'alphabetic', 0, 'washington', '0', '', 'active'),
(410, 3, 'alphabetic', 0, 'west_virginia', '0', '', 'active'),
(411, 3, 'alphabetic', 0, 'wisconsin', '0', '', 'active'),
(412, 3, 'alphabetic', 0, 'wyoming', '0', '', 'active'),
(413, 3, 'alphabetic', 0, 'yukon_territory', '0', '', 'active'),
(2050, 1, 'alphabetic', 1, 'dollar', '0', '', 'active'),
(2051, 1, 'alphabetic', 2, 'euro', '0', '', 'active'),
(2052, 1, 'alphabetic', 3, 'pound', '0', '', 'active'),
(415, 6, 'alphabetic', 1, 'price_options_free', '0', '', 'active'),
(416, 6, 'alphabetic', 2, 'price_options_negotiable', '0', '', 'active'),
(417, 6, 'alphabetic', 3, 'price_options_on_request', '1', '', 'active');
INSERT INTO `{db_prefix}data_formats` (`ID`, `Parent_ID`, `Order_type`, `Position`, `Key`, `Default`, `Conversion`, `Rate`, `Plugin`, `Status`) VALUES
(385, 0, 'position', 2, 'unit', '1','0', '0', '', 'active'),
(414, 385, 'alphabetic', 1, 'metr','0', '0', '0.3048','', 'active'),
(390, 385, 'alphabetic', 2, 'foot', '0', '0', '1', '', 'active');

DROP TABLE IF EXISTS `{db_prefix}email_templates`;
CREATE TABLE `{db_prefix}email_templates` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `Key` varchar(255) NOT NULL DEFAULT '',
  `Type` enum('plain','html') NOT NULL DEFAULT 'plain',
  `Position` int(3) NOT NULL DEFAULT '0',
  `Plugin` varchar(100) NOT NULL DEFAULT '',
  `Status` enum('active','approval') NOT NULL DEFAULT 'active',
  PRIMARY KEY (`ID`),
  KEY `Key` (`Key`,`Status`)
) ENGINE=InnoDB CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `{db_prefix}email_templates` (`Key`, `Type`, `Position`, `Plugin`, `Status`) VALUES
('account_created_active', 'html', 1, '', 'active'),
('account_activated', 'html', 2, '', 'active'),
('account_created_incomplete', 'html', 3, '', 'active'),
('new_password_created', 'html', 4, '', 'active'),
('tell_friend', 'html', 5, '', 'active'),
('contact_us', 'plain', 6, '', 'active'),
('account_deactivated', 'html', 7, '', 'active'),
('account_deleted', 'html', 8, '', 'active'),
('free_active_listing_created', 'html', 9, '', 'active'),
('free_approval_listing_created', 'html', 10, '', 'active'),
('listing_upgraded_active', 'html', 13, '', 'active'),
('listing_upgraded_approval', 'html', 14, '', 'active'),
('listing_activated', 'html', 15, '', 'active'),
('listing_deactivated', 'html', 16, '', 'active'),
('payment_accepted', 'html', 17, '', 'active'),
('cron_saved_search_match', 'html', 20, '', 'active'),
('listing_upgraded_to_featured_for_admin', 'plain', 43, '', 'active'),
('listing_moved', 'html', 22, '', 'active'),
('admin_listing_added', 'plain', 23, '', 'active'),
('admin_listing_paid', 'plain', 24, '', 'active'),
('listing_upgraded_to_featured', 'html', 42, '', 'active'),
('custom_category_added_user', 'html', 26, '', 'active'),
('custom_category_added_admin', 'plain', 27, '', 'active'),
('custom_category_deleted', 'html', 28, '', 'active'),
('custom_category_activated', 'html', 29, '', 'active'),
('free_package_purchased', 'html', 41, '', 'active'),
('featured_listing_annulled', 'html', 30, '', 'active'),
('listing_added_to_featured', 'html', 31, '', 'active'),
('account_created_admin', 'plain', 33, '', 'active'),
('account_confirmed_pending', 'html', 47, '', 'active'),
('contact_owner', 'html', 39, '', 'active'),
('account_confirmed_active', 'html', 46, '', 'active'),
('account_edit_email', 'html', 40, '', 'active'),
('edit_listing_pending', 'html', 45, '', 'active'),
('admin_listing_edited', 'plain', 44, '', 'active'),
('account_created_pending', 'html', 48, '', 'active'),
('contact_owner_user', 'html', 49, '', 'active'),
('grant_plan', 'html', 50, '', 'active'),
('listing_removed_by_admin', 'html', 51, '', 'active'),
('contact_owner_admin', 'html', 52, '', 'active'),
('remind_password_request', 'html', 53, '', 'active'),
('listing_plan_removed', 'html', 54, '', 'active'),
('quick_account_created', 'html', 58, '', 'active'),

/*added in 4.3*/
('cron_listing_expired2', 'plain', 59, '', 'active'),
('cron_listing_pre_expired2', 'plain', 60, '', 'active'),
('cron_featured_status_expired2', 'plain', 61, '', 'active'),
('cron_featured_status_pre_expired2', 'plain', 62, '', 'active'),
('cron_incomplete_listing2', 'plain', 63, '', 'active'),

/* added in 4.5.1 */
('bulk_listing_activated', 'html', 64, '', 'active'),
('bulk_listing_deactivated', 'html', 65, '', 'active'),

/* added in 4.5.2 */
('cron_incomplete_account', 'html', 66, '', 'active'),

/* added in 4.7.1 */
('smtp_configuration_success', 'html', 67, '', 'active'),

/* added in 4.8.2 */
('cron_membership_expired', 'plain', 68, '', 'active'),
('cron_membership_pre_expired', 'plain', 69, '', 'active'),

/* Added in 4.9.0 */
('send_invite_to_agent', 'html', 70, '', 'active'),
('agent_accepted_invite', 'html', 71, '', 'active'),
('agent_declined_invite', 'html', 72, '', 'active'),
('agency_removed_agent', 'html', 73, '', 'active');

DROP TABLE IF EXISTS `{db_prefix}favorites`;
CREATE TABLE `{db_prefix}favorites` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `Account_ID` int(11) NOT NULL DEFAULT '0',
  `Listing_ID` int(11) NOT NULL DEFAULT '0',
  `Date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `IP` varchar(64) NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB CHARSET=utf8 COLLATE=utf8_general_ci;

DROP TABLE IF EXISTS `{db_prefix}featured_form`;
CREATE TABLE `{db_prefix}featured_form` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `Position` int(4) NOT NULL DEFAULT '0',
  `Category_ID` int(4) NOT NULL DEFAULT '0',
  `Field_ID` int(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `Kind_ID` (`Category_ID`,`Field_ID`)
) ENGINE=InnoDB CHARSET=utf8 COLLATE=utf8_general_ci;

DROP TABLE IF EXISTS `{db_prefix}hooks`;
CREATE TABLE `{db_prefix}hooks` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `Name` varchar(150) NOT NULL DEFAULT '',
  `Class` varchar(25) NOT NULL DEFAULT '',
  `Plugin` varchar(100) NOT NULL DEFAULT '',
  `Code` mediumtext NOT NULL,
  `Status` enum('active','approval') NOT NULL DEFAULT 'active',
  PRIMARY KEY (`ID`),
  KEY `Name` (`Name`),
  KEY `Status` (`Status`)
) ENGINE=InnoDB CHARSET=utf8 COLLATE=utf8_general_ci;

DROP TABLE IF EXISTS `{db_prefix}languages`;
CREATE TABLE `{db_prefix}languages` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `Code` varchar(2) NOT NULL DEFAULT '',
  `Direction` enum('ltr','rtl') NOT NULL DEFAULT 'ltr',
  `Locale` varchar(25) NOT NULL DEFAULT '',
  `Key` varchar(100) NOT NULL DEFAULT '',
  `Translate` enum('0','1') NOT NULL DEFAULT '0',
  `Status` enum('active','approval','trash') NOT NULL DEFAULT 'approval',
  `Date_format` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `Code` (`Code`)
) ENGINE=InnoDB CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `{db_prefix}languages` (`Code`, `Direction`, `Key`, `Status`, `Date_format`) VALUES
('en', 'ltr', 'english', 'active', '%b %d, %Y');

DROP TABLE IF EXISTS `{db_prefix}lang_keys`;
CREATE TABLE `{db_prefix}lang_keys` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `Code` varchar(2) NOT NULL DEFAULT '0',
  `Module` enum('frontEnd','admin','common','system','formats','email_tpl','category','box') NOT NULL DEFAULT 'common',
  `JS` enum('0','1') NOT NULL DEFAULT '0',
  `Key` varchar(128) NOT NULL DEFAULT '',
  `Value` mediumtext NOT NULL,
  `Target_key` varchar(50) NOT NULL,
  `Modified` enum('0','1') NOT NULL DEFAULT '0',
  `Plugin` varchar(32) NOT NULL DEFAULT '',
  `Status` enum('active','approval','trash') NOT NULL DEFAULT 'active',
  PRIMARY KEY (`ID`),
  KEY `Key` (`Key`),
  KEY `Code` (`Code`),
  KEY `Module` (`Module`),
  KEY `Plugin` (`Plugin`),
  KEY (`Code`, `Module`, `Status`)
) ENGINE=InnoDB CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `{db_prefix}lang_keys` (`Code`, `Module`, `JS`, `Key`, `Value`, `Target_key`, `Modified`, `Plugin`, `Status`) VALUES
('en', 'frontEnd', '0', 'listings_of_category', 'Listings of the {category} category', 'print', '0', '', 'active'),
('en', 'admin', '0', 'links_type', 'Listing type URL', 'listing_types', '0', '', 'active'),
('en', 'common', '0', 'account_fields+name+First_name', 'First Name', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'registration_complete_auto_login', 'You\'ve been logged into the account automatically; you may [add listing] and use other features on the site.', 'registration', '0', '', 'active'),
('en', 'common', '0', 'photos_leave', '{count} pictures enabled', '', '0', '', 'active'),
('en', 'common', '0', 'set_primary_notice', 'The picture has been set as primary.', '', '0', '', 'active'),
('en', 'common', '0', 'images_number', 'Number of pictures', '', '0', '', 'active'),
('en', 'common', '0', 'listing_number', 'Number of listings', '', '0', '', 'active'),
('en', 'common', '0', 'profile_information', 'Profile Settings', '', '0', '', 'active'),
('en', 'common', '0', 'account_information', 'Account Settings', '', '0', '', 'active'),
('en', 'common', '0', 'crop_too_small', 'The selected area on the picture is too small; enlarge the area and try again.', '', '0', '', 'active'),
('en', 'common', '0', 'crop_completed', 'The picture has been successfully cropped and saved.', '', '0', '', 'active'),
('en', 'common', '0', 'listing_live_for', 'Listing live for', '', '0', '', 'active'),
('en', 'common', '0', 'error_listing_expired', 'The listing has expired.', '', '0', '', 'active'),
('en', 'admin', '0', 'edit_listing_no_form_fields_error', 'Listing form of the category doesn\'t have any fields.', '', '0', '', 'active'),
('en', 'admin', '0', 'replace_plan_option', 'Please select another listing package for all listings added under the <b>{plan}</b> before removing it.', '', '0', '', 'active'),
('en', 'admin', '0', 'full_plan_delete', 'Remove the listing package and disable all listings in main and mirror categories.', '', '0', '', 'active'),
('en', 'admin', '0', 'full_plan_drop', 'Remove the listing package and hide all the listings added.', '', '0', '', 'active'),
('en', 'admin', '0', 'submit_form_empty', 'Listing form of the <b>{category}</b> category is empty; click [here] to populate it with fields.', '', '0', '', 'active'),
('en', 'admin', '0', 'replace_account', 'Assign all the listings to another user before removing it.', '', '0', '', 'active'),
('en', 'admin', '0', 'full_username_delete', 'Remove the user account with all its listings irretrievably.', '', '0', '', 'active'),
('en', 'admin', '0', 'listing_type_edited', 'You\'ve successfully edited the listing type.', '', '0', '', 'active'),
('en', 'admin', '0', 'ability_to_add', 'Allow users to add listings to \"{type}\".', '', '0', '', 'active'),
('en', 'admin', '0', 'listing_made_featured', 'You\'ve successfully upgraded the selected listings to featured.', '', '0', '', 'active'),
('en', 'common', '0', 'pages+name+listing_remove', 'Remove Listing', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'pages+title+listing_remove', 'Remove incomplete listing', '', '0', '', 'active'),
('en', 'common', '0', 'pages+name+upgrade_listing', 'Upgrade Listing', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'pages+title+upgrade_listing', 'Upgrade Listing', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'pages+title+edit_listing', 'Edit Listing', '', '0', '', 'active'),
('en', 'common', '0', 'pages+name+edit_listing', 'Edit Listing', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'pages+title+my_profile', 'Edit My Profile', '', '0', '', 'active'),
('en', 'admin', '0', 'config+name+featured', 'Featured Settings', 'settings', '0', '', 'active'),
('en', 'common', '0', 'notice_listing_deleted', 'The listings have been successfully deleted.', '', '0', '', 'active'),
('en', 'common', '0', 'listing_plan_short', 'Listing', '', '0', '', 'active'),
('en', 'common', '0', 'empty_listing_url', 'listing', '', '0', '', 'active'),
('en', 'common', '0', 'profile', 'Profile', '', '0', '', 'active'),
('en', 'common', '0', 'no_listings_here', 'There are no listings. Be the first to [add a listing].', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'no_listings_here_submit_deny', 'No listings have been added yet.', 'listing_type', '0', '', 'active'),
('en', 'admin', '0', 'listing_meta_description_des', 'Build custom meta description for Ad Details page with values of listing fields.', '', '0', '', 'active'),
('en', 'admin', '0', 'admin_controllers+name+listings', 'Listings', '', '0', '', 'active'),
('en', 'admin', '0', 'admin_controllers+name+listing_fields', 'Listing Fields', '', '0', '', 'active'),
('en', 'admin', '0', 'admin_controllers+name+listing_plans', 'Listing Packages', '', '0', '', 'active'),
('en', 'admin', '0', 'admin_controllers+name+active_listings', 'Active Listings', '', '0', '', 'active'),
('en', 'admin', '0', 'admin_controllers+name+new_listings', 'New Listings', '', '0', '', 'active'),
('en', 'admin', '0', 'admin_controllers+name+pending_listings', 'Pending Listings', '', '0', '', 'active'),
('en', 'admin', '0', 'admin_controllers+name+listing_types', 'Listing Types', '', '0', '', 'active'),
('en', 'admin', '0', 'config_groups+name+listings', 'Listings', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config_groups+name+images', 'Pictures', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+listing_auto_approval', 'Auto approval of listings', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+featured_new_window', 'Featured listings in a new window', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+listings_per_rss', 'Number of listings on RSS page', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+listings_per_print_page', 'Number of listings on Print page', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+advertising_number', 'Number of listings in a box', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+new_period', 'Show as new in stats/filter for', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+listing_statistics', 'Listing Count Settings', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+count_listing_visits', 'Listing visit counter', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+listings_checking', 'Checking for Listings', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+listings_number', 'Number of listings to be checked per task', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+pre_days', 'Send notifications about expiration of listings and packages in advance', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+pg_upload_large_height', 'Picture height (in pixels)', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+pg_upload_large_width', 'Picture width (in pixels)', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+grid_photos_count', 'Picture view counter', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+display_posted_date', 'Posting date in listings', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+edit_listing_auto_approval', 'Auto approval of edited listings', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+cron_incomplete_listing_days', 'Remove incomplete listings in', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+mobile_featured_number', 'Number of featured listings', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+crossed_categories_by_type', 'Mirroring ads in other listing types', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+posting_date_update', 'Update posting date of listings after upgrading', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+img_auto_upload', 'Automatic picture upload', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+watermark_using', 'Watermark on pictures', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+security_img_add_listing', 'Captcha on the Post an Ad page', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+ld_keep_hiddenfields', 'Add fields to be hidden in details of removed or expired listings', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+ld_keep_alive', 'Keep URLs of expired and removed listings alive for SEO purposes', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+des+address_on_map', 'Allow users to synchronize their profile addresses with those in listings.', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+des+watermark_text', 'Leave the field empty to enable your domain name on all pictures.', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'notice_remote_activation_activated', 'The listings have been successfully activated.', '', '0', '', 'active'),
('en', 'admin', '0', 'notice_remote_activation_deny', 'Remote listing activation has failed due to:<br />* Listing was already activated;<br />* Listing was removed;<br />* Activation link is broken.', '', '0', '', 'active'),
('en', 'admin', '0', 'notice_delete_empty_listing_type', 'The listing type and its data will be removed irretrievably, are you sure you want to proceed?', '', '0', '', 'active'),
('en', 'admin', '0', 'notice_drop_plan', 'Are you sure you want to remove the listing package and hide all listings added?', '', '0', '', 'active'),
('en', 'admin', '0', 'notice_delete_plan', 'Are you sure you want to remove the listing package and disable all listings added to main and mirror categories?', '', '0', '', 'active'),
('en', 'admin', '0', 'submit_form_builder', 'Listing Form Builder', '', '0', '', 'active'),
('en', 'admin', '0', 'short_form_builder', 'Browse Form Builder', '', '0', '', 'active'),
('en', 'admin', '0', 'listing_title_builder', 'Listing Title Builder', '', '0', '', 'active'),
('en', 'admin', '0', 'featured_option', 'Featured listings', '', '0', '', 'active'),
('en', 'admin', '0', 'advanced_mode', 'Assign Featured and Standard Listings', '', '0', '', 'active'),
('en', 'admin', '0', 'featured_option_advanced_hint', 'Enter <b>0</b> to enable an unlimited number of listings.', '', '0', '', 'active'),
('en', 'admin', '0', 'my_listings_page_hint', 'Click [here] to edit \"My {type}\" page.', '', '0', '', 'active'),
('en', 'admin', '0', 'total_listings', 'Total Listings', '', '0', '', 'active'),
('en', 'admin', '0', 'listings_recounted', 'The listings have been successfully refreshed.', '', '0', '', 'active'),
('en', 'admin', '0', 'recount_text', 'Recalculate the number of listings in all categories', '', '0', '', 'active'),
('en', 'admin', '0', 'mass_listings_deleted', 'You\'ve successfully removed the selected listings.', '', '0', '', 'active'),
('en', 'admin', '0', 'mass_listings_dropped', 'You\'ve successfully moved the selected listings to the Trash Box.', '', '0', '', 'active'),
('en', 'admin', '0', 'listings_list', 'All Listings', '', '0', '', 'active'),
('en', 'admin', '0', 'full_category_delete', 'Remove the category with all its subcategories and listings irretrievably.', '', '0', '', 'active'),
('en', 'admin', '0', 'replace_parent_category', 'Assign all the subcategories and ads to another category before removing it.', '', '0', '', 'active'),
('en', 'admin', '0', 'no_listing_added', 'No listings have been added yet.', '', '0', '', 'active'),
('en', 'admin', '0', 'listing_moved', 'You\'ve successfully moved the selected listings.', '', '0', '', 'active'),
('en', 'admin', '0', 'saved_search_no_listings_found', 'No new listings have been found by the search criteria.', '', '0', '', 'active'),
('en', 'admin', '0', 'make_saved_search_notice', 'Are you sure you want to do a search by the criteria and send matching ads to the user?', '', '0', '', 'active'),
('en', 'admin', '0', 'listing_live_for_hint', 'Enter <b>0</b> to make listings active for an unlimited period.', '', '0', '', 'active'),
('en', 'admin', '0', 'listing_featured_annulled', 'The listings have been successfully downgraded to standard ones.', '', '0', '', 'active'),
('en', 'admin', '0', 'cross_listing_hint', 'Sets a number of mirror categories, in which listings will also be displayed.', '', '0', '', 'active'),
('en', 'admin', '0', 'listing_title_form', 'Listing Title Form', '', '0', '', 'active'),
('en', 'admin', '0', 'build_listing_title_form', 'Build Listing Title Form of {category} category', '', '0', '', 'active'),
('en', 'admin', '0', 'build_submit_form', 'Build Listing Form of the {category} category', '', '0', '', 'active'),
('en', 'admin', '0', 'full_account_delete', 'Remove the account type with all its user accounts and listings irretrievably.', '', '0', '', 'active'),
('en', 'admin', '0', 'replace_another_account_type', 'Assign all the user accounts and listings to another account type before removing it.', '', '0', '', 'active'),
('en', 'admin', '0', 'general_category_manage_hint', '[Build Listing Form] of the category; the form will be inherited by all subcategories.', '', '0', '', 'active'),
('en', 'admin', '0', 'listing_type_added', 'You\'ve successfully added a new listing type.', '', '0', '', 'active'),
('en', 'admin', '0', 'apply_pictures', 'Enable pictures', '', '0', '', 'active'),
('en', 'admin', '0', 'pre_listing_type_delete_notice', 'The <b>{type}</b> listing type has the following data:', '', '0', '', 'active'),
('en', 'admin', '0', 'replace_another_listing_type', 'Assign all the categories and listings to another type before removing it.', '', '0', '', 'active'),
('en', 'admin', '0', 'full_listing_type_drop', 'Move the listing type with all related data to the Trash Box.', '', '0', '', 'active'),
('en', 'admin', '0', 'full_listing_type_delete', 'Remove the listing type with all its categories and listings irretrievably.', '', '0', '', 'active'),
('en', 'admin', '0', 'remove_plan_crossed_option_notice', '<b>Warning</b>: All listings mirrored in other categories under the listing package will be disabled. Are you sure you want to proceed?', '', '0', '', 'active'),
('en', 'admin', '0', 'show_all_options_hint', 'Displays checked options of a field in a listing along with unchecked options greyed out.', '', '0', '', 'active'),
('en', 'admin', '0', 'plan_granted_in_use_notice', 'The multi-listing package you\'ve selected is already in use by <b>{username}</b>. You\'ll be able to grant it to the user after removing his current listing package; or increase the number of listings in his current listing package and try to grant the listing package again.', '', '0', '', 'active'),
('en', 'admin', '0', 'listing_owner_does_not_set', 'Please enter the username of a listing owner.', '', '0', '', 'active'),
('en', 'admin', '0', 'full_username_drop', 'Send the user account with all listings to the Trash Box.', '', '0', '', 'active'),
('en', 'admin', '0', 'listing_meta_title_des', 'Build custom title for Ad Details page with values of listing fields.', '', '0', '', 'active'),
('en', 'admin', '0', 'choose_listing_type', 'Select a listing type', '', '0', '', 'active'),
('en', 'admin', '0', 'resize_images', 'Refresh pictures after changing dimensions or watermark', '', '0', '', 'active'),
('en', 'admin', '0', 'resize_images_prompt', 'Picture settings have been changed. Would you like to resize all pictures now?', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'pages+title+rss_feed', 'Listing RSS Feed', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'pages+title+my_favorites', 'My Favorite Listings', '', '0', '', 'active'),
('en', 'common', '0', 'pages+name+add_listing', 'Add a Listing', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'pages+title+add_listing', 'Add a New Listing', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'pages+title+view_details', 'View Listing Details', '', '0', '', 'active'),
('en', 'common', '0', 'listing_plans+des+featured', 'The plan offers:  4 Featured listings  and  6 Standard listings.', '', '0', '', 'active'),
('en', 'common', '0', 'listing_plans+des+bronze', 'The bronze package allows you to add a listing with 5 pictures.', '', '0', '', 'active'),
('en', 'common', '0', 'listing_plans+des+gold_plan', 'The gold package is the best solution for you; the package allows you to add a listing with 15 pictures.', '', '0', '', 'active'),
('en', 'common', '0', 'account_rss_feed_caption', 'Listings by {name}', '', '0', '', 'active'),
('en', 'common', '0', 'search_results_sorting_mode', 'Search results: listings sorted by {field}', '', '0', '', 'active'),
('en', 'common', '0', 'unsaved_photos_notice', 'You\'ve selected <b>{number}</b> media files. Click <b>Upload</b> to upload them, or delete the files.', '', '0', '', 'active'),
('en', 'common', '0', 'notice_listing_plan_unavailable', 'The listing package is currently unavailable, please select another package.', '', '0', '', 'active'),
('en', 'common', '0', 'listing_id', 'Listing ID', '', '0', '', 'active'),
('en', 'common', '0', 'posted', 'Posted', '', '0', '', 'active'),
('en', 'common', '0', 'photos_count', 'Pictures', '', '0', '', 'active'),
('en', 'common', '0', 'max_file_size_caption', 'The maximum size of a picture users can upload:', '', '0', '', 'active'),
('en', 'common', '0', 'submit_form', 'Listing Form', '', '0', '', 'active'),
('en', 'common', '0', 'manage_photos', 'Manage Pictures', '', '0', '', 'active'),
('en', 'common', '0', 'selected_crossed_categories', 'Please select categories, in which listings will be mirrored.', '', '0', '', 'active'),
('en', 'common', '0', 'crossed_top_text', 'You can mirror your listing in {number} different categories below.', '', '0', '', 'active'),
('en', 'common', '0', 'cross_listing', 'Mirroring listings', '', '0', '', 'active'),
('en', 'common', '0', 'listings_left', 'Listings Left', '', '0', '', 'active'),
('en', 'common', '0', 'saved_search_search_results', '<b>{count}</b> listings found; details have been emailed to <b>{name}</b>.', '', '0', '', 'active'),
('en', 'common', '0', 'feature_mode_caption', 'Choose below if you want to post a standard ad or a featured one:', '', '0', '', 'active'),
('en', 'common', '0', 'listing_live', 'Listing live period', '', '0', '', 'active'),
('en', 'common', '0', 'waiting_approval', 'The listing is awaiting Administrator approval.', '', '0', '', 'active'),
('en', 'common', '0', 'photo_needs_crop', 'The picture needs to be cropped.', '', '0', '', 'active'),
('en', 'common', '0', 'move_listings', 'Move Listings', '', '0', '', 'active'),
('en', 'common', '0', 'crop_empty_coords', 'Please select an area to be cropped; click on the image keeping your left mouse button held down and move the cursor across the picture.', '', '0', '', 'active'),
('en', 'common', '0', 'crop_photo', 'Crop picture', '', '0', '', 'active'),
('en', 'common', '0', 'video_type', 'Video type', '', '0', '', 'active'),
('en', 'common', '0', 'featured_listing', 'Featured Listing', '', '0', '', 'active'),
('en', 'common', '0', 'feature_mode_caption_error', 'Please assign either standard or featured status to your listing.', '', '0', '', 'active'),
('en', 'common', '0', 'standard_listing', 'Standard Listing', '', '0', '', 'active'),
('en', 'common', '0', 'enable_for', 'Available to', '', '0', '', 'active'),
('en', 'common', '0', 'add_listing_to', 'Add a Listing to the {category} category', '', '0', '', 'active'),
('en', 'common', '0', 'listings', 'Listings', '', '0', '', 'active'),
('en', 'common', '0', 'new_listings', 'New Listings', '', '0', '', 'active'),
('en', 'common', '0', 'no_listing_photos', 'The listing doesn\'t have any pictures.', '', '0', '', 'active'),
('en', 'common', '0', 'with_photos_only', 'With pictures only', '', '0', '', 'active'),
('en', 'common', '0', 'pictures_manager', 'Picture Manager', '', '0', '', 'active'),
('en', 'common', '0', 'notice_listing_edited', 'You\'ve successfully edited the listing.', '', '0', '', 'active'),
('en', 'common', '0', 'edit_listing', 'Edit Listing', '', '0', '', 'active'),
('en', 'common', '0', 'no_items_in_sections', 'The listing type doesn\'t have any categories.', '', '0', '', 'active'),
('en', 'common', '0', 'listing_type', 'Listing type', '', '0', '', 'active'),
('en', 'common', '0', 'listing_plan', 'Single-listing Package', '', '0', '', 'active'),
('en', 'common', '0', 'package_plan', 'Multi-listing Package', '', '0', '', 'active'),
('en', 'common', '0', 'notice_listing_added', 'You\'ve successfully added a new listing.', '', '0', '', 'active'),
('en', 'common', '0', 'add_one_more_listing', 'Click [here] to post another ad.', '', '0', '', 'active'),
('en', 'common', '0', 'notice_delete_listing', 'Are you sure you want to remove the listing with all details?', '', '0', '', 'active'),
('en', 'common', '1', 'add_photo', 'Add a Picture', '', '0', '', 'active'),
('en', 'common', '0', 'listing_details', 'Listing details', '', '0', '', 'active'),
('en', 'common', '0', 'no_photos_uploaded', 'No pictures have been uploaded.', '', '0', '', 'active'),
('en', 'common', '0', 'upload_photo', 'Upload a picture', '', '0', '', 'active'),
('en', 'common', '0', 'listing_photos', 'Listing pictures', '', '0', '', 'active'),
('en', 'common', '0', 'no_more_photos', 'Your listing package \"<b>{plan}</b>\" allows you to add no more than <b>{count}</b> pictures.', '', '0', '', 'active'),
('en', 'common', '1', 'photo', 'Picture', '', '0', '', 'active'),
('en', 'common', '0', 'listing', 'Listing', '', '0', '', 'active'),
('en', 'common', '0', 'no_video_allowed', 'Your plan doesn&rsquo;t allow you to attach videos to listings.', '', '0', '', 'active'),
('en', 'common', '0', 'listing_video', 'Listing Video', '', '0', '', 'active'),
('en', 'common', '0', 'preview_image', 'Preview Image', '', '0', '', 'active'),
('en', 'common', '0', 'featured_type_featured', 'Featured Listings', '', '0', '', 'active'),
('en', 'admin', '0', 'resize_completed', 'Picture dimensions have been successfully updated.', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_listing_plans_manager', 'Listing Package Manager', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_build_listing_title', 'Build Listing Title', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_listing_groups_manager', 'Listing Group Manager', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_listings_manager', 'Listing Manager', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_listing_id', 'Listing ID', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_annul_featued_notice', 'Are you sure you want to downgrade the featured listings?', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_listings_count', 'Active Listings', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_search_listing_type', 'Search listing type / form name', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_manage_photo', 'Manage Pictures', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_listing_types_manager', 'Listing Type Manager', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_build_submit_form', 'Build Listing Form', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'ld_inactive_notice', 'The listing is either inactive or expired.', 'listing_details', '0', '', 'active'),
('en', 'system', '0', 'notice_payment_gateway_does_not_chose', 'Please select a <b>Payment Gateway</b> from the list.', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'no_listings_found_deny_posting', 'No listings have been found.', 'listing_type', '0', '', 'active'),
('en', 'frontEnd', '0', 'remote_delete_listing_alert', 'The requested listing hasn\'t been found or already activated.', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'remote_delete_listing_confirm', 'Are you sure you want to remove the listing irretrievably?', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'complete_posting', 'Complete', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'remote_delete_listing_removed', 'Your incomplete listing has been successfully removed; thank you for using our site!', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'notice_after_listing_adding', 'You\'ve successfully added a listing; it is awaiting Administrator approval.', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'notice_after_listing_adding_auto', 'You\'ve successfully added a listing; it has just been published on the site.', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'sort_listings_by', 'Sort listings by', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'no_listings_found', 'No listings have been found. [Click] to add a listing.', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'add_favorite_confirm', 'Are you sure you want to add the listing to Favorites?', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'remove_favorite_confirm', 'Are you sure you want to remove the listing from Favorites?', '', '0', '', 'active'),
('en', 'frontEnd', '1', 'notice_listing_removed_from_favorites', 'The listing has been removed from the Favorites.', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'search_saved', 'You\'ve successfully added an alert. We\'ll let you know about new ads matching your search criteria.', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'notice_listing_upgraded', 'Your listing package has been successfully upgraded.', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'notice_payment_listing_completed', 'Your payment has successfully gone through.<br />Please click [here] to check your listing details page.', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'notice_listing_plan_does_not_chose', 'Please select a <b>Listing Package</b> below.', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'no_packages_available', 'You don\'t have any listing packages; please click [here] to select/purchase a listing package.', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'notice_no_fields_related', 'The Administrator hasn\'t yet populated the listing form with fields, please contact the Administrator.', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'notice_no_plans_related', 'The Administrator hasn\'t yet assigned any listing packages to the category, please contact the Administrator.', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'notice_listing_category_inaccessible', 'Currently the category is inaccessible and you cannot edit your profile, please contact the Administrator.', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'add_listing_type_deny', 'Your account type doesn\'t offer the option to add listings to <b>{category_type}</b> categories.', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'add_listing_deny', 'Your account type doesn\'t offer the option to add listings.', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'remind_password_request_hash_fail', 'The \" password reset\" link you\'ve followed appears to be broken; please contact the Administrator.', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'plan_limit_using_deny', 'You\'ve exceeded the usage limit for the listing package, please select another package.', '', '0', '', 'active'),
('en', 'common', '0', 'featured_type_standard', 'Standard Listings', '', '0', '', 'active'),
('en', 'email_tpl', '0', 'email_templates+body+tell_friend', 'Hello {friend_name},\r\n\r\nA friend of yours named {name} has invited you to take a look at a listing he finds interesting:\r\n\r\n{message}\r\n\r\nFollow the link below to see the listing:\r\n\r\n{link}', '', '0', '', 'active'),
('en', 'email_tpl', '0', 'email_templates+subject+free_active_listing_created', 'Your ad posted on {site_name}', '', '0', '', 'active'),
('en', 'email_tpl', '0', 'email_templates+body+free_active_listing_created', 'Hello {name},\r\n\r\nYou have successfully added a new listing to {site_name}; the listing is active and can be\r\nmanaged in terms of adding pictures or videos and updating other details.\r\n\r\nYou may follow the link below to view the listing details:\r\n\r\n{link}', '', '0', '', 'active'),
('en', 'email_tpl', '0', 'email_templates+subject+free_approval_listing_created', 'Your ad posted and pending approval at {site_name}', '', '0', '', 'active'),
('en', 'email_tpl', '0', 'email_templates+body+free_approval_listing_created', 'Hello {name},\r\n\r\nYou\'ve successfully added a new listing to {site_name}. The listing hasn\'t yet been published pending approval of the Administrator.\r\n\r\nIf you think you missed something you may log in to manage your listing details:\r\n\r\n{link}', '', '0', '', 'active'),
('en', 'email_tpl', '0', 'email_templates+body+listing_deactivated', 'Hello {name},\r\n\r\nYour listing at {site_name} has been suspended by the Administrator.\r\n\r\nYou may email the Administrator to {site_email} for more details.', '', '0', '', 'active'),
('en', 'email_tpl', '0', 'email_templates+subject+listing_upgraded_active', 'Listing package upgraded at {site_name}', '', '0', '', 'active'),
('en', 'email_tpl', '0', 'email_templates+body+listing_upgraded_active', 'Hello {name},\r\n\r\nYou have successfully upgraded your listing package to {plan}, and now your listing is active:\r\n\r\n{link}', '', '0', '', 'active'),
('en', 'email_tpl', '0', 'email_templates+subject+listing_upgraded_approval', 'Your listing package upgraded and ad pending at {site_name}', '', '0', '', 'active'),
('en', 'email_tpl', '0', 'email_templates+body+listing_upgraded_approval', 'Hello {name},\r\n\r\nYou\'ve successfully upgraded your listing package to {plan}.\r\nYour listing is disabled pending approval of the Administrator.', '', '0', '', 'active'),
('en', 'email_tpl', '0', 'email_templates+subject+listing_activated', 'Your ad activated at {site_name}', '', '0', '', 'active'),
('en', 'email_tpl', '0', 'email_templates+body+listing_activated', 'Hello {name},\r\n\r\nYour listing has been activated at {site_name}.\r\nYou may follow the link below to view the listing details:\r\n\r\n{link}', '', '0', '', 'active'),
('en', 'email_tpl', '0', 'email_templates+subject+listing_deactivated', 'Your ad suspended at {site_name}', '', '0', '', 'active'),
('en', 'email_tpl', '0', 'email_templates+subject+cron_saved_search_match', 'An ad matching your criteria found at {site_name}', '', '0', '', 'active'),
('en', 'email_tpl', '0', 'email_templates+body+cron_saved_search_match', 'Hello {name},\r\n\r\nAbout {count} new ads posted at {site_name} match criteria of your alert.\r\n\r\nYou may follow the links below to check the new listings:\r\n\r\n{links}\r\n\r\n', '', '0', '', 'active'),
('en', 'email_tpl', '0', 'email_templates+subject+listing_moved', 'Your ad moved to another category at {site_name}', '', '0', '', 'active'),
('en', 'email_tpl', '0', 'email_templates+body+listing_moved', 'Hello {name},\r\n\r\nYour listing: {listing_title} has been moved to the {category} category.\r\n\r\nYou may find the listing at the link below:\r\n\r\n{link}', '', '0', '', 'active'),
('en', 'email_tpl', '0', 'email_templates+subject+admin_listing_added', 'A new ad posted at {site_name}', '', '0', '', 'active'),
('en', 'email_tpl', '0', 'email_templates+body+admin_listing_added', 'Hello Administrator,\r\n\r\nA new listing has been posted on {site_name}.\r\n\r\nListing Details\r\nOwner: {name}\r\nDate of posting: {date}\r\nStatus: {status}\r\nPayment Status: {paid}\r\nLink: {link}\r\n\r\n{if activation is enabled}\r\nPlease follow the link to activate the listing:\r\n{activation_link}\r\n{/if}', '', '0', '', 'active'),
('en', 'email_tpl', '0', 'email_templates+subject+admin_listing_paid', 'Payment for an ad accepted at {site_name}', '', '0', '', 'active'),
('en', 'email_tpl', '0', 'email_templates+body+admin_listing_paid', 'Hello Administrator,\r\n\r\nA payment has been successfully accepted:\r\n\r\n<u>Payment Details:</u>\r\nOwner: <strong>{name}</strong>\r\nProfile ID: <strong>{id}</strong>\r\nGateway: <strong>{gateway}</strong>\r\nTransaction ID: <strong>{txn}</strong>\r\nItem: <strong>{item}</strong>\r\nItem price: <strong>{price}</strong>\r\nDate: <strong>{date}</strong>\r\n\r\nYou can check the payment from the Transaction Manager.\r\n', '', '0', '', 'active'),
('en', 'email_tpl', '0', 'email_templates+body+custom_category_deleted', 'Hello {name},\r\n\r\nUnfortunately, the <strong>{category_name}</strong>A subcategory you requested has been rejected by the Administrator.\r\nYou may email the Administrator to {site_email} for more details.\r\n\r\n{if listing}\r\n\r\nYour listing has been moved to the parent category from the subcategory you\'ve added.\r\nIf you have already paid for it you can find it published at the link below:\r\n{link}\r\n{/if}\r\n', '', '0', '', 'active'),
('en', 'email_tpl', '0', 'email_templates+body+custom_category_activated', 'Hello {name},\r\n\r\nThe <strong>{category_name}</strong> subcategory you\'d requested was approved and activated by the Administrator:\r\n\r\n{category_location}\r\n\r\n{if listing}\r\nYour listing has been published and can be found in the user interface at the link below:\r\n{link}\r\n{/if}\r\n', '', '0', '', 'active'),
('en', 'email_tpl', '0', 'email_templates+body+featured_listing_annulled', 'Hello {name},\r\n\r\nYour featured listing at {site_name} has been downgraded by the Administrator.\r\n\r\nListing: <strong>{link}</strong>\r\nAdministrator: <strong>{admin}</strong>\r\nDate: <strong>{date}</strong>\r\n', '', '0', '', 'active'),
('en', 'email_tpl', '0', 'email_templates+subject+featured_listing_annulled', 'Your featured ad downgraded at {site_name}', '', '0', '', 'active'),
('en', 'email_tpl', '0', 'email_templates+body+listing_removed_by_admin', 'Hello {name},\r\n\r\nYour listing: \"{listing_title}\" at {site_name} has been removed by the Administrator due to the following reason:\r\n\r\n{reason}\r\n\r\nYou may [contact] the Administrator if you have any comments or questions.\r\n', '', '0', '', 'active'),
('en', 'email_tpl', '0', 'email_templates+subject+listing_removed_by_admin', 'Your ad removed by Administrator at {site_name}', '', '0', '', 'active'),
('en', 'email_tpl', '0', 'email_templates+body+grant_plan', 'Hello {name},\r\n\r\nYou\'ve been granted a <strong>{plan_name}</strong> package. The package is available for adding listings at {add_listing}.\r\n\r\n<strong>Plan Description</strong>:\r\n{plan_description}\r\n\r\nThe newly granted listing package will be added to the others you have, if any, and you\'ll be able to choose from the packages when adding listings.\r\n', '', '0', '', 'active'),
('en', 'email_tpl', '0', 'email_templates+subject+grant_plan', 'An ad package granted at {site_name}', '', '0', '', 'active'),
('en', 'email_tpl', '0', 'email_templates+body+edit_listing_pending', 'Hello {name},\r\n\r\nThe status of your listing at {site_name} has been changed to pending to be approved. We apologize for this inconvenience, but we do it in order to avoid offensive content on our site. Your listing will be activated once reviewed by the Administrator.\r\n\r\nClick [here] to view the listing details.\r\n', '', '0', '', 'active'),
('en', 'email_tpl', '0', 'email_templates+subject+edit_listing_pending', 'Your ad pending approval after editing at {site_name}', '', '0', '', 'active'),
('en', 'email_tpl', '0', 'email_templates+body+admin_listing_edited', 'Hello Administrator,\r\n\r\nA user has edited his listing at {site_name}.\r\n\r\n<strong><u>Details:</u></strong>\r\nOwner: <strong>{name}</strong>,\r\nDate of posting: <strong>{date}</strong>,\r\nStatus: <strong>{status}</strong>,\r\nLink: {link}\r\n\r\nPlease follow the link to review the edited listing:\r\n{activation_link}\r\n', '', '0', '', 'active'),
('en', 'email_tpl', '0', 'email_templates+subject+admin_listing_edited', 'User edited his ad at {site_name}', '', '0', '', 'active'),
('en', 'email_tpl', '0', 'email_templates+body+listing_upgraded_to_featured_for_admin', 'Hello Administrator,\r\n\r\n{listing} listing has been upgraded to featured. You may find details below:\r\n\r\nPackage: {plan_name}\r\nListing ID: {listing_id}\r\nOwner: {owner}\r\nStarting date: {start_date}\r\nExpiration date: {expiration_date}\r\n', '', '0', '', 'active'),
('en', 'email_tpl', '0', 'email_templates+subject+listing_upgraded_to_featured_for_admin', 'An ad upgraded to featured at {site_name}', '', '0', '', 'active'),
('en', 'email_tpl', '0', 'email_templates+subject+listing_upgraded_to_featured', 'Your ad upgraded to featured at {site_name}', '', '0', '', 'active'),
('en', 'email_tpl', '0', 'email_templates+body+listing_upgraded_to_featured', 'Hello {name},\r\n\r\nYour listing <strong>{listing}</strong> has been upgraded to featured; you may find details below:\r\n\r\nPackage: <strong>{plan_name}</strong>\r\nPrice: <strong>{plan_price}</strong>\r\nStarting date: <strong>{start_date}</strong>\r\nExpiration date: <strong>{expiration_date}</strong>\r\n\r\n{if paid}\r\n<u>Transaction Details:</u>\r\nPayment gateway: <strong>{gateway}</strong>\r\nTransaction ID: {txn}\r\nTotal amount: <strong>{amount}</strong>\r\nItem name: {item}\r\nPayment date: {payment_date}\r\n{/if}\r\n', '', '0', '', 'active'),
('en', 'email_tpl', '0', 'email_templates+subject+listing_plan_removed', 'Your ad suspended after removal of listing package at {site_name}', '', '0', '', 'active'),
('en', 'email_tpl', '0', 'email_templates+body+listing_plan_removed', 'Hello {name},\r\n\r\nYour listing: {link} posted on {site_name} has been suspended as the package of your listing was removed.\r\n\r\nThe reason for removing: {reason}\r\n\r\nYou may [contact] the Administrator for getting more information.\r\n', '', '0', '', 'active'),
('en', 'email_tpl', '0', 'email_templates+body+quick_account_created', 'Hello {name},\r\n\r\nYour account at {site_name} has been created automatically. To update your profile, edit your listings and their status, read messages from users etc, please use the login details below:\r\n\r\n{site_url}\r\n\r\nUsername: {login}\r\nPassword: {password}\r\n', '', '0', '', 'active'),
('en', 'email_tpl', '0', 'email_templates+subject+cron_incomplete_listing2', 'You have incomplete ad{if many}s{/if} at {site_name}', '', '0', '', 'active'),
('en', 'email_tpl', '0', 'email_templates+body+cron_incomplete_listing2', 'Hello {name},\r\n\r\n{if one}\r\nChecking our records for new listings we\'ve found that you have an incomplete listing:\r\n\r\n{listing_title}\r\n\r\nIf you were unable to complete your listing for some reason, you can do it within {number_days} days;\r\notherwise it will be removed, if no action is taken.\r\n\r\nPlease click the link below to complete your listing and enjoy the opportunities that our site offers you:\r\n\r\n{complete_link}\r\n\r\nIf you are no longer interested in completing the listing, please follow the link below to remove it:\r\n\r\n{delete_link}\r\n{/if}\r\n{if many}\r\nYou have incomplete listings at {site_name}. You may log in to either complete or remove them: \r\n\r\n{links}\r\n{/if}\r\n', '', '0', '', 'active'),
('en', 'email_tpl', '0', 'email_templates+subject+cron_listing_expired2', 'Your ad{if many}s{/if} expired at {site_name}', '', '0', '', 'active'),
('en', 'email_tpl', '0', 'email_templates+body+cron_listing_expired2', 'Hello {name},\r\n\r\n{if many}Your listings at {site_name} have expired:\r\n\r\n{links}{/if}\r\n\r\n{if one}Your listing at {site_name} has expired: \r\n\r\n{details_link}\r\n\r\nYou may renew your listing at the link below:\r\n{renew_link}{/if}\r\n', '', '0', '', 'active'),
('en', 'email_tpl', '0', 'email_templates+subject+cron_listing_pre_expired2', 'Your ad{if many}s{/if} will expire at {site_name}', '', '0', '', 'active'),
('en', 'email_tpl', '0', 'email_templates+body+cron_listing_pre_expired2', 'Hello {name},\r\n\r\n{if one}Your listing will expire in {days} days on ({expire_date}).\r\nPlease log into {site_name} to renew or upgrade your listing, or use the following link:\r\n\r\n{renew_link}\r\n\r\nYou may find details of the listing at the link below:\r\n\r\n{details_link}{/if}\r\n\r\n{if many}Your listings are about to expire.\r\nPlease log into {site_name} to renew or upgrade your listings, or use the following links:\r\n\r\n{links}{/if}\r\n', '', '0', '', 'active'),
('en', 'email_tpl', '0', 'email_templates+subject+cron_featured_status_expired2', 'Your featured ad{if many}s{/if} expired at {site_name}', '', '0', '', 'active'),
('en', 'email_tpl', '0', 'email_templates+body+cron_featured_status_expired2', 'Hello {name},\r\n\r\n{if one}Your featured listing at {site_name} has expired. The system will downgrade its status to a standard one.\r\n\r\nIf you want to keep the status of your featured listing; please log in to renew it, or use the following link:\r\n\r\n{renew_link}\r\n\r\nYou may find details of your featured listing at the link below:\r\n\r\n{details_link}{/if}\r\n\r\n{if many}The featured package of some of your listings have expired. Please log into {site_name} to upgrade your listing package, or use the links below:\r\n\r\n{links}{/if}', '', '0', '', 'active'),
('en', 'email_tpl', '0', 'email_templates+body+cron_featured_status_pre_expired2', 'Hello {name},\r\n\r\n{if one}The featured package of your listing will expire in {days} days on ({expire_date}).\r\nPlease log into {site_name} to renew or upgrade your listing package, or use the link below:\r\n\r\n{renew_link}{/if}\r\n\r\n{if many}The featured package of some of your listings will expire soon. Please log into {site_name} to upgrade your listing package, or use the links below:\r\n\r\n{links}{/if}\r\n', '', '0', '', 'active'),
('en', 'admin', '0', 'config+name+cron_expired_remove_divider', 'Checking for Expired Listings', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+cron_expired_remove', 'Remove expired listings', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+cron_expired_listing_days', 'Remove expired listings in', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'individual_add_listing_page', 'Individual Post an Ad page', '', '0', '', 'active'),
('en', 'admin', '0', 'add_listing_path_pattern', 'add-{type}-listing', '', '0', '', 'active'),
('en', 'admin', '0', 'add_listing_name_pattern', 'Post an Ad to {type}', '', '0', '', 'active'),
('en', 'admin', '0', 'config+name+tell_a_friend_tab', 'Tell-a-Friend tab in listing details', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+recently_added_order_field', 'Sort ads on recently added page by', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'myads', 'My Listings', '', '0', '', 'active'),
('en', 'admin', '0', 'myads_search', 'Search on My Listings page', '', '0', '', 'active'),
('en', 'common', '0', 'save_search_text', 'Or [Add an Alert] to get emails about new ads matching your criteria.', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'greater_listing_number', 'Number of ads (Descending)', '', '0', '', 'active'),
('en', 'admin', '0', 'with_picture_option', 'With picture option', '', '0', '', 'active'),
('en', 'admin', '0', 'move_listing_failed', 'No listings have been moved; probably you\'re trying to move them to the same category where they are.', '', '0', '', 'active'),
('en', 'common', '0', 'notice_has_active_subscription', 'You use an active subscription plan for the listing. You won\'t be able to upgrade to another plan until you cancel the current subscription plan.', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_notice_delete_general', 'Are you sure you want to remove the primary category, from which other categories may inherit their listing forms; this may cause such categories to be empty?', '', '0', '', 'active'),
('en', 'admin', '0', 'notice_delete_general', 'Are you sure you want to remove the primary category, from which other categories may inherit their listing forms; this may cause such categories to be empty?', '', '0', '', 'active'),
('en', 'admin', '0', 'mf_subdomain_denied', 'You cannot enable \"Locations on Subdomains\" because subdomains are already enabled for listing types.', '', '0', '', 'active'),
('en', 'admin', '0', 'refresh_coordinates', 'Refresh listing locations', 'controls', '0', '', 'active'),
('en', 'admin', '0', 'listing_locations_refreshed', 'Listing locations refreshed, listing locations updated: {updated}, failed: {failed}', 'controls', '0', '', 'active'),
('en', 'common', '0', 'exceeded_listing_limit', 'You&rsquo;ve exceeded the listing limit of your membership plan. Please follow the [link] to buy a new one.', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'view_picture_hint', 'To view the picture please', '', '0', '', 'active'),
('en', 'admin', '0', 'search_form_on_type_page', 'Search form on the {listing_type} page', '', '0', '', 'active'),
('en', 'admin', '0', 'config+name+allow_listing_plans', 'Listing packages', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+des+allow_listing_plans', 'Allows users to purchase listing packages along with membership plans.', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+base_listing_plan', 'Listing package', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'have_membership_active_listings', 'You\'ve added {count} listings under your membership plan. Please select a listing package you want to apply to the listings.', '', '0', '', 'active'),
('en', 'admin', '0', 'listing_options', 'Listing options', '', '0', '', 'active'),
('en', 'admin', '0', 'options_per_listing', 'Options per listing', '', '0', '', 'active'),
('en', 'common', '0', 'ms_listings_left', 'Listings Left', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'membership_is_not_paid', 'You will be able to post ads once you purchase a membership plan.', '', '0', '', 'active'),
('en', 'admin', '0', 'decrease_listing_number', 'Deduct the listing from user-owned membership plan', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'view_picture_not_available', 'The membership plan doesn\'t allow you to view this picture.', '', '0', '', 'active'),
('en', 'common', '0', 'listing_type_not_available', 'You&rsquo;ve exceeded the limit for this listing type; please choose the other type.', '', '0', '', 'active'),
('en', 'email_tpl', '0', 'email_templates+subject+bulk_listing_activated', 'Your ads activated at {site_name}', '', '0', '', 'active'),
('en', 'email_tpl', '0', 'email_templates+body+bulk_listing_activated', 'Hello {name},\r\n\r\nYour listings at {site_name} have been activated.\r\nPlease follow the links below to view the listing details:\r\n\r\n{links}\r\n', '', '0', '', 'active'),
('en', 'email_tpl', '0', 'email_templates+subject+bulk_listing_deactivated', 'Your ads suspended at {site_name}', '', '0', '', 'active'),
('en', 'email_tpl', '0', 'email_templates+body+bulk_listing_deactivated', 'Hello {name},\r\n\r\nYour listings at {site_name} have been suspended by the Administrator.\r\nYou may contact the Administrator for more details.\r\nYou have: {count} suspended listings. \r\n', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'membership_plan_not_allow_add_listing', 'Posting ads is not available to you under the membership plan; click [here] to renew/purchase a membership plan.', '', '0', '', 'active'),
('en', 'admin', '0', 'account_type_not_allow_add_listing', 'The {type} account type doesn\'t allow you to add listings, please choose another type.', '', '0', '', 'active'),
('en', 'admin', '0', 'confirm_change_listing_status', 'Changing status of the listing will renew the membership plan, under which it was added, and all expired listings under this plan and connected to your account; are you sure you want to proceed?', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'not_available_free_cells', 'The plan allows you to have {count} active listings; to enable the listing, please disable one of your active listings.', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'status_changed_ok', 'The status of your listing has been successfully updated.', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'status_changed_fail', 'The system failed to change the status of your listing; please contact the Administrator.', '', '0', '', 'active');
INSERT INTO `{db_prefix}lang_keys` (`Code`, `Module`, `JS`, `Key`, `Value`, `Target_key`, `Modified`, `Plugin`, `Status`) VALUES
('en', 'frontEnd', '0', 'type_changed_ok', 'The type of your listing has been successfully updated.', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'type_changed_fail', 'The system failed to change the type of your listing; please contact the Administrator.', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'not_available_free_cells_standard', 'The plan allows you to have {count} standard listings. You\'ve already exceeded the limit for standard ads. To make the listing standard please change status of one of your standard listings to featured, and give it another try.', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'not_available_free_cells_featured', 'The plan allows you to have {count} featured listings. You\'ve already exceeded the limit for featured ads. To make the listing featured please change status of one of your featured listings to standard, and give it another try.', '', '0', '', 'active'),
('en', 'admin', '0', 'listing_limit_exceeded_admin', 'The user has exceeded the limit for listings, please select another user or change the plan of the user.', '', '0', '', 'active'),
('en', 'admin', '0', 'confirm_change_listing_type', 'The plan of the user doesn\'t offer featured ads; you may reassign it as a standard listing, are you sure you want to proceed?', '', '0', '', 'active'),
('en', 'admin', '0', 'listing_statistic_mp_recount', 'Recalculate the number of listings added under membership plans', '', '0', '', 'active'),
('en', 'admin', '0', 'config+name+listings_per_page', 'Number of listings per page', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+view_details_new_window', 'Listing details in a new window', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+lisitng_get_children', 'Subcategory ads in parent category', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+cron_incompl_listings_notify_days', 'Send notifications about incomplete listings in', 'settings', '0', '', 'active'),
('en', 'common', '0', 'membership_services+name+add_listing', 'Add listings', '', '0', '', 'active'),
('en', 'common', '0', 'membership_services+name+view_photos', 'View pictures', '', '0', '', 'active'),
('en', 'common', '0', 'membership_services+name+view_contacts', 'View contact details', '', '0', '', 'active'),
('en', 'common', '0', 'membership_services+name+featured', 'Featured account', '', '0', '', 'active'),
('en', 'common', '0', 'add_listing', 'Post an Ad', '', '0', '', 'active'),
('en', 'email_tpl', '0', 'email_templates+body+listing_added_to_featured', 'Dear {name},\r\n\r\nYour listing at {site_name} has been upgraded to featured by the Administrator.\r\n\r\nListing: <b>{link}</b>\r\nAdministrator: <b>{admin}</b>\r\nDate: <b>{date}</b>\r\n\r\n', '', '0', '', 'active'),
('en', 'email_tpl', '0', 'email_templates+subject+listing_added_to_featured', 'Your listing at {site_name} upgraded to featured', '', '0', '', 'active'),
('en', 'admin', '0', 'incorrect_dump_file', 'The file you\'ve uploaded has an incorrect extension, please use files in .sql format.', '', '0', '', 'active'),
('en', 'admin', '0', 'admin_blocks+name+plugins_log', 'Plugin Changelog', 'home', '0', '', 'active'),
('en', 'admin', '0', 'admin_blocks+name+statistics', 'Statistics', 'home', '0', '', 'active'),
('en', 'admin', '0', 'admin_blocks+name+flynax_news', 'Flynax Blog Feed', 'home', '0', '', 'active'),
('en', 'admin', '0', 'admin_controllers+name+common', 'Common', '', '0', '', 'active'),
('en', 'admin', '0', 'admin_controllers+name+home', 'Dashboard', '', '0', '', 'active'),
('en', 'admin', '0', 'admin_controllers+name+config', 'Basic Settings', '', '0', '', 'active'),
('en', 'admin', '0', 'admin_controllers+name+languages', 'Languages', '', '0', '', 'active'),
('en', 'admin', '0', 'admin_controllers+name+statistics', 'Statistics', '', '0', '', 'active'),
('en', 'admin', '0', 'admin_controllers+name+trash', 'Trash Box', '', '0', '', 'active'),
('en', 'admin', '0', 'admin_controllers+name+categories', 'Categories', '', '0', '', 'active'),
('en', 'admin', '0', 'admin_controllers+name+listing_groups', 'Field Groups', '', '0', '', 'active'),
('en', 'admin', '0', 'admin_controllers+name+data_formats', 'Data Entries', '', '0', '', 'active'),
('en', 'admin', '0', 'admin_controllers+name+blocks', 'Content Boxes', '', '0', '', 'active'),
('en', 'admin', '0', 'admin_controllers+name+content', 'Content', '', '0', '', 'active'),
('en', 'admin', '0', 'admin_controllers+name+pages', 'Pages', '', '0', '', 'active'),
('en', 'admin', '0', 'admin_controllers+name+admins', 'Administrators', '', '0', '', 'active'),
('en', 'admin', '0', 'admin_controllers+name+active_accounts', 'Active Accounts', '', '0', '', 'active'),
('en', 'admin', '0', 'admin_controllers+name+saved_searches', 'Alerts', '', '0', '', 'active'),
('en', 'admin', '0', 'admin_controllers+name+email_templates', 'Email Templates', '', '0', '', 'active'),
('en', 'admin', '0', 'admin_controllers+name+account', 'User Accounts', '', '0', '', 'active'),
('en', 'admin', '0', 'admin_controllers+name+all_accounts', 'Accounts', '', '0', '', 'active'),
('en', 'admin', '0', 'admin_controllers+name+account_fields', 'Registration Fields', '', '0', '', 'active'),
('en', 'admin', '0', 'admin_controllers+name+pending_accounts', 'Pending Accounts', '', '0', '', 'active'),
('en', 'admin', '0', 'admin_controllers+name+forms', 'Forms', '', '0', '', 'active'),
('en', 'admin', '0', 'admin_controllers+name+search_forms', 'Search Forms', '', '0', '', 'active'),
('en', 'admin', '0', 'admin_controllers+name+news', 'News', '', '0', '', 'active'),
('en', 'admin', '0', 'admin_controllers+name+contacts', 'Messages', '', '0', '', 'active'),
('en', 'admin', '0', 'admin_controllers+name+new_accounts', 'New Accounts', '', '0', '', 'active'),
('en', 'admin', '0', 'admin_controllers+name+controls', 'Refresh', '', '0', '', 'active'),
('en', 'admin', '0', 'admin_controllers+name+plugins', 'Plugins', '', '0', '', 'active'),
('en', 'admin', '0', 'admin_controllers+name+transactions', 'Transactions', '', '0', '', 'active'),
('en', 'admin', '0', 'admin_controllers+name+browse', 'Browse', '', '0', '', 'active'),
('en', 'admin', '0', 'admin_controllers+name+add_category', 'Add a Category', '', '0', '', 'active'),
('en', 'admin', '0', 'admin_controllers+name+database', 'Database', '', '0', '', 'active'),
('en', 'admin', '0', 'admin_controllers+name+custom_categories', 'Subcategories by Users', '', '0', '', 'active'),
('en', 'admin', '0', 'admin_controllers+name+map_amenities', 'Amenities on Maps', '', '0', '', 'active'),
('en', 'admin', '0', 'admin_controllers+name+plans_using', 'Plan Usage Stats', '', '0', '', 'active'),
('en', 'admin', '0', 'admin_controllers+name+account_types', 'Account Types', '', '0', '', 'active'),
('en', 'admin', '0', 'admin_controllers+name+account_forms', 'Account Forms', '', '0', '', 'active'),
('en', 'admin', '0', 'admin_controllers+name+messages', 'My Messages', '', '0', '', 'active'),
('en', 'admin', '0', 'config_groups+name+general', 'General', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config_groups+name+accounts', 'Accounts', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config_groups+name+mail', 'Email', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config_groups+name+video', 'Video', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config_groups+name+news', 'News', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config_groups+name+search', 'Search', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config_groups+name+messages', 'Messaging', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config_groups+name+admin_panel', 'Dashboard', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config_groups+name+google_map', 'Maps/Geocoding', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config_groups+name+cron', 'Cron Jobs', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config_groups+name+cache', 'Cache', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config_groups+name+security_img', 'Security', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+template', 'Template', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+mod_rewrite', 'SEO URLs (Apache rewrite module)', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+lang', 'Default language', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+expire_languages', 'Language cookie expiration period', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+encoding', 'Output encoding', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+trash', 'Trash box', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+account_password_strength', 'Password strength control', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+login_redirect', 'After logging page', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+paypal_account_email', 'PayPal account email', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+paypal_merchant_id', 'Merchant ID', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+2co_id', 'Merchant Code', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+2co_secret_word', 'Secret word', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+general_common', 'Common Settings', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+general_languages', 'Language Settings', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+general_email', 'General', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+site_main_email', 'Site email', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+owner_name', 'Site owner name', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+mail_method', 'Mail method', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+smtp_divider', 'SMTP Settings', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+smtp_server', 'SMTP server:port', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+smtp_username', 'SMTP server username', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+smtp_password', 'SMTP server password', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+short_form_divider', 'Browse Form Settings', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+sf_display_fields', 'Field names in browse form', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+video_width', 'Video width', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+video_height', 'Video height', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+video_allowfullscreen', 'Enable full screen', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+video_autostart', 'Autostart', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+video_bufferlength', 'Buffer length', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+video_repeat', 'Enable autorepeat', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+video_smoothing', 'Enable smoothing', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+video_volume', 'Default volume', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+news_block_content_length', 'News excerpt length in the News box', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+news_block_news_in_block', 'Number of articles in a News box', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+news_page_content_length', 'News excerpt length on the News page', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+news_at_page', 'Number of articles on News page', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+messages_module', 'Messaging module', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+messages_length', 'Maximum message length', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+messages_refresh', 'Check for new messages every', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+security_img_tell_friend', 'Captcha on the Tell-a-Friend form', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+security_img_contact_us', 'Captcha on the Contact Us page', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+advertising', 'Advertising Listings', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+reefless_news_block', 'Flynax news feed', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+reefless_news_number', 'Number of posts in the Flynax news box', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+miscellaneous', 'Miscellaneous', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+random_block_slideshow_delay', 'Slideshow delay for featured gallery on Home page', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+map_module', 'Maps module', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+map_default_zoom', 'Location default zoom', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+google_map_key', 'Google API key', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+system_currency', 'Currency symbol', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+des+system_currency', 'Symbols are shown to users, for example as: $.', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+system_currency_code', 'Currency code', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+des+system_currency_code', 'Codes used in payment gateways must comply with ISO 4717.', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+check_search', 'Checking for Alerts', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+searches_per_run', 'Number of alerts to be checked per one run', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+listings_checking_notification', 'Email the Administrator every time cron jobs are run', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+notifications_email', 'Notification/bug report email', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+cat_common', 'Common', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+subcat_common', 'Subcategories', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+address_on_map', 'Synchronize addresses', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+pg_upload_thumbnail_height', 'Thumbnail height (in pixels)', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+pg_upload_thumbnail_width', 'Thumbnail width (in pixels)', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+pg_upload_divider', 'Picture Dimensions in Listings', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+img_common', 'Common', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+img_watermark_devider', 'Watermarking', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+img_crop_devider', 'Cropping of Pictures in Listings', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+img_crop_module', 'Autocropping of large pictures', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+img_crop_thumbnail', 'Autocropping of listing thumbnails', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+img_crop_interface', 'Cropping by users', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+map_amenities', 'Local amenities', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+system_currency_position', 'Currency position', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+admin_hide_denied_items', 'Hide limited access sections', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+watermark_type', 'Watermark type', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+watermark_image_url', 'URL of a PNG image', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+fckeditor_bar', 'FCKeditor bar view', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+show_cents', 'Zero cents in prices', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+price_delimiter', 'Separator symbol in prices', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+flynax_news_number', 'Number of Flynax news posts', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+account_edit_email_confirmation', 'Email change verification', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+messages_notification', 'Email users about new messages', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+account_common_divider', 'Common Settings', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+account_wildcard_divider', 'Wildcard Subdomain Settings', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+account_wildcard', 'Wildcard subdomains', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+account_wildcard_deny', 'Restrain users from adding the following subdomains/subdirectories', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+video_thumbnail_position', 'Thumbnail position', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+video_display_type', 'Display a video type', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+cache', 'Common caching', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+cron_messages_divider', 'Checking for Trashed Messages', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+cron_messages_remove', 'Remove trashed messages', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+transactions_per_page', 'Transactions per page', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+mobile_common_divider', 'Common', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+mobile_template', 'Template', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+mobile_url_divider', 'URL builder', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+mobile_location_type', 'Build URL as a', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+mobile_location_name', 'Preferred name (use 1 or more than 2 characters)', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+paypal_sandbox', 'PayPal sandbox', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+2co_testmode', '2CO test mode', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+gallery_slideshow_divider', 'Slideshow Settings', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+gallery_slideshow', 'Slideshow module', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+gallery_slideshow_delay', 'Slideshow delay', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+timezone', 'Time zone', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+security_img_devider', 'Captcha Settings', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+security_login_attempt_admin_divider', 'Login Attempt Control for Admin Panel', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+security_login_attempt_admin_module', 'Login attempt control', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+security_login_attempt_admin_attempts', 'Number of attempts allowed', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+security_login_attempt_admin_period', 'Per', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+security_login_attempt_user_divider', 'Login Attempt Control for User Interface', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+security_login_attempt_user_module', 'Login attempt control', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+security_login_attempt_user_attempts', 'Number of attempts allowed', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+security_login_attempt_user_period', 'Per', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+watermark_text', 'Watermark text', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+img_quality', 'Image quality', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+security_img_registration', 'Captcha on the Registration page', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+security_code_length', 'Number of characters in captcha', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+account_thumb_divider', 'Thumbnail Dimensions', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+account_thumb_width', 'Width', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+account_thumb_height', 'Height', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+des+expire_languages', 'days', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+des+video_width', 'px', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+des+video_height', 'px', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+des+video_bufferlength', 'Number of seconds a video should be buffered ahead before the player starts it.', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+des+news_block_content_length', 'characters', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+des+news_page_content_length', 'characters', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+des+admin_hide_denied_items', 'Hides restricted sections from administrators with limited access in admin panel.', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+des+messages_refresh', 'seconds', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+des+new_period', 'days', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+des+random_block_slideshow_delay', 'in seconds', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+des+pre_days', 'days', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+des+watermark_image_url', '<div>You must use a PNG image with the transparent background.</div>', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+des+cron_messages_remove', 'The cron will check if a message was deleted by both a sender and a recipient and will remove it completely.', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+des+cron_incomplete_listing_days', 'day(s)', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+des+gallery_slideshow_delay', 'in seconds', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+des+security_login_attempt_admin_period', 'hour(s)', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+des+security_login_attempt_user_period', 'hour(s)', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+des+img_quality', 'Ranges from 0 to 100 (We recommend setting the quality to 70)', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+des+security_code_length', '10 characters maximum', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+des+ld_keep_alive', 'The option is unavailable with the Trash Box disabled.', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+option+system_currency_position_after', 'After', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+option+system_currency_position_before', 'Before', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'notice_category_exist', 'The category with the {key} key already exists.', '', '0', '', 'active'),
('en', 'admin', '0', 'notice_group_exist', 'The group with the {key} key already exists, please consider using a different one.', '', '0', '', 'active'),
('en', 'admin', '0', 'notice_item_key_exist', 'The item with the {key} key already exists, please consider using a different one.', '', '0', '', 'active'),
('en', 'admin', '0', 'notice_page_exist', 'The page with the {key} key already exists, please consider using a different one.', '', '0', '', 'active'),
('en', 'admin', '0', 'notice_page_path_exist', 'The URL {path} is already used by another page.', '', '0', '', 'active'),
('en', 'admin', '0', 'notice_block_exist', 'The box with the {key} key already exists, please consider using a different one.', '', '0', '', 'active'),
('en', 'admin', '0', 'notice_field_not_found', 'The field you\'re looking for hasn\'t been found.', '', '0', '', 'active'),
('en', 'admin', '0', 'notice_key_exist', 'The key {key} that you entered is already in use.', '', '0', '', 'active'),
('en', 'admin', '0', 'notice_field_exist', 'The field with the {key} key already exists.', '', '0', '', 'active'),
('en', 'admin', '0', 'notice_type_empty', 'Please select a field type from the list.', '', '0', '', 'active'),
('en', 'admin', '0', 'notice_admin_exist', 'The admin account with the {username} username already exists, please consider using a different one.', '', '0', '', 'active'),
('en', 'admin', '0', 'notice_template_exist', 'The template with the {key} key already exists.', '', '0', '', 'active'),
('en', 'admin', '0', 'notice_mode_not_chose', 'Please select a mode of the field.', '', '0', '', 'active'),
('en', 'system', '0', 'notice_plugin_installed', 'The new Plugin has been successfully installed.', '', '0', '', 'active'),
('en', 'admin', '0', 'notice_plugin_uninstalled', 'You\'ve successfully uninstalled the plugin.', '', '0', '', 'active'),
('en', 'admin', '0', 'notice_delete_empty_category', 'The <b>{category}</b> category will be removed irretrievably? Are you sure you want to proceed?', '', '0', '', 'active'),
('en', 'admin', '0', 'notice_path_exist_droped', 'The category URL - {path} - already exists and can be found in the Trash Box; you may either remove it from the Trash Box or come up with a different one.', '', '0', '', 'active'),
('en', 'admin', '0', 'notice_path_exist', 'The category URL - {path} - already exists, please come up with a different URL for the category.', '', '0', '', 'active'),
('en', 'admin', '0', 'notice_drop_empty_category', 'Are you sure you want to move the <b>{category}</b> category to the Trash Box?', '', '0', '', 'active'),
('en', 'admin', '0', 'notice_items_restored', 'You\'ve successfully restored the selected items.', '', '0', '', 'active'),
('en', 'admin', '0', 'notice_format_added', 'You\'ve successfully added a data entry.', '', '0', '', 'active'),
('en', 'admin', '0', 'notice_format_edited', 'You\'ve successfully edited the Data Item.', '', '0', '', 'active'),
('en', 'admin', '0', 'notice_remote_activation_activated_account', 'The account has been successfully activated.', '', '0', '', 'active'),
('en', 'admin', '0', 'notice_drop_empty_account_type', 'Are you sure you want to move the <b>{type}</b> account type to the Trash Box?', '', '0', '', 'active'),
('en', 'admin', '0', 'notice_delete_empty_account_type', 'The <b>{type}</b> account type will be removed irretrievably? Are you sure you want to proceed?', '', '0', '', 'active'),
('en', 'admin', '0', 'notice_remote_account_activation_deny', 'Remote account activation has failed due to: <br />* Account is already activated;<br />* Account was removed;<br />* Activation link is broken.', '', '0', '', 'active'),
('en', 'admin', '0', 'notice_lang_direction_missed', 'Please fill in the text direction field.', '', '0', '', 'active'),
('en', 'admin', '0', 'notice_form_key_exist', 'The search form with the {key} key already exists.', '', '0', '', 'active'),
('en', 'admin', '0', 'notice_drop_empty_listing_type', 'Are you sure you want to send the <b>{type}</b> type to the Trash Box?', '', '0', '', 'active'),
('en', 'admin', '0', 'notice_delete_empty_account', 'The <b>{username}</b> account will be removed irretrievably? Are you sure you want to proceed?', '', '0', '', 'active'),
('en', 'admin', '0', 'notice_drop_empty_account', 'Are you sure you want to move the <b>{username}</b> account to the Trash Box?', '', '0', '', 'active'),
('en', 'admin', '0', 'notice_account_type_key_exist', 'The account with the <b>{key}</b> key already exists, please consider using a different one.', '', '0', '', 'active'),
('en', 'admin', '0', 'language_deleted', 'You\'ve successfully removed the language.', '', '0', '', 'active'),
('en', 'admin', '0', 'language_no_selected', 'Please select a language, from which you want to import phrases.', '', '0', '', 'active'),
('en', 'admin', '0', 'language_added', 'You\'ve successfully added a new language.', '', '0', '', 'active'),
('en', 'admin', '0', 'language_incorrect_date_format', 'Error: The Date Format field is either empty or contains less than 3 characters.', '', '0', '', 'active'),
('en', 'admin', '0', 'language_no_phrases', 'No phrases have been found for the selected language.', '', '0', '', 'active'),
('en', 'admin', '0', 'language_edited', 'You\'ve successfully edited the language.', '', '0', '', 'active'),
('en', 'admin', '0', 'trash_confirm', 'Are you sure you want to send the item to the Trash Box?', '', '0', '', 'active'),
('en', 'admin', '0', 'trash_box_desabled', 'The <b>\"Trash Box\"</b> is disabled, please follow the [link] to enable it.', '', '0', '', 'active'),
('en', 'admin', '0', 'trash_cleared', 'You\'ve successfully cleared the Trash Box.', '', '0', '', 'active'),
('en', 'admin', '0', 'category_added', 'You\'ve successfully added a category.', '', '0', '', 'active'),
('en', 'admin', '0', 'category_edited', 'You\'ve successfully edited the category.', '', '0', '', 'active'),
('en', 'admin', '0', 'category_dropped', 'You\'ve successfully sent the category to the Trash Box.', '', '0', '', 'active'),
('en', 'admin', '0', 'category_deleted', 'You\'ve successfully removed the category.', '', '0', '', 'active'),
('en', 'admin', '0', 'category_path_warning', 'You\'re not allowed to make changes to the category URL after the last slash.', '', '0', '', 'active'),
('en', 'admin', '0', 'category_activated', 'You\'ve successfully activated the category.', '', '0', '', 'active'),
('en', 'admin', '0', 'category_order', 'Category sorting type', '', '0', '', 'active'),
('en', 'admin', '0', 'category_settings', 'Category Settings', '', '0', '', 'active'),
('en', 'admin', '0', 'category_url_listing_logic', 'Unfortunately, URLs ending with digits aren\'t allowed; please consider using only letters.', '', '0', '', 'active'),
('en', 'admin', '0', 'iso_code_incorrect_exist', 'Error: The ISO code of the language you\'ve entered is already in use.', '', '0', '', 'active'),
('en', 'admin', '0', 'iso_code_incorrect_number', 'Error: Incorrect ISO code format (no more than 2 characters long).', '', '0', '', 'active'),
('en', 'admin', '0', 'rl_admin_panel', 'Flynax Admin Panel', '', '0', '', 'active'),
('en', 'admin', '0', 'version', 'version', '', '0', '', 'active'),
('en', 'admin', '0', 'admin_panel', 'admin panel', '', '0', '', 'active'),
('en', 'admin', '0', 'rl_system_info', 'System Info', '', '0', '', 'active'),
('en', 'admin', '0', 'set_default', 'Set as default', '', '0', '', 'active'),
('en', 'admin', '0', 'import', 'Import', '', '0', '', 'active'),
('en', 'admin', '0', 'date_format', 'Date format', '', '0', '', 'active'),
('en', 'admin', '0', 'copy_from', 'Import from', '', '0', '', 'active'),
('en', 'admin', '0', 'iso_code', 'ISO code', '', '0', '', 'active'),
('en', 'admin', '0', 'add_language', 'Add a Language', '', '0', '', 'active'),
('en', 'admin', '0', 'phrase_text', 'Phrase', '', '0', '', 'active'),
('en', 'admin', '0', 'confog_group_empty', 'The group hasn\'t been set up yet.', '', '0', '', 'active'),
('en', 'admin', '0', 'config_saved', 'The changes have been successfully saved.', '', '0', '', 'active'),
('en', 'admin', '0', 'add_category', 'Add a Category', '', '0', '', 'active'),
('en', 'admin', '0', 'categories_list', 'All Categories', '', '0', '', 'active'),
('en', 'admin', '0', 'edit_category', 'Edit Category', '', '0', '', 'active'),
('en', 'admin', '0', 'section', 'Section', '', '0', '', 'active'),
('en', 'admin', '0', 'groups_list', 'All Groups', '', '0', '', 'active'),
('en', 'admin', '0', 'add_group', 'Add a Group', '', '0', '', 'active'),
('en', 'admin', '0', 'edit_group', 'Edit Group', '', '0', '', 'active'),
('en', 'admin', '0', 'default_expand', 'Expansion by default', '', '0', '', 'active'),
('en', 'admin', '0', 'group_added', 'You\'ve successfully added a field group.', '', '0', '', 'active'),
('en', 'admin', '0', 'group_edited', 'You\'ve successfully edited the field group.', '', '0', '', 'active'),
('en', 'admin', '0', 'group_deleted', 'You\'ve successfully removed the field group.', '', '0', '', 'active'),
('en', 'admin', '0', 'group_dropped', 'You\'ve successfully moved the group to the Trash Box.', '', '0', '', 'active'),
('en', 'admin', '0', 'drop_confirm', 'Are you sure you want to delete the item irretrievably?', '', '0', '', 'active'),
('en', 'admin', '0', 'side', 'System module', '', '0', '', 'active'),
('en', 'admin', '0', 'add_item', 'Add a New Item', '', '0', '', 'active'),
('en', 'admin', '0', 'item_added', 'You\'ve successfully added a new item.', '', '0', '', 'active'),
('en', 'admin', '0', 'add_page', 'Add a Page', '', '0', '', 'active'),
('en', 'admin', '0', 'edit_page', 'Edit Page', '', '0', '', 'active'),
('en', 'admin', '0', 'pages_list', 'All Pages', '', '0', '', 'active'),
('en', 'admin', '0', 'title', 'Title', '', '0', '', 'active'),
('en', 'admin', '0', 'page_url', 'Page URL (SEO)', '', '0', '', 'active'),
('en', 'admin', '0', 'login_only', 'Logging in required', '', '0', '', 'active'),
('en', 'admin', '0', 'external', 'External', '', '0', '', 'active'),
('en', 'admin', '0', 'use_tpl', 'Enable site design', '', '0', '', 'active'),
('en', 'admin', '0', 'show_in_menu', 'Show page link in', '', '0', '', 'active'),
('en', 'admin', '0', 'main_menu', 'Top menu', '', '0', '', 'active'),
('en', 'admin', '0', 'account_menu', 'Account menu', '', '0', '', 'active'),
('en', 'admin', '0', 'bottom_menu', 'Bottom menu', '', '0', '', 'active'),
('en', 'admin', '0', 'page_type', 'Page type', '', '0', '', 'active'),
('en', 'admin', '0', 'page_controller', 'Page controller', '', '0', '', 'active'),
('en', 'admin', '0', 'page_content', 'Page content', '', '0', '', 'active'),
('en', 'admin', '0', 'external_url', 'External page URL', '', '0', '', 'active'),
('en', 'admin', '0', 'incorrect_page_address', 'The page URL must be at least 3 characters long.', '', '0', '', 'active'),
('en', 'admin', '0', 'page_added', 'You\'ve successfully added a page.', '', '0', '', 'active'),
('en', 'system', '0', 'page_edited', 'You\'ve successfully edited the page.', '', '0', '', 'active'),
('en', 'admin', '0', 'page_readonly', 'You are not allowed to remove the system page; consider disabling it by changing its status to inactive.', '', '0', '', 'active'),
('en', 'admin', '0', 'left', 'Sidebar', '', '0', '', 'active'),
('en', 'admin', '0', 'top', 'Top', '', '0', '', 'active'),
('en', 'admin', '0', 'bottom', 'Bottom', '', '0', '', 'active'),
('en', 'admin', '0', 'middle_left', 'Middle left', '', '0', '', 'active'),
('en', 'admin', '0', 'middle_right', 'Middle right', '', '0', '', 'active'),
('en', 'admin', '0', 'header_banner', 'Header Banner', '', '0', '', 'active'),
('en', 'admin', '0', 'long_top', 'Long Top', '', '0', '', 'active'),
('en', 'admin', '0', 'add_block', 'Add a Box', '', '0', '', 'active'),
('en', 'admin', '0', 'blocks_list', 'All Boxes', '', '0', '', 'active'),
('en', 'admin', '0', 'edit_block', 'Edit Box', '', '0', '', 'active'),
('en', 'admin', '0', 'block_side', 'Box position', '', '0', '', 'active'),
('en', 'admin', '0', 'block_type', 'Box type', '', '0', '', 'active'),
('en', 'admin', '0', 'html', 'HTML', '', '0', '', 'active'),
('en', 'admin', '0', 'smarty', 'Smarty', '', '0', '', 'active'),
('en', 'admin', '0', 'php', 'PHP', '', '0', '', 'active'),
('en', 'admin', '0', 'content', 'Content', '', '0', '', 'active'),
('en', 'admin', '0', 'show_on_pages', 'Show box on', '', '0', '', 'active'),
('en', 'admin', '0', 'item_edited', 'You\'ve successfully edited the item.', '', '0', '', 'active'),
('en', 'admin', '0', 'item_dropped', 'You\'ve successfully moved the item to the Trash Box.', '', '0', '', 'active'),
('en', 'admin', '0', 'type_price', 'Price', '', '0', '', 'active'),
('en', 'admin', '0', 'bind_data_format', 'Link to Data Entries', '', '0', '', 'active'),
('en', 'admin', '0', 'form', 'Form', '', '0', '', 'active'),
('en', 'admin', '0', 'append_to_form', 'Append to Form', '', '0', '', 'active'),
('en', 'admin', '0', 'no_groups', 'There are no groups.', '', '0', '', 'active'),
('en', 'admin', '0', 'append_to_group', 'Append to group', '', '0', '', 'active'),
('en', 'admin', '0', 'move_up', 'Move up', '', '0', '', 'active'),
('en', 'admin', '0', 'move_down', 'Move down', '', '0', '', 'active'),
('en', 'admin', '0', 'system', 'System', '', '0', '', 'active'),
('en', 'admin', '0', 'static', 'Static', '', '0', '', 'active'),
('en', 'admin', '0', 'block_added', 'You\'ve successfully added a box.', '', '0', '', 'active'),
('en', 'admin', '0', 'block_edited', 'You\'ve successfully edited the box.', '', '0', '', 'active'),
('en', 'admin', '0', 'type_flash', 'Flash', '', '0', '', 'active'),
('en', 'admin', '0', 'width', 'Width', '', '0', '', 'active'),
('en', 'admin', '0', 'height', 'Height', '', '0', '', 'active'),
('en', 'admin', '0', 'block_deleted', 'You\'ve successfully removed the content box.', '', '0', '', 'active'),
('en', 'admin', '0', 'page_deleted', 'You\'ve successfully removed the page.', '', '0', '', 'active'),
('en', 'admin', '0', 'block_dropped', 'You\'ve successfully moved the content box to the Trash Box.', '', '0', '', 'active'),
('en', 'admin', '0', 'page_dropped', 'You\'ve successfully moved the page to the Trash Box.', '', '0', '', 'active'),
('en', 'admin', '0', 'block_readonly', 'You\'re not allowed to remove system boxes; consider disabling it by changing its status to inactive.', '', '0', '', 'active'),
('en', 'admin', '0', 'link', 'Link', '', '0', '', 'active'),
('en', 'admin', '0', 'use_block_design', 'Site design', '', '0', '', 'active'),
('en', 'admin', '0', 'use_block_header', 'Box heading', '', '0', '', 'active'),
('en', 'admin', '0', 'incorrect_phrase_key', 'A key value must be at least three characters long.', '', '0', '', 'active'),
('en', 'admin', '0', 'file_type', 'File type', '', '0', '', 'active'),
('en', 'admin', '0', 'field_edited', 'You\'ve successfully edited the field.', '', '0', '', 'active'),
('en', 'admin', '0', 'edit_field', 'Edit Field', '', '0', '', 'active'),
('en', 'admin', '0', 'resolution', 'Resolution', '', '0', '', 'active'),
('en', 'admin', '0', 'by_width_height', 'Width &amp; height', '', '0', '', 'active'),
('en', 'admin', '0', 'by_height', 'Height', '', '0', '', 'active'),
('en', 'admin', '0', 'by_width', 'Width', '', '0', '', 'active'),
('en', 'admin', '0', 'resize_type', 'Resize by', '', '0', '', 'active'),
('en', 'admin', '0', 'add_phrase', 'Add a Phrase', '', '0', '', 'active'),
('en', 'admin', '0', 'key_incorrect_charset', 'Error: Incorrect key; please use Latin characters only.', '', '0', '', 'active'),
('en', 'admin', '0', 'lang_phrase_added', 'You\'ve successfully added a phrase.', '', '0', '', 'active'),
('en', 'admin', '0', 'value', 'Value', '', '0', '', 'active'),
('en', 'admin', '0', 'full_account_drop', 'Send the account type with all related data to the Trash Box.', '', '0', '', 'active'),
('en', 'admin', '0', 'key', 'Key', '', '0', '', 'active'),
('en', 'admin', '0', 'required_field', 'Make required', '', '0', '', 'active'),
('en', 'admin', '0', 'field_type', 'Field type', '', '0', '', 'active'),
('en', 'admin', '0', 'type_text', 'Text', '', '0', '', 'active'),
('en', 'admin', '0', 'type_textarea', 'Textarea', '', '0', '', 'active'),
('en', 'admin', '0', 'type_number', 'Numeric', '', '0', '', 'active'),
('en', 'admin', '0', 'type_bool', 'Yes/No', '', '0', '', 'active'),
('en', 'admin', '0', 'type_radio', 'Radio buttons', '', '0', '', 'active'),
('en', 'admin', '0', 'type_checkbox', 'Checkboxes', '', '0', '', 'active'),
('en', 'admin', '0', 'type_image', 'Image upload', '', '0', '', 'active'),
('en', 'admin', '0', 'type_file_storage', 'File upload', '', '0', '', 'active'),
('en', 'admin', '0', 'type_accept', 'Agreement', '', '0', '', 'active'),
('en', 'admin', '0', 'default_value', 'Default value', '', '0', '', 'active'),
('en', 'admin', '0', 'maxlength', 'Max. number of characters', '', '0', '', 'active'),
('en', 'admin', '0', 'default_text_value_des', 'in the range of 1 to 255 only, default value is 50', '', '0', '', 'active'),
('en', 'admin', '0', 'remove_slashes_warning', 'You are not allowed to add/remove slashes in the category URL.', '', '0', '', 'active'),
('en', 'admin', '0', 'build_form', 'Build Form', '', '0', '', 'active'),
('en', 'admin', '0', 'type_select', 'Dropdown', '', '0', '', 'active'),
('en', 'admin', '0', 'field_items', 'Field options', '', '0', '', 'active'),
('en', 'admin', '0', 'condition', 'Condition', '', '0', '', 'active'),
('en', 'admin', '0', 'url', 'URL', '', '0', '', 'active'),
('en', 'admin', '0', 'check_condition', 'Checking  condition', '', '0', '', 'active'),
('en', 'admin', '0', 'fields_list', 'All Fields', '', '0', '', 'active'),
('en', 'admin', '0', 'field_deleted', 'The field has been successfully deleted.', '', '0', '', 'active'),
('en', 'admin', '0', 'item_value', 'Item value', '', '0', '', 'active'),
('en', 'admin', '0', 'edit_admin', 'Edit Administrator account', '', '0', '', 'active'),
('en', 'admin', '0', 'admin_added', 'You\'ve successfully added a new account type.', '', '0', '', 'active'),
('en', 'admin', '0', 'admin_edited', 'You\'ve successfully edited the admin account.', '', '0', '', 'active'),
('en', 'admin', '0', 'admin_deleted', 'You\'ve successfully removed the admin account.', '', '0', '', 'active'),
('en', 'admin', '0', 'admin_dropped', 'You\'ve successfully sent the admin account to the Trash Box.', '', '0', '', 'active'),
('en', 'admin', '0', 'plans_list', 'All Packages', '', '0', '', 'active'),
('en', 'admin', '0', 'add_plan', 'Add a Package', '', '0', '', 'active'),
('en', 'admin', '0', 'edit_plan', 'Edit Package', '', '0', '', 'active'),
('en', 'admin', '0', 'plan_type', 'Package type', '', '0', '', 'active'),
('en', 'admin', '0', 'show_in_categories', 'Show in categories', '', '0', '', 'active'),
('en', 'admin', '0', 'plan_added', 'You\'ve successfully added a plan.', '', '0', '', 'active'),
('en', 'admin', '0', 'plan_edited', 'You\'ve successfully edited the plan.', '', '0', '', 'active'),
('en', 'admin', '0', 'plan_deleted', 'You\'ve successfully removed the plan.', '', '0', '', 'active'),
('en', 'admin', '0', 'plan_dropped', 'You\'ve successfully moved the plan to the Trash Box.', '', '0', '', 'active'),
('en', 'admin', '0', 'add_admin', 'Add an Administrator', '', '0', '', 'active'),
('en', 'admin', '0', 'admins_list', 'All Administrators', '', '0', '', 'active'),
('en', 'admin', '0', 'templates_list', 'All Templates', '', '0', '', 'active'),
('en', 'admin', '0', 'add_template', 'Add a Template', '', '0', '', 'active'),
('en', 'admin', '0', 'edit_template', 'Edit Template', '', '0', '', 'active'),
('en', 'admin', '0', 'subject', 'Subject', '', '0', '', 'active'),
('en', 'admin', '0', 'template_added', 'You\'ve successfully added a template.', '', '0', '', 'active'),
('en', 'admin', '0', 'template_edited', 'You\'ve successfully edited the template.', '', '0', '', 'active'),
('en', 'admin', '0', 'add_template_variable', 'You may select a variable and add it to the template.', '', '0', '', 'active'),
('en', 'admin', '0', 'edit_account', 'Edit Account', '', '0', '', 'active'),
('en', 'admin', '0', 'add_account', 'Add an Account', '', '0', '', 'active'),
('en', 'admin', '0', 'accounts_list', 'All Accounts', '', '0', '', 'active'),
('en', 'admin', '0', 'account_deleted_notice', 'You\'ve successfully removed the account.', '', '0', '', 'active'),
('en', 'admin', '0', 'account_dropped_notice', 'The account has been successfully moved to the Trash Box.', '', '0', '', 'active'),
('en', 'admin', '0', 'phrase_key', 'Phrase key', '', '0', '', 'active'),
('en', 'admin', '0', 'no_fields', 'There are no fields.', '', '0', '', 'active'),
('en', 'admin', '0', 'session_expired', 'The admin session has expired.', '', '0', '', 'active'),
('en', 'admin', '0', 'manage_phrases', 'Manage Phrases', '', '0', '', 'active'),
('en', 'admin', '0', 'languages_list', 'All Languages', '', '0', '', 'active'),
('en', 'admin', '0', 'featured_form_builder', 'Featured Form Builder', '', '0', '', 'active'),
('en', 'admin', '0', 'add_news', 'Add News', '', '0', '', 'active'),
('en', 'admin', '0', 'edit_news', 'Edit News', '', '0', '', 'active'),
('en', 'admin', '0', 'news_list', 'All News', '', '0', '', 'active'),
('en', 'admin', '0', 'news_added', 'You\'ve successfully added news.', '', '0', '', 'active'),
('en', 'admin', '0', 'news_edited', 'You\'ve successfully edited the news.', '', '0', '', 'active'),
('en', 'admin', '0', 'news_deleted', 'You\'ve successfully removed the news.', '', '0', '', 'active'),
('en', 'admin', '0', 'time_period', 'Time period', '', '0', '', 'active'),
('en', 'admin', '0', 'single_date', 'Single date', '', '0', '', 'active'),
('en', 'admin', '0', 'type_date', 'Date', '', '0', '', 'active'),
('en', 'admin', '0', 'parent', 'Parent', '', '0', '', 'active'),
('en', 'admin', '0', 'no_parent', 'No Parent', '', '0', '', 'active'),
('en', 'admin', '0', 'forms_list', 'All Forms', '', '0', '', 'active'),
('en', 'admin', '0', 'plugin_update_not_found', 'No available updates for the <b>{plugin}</b> plugin  have been found on Flynax Server.', '', '0', '', 'active'),
('en', 'admin', '0', 'search_forms+name+advanced_search', 'Advanced Search ', '', '0', '', 'active'),
('en', 'admin', '0', 'search_forms+name+advanced_search_spares', 'Advanced Search for Spares', '', '0', '', 'active'),
('en', 'admin', '0', 'contacts_list', 'All Messages', '', '0', '', 'active'),
('en', 'admin', '0', 'view_contact', 'View contact', '', '0', '', 'active'),
('en', 'admin', '0', 'contact_deleted', 'You\'ve successfully removed the message.', '', '0', '', 'active'),
('en', 'admin', '0', 'contact_dropped', 'You\'ve successfully moved the message to the Trash Box.', '', '0', '', 'active'),
('en', 'admin', '0', 'my_listings_pattern', 'My {type}', '', '0', '', 'active'),
('en', 'admin', '0', 'readed', 'Read', '', '0', '', 'active'),
('en', 'admin', '0', 'accounts', 'Accounts', '', '0', '', 'active'),
('en', 'common', '0', 'total_accounts', 'Total Accounts', '', '0', '', 'active'),
('en', 'admin', '0', 'admin_change_account_type_notice', 'Are you sure you want to change the type of the user account?', '', '0', '', 'active'),
('en', 'admin', '0', 'over_days', 'Over the last {days} day(s)', '', '0', '', 'active'),
('en', 'admin', '0', 'contacts', 'Messages', '', '0', '', 'active'),
('en', 'admin', '0', 'show_all_options', 'Show all options', '', '0', '', 'active'),
('en', 'admin', '0', 'recount', 'Recount', '', '0', '', 'active'),
('en', 'admin', '0', 'item_restored', 'The item has been restored successfully.', '', '0', '', 'active'),
('en', 'admin', '0', 'arrange_by_field_hint', 'Content in boxes will be arranged into tabs based on options of the selected field.', '', '0', '', 'active'),
('en', 'admin', '0', 'news_dropped', 'The news has been successfully moved to the Trash Box.', '', '0', '', 'active'),
('en', 'admin', '0', 'use_for_displaing_map', 'Use the field as part of the address on the map.', '', '0', '', 'active'),
('en', 'admin', '0', 'items_list', 'All Items', '', '0', '', 'active'),
('en', 'admin', '0', 'mass_action_completed', 'You\'ve successfully applied the bulk action.', '', '0', '', 'active'),
('en', 'admin', '0', 'view_account', 'View account details', '', '0', '', 'active');
INSERT INTO `{db_prefix}lang_keys` (`Code`, `Module`, `JS`, `Key`, `Value`, `Target_key`, `Modified`, `Plugin`, `Status`) VALUES
('en', 'admin', '0', 'sticky', 'Sticky', '', '0', '', 'active'),
('en', 'system', '0', 'plugin_files_missed', 'The following files: {files} in the plugin are missing. Please reupload the plugin files before the installation.', '', '0', '', 'active'),
('en', 'system', '0', 'install_not_found', 'The install.xml file hasn\'t been found in the plugin folder, please make sure it is there.', '', '0', '', 'active'),
('en', 'admin', '0', 'login_to', 'Sign in to', '', '0', '', 'active'),
('en', 'admin', '0', 'images', 'Images', '', '0', '', 'active'),
('en', 'admin', '0', 'filters', 'Filters', '', '0', '', 'active'),
('en', 'admin', '0', 'filter_by', 'Filter by', '', '0', '', 'active'),
('en', 'admin', '0', 'pay_status', 'Pay status', '', '0', '', 'active'),
('en', 'admin', '0', 'not_payed', 'Unpaid', '', '0', '', 'active'),
('en', 'admin', '0', 'filter', 'Filter', '', '0', '', 'active'),
('en', 'admin', '0', 'set_owner', 'Owner username', '', '0', '', 'active'),
('en', 'admin', '0', 'in_trash', 'In the Trash Box', '', '0', '', 'active'),
('en', 'admin', '0', 'transaction_dropped', 'You\'ve successfully moved the transaction to the Trash Box.', '', '0', '', 'active'),
('en', 'admin', '0', 'transaction_deleted', 'The transaction has been successfully deleted.', '', '0', '', 'active'),
('en', 'admin', '0', 'show_on', 'Enable on', '', '0', '', 'active'),
('en', 'admin', '0', 'details_page', 'Details Page', '', '0', '', 'active'),
('en', 'admin', '0', 'meta_description', 'Meta description', '', '0', '', 'active'),
('en', 'admin', '1', 'remote_plugin_install_notice', 'Are you sure you want to install the plugin?', '', '0', '', 'active'),
('en', 'system', '0', 'plugin_download_deny', 'Error: Flynax Plugin installation wizard has failed, please contact Flynax Helpdesk.', '', '0', '', 'active'),
('en', 'admin', '0', 'full_category_drop', 'Move the category with all related data to the Trash Box.', '', '0', '', 'active'),
('en', 'admin', '0', 'support', 'Support', '', '0', '', 'active'),
('en', 'admin', '0', 'parent_category', 'Parent category', '', '0', '', 'active'),
('en', 'admin', '0', 'detecting', 'Detecting...', '', '0', '', 'active'),
('en', 'admin', '0', 'build_category', 'Build Category', '', '0', '', 'active'),
('en', 'admin', '0', 'delete_category', 'Remove Category', '', '0', '', 'active'),
('en', 'admin', '0', 'no_subcategories', 'There are no subcategories in the category.', '', '0', '', 'active'),
('en', 'admin', '0', 'delete_conditions', 'The <b>{category}</b> category has the following data:', '', '0', '', 'active'),
('en', 'admin', '0', 'choose_removal_method', 'Please select a way of removing below:', '', '0', '', 'active'),
('en', 'admin', '0', 'include_subcats', 'Include subcategories', '', '0', '', 'active'),
('en', 'admin', '0', 'rebuild_cat_levels', 'Rearrange category levels', '', '0', '', 'active'),
('en', 'admin', '0', 'regenerate_path_desc', 'Leave the field empty to automatically generate the category URL.', '', '0', '', 'active'),
('en', 'admin', '0', 'rebuild', 'Rebuild', '', '0', '', 'active'),
('en', 'admin', '0', 'levels_rebuilt', 'The category levels have been successfully rebuilt.', '', '0', '', 'active'),
('en', 'admin', '0', 'formats_list', 'All Entries', '', '0', '', 'active'),
('en', 'admin', '0', 'add_format', 'Add an Entry', '', '0', '', 'active'),
('en', 'admin', '0', 'edit_item', 'Edit Item', '', '0', '', 'active'),
('en', 'admin', '0', 'edit_format', 'Edit Data Item', '', '0', '', 'active'),
('en', 'admin', '0', 'lock_category', 'Lock category', '', '0', '', 'active'),
('en', 'admin', '0', 'unlock_category', 'Unlock Category', '', '0', '', 'active'),
('en', 'admin', '0', 'message_category_locked', 'You\'ve successfully locked the category.', '', '0', '', 'active'),
('en', 'admin', '0', 'message_category_unlocked', 'You\'ve successfully unlocked the category.', '', '0', '', 'active'),
('en', 'admin', '0', 'dump_has_not_content', 'The MySQL dump is empty.', '', '0', '', 'active'),
('en', 'admin', '0', 'incorrect_lang_dump', 'The language file name is incorrect, please consider the following sample: <b>English(EN).sql</b>', '', '0', '', 'active'),
('en', 'admin', '0', 'sql_dump', 'Browse for an SQL file', '', '0', '', 'active'),
('en', 'admin', '0', 'can_not_run_sql_query', 'Error: Failed to run the SQL query.', '', '0', '', 'active'),
('en', 'admin', '0', 'dump_imported', 'The data has been successfully imported from the SQL dump.', '', '0', '', 'active'),
('en', 'admin', '0', 'sql_query', 'Enter an SQL query', '', '0', '', 'active'),
('en', 'admin', '0', 'reset', 'Reset', '', '0', '', 'active'),
('en', 'admin', '0', 'query_ran', 'The query has been successfully implemented; {number} rows have been affected.', '', '0', '', 'active'),
('en', 'admin', '0', 'fields', 'Fields', '', '0', '', 'active'),
('en', 'admin', '0', 'tables', 'Tables', '', '0', '', 'active'),
('en', 'admin', '0', 'clear_trash', 'Clear Trash Box', '', '0', '', 'active'),
('en', 'admin', '0', 'clear_trash_nitice', 'All data in the Trash Box will be deleted irreversibly! Are you sure you want to proceed?', '', '0', '', 'active'),
('en', 'admin', '0', 'positions_reordered', 'The positions have been successfully rearranged.', '', '0', '', 'active'),
('en', 'admin', '0', 'reorder_fields_positions', 'Update position of fields/groups for each form', '', '0', '', 'active'),
('en', 'admin', '0', 'type_mixed', 'Mixed', '', '0', '', 'active'),
('en', 'admin', '0', 'compare_no_diff_found', 'No differences have been found; the languages have identical phrases.', '', '0', '', 'active'),
('en', 'admin', '0', 'compare_translation_result_info', 'The following phrases are identical both in the <b>{lang1}</b>  and the <b>{lang2}</b> languages.', '', '0', '', 'active'),
('en', 'admin', '0', 'compare_mode', 'Compare for', '', '0', '', 'active'),
('en', 'admin', '0', 'by_phrases_exist', 'missing phrases', '', '0', '', 'active'),
('en', 'admin', '0', 'by_translation_different', 'identical phrases', '', '0', '', 'active'),
('en', 'admin', '0', 'compare_phrases_copied', 'The phrases have been successfully imported.', '', '0', '', 'active'),
('en', 'admin', '0', 'compare_copy_phrases', 'Import missing phrases from {lang1} to {lang2}', '', '0', '', 'active'),
('en', 'admin', '0', 'compare_languages_same', 'Please select two different languages from the dropdowns to make a comparison.', '', '0', '', 'active'),
('en', 'admin', '0', 'compare_empty_langs', 'Please select two languages to make a comparison.', '', '0', '', 'active'),
('en', 'admin', '0', 'languages_compare', 'Comparing Languages', '', '0', '', 'active'),
('en', 'admin', '0', 'compare', 'Compare', '', '0', '', 'active'),
('en', 'admin', '0', 'new_language_imported', 'You\'ve successfully imported a new language. Please do a language comparison to copy missing phrases.', '', '0', '', 'active'),
('en', 'admin', '0', 'compare_result_info', 'The following <b>{lang1}</b> phrases are missing in the <b>{lang2}</b> language.', '', '0', '', 'active'),
('en', 'admin', '0', 'dump_query_corrupt', 'The MySQL dump has corrupt queries; importing the new language has failed.', '', '0', '', 'active'),
('en', 'admin', '0', 'order_type', 'Order Type', '', '0', '', 'active'),
('en', 'admin', '0', 'position_order', 'Position', '', '0', '', 'active'),
('en', 'admin', '0', 'allow_subcategories', 'Users add subcategories', '', '0', '', 'active'),
('en', 'admin', '0', 'tmp_categories_desabled', 'The ability of adding <b>\'Subcategories by Users\'</b> from the user interface is disabled; please follow the {link} to enable it.', '', '0', '', 'active'),
('en', 'admin', '0', 'alphabetic_order', 'Alphabetic', '', '0', '', 'active'),
('en', 'admin', '0', 'arrange_settings', 'Tabbed Data Settings', '', '0', '', 'active'),
('en', 'admin', '0', 'account_type_auto_login', 'Log users in after registration', '', '0', '', 'active'),
('en', 'admin', '0', 'delete_category_conditions', 'The <b>{category}</b> category has the following data:', '', '0', '', 'active'),
('en', 'admin', '0', 'replace_category_duplicate', 'Please select another category; the <b>{category}</b> category is awaiting removal.', '', '0', '', 'active'),
('en', 'admin', '0', 'limit_account_types_remove', 'You are not allowed to remove all account types as there should be at least one account type in the system (except for \"Visitor\").', '', '0', '', 'active'),
('en', 'admin', '0', 'super_admin', 'Super Admin', '', '0', '', 'active'),
('en', 'admin', '0', 'limited_account', 'Limited Access Admin', '', '0', '', 'active'),
('en', 'admin', '0', 'admin_access_denied', 'Your administrator account is limited to certain sections and you don\'t have access to the {manager} manager.', '', '0', '', 'active'),
('en', 'admin', '0', 'plan_live_for_hint', 'Enter <b>0</b> to make the listing package active for an unlimited period.', '', '0', '', 'active'),
('en', 'admin', '0', 'configs_caption', 'Basic settings for <u>{group}</u>', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'limited_plan', 'Limited Package', '', '0', '', 'active'),
('en', 'admin', '0', 'import_language_already_exist', 'Error: Failed to import the <b>{language}</b> language; the language with the <b>{code}</b> code already exists.', '', '0', '', 'active'),
('en', 'admin', '0', 'short_form', 'Browse Form', '', '0', '', 'active'),
('en', 'admin', '0', 'build_short_form', 'Build Browse Form of the {category} category', '', '0', '', 'active'),
('en', 'admin', '0', 'featured_form', 'Featured Form', '', '0', '', 'active'),
('en', 'admin', '0', 'build_featured_form', 'Build Featured Form of the {category} category', '', '0', '', 'active'),
('en', 'admin', '0', 'limit_use_of_plan', 'Limit use of listing package', '', '0', '', 'active'),
('en', 'admin', '0', 'limit_use_of_plan_hint', 'Enter <b>0</b> to enable unlimited use of the listing package.', '', '0', '', 'active'),
('en', 'admin', '0', 'add_type', 'Add a Type', '', '0', '', 'active'),
('en', 'admin', '0', 'types_list', 'All Types', '', '0', '', 'active'),
('en', 'admin', '0', 'edit_type', 'Edit Type', '', '0', '', 'active'),
('en', 'admin', '0', 'abilities', 'Options', '', '0', '', 'active'),
('en', 'admin', '0', 'deny_access_for', 'Restrict access to', '', '0', '', 'active'),
('en', 'admin', '0', 'account_type_added', 'You\'ve successfully added a new account type.', '', '0', '', 'active'),
('en', 'admin', '0', 'account_type_edited', 'You\'ve successfully edited the account type.', '', '0', '', 'active'),
('en', 'admin', '0', 'delete_account_type', 'Account Type Removal', '', '0', '', 'active'),
('en', 'admin', '0', 'pre_account_type_delete_notice', 'The <b>{type}</b> account type has the following data:', '', '0', '', 'active'),
('en', 'admin', '0', 'lang_direction', 'Text direction', '', '0', '', 'active'),
('en', 'admin', '0', 'ltr_direction', 'ltr', '', '0', '', 'active'),
('en', 'admin', '0', 'ltr_direction_title', 'Left to Right', '', '0', '', 'active'),
('en', 'admin', '0', 'rtl_direction', 'rtl', '', '0', '', 'active'),
('en', 'admin', '0', 'rtl_direction_title', 'Right to Left', '', '0', '', 'active'),
('en', 'admin', '0', 'form_readonly', 'The selected form is a system element that cannot be removed; you can disable it by changing its status.', '', '0', '', 'active'),
('en', 'admin', '0', 'form_dropped', 'You\'ve successfully moved the form to the Trash Box.', '', '0', '', 'active'),
('en', 'admin', '0', 'form_deleted', 'You\'ve successfully removed the form.', '', '0', '', 'active'),
('en', 'admin', '0', 'field_value_does_not_selected', 'Please select a value of the {field} field.', '', '0', '', 'active'),
('en', 'admin', '0', 'form_edited', 'You\'ve successfully edited the form.', '', '0', '', 'active'),
('en', 'admin', '0', 'form_added', 'You\'ve successfully added a new form.', '', '0', '', 'active'),
('en', 'admin', '0', 'use_groups', 'Enable groups', '', '0', '', 'active'),
('en', 'admin', '0', 'edit_form', 'Edit Form', '', '0', '', 'active'),
('en', 'admin', '0', 'add_form', 'Add a Form', '', '0', '', 'active'),
('en', 'admin', '0', 'info_account_type_plans', 'Leave the field empty to make the package available to all account types.', '', '0', '', 'active'),
('en', 'admin', '0', 'text_direction_fail', 'The text direction value you\'ve entered is incorrect.', '', '0', '', 'active'),
('en', 'admin', '0', 'search_form_hint', 'Click [here] to build the form.', '', '0', '', 'active'),
('en', 'admin', '0', 'featured_blocks_hint', 'Click [here] to edit the box settings.', '', '0', '', 'active'),
('en', 'admin', '0', 'individual_page_hint', 'Click [here] to edit the page.', '', '0', '', 'active'),
('en', 'admin', '0', 'no_categories_available', 'There are no categories.', '', '0', '', 'active'),
('en', 'admin', '0', 'featured_blocks', 'Featured box', '', '0', '', 'active'),
('en', 'admin', '0', 'featured_settings', 'Featured Settings', '', '0', '', 'active'),
('en', 'admin', '0', 'additional_cat_block', 'Additional category box', '', '0', '', 'active'),
('en', 'admin', '0', 'submit_method', 'Submit method', '', '0', '', 'active'),
('en', 'admin', '0', 'block_only', 'Box only', '', '0', '', 'active'),
('en', 'admin', '0', 'content_and_block', 'Content and box', '', '0', '', 'active'),
('en', 'admin', '0', 'search_form', 'Search form', '', '0', '', 'active'),
('en', 'admin', '0', 'search_settings', 'Search Settings', '', '0', '', 'active'),
('en', 'admin', '0', 'alphabetic', 'Alphabetic', '', '0', '', 'active'),
('en', 'admin', '0', 'order', 'Order', '', '0', '', 'active'),
('en', 'admin', '0', 'number_of_columns', 'Number of columns', '', '0', '', 'active'),
('en', 'admin', '0', 'position', 'Position', '', '0', '', 'active'),
('en', 'admin', '0', 'settings', 'Settings', '', '0', '', 'active'),
('en', 'admin', '0', 'admin_only', 'Administrator only', '', '0', '', 'active'),
('en', 'admin', '0', 'general_category_hint', 'You will be able to use this option in <b>\"Edit\"</b> mode next time.', '', '0', '', 'active'),
('en', 'admin', '0', 'general_category', 'Primary Category', '', '0', '', 'active'),
('en', 'admin', '0', 'apply_video', 'Enable video', '', '0', '', 'active'),
('en', 'admin', '0', 'fixed_height', 'Fixed Height', '', '0', '', 'active'),
('en', 'admin', '0', 'desktop_settings', 'Desktop Settings', '', '0', '', 'active'),
('en', 'admin', '0', 'desktop_blocks', 'Desktop Boxes', '', '0', '', 'active'),
('en', 'system', '0', 'remote_progress_update_completed', 'Updating has been completed.', '', '0', '', 'active'),
('en', 'system', '0', 'plugin_updated', 'Plugin has been successfully updated.', '', '0', '', 'active'),
('en', 'system', '0', 'install_fail_files_upload', 'Unable to copy the files; please contact Flynax Helpdesk.', '', '0', '', 'active'),
('en', 'system', '0', 'plugin_backingup_deny', 'Unable to backup the current plugin version; please check <b>/backup/plugins/</b> on the server.', '', '0', '', 'active'),
('en', 'admin', '1', 'remote_progress_updating', 'Updating the plugin...', '', '0', '', 'active'),
('en', 'admin', '0', 'remote_progress_backingup', 'Making a back up of the current plugin...', '', '0', '', 'active'),
('en', 'admin', '1', 'plugin_is_updating', 'is updating...', '', '0', '', 'active'),
('en', 'admin', '1', 'remote_plugin_update_notice', 'Are you sure you want to update the plugin?<br /><b>Warning</b>: Changes made to the plugin might be lost.', '', '0', '', 'active'),
('en', 'system', '0', 'remote_progress_installation_completed', 'Installation completed!', '', '0', '', 'active'),
('en', 'admin', '1', 'remote_progress_installing', 'Installing plugin...', '', '0', '', 'active'),
('en', 'admin', '1', 'remote_progress_download', 'Downloading the plugin and extracting files. The process might take some time, please wait.', '', '0', '', 'active'),
('en', 'admin', '1', 'remote_progress_connect', 'Connect to Flynax plugin server...', '', '0', '', 'active'),
('en', 'system', '0', 'plugin_download_fail', 'Unable to download/extract remote files; please contact Flynax Helpdesk.', '', '0', '', 'active'),
('en', 'admin', '0', 'desktop', 'Desktop', '', '0', '', 'active'),
('en', 'admin', '1', 'plugin_is_installing', 'is installing...', '', '0', '', 'active'),
('en', 'admin', '0', 'html_editor', 'HTML editor', '', '0', '', 'active'),
('en', 'admin', '0', 'registration_form', 'Reg. Form', '', '0', '', 'active'),
('en', 'admin', '0', 'suggest_category_building', 'Form of the category you\'ve just added is empty, do you want to populate it with fields?', '', '0', '', 'active'),
('en', 'admin', '0', 'suggest_account_type_building', 'A registration form of the account type you\'ve added is empty. Do you want to populate it with fields?', '', '0', '', 'active'),
('en', 'admin', '0', 'resend_activation_link_success', 'An activation link has been sent to <b>{count}</b> accounts out of selected ones.', '', '0', '', 'active'),
('en', 'admin', '0', 'limit_listing_types_remove', 'You\'re not allowed to remove all account types as there should be at least one active account type.', '', '0', '', 'active'),
('en', 'admin', '0', 'resend_activation_link_fail', 'The selected accounts have already been confirmed.', '', '0', '', 'active'),
('en', 'admin', '0', 'resend_activation_link', 'Resend activation link', '', '0', '', 'active'),
('en', 'admin', '0', 'system_field_notice', 'The field has system attributes; some options are unavailable to you.', '', '0', '', 'active'),
('en', 'admin', '0', 'drop_group_field_here', 'Drag and drop groups and fields here to populate the form.', '', '0', '', 'active'),
('en', 'admin', '0', 'drop_field_here', 'Drag and drop fields here.', '', '0', '', 'active'),
('en', 'admin', '0', 'lang_export_empty_alert', 'There are no phrases to be exported, please contact Flynax Help desk.', '', '0', '', 'active'),
('en', 'admin', '0', 'module_frontEnd', 'User Interface', '', '0', '', 'active'),
('en', 'admin', '0', 'query_results', 'Query results', '', '0', '', 'active'),
('en', 'admin', '0', 'build_register_form', 'Build registration form', '', '0', '', 'active'),
('en', 'admin', '0', 'replace_account_duplicate', 'Please select another username; the <b>{username}</b> will be removed.', '', '0', '', 'active'),
('en', 'admin', '0', 'module_common', 'Common', '', '0', '', 'active'),
('en', 'admin', '0', 'module_admin', 'Admin Panel', '', '0', '', 'active'),
('en', 'admin', '0', 'label_bg_color', 'Background color', '', '0', '', 'active'),
('en', 'admin', '0', 'plan_granted_notice', 'You\'ve successfully granted the plan.', '', '0', '', 'active'),
('en', 'admin', '0', 'grant_plan', 'Grant a Package', '', '0', '', 'active'),
('en', 'admin', '0', 'arrange_box_name', 'Box name ({name})', '', '0', '', 'active'),
('en', 'admin', '0', 'arrange_col_name', 'Tab Name ({name})', '', '0', '', 'active'),
('en', 'admin', '0', 'in_tab', '(In tab)', '', '0', '', 'active'),
('en', 'admin', '0', 'search_form_builder', 'Search Form Builder', '', '0', '', 'active'),
('en', 'admin', '0', 'account_type_own_location', 'Build URLs of individual pages {type}.', '', '0', '', 'active'),
('en', 'admin', '0', 'search_form_on_search', 'Search form on the Search page', '', '0', '', 'active'),
('en', 'admin', '0', 'search_form_on_home', 'Search form on the Home page', '', '0', '', 'active'),
('en', 'admin', '0', 'featured_block_pattern', 'Featured {type}', '', '0', '', 'active'),
('en', 'admin', '0', 'categories_block_pattern', '{type} Categories', '', '0', '', 'active'),
('en', 'admin', '0', 'refine_search_pattern', 'Refine search ({type})', '', '0', '', 'active'),
('en', 'admin', '0', 'cache_updated', 'System cache has been successfully updated.', '', '0', '', 'active'),
('en', 'admin', '0', 'update_cache', 'Update system cache', '', '0', '', 'active'),
('en', 'admin', '0', 'delete_account_conditions', 'The <b>{username}</b> account has the following data:', '', '0', '', 'active'),
('en', 'common', '1', 'delete_account', 'Remove Account', '', '0', '', 'active'),
('en', 'admin', '0', 'account_type_has_not_fields', 'The account type has only one step of registration. The data collected in the second step of registration will be hidden.', '', '0', '', 'active'),
('en', 'admin', '0', 'account_short_form_builder', 'Account Browse Form Builder', '', '0', '', 'active'),
('en', 'admin', '0', 'build_group_in_group_alert', 'You cannot add the groups to other groups.', '', '0', '', 'active'),
('en', 'admin', '0', 'arrange_tab_name', 'Tab name ({name})', '', '0', '', 'active'),
('en', 'admin', '0', 'arrange_by_field', 'Arrange by field', '', '0', '', 'active'),
('en', 'admin', '0', 'no_fields_available', 'There are no fields.', '', '0', '', 'active'),
('en', 'admin', '0', 'apply_to', 'Apply to', '', '0', '', 'active'),
('en', 'admin', '0', 'arrange_search_form', 'Search form', '', '0', '', 'active'),
('en', 'admin', '0', 'account_type_custom_page', 'Generate individual pages for users of this type.', '', '0', '', 'active'),
('en', 'admin', '0', 'plugin_update_request_hint', 'The {version} version of the {name} plugin is now available, do you want to update?', '', '0', '', 'active'),
('en', 'admin', '0', 'delete_plan_conditions', 'The <b>{plan}</b> plan has the following data:', '', '0', '', 'active'),
('en', 'admin', '0', 'delete_plan', 'Remove Package', '', '0', '', 'active'),
('en', 'admin', '0', 'type_phone', 'Phone number', '', '0', '', 'active'),
('en', 'admin', '0', 'number_field_length_hint', 'Leave the field empty to enable an unlimited number of characters.', '', '0', '', 'active'),
('en', 'admin', '0', 'browse', 'Browse', '', '0', '', 'active'),
('en', 'admin', '0', 'available_plugins', 'Available Plugins', '', '0', '', 'active'),
('en', 'admin', '0', 'update_from_to', 'Update from v{from} to v{to}', '', '0', '', 'active'),
('en', 'admin', '0', 'search_multicat_levels_hint', 'Sets a number of levels of cascading category dropdowns.', '', '0', '', 'active'),
('en', 'admin', '0', 'search_in_plugins', 'Search in plugins', '', '0', '', 'active'),
('en', 'system', '0', 'no_new_plugins', 'Oops! Looks like you\'ve installed all plugins!', '', '0', '', 'active'),
('en', 'admin', '0', 'plugin_not_installed', 'To be installed', '', '0', '', 'active'),
('en', 'common', '0', 'account_fields+name+Last_name', 'Last Name', '', '0', '', 'active'),
('en', 'common', '0', 'account_fields+description+about_me', 'Please write a few words about yourself.\nWe would be glad to get to know you.', '', '0', '', 'active'),
('en', 'common', '0', 'account_fields+default+police', 'This is the basic website agreement we use for delivering website services. We encourage our Clients to read and understand the agreement as it is designed to protect them as well as us. It explains what we and also they are responsible for and not responsible for.', '', '0', '', 'active'),
('en', 'common', '0', 'account_fields+name+police', 'Privacy Policy', '', '0', '', 'active'),
('en', 'common', '0', 'account_fields+name+additional_e_mail', 'Additional Email', '', '0', '', 'active'),
('en', 'common', '0', 'account_fields+name+about_me', 'About Me', '', '0', '', 'active'),
('en', 'common', '0', 'account_fields+name+country', 'Country', '', '0', '', 'active'),
('en', 'common', '0', 'account_fields+name+zip_code', 'ZIP code', '', '0', '', 'active'),
('en', 'common', '0', 'account_fields+name+docs', 'Documentation', '', '0', '', 'active'),
('en', 'common', '0', 'account_fields+name+phone', 'Phone', '', '0', '', 'active'),
('en', 'common', '0', 'account_fields+name+address', 'Address', '', '0', '', 'active'),
('en', 'common', '0', 'account_fields+name+website', 'Website', '', '0', '', 'active'),
('en', 'common', '0', 'account_fields+name+company_name', 'Company Name', '', '0', '', 'active'),
('en', 'box', '0', 'blocks+name+ltsb_listings', 'Refine Search', 'ltsb_listings', '0', '', 'active'),
('en', 'box', '0', 'blocks+name+keyword_search', 'Keyword Search', 'keyword_search', '0', '', 'active'),
('en', 'box', '0', 'blocks+name+advertising', 'Advertising', 'advertising', '0', '', 'active'),
('en', 'box', '0', 'blocks+name+statistics', 'Statistics', 'statistics', '0', '', 'active'),
('en', 'box', '0', 'blocks+name+news', 'News', 'news', '0', '', 'active'),
('en', 'box', '0', 'blocks+name+account_area', 'Account Area', 'account_area', '0', '', 'active'),
('en', 'common', '0', 'pages+name+404', 'Undefined Page', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'pages+title+404', 'Oops! The page you are looking for doesn\'t exist.', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'pages+content+404', 'We\'re sorry but the page you\'re looking for doesn\'t exist.<br />You may have mistyped something or the page was removed; please check the URL and try again.', '404', '0', '', 'active'),
('en', 'common', '0', 'pages+name+payment_history', 'Payment History', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'pages+title+payment_history', 'Payment History', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'pages+meta_description+news', 'Stay updated with Flynax news feeds!', 'news', '0', '', 'active'),
('en', 'common', '0', 'pages+name+my_packages', 'My Packages', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'pages+title+my_packages', 'My Packages', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'pages+title+my_ads', 'My Ads', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'pages+content+privacy_policy', 'If you continue to browse and use this website, you are agreeing to comply with our Terms of Use. We respect and comply with EU General Data Protection Regulations (GDPR) and GDPR requirements have become an integral part of our Terms of Use. When using our website, we will collect and store some of your personal information. These Terms of Use will explain <strong>why we collect</strong> and <strong>how we use </strong>your personal data. If you still have any questions, or need clarifications regarding the use of your personal information, feel free to contact us via the contact form.<br />\r\n<br />\r\n<strong>Cookies</strong><br />\r\nCookies are files stored in your browser with the aim of personalizing your web experience. By accepting our cookie policy, you are agreeing to our use of cookies. We use cookies in order to enhance your browsing experience and receive error reports when you use our website.<br />\r\n<br />\r\n<strong>Personal information</strong><br />\r\nPersonal information we collect from you may include your <strong>name</strong>, <strong>address</strong>, <strong>e-mail address</strong>, <strong>phone number</strong>, and <strong>IP address</strong>. We only collect this information when you <strong>make a purchase</strong> or <strong>register</strong> in our system and we need this information in order to identify and register you as a customer, confirm your purchase and contact you regarding the use of our product or answer your queries. Your phone number may be used to contact you to confirm your purchase if you have difficulty confirming it by email. We <strong>do not</strong> share this information with any third parties, and you may rest assured that all of your personal data is safe with us.<br />\r\n<br />\r\n<strong>Your location</strong><br />\r\nWhen you browse our website, we may use your IP address to detect your location. We need this information to personalize your experience, particularly when you are using a map search on our site or looking for ads on the Maps. Your location is needed to show you the appropriate location on the Maps and ads in the vicinity of your location. We also use your location to show you the appropriate banners or geo-targeted ads by Google.<br />\r\n<br />\r\n<strong>Credit Card information</strong><br />\r\nWhen you make a purchase on our website, you enter your credit card information or your PayPal address in order to complete the purchase. Because the payment process is handled by third-party payment providers, neither your credit card information nor your PayPal details are stored by us and we have no access to this information at no stage of the payment process.<br />\r\n<br />\r\n<strong>System notifications</strong><br />\r\nBy using our website, you are giving your consent that you will sometimes receive system notifications to your email address informing you of a successfully added listing, warning you that a listing period is expiring, meaning that your ad will get taken down if you don’t renew it and other types of notifications relating to your activity on the website. The system notifications are designed to serve as reminders or helpful tips enhancing your experience on our website. You cannot opt out of receiving system notifications, and the only way to stop receiving them is to delete your account via my profile page.', 'privacy_policy', '0', '', 'active'),
('en', 'frontEnd', '0', 'pages+content+terms_of_use', 'Your \"Terms of Use\" text here.', 'terms_of_use', '0', '', 'active'),
('en', 'common', '0', 'pages+name+saved_search', 'My Alerts', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'pages+title+saved_search', 'My Alerts', '', '0', '', 'active'),
('en', 'common', '0', 'pages+name+rss_feed', 'RSS Feed', '', '0', '', 'active'),
('en', 'common', '0', 'pages+name+print', 'Print Page', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'pages+title+print', 'Print Page', '', '0', '', 'active'),
('en', 'common', '0', 'pages+name+my_messages', 'My Messages', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'pages+title+my_messages', 'My Messages', '', '0', '', 'active'),
('en', 'common', '0', 'pages+name+my_favorites', 'Favorites', '', '0', '', 'active'),
('en', 'common', '0', 'pages+name+news', 'News', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'pages+title+news', 'Our News', '', '0', '', 'active'),
('en', 'common', '0', 'pages+name+home', 'Home', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'pages+title+home', '{advanced_site_name}', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'pages+title+about_us', 'About Us', '', '0', '', 'active'),
('en', 'common', '0', 'pages+name+about_us', 'About Us', '', '0', '', 'active'),
('en', 'common', '0', 'pages+name+contact_us', 'Contact Us', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'pages+title+contact_us', 'Contact us', '', '0', '', 'active'),
('en', 'common', '0', 'pages+name+terms_of_use', 'Terms of Use', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'pages+title+terms_of_use', 'Terms of use', '', '0', '', 'active'),
('en', 'common', '0', 'pages+name+privacy_policy', 'Privacy Policy', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'pages+title+privacy_policy', 'Privacy Policy', '', '0', '', 'active'),
('en', 'common', '0', 'pages+name+search', 'Search', '', '0', '', 'active'),
('en', 'common', '0', 'pages+name+my_profile', 'My Profile', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'pages+title+login', 'Log in to your Account', '', '0', '', 'active'),
('en', 'common', '0', 'pages+name+login', 'Sign in', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'pages+title+remind', 'Reset password to my account', '', '0', '', 'active'),
('en', 'common', '0', 'pages+name+remind', 'Reset Your Password', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'pages+title+registration', 'Account registration', '', '0', '', 'active'),
('en', 'common', '0', 'pages+name+registration', 'Registration', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'pages+content+about_us', 'Your \"About Us\" text here.', 'about_us', '0', '', 'active'),
('en', 'common', '0', 'pages+name+confirm', 'Account confirmation', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'pages+title+confirm', 'User account confirmation', '', '0', '', 'active'),
('en', 'common', '0', 'pages+name+payment', 'Checkout', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'pages+title+payment', 'Checkout', '', '0', '', 'active'),
('en', 'common', '0', 'pages+name+view_details', 'View Details', '', '0', '', 'active'),
('en', 'common', '0', 'listing_plans+name+featured_paid', 'Upgrade to Featured', '', '0', '', 'active'),
('en', 'common', '0', 'listing_plans+des+featured_paid', 'Paid Upgrade to Featured package', '', '0', '', 'active'),
('en', 'common', '0', 'listing_plans+name+featured', 'Featured Package', '', '0', '', 'active'),
('en', 'common', '0', 'listing_plans+des+free_package', 'Free Package', '', '0', '', 'active'),
('en', 'common', '0', 'listing_plans+name+free_package', 'Free Package', '', '0', '', 'active'),
('en', 'common', '0', 'listing_plans+name+silver', 'Silver Package', '', '0', '', 'active'),
('en', 'common', '0', 'listing_plans+name+bronze', 'Bronze Package', '', '0', '', 'active'),
('en', 'common', '0', 'listing_plans+name+gold_plan', 'Golden Package', '', '0', '', 'active'),
('en', 'common', '0', 'error_textarea_limit_exceeded', 'The value of the <span class=\"field_error\">\"{field}\"</span> field has exceeded the length allowed, which is <span class=\"field_error\">{limit}</span> characters.', '', '0', '', 'active'),
('en', 'common', '0', 'notice_phone_field_error', 'The {field} field is empty or partially filled in.', '', '0', '', 'active'),
('en', 'common', '0', 'domain', 'Domain', '', '0', '', 'active'),
('en', 'common', '1', 'error_maxFileSize', 'The file size exceeds the {limit}Mb limit.', '', '0', '', 'active'),
('en', 'common', '0', 'error_acceptFileTypes', 'Unacceptable file format', '', '0', '', 'active'),
('en', 'common', '0', 'uploading_completed', 'The files have been successfully uploaded.', '', '0', '', 'active'),
('en', 'common', '0', 'login_attempt_error', '[Error]: Too many failed login attempts detected, please try again in {period} hour(s).', '', '0', '', 'active'),
('en', 'common', '0', 'login_attempt_warning', '[Attention]: You have {number} login attempt(s) left', '', '0', '', 'active'),
('en', 'common', '0', 'picture_preparing', 'Preparing...', '', '0', '', 'active'),
('en', 'common', '0', 'upload_file', 'File:', '', '0', '', 'active'),
('en', 'common', '0', 'upload_no_preview_available', 'No preview available<br /> in IE browsers', '', '0', '', 'active'),
('en', 'common', '0', 'menu_more', 'More', '', '0', '', 'active'),
('en', 'common', '0', 'purchased_packages', 'Active packages', '', '0', '', 'active'),
('en', 'common', '0', 'payment_gateway', 'Gateway', '', '0', '', 'active'),
('en', 'common', '0', 'item_not_available', 'The item is unavailable or removed.', '', '0', '', 'active'),
('en', 'common', '0', 'website_admin', 'Site Administrator', '', '0', '', 'active'),
('en', 'common', '0', 'my_messages', 'My Messages', '', '0', '', 'active'),
('en', 'common', '0', 'select_plan', 'Select a Package', '', '0', '', 'active'),
('en', 'common', '0', 'fill_out_form', 'Fill Out Form', '', '0', '', 'active'),
('en', 'common', '0', 'package_plan_short', 'Package', '', '0', '', 'active'),
('en', 'common', '0', 'sign_up', 'Sign Up', '', '0', '', 'active'),
('en', 'common', '0', 'or', 'or', '', '0', '', 'active'),
('en', 'common', '0', 'allowed_count', 'You may add another <b>{count}</b>', '', '0', '', 'active'),
('en', 'common', '0', 'manage_description', 'Manage Description', '', '0', '', 'active'),
('en', 'common', '1', 'password_weak_warning', 'Your password is too weak, we suggest using uppercase characters to make it stronger.', '', '0', '', 'active'),
('en', 'common', '0', 'perv_step', 'Go Back', '', '0', '', 'active'),
('en', 'common', '0', 'next_step', 'Next', '', '0', '', 'active'),
('en', 'common', '1', 'password_strength_pattern', 'Strength ({number} of {maximum})', '', '0', '', 'active'),
('en', 'common', '0', 'reg_done', 'Done!', '', '0', '', 'active'),
('en', 'common', '0', 'personal_details', 'Personal Details', '', '0', '', 'active'),
('en', 'common', '0', 'show_next_categories', 'Show next categories', '', '0', '', 'active'),
('en', 'common', '0', 'show_previous_categories', 'Show previous categories', '', '0', '', 'active'),
('en', 'common', '0', 'show_other_categories', 'Show other categories', '', '0', '', 'active'),
('en', 'common', '0', 'back_to_advanced_search', 'Back to advanced search form', '', '0', '', 'active'),
('en', 'common', '0', 'middle', 'Middle', '', '0', '', 'active'),
('en', 'common', '0', 'currency', 'Currency', '', '0', '', 'active'),
('en', 'common', '0', 'back_to_search_results', 'Back to search results', '', '0', '', 'active'),
('en', 'common', '0', 'no_more_videos', 'Your listing package \"<b>{plan}</b>\" allows you to add no more than <b>{count}</b> video(s).', '', '0', '', 'active'),
('en', 'common', '0', 'error_video_upload_fail', 'Unable to upload the video file; please contact the Administrator.', '', '0', '', 'active'),
('en', 'common', '0', 'upload_video_left', 'Upload / <b>{number}</b> video(s) left', '', '0', '', 'active'),
('en', 'common', '0', 'plan_option_using_hack', 'HACK DETECTED: You are not allowed to use the packages, please choose another package.', '', '0', '', 'active'),
('en', 'common', '0', 'sort_accounts_by', 'Sort accounts by', '', '0', '', 'active'),
('en', 'common', '0', 'search_accounts_by', 'Search accounts by', '', '0', '', 'active'),
('en', 'common', '0', 'alphabet_characters', 'All,0-9,A,B,C,D,E,F,G,H,I,J,K,L,M,N,O,P,Q,R,S,T,U,V,W,X,Y,Z', '', '0', '', 'active'),
('en', 'common', '0', 'total', 'Total', '', '0', '', 'active'),
('en', 'common', '0', 'today', 'Today', '', '0', '', 'active'),
('en', 'common', '0', 'advanced_options', 'More Options', '', '0', '', 'active'),
('en', 'common', '0', 'keyword_search_opt1', 'All words in any order', '', '0', '', 'active'),
('en', 'common', '0', 'keyword_search_opt2', 'Any words in any order', '', '0', '', 'active'),
('en', 'common', '0', 'keyword_search_opt3', 'Exact match', '', '0', '', 'active'),
('en', 'common', '0', 'package_info', 'Package Info', '', '0', '', 'active'),
('en', 'common', '0', 'features', 'Features', '', '0', '', 'active'),
('en', 'common', '0', 'already_purchased', 'Already Purchased', '', '0', '', 'active'),
('en', 'common', '0', 'feed', 'Feed', '', '0', '', 'active'),
('en', 'common', '0', 'sub_domain', 'on subdomains', '', '0', '', 'active'),
('en', 'common', '0', 'sub_directory', 'in subdirectories', '', '0', '', 'active'),
('en', 'common', '0', 'personal_address_error', '\"Personal address\" either hasn\'t been entered or is incorrect; please try again.', '', '0', '', 'active'),
('en', 'common', '0', 'personal_address_in_use', '\"Personal address\" is already in use or denied', '', '0', '', 'active'),
('en', 'common', '0', 'me', 'Me', '', '0', '', 'active'),
('en', 'common', '0', 'id', 'ID', '', '0', '', 'active'),
('en', 'common', '0', 'item', 'Item', '', '0', '', 'active'),
('en', 'common', '0', 'amount', 'Amount', '', '0', '', 'active'),
('en', 'common', '0', 'txn_id', 'Transaction ID', '', '0', '', 'active'),
('en', 'common', '0', 'email_footer', 'Thank you, \nFlynax Team', '', '0', '', 'active'),
('en', 'common', '0', 'plain_text', 'Plain Text', '', '0', '', 'active'),
('en', 'common', '0', 'html_code', 'HTML', '', '0', '', 'active'),
('en', 'common', '1', 'loading', 'Loading...', '', '0', '', 'active'),
('en', 'common', '0', 'crossed', 'Related', '', '0', '', 'active'),
('en', 'common', '0', 'show_list', 'Show List', '', '0', '', 'active'),
('en', 'common', '1', 'flynax_connect_fail', 'Unable to reach Flynax Server.', '', '0', '', 'active'),
('en', 'common', '0', 'you_use', 'You use', '', '0', '', 'active'),
('en', 'common', '1', 'update', 'Update', '', '0', '', 'active'),
('en', 'common', '0', 'install', 'Install', '', '0', '', 'active'),
('en', 'common', '0', 'buy_plugin', 'Buy Plugin', '', '0', '', 'active'),
('en', 'common', '0', 'buy_plugin_title', 'Buy the plugin from Flynax', '', '0', '', 'active'),
('en', 'common', '1', 'reviewed', 'Reviewed', '', '0', '', 'active'),
('en', 'common', '0', 'learn_more_about', 'Learn more about', '', '0', '', 'active'),
('en', 'common', '0', 'current_version', 'Current Version', '', '0', '', 'active'),
('en', 'common', '0', 'posted_date', 'Date of posting', '', '0', '', 'active'),
('en', 'common', '0', 'plan_detals', 'Plan Details', '', '0', '', 'active'),
('en', 'common', '0', 'saving', 'Saving...', '', '0', '', 'active'),
('en', 'common', '0', 'subcategories', 'Subcategories', '', '0', '', 'active'),
('en', 'common', '0', 'currently_uploaded_file', 'Uploaded file', '', '0', '', 'active'),
('en', 'common', '0', 'show', 'Show', '', '0', '', 'active'),
('en', 'common', '0', 'advanced', 'Advanced', '', '0', '', 'active'),
('en', 'common', '0', 'quick', 'Quick', '', '0', '', 'active'),
('en', 'common', '0', 'hide', 'Hide', '', '0', '', 'active'),
('en', 'common', '1', 'replied', 'Replied', '', '0', '', 'active'),
('en', 'common', '0', 'manage_video', 'Manage Video', '', '0', '', 'active'),
('en', 'common', '0', 'crossed_count_hack', 'HACK DETECTED: You have exceeded the number of mirror categories offered by the package.', '', '0', '', 'active'),
('en', 'common', '0', 'crossed_top_text_denied', 'You\'ve exceeded the limit for mirror categories.', '', '0', '', 'active'),
('en', 'common', '0', 'crossed_categories', 'Related Categories', '', '0', '', 'active'),
('en', 'common', '0', 'plan_live_for', 'Package live for', '', '0', '', 'active'),
('en', 'common', '0', 'remove_selected', 'Remove the selected messages', '', '0', '', 'active'),
('en', 'common', '0', 'remove_message_notice', 'Are you sure you want to remove the messages?', '', '0', '', 'active'),
('en', 'common', '0', 'removed', 'Removed', '', '0', '', 'active'),
('en', 'common', '0', 'removed_by', 'Removed by {name}', '', '0', '', 'active'),
('en', 'common', '0', 'remove_contact_notice', 'Are you sure you want to remove the chat?', '', '0', '', 'active'),
('en', 'common', '0', 'rest_of_amount', '<b>{rest}</b> of {amount}', '', '0', '', 'active'),
('en', 'common', '0', 'plan_details', 'Package Details', '', '0', '', 'active'),
('en', 'common', '0', 'renew_package_not_owner', 'The listing package is not available to you.', '', '0', '', 'active'),
('en', 'common', '0', 'standard', 'Standard', '', '0', '', 'active'),
('en', 'common', '0', 'unset_unlimited', 'Cancel unlimited', '', '0', '', 'active'),
('en', 'common', '0', 'set_unlimited', 'Set unlimited', '', '0', '', 'active'),
('en', 'common', '0', 'renew', 'Renew', '', '0', '', 'active'),
('en', 'common', '0', 'overdue', 'Overdue', '', '0', '', 'active'),
('en', 'common', '0', 'search_criteria', 'Search Criteria', '', '0', '', 'active'),
('en', 'common', '0', 'account_rules', 'Admin Permissions', '', '0', '', 'active'),
('en', 'common', '0', 'unlimited', 'Unlimited', '', '0', '', 'active'),
('en', 'common', '0', 'unlimited_short', 'Unlim', '', '0', '', 'active'),
('en', 'common', '0', 'plan_live', 'Package live period', '', '0', '', 'active'),
('en', 'common', '0', 'available', 'Available', '', '0', '', 'active'),
('en', 'common', '0', 'number_of_videos', 'Number of videos', '', '0', '', 'active'),
('en', 'common', '0', 'times', 'Times', '', '0', '', 'active'),
('en', 'common', '0', 'authorization', 'Authorization', '', '0', '', 'active'),
('en', 'common', '0', 'sign_in', 'Sign in', '', '0', '', 'active'),
('en', 'common', '0', 'purchase_new_package', 'Purchase a new package', '', '0', '', 'active'),
('en', 'common', '0', 'no_available_packages', 'There are no available listing packages.', '', '0', '', 'active'),
('en', 'common', '0', 'checkout', 'Checkout', '', '0', '', 'active'),
('en', 'common', '0', 'required_multilingual_error', 'Fill in the <b>{field}</b> field at least in one of the languages.', '', '0', '', 'active'),
('en', 'common', '0', 'multilingual', 'Multilingual', '', '0', '', 'active'),
('en', 'common', '1', 'password_lenght_fail', 'Your password is either too short or empty.', '', '0', '', 'active'),
('en', 'common', '0', 'no_reason_specified', 'No reason has been provided.', '', '0', '', 'active'),
('en', 'common', '0', 'unable_parse_video_key', 'Error: Failed to identify a video key in the URL/Embed Code you provided.', '', '0', '', 'active'),
('en', 'common', '0', 'map_amenities+name+cafe', 'Cafe', '', '0', '', 'active'),
('en', 'common', '0', 'map_amenities+name+night-club', 'Night Club', '', '0', '', 'active'),
('en', 'common', '0', 'map_amenities+name+hospital', 'Hospital', '', '0', '', 'active'),
('en', 'common', '0', 'add_listing_category_fail', 'Please select a category.', '', '0', '', 'active'),
('en', 'common', '1', 'done', 'Done', '', '0', '', 'active'),
('en', 'common', '1', 'incomplete', 'Incomplete', '', '0', '', 'active'),
('en', 'common', '0', 'active_till', 'Active till', '', '0', '', 'active'),
('en', 'common', '0', 'featured_till', 'Featured till', '', '0', '', 'active'),
('en', 'common', '1', 'warning', 'Warning!', '', '0', '', 'active'),
('en', 'common', '0', 'link_or_embed', 'Link or Embed', '', '0', '', 'active'),
('en', 'common', '1', 'pending', 'Pending', '', '0', '', 'active'),
('en', 'common', '0', 'account', 'Account', '', '0', '', 'active'),
('en', 'common', '1', 'expired', 'Expired', '', '0', '', 'active'),
('en', 'common', '0', 'content_type', 'Content Type', '', '0', '', 'active'),
('en', 'common', '0', 'local', 'Local', '', '0', '', 'active'),
('en', 'common', '0', 'youtube', 'YouTube', '', '0', '', 'active'),
('en', 'common', '0', 'embed', 'Embed', '', '0', '', 'active'),
('en', 'common', '0', 'max_file_size', 'Max file size', '', '0', '', 'active'),
('en', 'common', '0', 'local_amenity', 'Local Amenity', '', '0', '', 'active'),
('en', 'common', '0', 'number_left', '{number} left', '', '0', '', 'active'),
('en', 'common', '0', 'field_protected', 'Sorry, but you are not allowed to remove the system field <b>{field}</b>; consider disabling it by changing its status to inactive.', '', '0', '', 'active'),
('en', 'common', '0', 'date_to', 'Date to', '', '0', '', 'active');
INSERT INTO `{db_prefix}lang_keys` (`Code`, `Module`, `JS`, `Key`, `Value`, `Target_key`, `Modified`, `Plugin`, `Status`) VALUES
('en', 'common', '0', 'date_from', 'Date from', '', '0', '', 'active'),
('en', 'common', '1', 'system_error', 'A system error has occurred; please see the error log or contact Flynax helpdesk.', '', '0', '', 'active'),
('en', 'common', '0', 'and', 'and', '', '0', '', 'active'),
('en', 'common', '0', 'move', 'Move', '', '0', '', 'active'),
('en', 'common', '0', 'suspended', 'Suspended', '', '0', '', 'active'),
('en', 'common', '0', 'not_paid', 'Unpaid', '', '0', '', 'active'),
('en', 'common', '0', 'photo_cropping', 'Cropping', '', '0', '', 'active'),
('en', 'common', '0', 'crop_notice', 'Use a dotted square to select a cropping area.', '', '0', '', 'active'),
('en', 'common', '0', 'rl_accept', 'Accept', '', '0', '', 'active'),
('en', 'common', '0', 'error_crop_owner_fail', 'The system hasn\'t identified you are as the owner of this image, please contact the Administrator to resolve this issue.', '', '0', '', 'active'),
('en', 'common', '0', 'crop_protected', 'Removal is not allowed in the cropping mode.', '', '0', '', 'active'),
('en', 'common', '1', 'confirm_notice', 'Please confirm the action.', '', '0', '', 'active'),
('en', 'common', '0', 'category_locked', 'The category is locked.', '', '0', '', 'active'),
('en', 'common', '0', 'notice_saved_search_deleted', 'The alert has been successfully deleted.', '', '0', '', 'active'),
('en', 'common', '0', 'can_not_read_file', 'Error: Failed to process the uploaded file.', '', '0', '', 'active'),
('en', 'common', '0', 'unmark', 'Unmark', '', '0', '', 'active'),
('en', 'common', '0', 'feature_mode_access_hack', 'You\'ve run out of your plan, please renew the plan or consider using another plan.', '', '0', '', 'active'),
('en', 'common', '0', 'used_up', 'Used Up', '', '0', '', 'active'),
('en', 'common', '0', 'package_purchased', 'The listing package is available.', '', '0', '', 'active'),
('en', 'common', '0', 'search_by', 'Search for -{char}-', '', '0', '', 'active'),
('en', 'common', '0', 'info', 'Info', '', '0', '', 'active'),
('en', 'common', '1', 'show_subcategories', 'Show Subcategories', '', '0', '', 'active'),
('en', 'common', '0', 'choose', 'Choose', '', '0', '', 'active'),
('en', 'common', '0', 'apply', 'Apply', '', '0', '', 'active'),
('en', 'common', '1', 'cancel', 'Cancel', '', '0', '', 'active'),
('en', 'common', '0', 'no_follow', 'No Follow', '', '0', '', 'active'),
('en', 'common', '1', 'notice', 'Note', '', '0', '', 'active'),
('en', 'common', '0', 'reorder', 'Update', '', '0', '', 'active'),
('en', 'common', '0', 'location_not_found', 'The <b>{location}</b> location hasn\'t been found.', '', '0', '', 'active'),
('en', 'common', '0', 'google_map', 'Use on map', '', '0', '', 'active'),
('en', 'common', '0', 'not_available', 'N/A', '', '0', '', 'active'),
('en', 'common', '0', 'join_date', 'Registration Date', '', '0', '', 'active'),
('en', 'common', '0', 'votes', 'votes', '', '0', '', 'active'),
('en', 'common', '0', 'plan', 'Plan', '', '0', '', 'active'),
('en', 'common', '0', 'select_category', 'Select a Category', '', '0', '', 'active'),
('en', 'common', '0', 'administrator', 'Administrator', '', '0', '', 'active'),
('en', 'common', '0', 'upgrade_to_featured', 'Upgrade to Featured', '', '0', '', 'active'),
('en', 'common', '1', 'save', 'Save', '', '0', '', 'active'),
('en', 'common', '0', 'notice_description_saved', 'The new description has been successfully saved.', '', '0', '', 'active'),
('en', 'common', '1', 'new', 'New', '', '0', '', 'active'),
('en', 'common', '0', 'last_check', 'Last Check', '', '0', '', 'active'),
('en', 'common', '0', 'activate', 'Enable', '', '0', '', 'active'),
('en', 'common', '0', 'deactivate', 'Disable', '', '0', '', 'active'),
('en', 'common', '0', 'notice_items_deleted', 'You\'ve successfully removed the selected items.', '', '0', '', 'active'),
('en', 'common', '0', 'rss_feed', 'RSS Feed', '', '0', '', 'active'),
('en', 'common', '0', 'added', 'Added', '', '0', '', 'active'),
('en', 'common', '0', 'print_page', 'Print out the Page', '', '0', '', 'active'),
('en', 'common', '1', 'close', 'Close', '', '0', '', 'active'),
('en', 'common', '0', 'new_message_available', 'You have [count] new messages.', '', '0', '', 'active'),
('en', 'common', '0', 'no_messages', 'You don\'t have any new messages.', '', '0', '', 'active'),
('en', 'common', '0', 'user', 'User', '', '0', '', 'active'),
('en', 'common', '0', 'new_message', 'New Message', '', '0', '', 'active'),
('en', 'common', '0', 'reply', 'Reply', '', '0', '', 'active'),
('en', 'common', '0', 'show_chat', 'Show Chat', '', '0', '', 'active'),
('en', 'common', '0', 'chat_with', 'Chat with {name}', '', '0', '', 'active'),
('en', 'common', '0', 'messages', 'Messages', '', '0', '', 'active'),
('en', 'common', '0', 'contact_us', 'Contact Us', '', '0', '', 'active'),
('en', 'common', '1', 'characters_left', 'Characters left', '', '0', '', 'active'),
('en', 'common', '0', 'unit', 'Unit', '', '0', '', 'active'),
('en', 'common', '1', 'to', 'to', '', '0', '', 'active'),
('en', 'common', '0', 'search_results', 'Search Results', '', '0', '', 'active'),
('en', 'common', '1', 'any', '- Any -', '', '0', '', 'active'),
('en', 'common', '0', 'advanced_search', 'Advanced search', '', '0', '', 'active'),
('en', 'common', '0', 'modify_search_criterion', 'Change Search Criteria', '', '0', '', 'active'),
('en', 'common', '0', 'ascending', 'Ascending', '', '0', '', 'active'),
('en', 'common', '0', 'descending', 'Descending', '', '0', '', 'active'),
('en', 'common', '0', 'expire_date', 'Expiration Date', '', '0', '', 'active'),
('en', 'common', '1', 'shows', 'Views', '', '0', '', 'active'),
('en', 'common', '0', 'message', 'Message', '', '0', '', 'active'),
('en', 'common', '0', 'send', 'Send', '', '0', '', 'active'),
('en', 'common', '0', 'listing_groups+name+additional_information', 'Additional information', '', '0', '', 'active'),
('en', 'common', '0', 'notice_message_sent', 'The message has been successfully sent.', '', '0', '', 'active'),
('en', 'common', '0', 'locked', 'Locked', '', '0', '', 'active'),
('en', 'common', '0', 'dp_choose_date', 'Set a Date', '', '0', '', 'active'),
('en', 'common', '0', 'mode', 'Date type', '', '0', '', 'active'),
('en', 'common', '0', 'search_forms+name+quick_search', 'Quick Search', '', '0', '', 'active'),
('en', 'common', '0', 'powered_by', 'powered by', '', '0', '', 'active'),
('en', 'common', '0', 'copy_rights', '{advanced_site_name}', '', '0', '', 'active'),
('en', 'common', '0', 'flynax_url', 'https://www.flynax.com', '', '0', '', 'active'),
('en', 'common', '0', 'languages+name+english', 'English', '', '0', '', 'active'),
('en', 'common', '0', 'language', 'language', '', '0', '', 'active'),
('en', 'common', '1', 'from', 'from', '', '0', '', 'active'),
('en', 'common', '0', 'login', 'Sign in', '', '0', '', 'active'),
('en', 'common', '1', 'password', 'Password', '', '0', '', 'active'),
('en', 'common', '0', 'username', 'Username', '', '0', '', 'active'),
('en', 'common', '0', 'rl_logging_error', 'Username or password you\'ve entered is incorrect.', '', '0', '', 'active'),
('en', 'common', '0', 'rl_empty_username', 'Please enter your \"Username\".', '', '0', '', 'active'),
('en', 'common', '0', 'changes_saved', 'The changes have been successfully saved.', '', '0', '', 'active'),
('en', 'common', '1', 'delete_confirm', 'Are you sure you want to completely remove the item?', '', '0', '', 'active'),
('en', 'common', '0', 'add', 'Add', '', '0', '', 'active'),
('en', 'common', '1', 'manage', 'Manage', '', '0', '', 'active'),
('en', 'common', '1', 'delete', 'Delete', '', '0', '', 'active'),
('en', 'common', '0', 'all', 'All', '', '0', '', 'active'),
('en', 'common', '0', 'notice_incorrect_auth', 'The username or password is incorrect.', '', '0', '', 'active'),
('en', 'common', '0', 'notice_account_approval', 'Your account hasn\'t been activated yet, please wait for the Administrator to activate it.', '', '0', '', 'active'),
('en', 'common', '0', 'notice_logged_out', 'You\'ve logged out.', '', '0', '', 'active'),
('en', 'common', '0', 'welcome', 'Welcome', '', '0', '', 'active'),
('en', 'common', '0', 'title_logout', 'Log out from your Account', '', '0', '', 'active'),
('en', 'common', '0', 'logout', 'Log out', '', '0', '', 'active'),
('en', 'common', '0', 'search_in', 'Search for', '', '0', '', 'active'),
('en', 'common', '0', 'create_account', 'Register for a new account', '', '0', '', 'active'),
('en', 'common', '0', 'remind_pass', 'Reset your password', '', '0', '', 'active'),
('en', 'common', '0', 'remind', 'Remind', '', '0', '', 'active'),
('en', 'common', '0', 'registration', 'Sign up', '', '0', '', 'active'),
('en', 'common', '0', 'new_here', 'New here?', '', '0', '', 'active'),
('en', 'common', '0', 'forgot_pass', 'Forgot your password?', '', '0', '', 'active'),
('en', 'common', '0', 'iso_code_incorrect_charset', 'Error: Incorrect ISO code; please use Latin characters only.', '', '0', '', 'active'),
('en', 'common', '0', 'rl_empty_pass', 'Please enter your \"Password\".', '', '0', '', 'active'),
('en', 'common', '0', 'rl_interface', 'Interface', '', '0', '', 'active'),
('en', 'common', '0', 'phrase', 'Phrase', '', '0', '', 'active'),
('en', 'common', '0', 'enabled', 'enable', '', '0', '', 'active'),
('en', 'common', '0', 'disabled', 'disable', '', '0', '', 'active'),
('en', 'common', '0', 'name', 'Name', '', '0', '', 'active'),
('en', 'common', '0', 'default', 'Default', '', '0', '', 'active'),
('en', 'common', '0', 'notice_account_email_exist', 'The {email} email address is already in use by another account.', '', '0', '', 'active'),
('en', 'common', '0', 'notice_reg_complete', 'The account has been successfully added.', '', '0', '', 'active'),
('en', 'common', '0', 'account_type_admin_confirmation', 'Account activation by Administrator', '', '0', '', 'active'),
('en', 'common', '0', 'account_type_email_confirmation', 'Account confirmation by email', '', '0', '', 'active'),
('en', 'common', '0', 'notice_bad_email', 'Please make sure you\'ve entered a valid email address.', '', '0', '', 'active'),
('en', 'common', '0', 'notice_choose_account_type', 'Please select an account type.', '', '0', '', 'active'),
('en', 'common', '1', 'notice_pass_bad', 'Passwords do not match.', '', '0', '', 'active'),
('en', 'common', '0', 'notice_account_exist', 'The <b>{username}</b> username is already in use, please consider using a different one.', '', '0', '', 'active'),
('en', 'common', '1', 'notice_reg_length', 'The value in the {field} field must be at least 3 characters long.', '', '0', '', 'active'),
('en', 'common', '0', 'finish', 'Finish', '', '0', '', 'active'),
('en', 'common', '0', 'accept', 'I accept', '', '0', '', 'active'),
('en', 'common', '1', 'notice_bad_file_ext', 'The {ext} file extension is incompatible; please consider using an extension from the list.', '', '0', '', 'active'),
('en', 'common', '0', 'security_code_incorrect', 'The characters you\'ve entered do not match the captcha.', '', '0', '', 'active'),
('en', 'common', '0', 'click_refresh', 'Click on the image to refresh the captcha.', '', '0', '', 'active'),
('en', 'common', '0', 'security_code', 'Captcha', '', '0', '', 'active'),
('en', 'common', '0', 'notice_field_incorrect', 'The data you\'ve entered in the {field} field are incorrect.', '', '0', '', 'active'),
('en', 'common', '0', 'notice_select_empty', 'Select a {field} from the list.', '', '0', '', 'active'),
('en', 'common', '0', 'notice_checkbox_empty', 'Please select a {field} from the list.', '', '0', '', 'active'),
('en', 'common', '0', 'notice_no_agree', 'You have to fill in the {field}.', '', '0', '', 'active'),
('en', 'common', '0', 'registration_complete_active', 'You\'ve successfully created an account! Now you may sign into your [Account Area].', '', '0', '', 'active'),
('en', 'common', '0', 'name_field_empty', 'Please fill in the \'Name\'  field.', '', '0', '', 'active'),
('en', 'common', '0', 'no', 'No', '', '0', '', 'active'),
('en', 'common', '0', 'yes', 'Yes', '', '0', '', 'active'),
('en', 'common', '0', 'date', 'Date', '', '0', '', 'active'),
('en', 'common', '0', 'ms_excel', 'MS Excel', '', '0', '', 'active'),
('en', 'common', '0', 'ms_word', 'MS Word', '', '0', '', 'active'),
('en', 'common', '0', 'archive', 'Archive', '', '0', '', 'active'),
('en', 'common', '0', 'adobe_acrobat', 'Abobe Acrobat', '', '0', '', 'active'),
('en', 'common', '1', 'notice_field_empty', 'The {field} field is required; please fill in it.', '', '0', '', 'active'),
('en', 'common', '0', 'search', 'Search', '', '0', '', 'active'),
('en', 'common', '0', 'error_404', 'ERROR 404: Requested page not found.', '', '0', '', 'active'),
('en', 'common', '0', 'step', 'Step', '', '0', '', 'active'),
('en', 'common', '0', 'latin_characters_only', '<b>Notice</b>: Use Latin characters and digits only.', '', '0', '', 'active'),
('en', 'common', '0', 'menus', 'Menu', '', '0', '', 'active'),
('en', 'common', '0', 'personal_address', 'Individual page', '', '0', '', 'active'),
('en', 'common', '0', 'required_fields', 'Fields marked with * are required', '', '0', '', 'active'),
('en', 'common', '0', 'password_repeat', 'Confirm password', '', '0', '', 'active'),
('en', 'common', '0', 'first_name', 'First name', '', '0', '', 'active'),
('en', 'common', '0', 'last_name', 'Last Name', '', '0', '', 'active'),
('en', 'common', '0', 'mail', 'Email', '', '0', '', 'active'),
('en', 'common', '0', 'account_type', 'Account type', '', '0', '', 'active'),
('en', 'common', '0', 'next', 'Next', '', '0', '', 'active'),
('en', 'common', '0', 'undefined_page', 'Undefined Page', '', '0', '', 'active'),
('en', 'common', '0', 'your_photo', 'Your thumbnail', '', '0', '', 'active'),
('en', 'common', '0', 'edit', 'Edit', '', '0', '', 'active'),
('en', 'common', '0', 'notice_profile_edited', 'You\'ve successfully edited the profile.', '', '0', '', 'active'),
('en', 'common', '0', 'manage_password', 'Manage password', '', '0', '', 'active'),
('en', 'common', '0', 'current_password', 'Current password', '', '0', '', 'active'),
('en', 'common', '0', 'new_password', 'New password', '', '0', '', 'active'),
('en', 'common', '0', 'change', 'Change', '', '0', '', 'active'),
('en', 'common', '0', 'notice_incorrect_current_pass', 'The password is incorrect.', '', '0', '', 'active'),
('en', 'common', '0', 'status', 'Status', '', '0', '', 'active'),
('en', 'common', '1', 'active', 'Active', '', '0', '', 'active'),
('en', 'common', '1', 'approval', 'Inactive', '', '0', '', 'active'),
('en', 'common', '0', 'listing_groups+name+common', 'Common', '', '0', '', 'active'),
('en', 'common', '0', 'no_items_in_group', 'There are no fields in the group.', '', '0', '', 'active'),
('en', 'common', '0', 'add_field', 'Add a Field', '', '0', '', 'active'),
('en', 'common', '0', 'default_textarea_value_des', 'maximum number of characters, default value is 500 (3000 max )', '', '0', '', 'active'),
('en', 'common', '0', 'add_field_item', 'Add an Option', '', '0', '', 'active'),
('en', 'common', '0', 'field_added', 'You\'ve successfully added a new field.', '', '0', '', 'active'),
('en', 'common', '0', 'remove', 'Remove', '', '0', '', 'active'),
('en', 'common', '0', 'description', 'Description', '', '0', '', 'active'),
('en', 'common', '0', 'categories', 'Categories', '', '0', '', 'active'),
('en', 'common', '0', 'notice_number_incorrect', 'The {field} field has an invalid value; please use numbers in the range of ({min} to {max}).', '', '0', '', 'active'),
('en', 'common', '0', 'actions', 'Actions', '', '0', '', 'active'),
('en', 'common', '0', 'item_deleted', 'You\'ve successfully removed the item.', '', '0', '', 'active'),
('en', 'common', '0', 'select', '- Select -', '', '0', '', 'active'),
('en', 'common', '0', 'file', 'File', '', '0', '', 'active'),
('en', 'common', '0', 'go', 'Go', '', '0', '', 'active'),
('en', 'common', '0', 'check_all', 'Check All', '', '0', '', 'active'),
('en', 'common', '0', 'uncheck_all', 'Uncheck all', '', '0', '', 'active'),
('en', 'common', '0', 'payment_gateways', 'Payment gateways', '', '0', '', 'active'),
('en', 'common', '0', 'incorrect_username', 'Error: Incorrect username; please use Latin characters only.', '', '0', '', 'active'),
('en', 'common', '0', 'plans', 'Packages', '', '0', '', 'active'),
('en', 'common', '1', 'price', 'Price', '', '0', '', 'active'),
('en', 'common', '0', 'days', 'Days', '', '0', '', 'active'),
('en', 'common', '0', 'no_plan_chose', 'Please select a plan.', '', '0', '', 'active'),
('en', 'common', '0', 'download', 'Download', '', '0', '', 'active'),
('en', 'common', '0', 'incorrect_email', 'The email address you\'ve entered is incorrect.', '', '0', '', 'active'),
('en', 'common', '0', 'email_account_not_found', 'No account has been found with the email you\'ve entered.', '', '0', '', 'active'),
('en', 'common', '0', 'here', 'here', '', '0', '', 'active'),
('en', 'common', '0', 'account_confirmed_pending', 'Your account has been confirmed and <br /> is awaiting to be activated by the Administrator.', '', '0', '', 'active'),
('en', 'common', '0', 'free', 'Free', '', '0', '', 'active'),
('en', 'common', '0', 'new_password_repeat', 'Confirm password', '', '0', '', 'active'),
('en', 'common', '0', 'make_featured', 'Upgrade to Featured', '', '0', '', 'active'),
('en', 'common', '0', 'category', 'Category', '', '0', '', 'active'),
('en', 'common', '0', 'add_video', 'Add a Video', '', '0', '', 'active'),
('en', 'common', '0', 'upload', 'Upload', '', '0', '', 'active'),
('en', 'common', '0', 'primary', 'Primary', '', '0', '', 'active'),
('en', 'common', '0', 'set_primary', 'Set as primary', '', '0', '', 'active'),
('en', 'common', '1', 'of', 'of', '', '0', '', 'active'),
('en', 'common', '0', 'view_details', 'View details', '', '0', '', 'active'),
('en', 'common', '0', 'inventory_menu', 'Inventory menu', '', '0', '', 'active'),
('en', 'common', '0', 'map', 'Map View', '', '0', '', 'active'),
('en', 'common', '0', 'tell_friend', 'Tell a Friend', '', '0', '', 'active'),
('en', 'common', '0', 'click_here', 'Click here', '', '0', '', 'active'),
('en', 'common', '0', 'display_email', 'Publish my email', '', '0', '', 'active'),
('en', 'common', '0', 'video', 'Video', '', '0', '', 'active'),
('en', 'common', '0', 'upload_video', 'Upload a video', '', '0', '', 'active'),
('en', 'common', '0', 'no_video_uploaded', 'No video has been uploaded.', '', '0', '', 'active'),
('en', 'common', '0', 'available_file_type', 'Available file types', '', '0', '', 'active'),
('en', 'common', '0', 'featured_plan', 'Upgrade to Featured', '', '0', '', 'active'),
('en', 'common', '0', 'upgrade', 'Upgrade', '', '0', '', 'active'),
('en', 'common', '0', 'notice_account_edited', 'You\'ve successfully edited the user account.', '', '0', '', 'active'),
('en', 'common', '0', 'data_formats+name+foot', 'ft', '', '0', '', 'active'),
('en', 'common', '0', 'data_formats+name+unit', 'Units', '', '0', '', 'active'),
('en', 'common', '0', 'data_formats+name+metr', 'm', '', '0', '', 'active'),
('en', 'common', '0', 'data_formats+name+years', 'Years Range', '', '0', '', 'active'),
('en', 'common', '0', 'data_formats+name+us_states', 'US States', '', '0', '', 'active'),
('en', 'common', '0', 'data_formats+name+countries', 'Countries', '', '0', '', 'active'),
('en', 'common', '0', 'data_formats+name+dollar', '$', '', '0', '', 'active'),
('en', 'common', '0', 'data_formats+name+euro', '€', '', '0', '', 'active'),
('en', 'common', '0', 'data_formats+name+pound', '£', '', '0', '', 'active'),
('en', 'common', '0', 'data_formats+name+currency', 'Currency', '', '0', '', 'active'),
('en', 'common', '0', 'data_formats+name+yukon_territory', 'Yukon Territory', '', '0', '', 'active'),
('en', 'common', '0', 'data_formats+name+wisconsin', 'Wisconsin', '', '0', '', 'active'),
('en', 'common', '0', 'data_formats+name+west_virginia', 'West Virginia', '', '0', '', 'active'),
('en', 'common', '0', 'data_formats+name+washington', 'Washington', '', '0', '', 'active'),
('en', 'common', '0', 'data_formats+name+virginia', 'Virginia', '', '0', '', 'active'),
('en', 'common', '0', 'data_formats+name+vermont', 'Vermont', '', '0', '', 'active'),
('en', 'common', '0', 'data_formats+name+utah', 'Utah', '', '0', '', 'active'),
('en', 'common', '0', 'data_formats+name+us_virgin_isles', 'US Virgin Isles', '', '0', '', 'active'),
('en', 'common', '0', 'data_formats+name+texas', 'Texas', '', '0', '', 'active'),
('en', 'common', '0', 'data_formats+name+tennessee', 'Tennessee', '', '0', '', 'active'),
('en', 'common', '0', 'data_formats+name+south_dakota', 'South Dakota', '', '0', '', 'active'),
('en', 'common', '0', 'data_formats+name+south_carolina', 'South Carolina', '', '0', '', 'active'),
('en', 'common', '0', 'data_formats+name+rhode_island', 'Rhode Island', '', '0', '', 'active'),
('en', 'common', '0', 'data_formats+name+quebec', ' Quebec', '', '0', '', 'active'),
('en', 'common', '0', 'data_formats+name+pennsylvania', 'Pennsylvania', '', '0', '', 'active'),
('en', 'common', '0', 'data_formats+name+oregon', 'Oregon', '', '0', '', 'active'),
('en', 'common', '0', 'data_formats+name+ontario', 'Ontario', '', '0', '', 'active'),
('en', 'common', '0', 'data_formats+name+oklahoma', 'Oklahoma', '', '0', '', 'active'),
('en', 'common', '0', 'data_formats+name+ohio', 'Ohio', '', '0', '', 'active'),
('en', 'common', '0', 'data_formats+name+nova_scotia', 'Nova Scotia', '', '0', '', 'active'),
('en', 'common', '0', 'data_formats+name+northwest_territories', 'Northwest Territories', '', '0', '', 'active'),
('en', 'common', '0', 'data_formats+name+north_dakota', 'North Dakota', '', '0', '', 'active'),
('en', 'common', '0', 'data_formats+name+north_carolina', 'North Carolina', '', '0', '', 'active'),
('en', 'common', '0', 'data_formats+name+newfoundland', 'Newfoundland', '', '0', '', 'active'),
('en', 'common', '0', 'data_formats+name+new_york', 'New York', '', '0', '', 'active'),
('en', 'common', '0', 'data_formats+name+new_mexico', 'New Mexico', '', '0', '', 'active'),
('en', 'common', '0', 'data_formats+name+new_jersey', 'New Jersey', '', '0', '', 'active'),
('en', 'common', '0', 'data_formats+name+new_hampshire', 'New Hampshire', '', '0', '', 'active'),
('en', 'common', '0', 'data_formats+name+new_brunswick', 'New Brunswick', '', '0', '', 'active'),
('en', 'common', '0', 'data_formats+name+nevada', 'Nevada', '', '0', '', 'active'),
('en', 'common', '0', 'data_formats+name+nebraska', 'Nebraska', '', '0', '', 'active'),
('en', 'common', '0', 'data_formats+name+montana', 'Montana', '', '0', '', 'active'),
('en', 'common', '0', 'data_formats+name+missouri', 'Missouri', '', '0', '', 'active'),
('en', 'common', '0', 'data_formats+name+mississippi', 'Mississippi', '', '0', '', 'active'),
('en', 'common', '0', 'data_formats+name+minnesota', 'Minnesota', '', '0', '', 'active'),
('en', 'common', '0', 'data_formats+name+michigan', 'Michigan', '', '0', '', 'active'),
('en', 'common', '0', 'data_formats+name+massachusetts', 'Massachusetts', '', '0', '', 'active'),
('en', 'common', '0', 'data_formats+name+maryland', 'Maryland', '', '0', '', 'active'),
('en', 'common', '0', 'data_formats+name+manitoba', 'Manitoba', '', '0', '', 'active'),
('en', 'common', '0', 'data_formats+name+maine', 'Maine', '', '0', '', 'active'),
('en', 'common', '0', 'data_formats+name+louisiana', 'Louisiana', '', '0', '', 'active'),
('en', 'common', '0', 'data_formats+name+kentucky', 'Kentucky', '', '0', '', 'active'),
('en', 'common', '0', 'data_formats+name+kansas', 'Kansas', '', '0', '', 'active'),
('en', 'common', '0', 'data_formats+name+iowa', 'Iowa', '', '0', '', 'active'),
('en', 'common', '0', 'data_formats+name+indiana', 'Indiana', '', '0', '', 'active'),
('en', 'common', '0', 'data_formats+name+illinois', 'Illinois', '', '0', '', 'active'),
('en', 'common', '0', 'data_formats+name+idaho', 'Idaho ', '', '0', '', 'active'),
('en', 'common', '0', 'data_formats+name+arkansas', 'Arkansas ', '', '0', '', 'active'),
('en', 'common', '0', 'data_formats+name+arizona', 'Arizona', '', '0', '', 'active'),
('en', 'common', '0', 'data_formats+name+alberta', 'Alberta  ', '', '0', '', 'active'),
('en', 'common', '0', 'data_formats+name+alaska', 'Alaska', '', '0', '', 'active'),
('en', 'common', '0', 'data_formats+name+alabama', 'Alabama', '', '0', '', 'active'),
('en', 'common', '0', 'data_formats+name+us_states_georgia', 'Georgia', '', '0', '', 'active'),
('en', 'common', '0', 'data_formats+name+florida', 'Florida', '', '0', '', 'active'),
('en', 'common', '0', 'data_formats+name+connecticut', 'Connecticut', '', '0', '', 'active'),
('en', 'common', '0', 'data_formats+name+colorado', 'Colorado', '', '0', '', 'active'),
('en', 'common', '0', 'data_formats+name+california', 'California', '', '0', '', 'active'),
('en', 'common', '0', 'data_formats+name+british_columbia', 'British Columbia', '', '0', '', 'active'),
('en', 'common', '0', 'data_formats+name+wyoming', 'Wyoming', '', '0', '', 'active'),
('en', 'common', '0', 'data_formats+name+delaware', 'Delaware ', '', '0', '', 'active'),
('en', 'common', '0', 'data_formats+name+district_of_columbia', 'District of Columbia', '', '0', '', 'active'),
('en', 'common', '0', 'data_formats+name+hawaii', 'Hawaii ', '', '0', '', 'active'),
('en', 'common', '0', 'featured', 'Featured', '', '0', '', 'active'),
('en', 'common', '0', 'payed', 'Paid', '', '0', '', 'active'),
('en', 'common', '0', 'search_multi_categories', 'Cascading category dropdowns', '', '0', '', 'active'),
('en', 'common', '0', 'uploaded', 'Uploaded', '', '0', '', 'active'),
('en', 'admin', '0', 'resize_in_progress', 'Processing, please wait...', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_resize_error', 'A system error has occurred; please contact Flynax helpdesk.', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_item_value', 'Value', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_remove', 'Remove', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_delete', 'Delete', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_edit', 'Edit', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_actions', 'Actions', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_position', 'Position', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_notice_delete', 'Are you sure you want to delete the item irretrievably?', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_notice_trash', 'The item will be sent to the Trash Box? Are you sure you want to proceed?', '', '0', '', 'active');
INSERT INTO `{db_prefix}lang_keys` (`Code`, `Module`, `JS`, `Key`, `Value`, `Target_key`, `Modified`, `Plugin`, `Status`) VALUES
('en', 'admin', '1', 'ext_field_in_type_arrange_warning', '<b>Warning:</b> The field is used for building tabbed forms of the <b>{type}</b> type; all related data will be removed.', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_listing_fields_manager', 'Field Manager', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_name', 'Name', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_type', 'Type', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_default', 'Default', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_required_field', 'Required field', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_status', 'Status', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_saving_changes', 'Saving changes...', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_error_saving_changes', 'Error saving the changes...', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_yes', 'Yes', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_no', 'No', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_not_available', 'N/A', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_value', 'Value', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_area', 'Area', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_item', 'Item', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_deleted_by', 'Removed by', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_display_items', 'Displaying items {0} - {1} of {2}', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_no_items', 'There are no items to display.', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_page', 'page', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_of', 'of', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_key', 'Key', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_side', 'System module', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_saved_searches_manager', 'Alert Manager', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_data_format_auto', 'The data format is generated automatically.', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_need_login', 'Logging in required', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_pages_manager', 'Page Manager', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_block_side', 'Side', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_blocks_manager', 'Content Box Manager', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_block_style', 'Site design', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_block_header', 'Box heading', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_categories_manager', 'Category Manager', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_description', 'Description', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_default_display', 'Expansion by default', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_build', 'Click to build', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_login', 'Sign in', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_admins_manager', 'Administrator Manager', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_price', 'Price', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_days', 'Days', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_email_templates_manager', 'Email Template Manager', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_subject', 'Subject', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_account_fields_manager', 'Registration Field Manager', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_username', 'Username', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_email', 'Email', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_accounts_manager', 'Account Manager', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_join_date', 'Date of Creation', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_build_short_form', 'Build Browse Form', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_build_featured', 'Build Featured Form', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_news_manager', 'News Manager', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_title', 'Title', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_add_date', 'Date of Creation', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_search_forms_manager', 'Search Form Manager', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_view', 'View', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_check_for_update', 'Check for Updates', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_trash_manager', 'Trash Box', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_delete_date', 'Date of Removal', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_restore', 'Restore', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_visitor_incomplete', 'Visitor (incomplete)', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_version', 'Version', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_uninstall', 'Uninstall', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_install', 'Install', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_plugins_manager', 'Plugin Manager', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_manager', 'Manager', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_select_action', 'Select Action', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_payed', 'Payment Date', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_activate', 'Activate', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_suspend', 'Suspend', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_notice', 'Note', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_need_install', 'Please install the plugin first.', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_category', 'Category', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_click_to_edit', 'Click here to edit.', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_plan', 'Package/Plan', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_not_payed', 'Unpaid', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_click_to_set_pay', 'Click here to set a payment date.', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_id', 'ID', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_click_to_view_details', 'Click to view details', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_txn_id', 'Txn ID', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_total', 'Total', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_gateway', 'Gateway', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_date', 'Date', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_transactions_manager', 'Transaction Manager', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_plugin_uninstall', 'Are you sure you want to uninstall the plugin?', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_make_featured', 'Upgrade to Featured', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_search', 'Search', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_parent', 'Parent', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_no_follow', 'No follow', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_data_formats_manager', 'Data Entry Manager', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_manage', 'Manage', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_locked', 'Locked', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_no_plan_set', 'You haven\'t selected a package.', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_move', 'Move', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_activate_category_notice', 'Are you sure you want to enable the category?', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_amenities_manager', 'Amenity Manager', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_annul_featured', 'Downgrade Featured', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_plans_using_manager', 'Plan Usage Manager', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_balance', 'Balance', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_browse_category', 'Browse Category', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_accounts', 'Accounts', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_account_types_manager', 'Account Type Manager', '', '0', '', 'active'),
('en', 'admin', '1', 'refresh', 'Refresh', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_contacts_manager', 'Message Manager (Via Contact Form)', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_manage_video', 'Manage Video', '', '0', '', 'active'),
('en', 'admin', '1', 'alert', 'Alert', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_use_groups', 'Enable groups', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_option', 'Option', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_admin_only', 'Administrator only', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_build_reg_form', 'Build Registration Form', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_export', 'Export', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_format_items_manager', 'Data Item Manager', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_set_default', 'Set as default', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_phrases_manager', 'Phrase Manager', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_restore_options_confirm', 'Are you sure you want to set the default grid?', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_restore_options_title', 'Restore to default grid settings', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_restore_options', 'Restore Options', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_phrases_number', 'Number of phrases', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_text_direction', 'Text Direction', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_languages_manager', 'Language Manager', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_empty_grid_message', 'There is no data to display.', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_explain_your_reason', 'Can you please provide your reasons?', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_search_form', 'Build Search Form', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_edit_parent_category', 'Edit parent category', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_confirm', 'Confirm', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_view_details', 'View details', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_not_available_for_this_plan', 'Unavailable for this package', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_standard_remains', 'Standard', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_featured_remains', 'Featured', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_copy_phrase_to_lang', 'Copy the phrase to other languages', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_copy_phrase_done', 'The phrase has been successfully copied to other languages.', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'notice_account_type_approval', 'Your account type has been disabled by the Administrator.', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'notice_package_payment_completed', 'Your package payment has been successfully accepted.', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'notice_package_payment_canceled', 'Your transaction has been canceled.', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'mobile_standart_version', 'Standard Version', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'quick_signup_fail', 'Sign in if you have an account or Sign up if you don\'t.', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'no_javascript_warning', 'This website makes heavy use of <b>JavaScript</b>, please enable JavaScript in your browser to continue comfort use of the website.', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'no_account_transactions', 'You don\'t have any transactions.', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'accounts_found', '{number} account(s) found', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'account_type_page_access_restricted', 'The requested account type page is either disabled or restricted.', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'statistics_isnot_available', 'Statistics are unavailable', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'days_ago_pattern', '{day} Days Ago', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'yesterday', 'Yesterday', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'package_renewed', 'The listing package has been successfully renewed.', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'registration_complete_incomplete', 'You\'ve successfully created an account; an activation link has been sent to your <b>{email}</b>.<br /><br />Please, check your email box to verify your email address.', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'registration_complete_caption', 'Registration completed!', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'slogan_large', 'Slogan', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'slogan_small', 'Tagline text', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'quick_search', 'Quick Search', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'registration_complete_pending', 'You\'ve successfully created an account! It is awaiting Administrator approval.<br />Verification might take up to 24 hours, please be patient.', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'notice_should_login', 'You should have an account in order to log in and view the page.', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'captcha_info', 'Please enter characters depicted on the image.', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'notice_account_access_deny', 'Your account type doesn\'t have permission to view the page.', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'complete_payment', 'Complete Payment', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'checkout_step_info', 'Please select a payment gateway below and proceed with checkout.', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'account_confirmed', 'You\'ve confirmed your account. Please click [here] to log in.', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'account_already_confirmed_pending', 'Your account has been confirmed <br /> and is awaiting to be activated by the Administrator.', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'password_created', 'An email with a new password has been sent to your email address.', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'current_page', 'Current page', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'previous_page', 'Previous page', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'next_page', 'Next page', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'all_news', 'All news', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'no_news', 'There are no news.', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'back_to_news', 'Go back to the news list', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'page', 'Page', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'friend_name', 'Your Friend\'s Name', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'friend_email', 'Your Friend\'s Email', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'your_email', 'Email', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'your_name', 'Name', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'sort_by', 'Sort by', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'listings_found', '{number} ad(s) found', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'miles', 'miles', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'sort', 'Sort', '', '0', '', 'active'),
('en', 'frontEnd', '1', 'add_to_favorites', 'Add to Favorites', '', '0', '', 'active'),
('en', 'frontEnd', '1', 'no_favorite', 'You don\'t have any Favorites.', '', '0', '', 'active'),
('en', 'frontEnd', '1', 'remove_from_favorites', 'Undo Favorite', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'save_search', 'Add an Alert', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'notice_operation_inhibit', 'Please create an account to sign in and use the option.', '', '0', '', 'active'),
('en', 'frontEnd', '1', 'save_search_confirm', 'Are you sure you want to add an alert?', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'criteria', 'Criteria', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'check_search', 'Check Alert', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'no_saved_search', 'You haven\'t yet added any alerts.', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'notice_remove_search', 'Are you sure you want to delete the alert?', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'mass_actions', 'Bulk Action:', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'notice_items_activated', 'You\'ve successfully enabled the items.', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'notice_items_deactivated', 'You\'ve successfully disabled the items.', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'search_already_saved', 'You\'ve already added the alert.', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'regular', 'Regular', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'send_message', 'Send Message', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'for', 'for', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'contact_sent', 'Thank you for contacting us; we\'ll get back to you shortly.', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'play', 'Play', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'pause', 'Pause', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'empty_search_disallow', 'Please select search criteria in the form and do a search to add an alert.', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'notice_payment_canceled', 'Your payment has been canceled, please contact the Administrator for getting details.', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'account_info', 'Account Details', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'alphabetic_search', 'Alphabetic Search', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'expiration_date', 'Exp. Date', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'contact_phone', 'Phone', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'tmp_category_info', 'Click [here] to add a subcategory to the {category} category.', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'tmp_category_exists', 'The <b>{category}</b> category already exists.', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'free_package_purchase_notice', 'You\'ve successfully signed up for the free package.', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'duplicate_package_purchase_error', 'You\'ve already purchased the plan, please either renew it or select another plan.', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'set_new_password_hint', 'Please enter and confirm the new password.', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'account_confirmed_auto_login', 'Your account was successfully confirmed and you logged in.', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'remind_password_request_sent', 'The instruction for resetting password has been sent to your email address; follow it to reset your password.', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'plan_limit_using_hack', 'HACK DETECTED: You are not allowed to use the packages, please choose another package.', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'error_payment_gateway_fail', 'The payment gateway has failed, please try another gateway.', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'back_to_category', 'Back to {name}', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'browse_category_locked', 'The category is locked by the Administrator, please click [here] to go back to the previous category level.', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'title_page_part', ' | Page {page}', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'listing_type_no_categories', 'There are no categories.', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'noscript_show_email', 'Please enable Javascript to see the email address.', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'account_edit_email_confirmed', 'You\'ve successfully submitted a request for \"Email Change\".', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'account_edit_email_confirmation_fail', 'The activation link has already been used or is no longer active.', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'account_edit_email_confirmation_info', 'A confirmation link has been sent to your new email address: <b>[e-mail]</b>.', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'account_edit_email_confirmation_notice', 'Please confirm the change of your email address by email.', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'list_view', 'List View', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'grid_in_category', 'in {category}', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'gallery_view', 'Gallery View', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'subscribe_rss', 'Subscribe to RSS-feed', '', '0', '', 'active'),
('en', 'email_tpl', '0', 'email_templates+subject+account_created_active', 'Your account created at {site_name}', '', '0', '', 'active'),
('en', 'email_tpl', '0', 'email_templates+subject+account_activated', 'Your account activated', '', '0', '', 'active'),
('en', 'email_tpl', '0', 'email_templates+body+account_activated', 'Hello {name},\r\n\r\nYour account at {site_name} has been activated and you may log into {site_name} using your logins.\r\n\r\n{site_url}', '', '0', '', 'active'),
('en', 'email_tpl', '0', 'email_templates+body+account_created_active', 'Hello {name},\r\n\r\nThank you for registering at {site_name}!\r\nYour account has been activated; you may log into your {account_area} using the details below:\r\n\r\nUsername: {login}\r\nPassword: {password}\r\n\r\n{plan_info}', '', '0', '', 'active'),
('en', 'email_tpl', '0', 'email_templates+subject+account_created_pending', 'A new account created at {site_name}', '', '0', '', 'active'),
('en', 'email_tpl', '0', 'email_templates+subject+account_created_incomplete', 'Account confirmation at {site_name}', '', '0', '', 'active'),
('en', 'email_tpl', '0', 'email_templates+body+account_created_incomplete', 'Hello {name},\r\n\r\nThank you for registering at {site_name}!\r\n\r\n{plan_info}\r\n\r\nYour account has been created and is awaiting approval. Please, follow a confirmation link below to verify your email.\r\n\r\n{activation_link}', '', '0', '', 'active'),
('en', 'email_tpl', '0', 'email_templates+subject+new_password_created', 'New password to {site_name}', '', '0', '', 'active'),
('en', 'email_tpl', '0', 'email_templates+body+new_password_created', 'Hello {name},\r\n\r\nYou have successfully reset your password to the account.\r\nYou may [log in] using your new password below:\r\n\r\nUsername: {login}\r\nNew password: {password}', '', '0', '', 'active'),
('en', 'email_tpl', '0', 'email_templates+body+payment_accepted', 'Hello {name},\r\n\r\nYour payment has been successfully accepted.\r\n\r\nPayment details:\r\n\r\nGateway: {gateway}\r\nTransaction ID: {txn}\r\nItem: {item}\r\nPrice: {price}\r\nDate: {date}', '', '0', '', 'active'),
('en', 'email_tpl', '0', 'email_templates+subject+payment_accepted', 'Your payment has gone through at {site_name}', '', '0', '', 'active'),
('en', 'email_tpl', '0', 'email_templates+subject+tell_friend', 'A friend of yours invited you to {site_name}', '', '0', '', 'active'),
('en', 'email_tpl', '0', 'email_templates+subject+contact_us', 'A message from {name}', '', '0', '', 'active'),
('en', 'email_tpl', '0', 'email_templates+body+contact_us', 'Hello Administrator,\r\n\r\nYou\'ve got a new message from a visitor:\r\n\r\nName: {name}\r\nMessage: {message}', '', '0', '', 'active'),
('en', 'email_tpl', '0', 'email_templates+subject+account_deactivated', 'Your account suspended at {site_name}', '', '0', '', 'active'),
('en', 'email_tpl', '0', 'email_templates+body+account_deactivated', 'Hello {name},\r\n\r\nYour account at {site_name} has been suspended.\r\n\r\nYou may email the Administrator to {site_email} for more details.', '', '0', '', 'active'),
('en', 'email_tpl', '0', 'email_templates+subject+account_deleted', 'Your account deleted at {site_name}', '', '0', '', 'active'),
('en', 'email_tpl', '0', 'email_templates+body+account_deleted', 'Hello {name},\r\n\r\nYour account at {site_name} has been deleted.\r\n\r\nReason: {reason}\r\n\r\nYou may email the Administrator to {site_email} for more details.', '', '0', '', 'active'),
('en', 'email_tpl', '0', 'email_templates+subject+custom_category_added_user', 'Your custom subcategory at {site_name}', '', '0', '', 'active'),
('en', 'email_tpl', '0', 'email_templates+body+custom_category_added_user', 'Hello {name},\r\n\r\nWe\'ve got your request for adding the <strong>{category_name}</strong> subcategory. We\'ll review it shortly and if it is needed we\'ll enable it on the site.\r\n', '', '0', '', 'active'),
('en', 'email_tpl', '0', 'email_templates+subject+custom_category_added_admin', 'A new subcategory added at {site_name}', '', '0', '', 'active'),
('en', 'email_tpl', '0', 'email_templates+body+custom_category_added_admin', 'Hello Administrator,\r\n\r\nA new subcategory: <strong>{category_name}</strong> has been added by a user and is awaiting your approval.\r\nPlease go to <strong>Subcategories by Users</strong> to either approve or deny the new subcategory.\r\n', '', '0', '', 'active'),
('en', 'email_tpl', '0', 'email_templates+subject+custom_category_deleted', 'Your custom subcategory rejected at {site_name}', '', '0', '', 'active'),
('en', 'email_tpl', '0', 'email_templates+subject+custom_category_activated', 'You custom subcategory approved at {site_name}', '', '0', '', 'active'),
('en', 'email_tpl', '0', 'email_templates+body+free_package_purchased', 'Hello {name},\r\n\r\nYou\'ve successfully signed up for the <strong>{plan_name}</strong> package.Click [here] to get started.\r\n', '', '0', '', 'active'),
('en', 'email_tpl', '0', 'email_templates+subject+free_package_purchased', 'You signed up for free package at {site_name}', '', '0', '', 'active'),
('en', 'email_tpl', '0', 'email_templates+body+remind_password_request', 'Hello {name},\r\n\r\nWe\'ve received a request for resetting password to your account at {site_name}.\r\nIf it were you who sent it, please follow the link to reset the password:\r\n\r\n{link}\r\n\r\nIf you didn\'t send the request for password change then disregard the email.\r\n', '', '0', '', 'active'),
('en', 'email_tpl', '0', 'email_templates+subject+remind_password_request', 'Request for password change at {site_name}', '', '0', '', 'active'),
('en', 'email_tpl', '0', 'email_templates+body+contact_owner', 'Hello {owner_name},\r\n\r\nYou\'ve got a message from {visitor_name} at {site_name}.{if listing_page}\r\n\r\nSubject: {listing_link}{/if}\r\n\r\n{message}\r\n\r\nContact phone: {contact_phone}\r\n', '', '0', '', 'active'),
('en', 'email_tpl', '0', 'email_templates+subject+contact_owner', 'A new message from {visitor_name} at {site_name}', '', '0', '', 'active'),
('en', 'email_tpl', '0', 'email_templates+subject+account_created_admin', 'A new account created at {site_name}', '', '0', '', 'active'),
('en', 'email_tpl', '0', 'email_templates+body+account_created_admin', 'Hello Administrator,\r\n\r\nA new account has been created at {site_name}.\r\n\r\n<strong><u>Account Details:</u></strong>\r\nFirst name: <strong>{first_name}</strong>,\r\nLast name: <strong>{last_name}</strong>,\r\nUsername: <strong>{username}</strong>\r\nRegistration date: <strong>{join_date}</strong>\r\nStatus: <strong>{status}</strong>\r\n{plan_info}\r\n\r\nYou can view details of the new account at the link below:\r\n\r\n{details_link}\r\n\r\n{if activation is enabled}\r\nPlease follow the link to review and activate the account:\r\n{activation_link}\r\n{/if}\r\n', '', '0', '', 'active'),
('en', 'email_tpl', '0', 'email_templates+body+account_edit_email', 'Hello {name},\r\n\r\nYou\'ve requested an email change. To change the email associated with your account you need to verify a new email by following the link below:\r\n\r\n{activation_link}\r\n', '', '0', '', 'active'),
('en', 'email_tpl', '0', 'email_templates+subject+account_edit_email', 'Email change verification at {site_name}', '', '0', '', 'active'),
('en', 'email_tpl', '0', 'email_templates+subject+account_confirmed_active', 'Your account activated at {site_name}', '', '0', '', 'active'),
('en', 'email_tpl', '0', 'email_templates+body+account_confirmed_active', 'Hello {name},\r\n\r\nYour account was verified and activated by the system. \r\nYou may log into your {account_area} using the login details below: \r\n\r\nUsername: {login}\r\nPassword: {password}\r\n', '', '0', '', 'active'),
('en', 'email_tpl', '0', 'email_templates+subject+account_confirmed_pending', 'Your account pending approval at {site_name}', '', '0', '', 'active'),
('en', 'email_tpl', '0', 'email_templates+body+account_confirmed_pending', 'Hello {name},\r\n\r\nYour account has been verified and pending to be reviewed and approved by the Administrator.\r\nOnce your account is approved you will be able to log into your {account_area} using the login details below:\r\n\r\nUsername: {login}\r\nPassword: {password}\r\n', '', '0', '', 'active'),
('en', 'email_tpl', '0', 'email_templates+body+account_created_pending', 'Hello {name},\r\n\r\nThank you for registering an account at {site_name}!\r\n\r\nYour account is pending to be reviewed and approved by the Administrator.\r\n\r\nWe will let you know once your account is activated and you will be able to log into the\r\n{account_area} using the following login details:\r\n\r\nusername: {login}\r\npassword: {password}\r\n{plan_info}\r\n', '', '0', '', 'active'),
('en', 'email_tpl', '0', 'email_templates+subject+contact_owner_user', 'A new message from {visitor_name} at {site_name}', '', '0', '', 'active'),
('en', 'email_tpl', '0', 'email_templates+body+contact_owner_user', 'Hello {owner_name},\r\n\r\n{visitor_name} at {site_name} has sent you a message.{if listing_page}\r\n\r\nSubject: {listing_link}{/if}\r\n\r\n{message}\r\n\r\nYou may follow the link below to reply to the message:\r\n{reply_link}\r\n', '', '0', '', 'active'),
('en', 'email_tpl', '0', 'email_templates+subject+contact_owner_admin', 'A message from Administrator at {site_name}', '', '0', '', 'active'),
('en', 'email_tpl', '0', 'email_templates+body+contact_owner_admin', 'Hello {owner_name},\r\n\r\nThe Administrator from {site_name} has sent you a message:\r\n\r\n{message}\r\n\r\nYou may reply to the message at the link below:\r\n\r\n{reply_link}\r\n', '', '0', '', 'active'),
('en', 'email_tpl', '0', 'email_templates+subject+quick_account_created', 'Your account created automatically at {site_name}', '', '0', '', 'active'),
('en', 'email_tpl', '0', 'email_templates+subject+cron_featured_status_pre_expired2', 'Your featured package will expire at {site_name}', '', '0', '', 'active'),
('en', 'admin', '0', 'enable_conversion', 'Enable Conversion', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_conversion_rate', 'Rate', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'notice_logged_in', 'You\'ve successfully logged in.', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_renew', 'Renew', '', '0', '', 'active'),
('en', 'admin', '0', 'hide_empty_cats', 'Hide empty categories', '', '0', '', 'active'),
('en', 'admin', '0', 'flynax_connect_forbidden', 'Flynax License problem identified, please contact Flynax Helpdesk.', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'card_holder_name', 'Name on Card', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'card_number', 'Card Number', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'card_expiration', 'Expiration Date', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'card_verification_code', 'CVC', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'month', 'Month', '', '0', '', 'active'),
('en', 'common', '0', 'gallery', 'Gallery', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'year', 'Year', '', '0', '', 'active'),
('en', 'admin', '0', 'lt_links_full', 'Full URL', '', '0', '', 'active'),
('en', 'admin', '0', 'lt_links_short', 'Short URL', '', '0', '', 'active'),
('en', 'admin', '0', 'lt_links_subdomain', 'On subdomain', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'thumbnail_removed', 'You\'ve successfully removed the thumbnail.', '', '0', '', 'active'),
('en', 'common', '0', 'account_type_since_data', '{account_type} since {date}', '', '0', '', 'active'),
('en', 'admin', '0', 'add_listing_page_hint', 'Click [here] to edit the page.', '', '0', '', 'active'),
('en', 'common', '1', 'no_browser_gps_support', 'Your browser doesn\'t support the Geolocation option.', '', '0', '', 'active'),
('en', 'common', '1', 'gps_support_denied', 'Please enable Geolocation detection in your browser settings.', '', '0', '', 'active'),
('en', 'common', '0', 'website_visitor', 'Website Visitor', '', '0', '', 'active'),
('en', 'common', '0', 'account_type_details', '{account_type} Details', '', '0', '', 'active'),
('en', 'admin', '0', 'number_format', 'Number format', '', '0', '', 'active'),
('en', 'admin', '0', 'number_format_hint', 'Enables number format using decimal point and/or thousands separator.', '', '0', '', 'active'),
('en', 'admin', '0', 'thousands_separator', 'Thousandths separator', '', '0', '', 'active'),
('en', 'admin', '0', 'thousands_separator_hint', 'Default separator character - \",\"', '', '0', '', 'active'),
('en', 'common', '0', 'profile_lang', 'Preferred language', '', '0', '', 'active'),
('en', 'admin', '0', 'config+name+smtp_method', 'SMTP secure protocol', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'notice_mixed_df_empty', 'Please select a data entry or add your own values.', '', '0', '', 'active'),
('en', 'admin', '0', 'at_key_incorrect', 'You\'re not allowed to add an account type with the key that starts with at_.', '', '0', '', 'active'),
('en', 'admin', '0', 'config+name+price_tag_field', 'Primary price field', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'account_meta_description', 'Account meta description', 'account_types', '0', '', 'active'),
('en', 'admin', '0', 'config+name+header_banner_space', 'Banner space in header', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+facebook_page', 'Your Facebook account URL', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+twitter_page', 'Your Twitter account URL', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+account_login_mode', 'Users sign in with', 'settings', '0', '', 'active'),
('en', 'admin', '1', 'ext_notice_removing_current_admin', 'You are about to remove the admin account you are logged in with, please note you will be logged out of the admin panel.', '', '0', '', 'active'),
('en', 'common', '0', 'renew_package', 'Renew Package', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'video_file', 'Video File', '', '0', '', 'active'),
('en', 'common', '0', 'not_image_file', 'Please consider uploading the following image file formats: gif, jpg, png etc.', '', '0', '', 'active'),
('en', 'common', '0', 'no_account_location', 'User location data are unavailable.', '', '0', '', 'active'),
('en', 'common', '0', 'transaction_info', 'Transaction Details', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'expand_map', 'Expand Map', '', '0', '', 'active'),
('en', 'box', '0', 'blocks+name+account_alphabetic_filter', 'Alphabetic Search', 'account_alphabetic_filter', '0', '', 'active'),
('en', 'box', '0', 'blocks+name+my_profile_sidebar', 'My Profile Sidebar', 'my_profile_sidebar', '0', '', 'active'),
('en', 'frontEnd', '0', 'regarding_short', 'Re', '', '0', '', 'active'),
('en', 'common', '0', 'myads_box_pattern', 'Search in My {type}', '', '0', '', 'active'),
('en', 'common', '0', 'sf_active_till_ndays', 'Expired in %d day', '', '0', '', 'active'),
('en', 'common', '0', 'sf_active_till_nweeks', 'Expired in %d week', '', '0', '', 'active'),
('en', 'common', '0', 'sf_active_till_nmonths', 'Expired in %d month', '', '0', '', 'active'),
('en', 'common', '0', 'listing_fields+name+sf_status', 'Status', '', '0', '', 'active'),
('en', 'common', '0', 'listing_fields+name+sf_active_till', 'Active till', '', '0', '', 'active'),
('en', 'common', '0', 'listing_fields+name+sf_plan', 'Plan', '', '0', '', 'active'),
('en', 'common', '0', 'listing_fields+name+sf_featured', 'Featured', '', '0', '', 'active'),
('en', 'common', '1', 'nothing_found_for_char', 'Nothing found for <b>\"{char}\"</b>', '', '0', '', 'active'),
('en', 'admin', '0', 'search_installed', 'Search in installed', '', '0', '', 'active'),
('en', 'admin', '0', 'more_plugins', 'All Plugins', '', '0', '', 'active'),
('en', 'common', '0', 'notice_incorrect_auth_email', 'Email or password is incorrect.', '', '0', '', 'active'),
('en', 'admin', '0', 'cron_not_configured', 'Cron is not set up or hasn\'t been run yet; you may find an instruction <a target=\"_blank\" href=\"http://forum.flynax.com/showthread.php?3-Cron-Jobs-setup\">here</a>', '', '0', '', 'active'),
('en', 'admin', '0', 'admin_controllers+name+payment_gateways', 'Payment Gateways', '', '0', '', 'active'),
('en', 'admin', '0', 'admin_controllers+name+subscriptions', 'Recurring Stats', '', '0', '', 'active'),
('en', 'admin', '0', 'admin_controllers+name+finances', 'Monetization', '', '0', '', 'active'),
('en', 'admin', '0', 'gateway_type_online', 'Online', '', '0', '', 'active'),
('en', 'admin', '0', 'gateway_type_offline', 'Offline', '', '0', '', 'active'),
('en', 'admin', '0', 'edit_gateway', 'Set up gateway', '', '0', '', 'active'),
('en', 'admin', '0', 'payment_gateway_edited', 'Gateway has been successfully set up.', '', '0', '', 'active'),
('en', 'admin', '0', 'subscription_enable', 'Recurring', '', '0', '', 'active'),
('en', 'admin', '0', 'subscription_list', 'All Subscriptions', '', '0', '', 'active'),
('en', 'admin', '0', 'subscribers_by_plan', '{count} users subscribed for the plan. Disabling the subscription option for the plan won\'t affect current users; the system will continue to charge them until their subscriptions expire or until they choose to unsubscribe.', '', '0', '', 'active'),
('en', 'admin', '0', 'see_all_subscribers', 'View all subscribers', '', '0', '', 'active'),
('en', 'admin', '0', 'subscription_period_total_hint', 'Sets a number of periods indicating subscription duration; the option is available for PayPal only.', '', '0', '', 'active'),
('en', 'common', '0', 'subscription', 'Recurring', '', '0', '', 'active'),
('en', 'common', '0', 'payment_gateways+name+paypal', 'Paypal', '', '0', '', 'active'),
('en', 'common', '0', 'payment_gateways+name+2co', '2Checkout', '', '0', '', 'active'),
('en', 'common', '0', 'paid', 'Paid', '', '0', '', 'active'),
('en', 'common', '0', 'unpaid', 'Unpaid', '', '0', '', 'active'),
('en', 'common', '0', 'payment_completed', 'Your payment has been successfully accepted.', '', '0', '', 'active'),
('en', 'common', '0', 'payment_canceled', 'Your payment has been canceled.', '', '0', '', 'active'),
('en', 'common', '0', 'recurring', 'Recurring', '', '0', '', 'active'),
('en', 'common', '0', 'credit_card_details', 'Credit Card Details', '', '0', '', 'active'),
('en', 'common', '0', 'billing_details', 'Billing Details', '', '0', '', 'active'),
('en', 'common', '0', 'use_account_info', 'Use account info for billing purposes', '', '0', '', 'active'),
('en', 'common', '0', 'unsubscription', 'Unsubscribe', '', '0', '', 'active'),
('en', 'common', '0', 'cancel_subscription_success', 'The subscription has been successfully canceled.', '', '0', '', 'active'),
('en', 'common', '1', 'canceled', 'Canceled', '', '0', '', 'active'),
('en', 'common', '0', 'subscription_details', 'Subscription details', '', '0', '', 'active'),
('en', 'common', '0', 'service', 'Service', '', '0', '', 'active'),
('en', 'common', '0', 'subscription_count', '# of recurring periods', '', '0', '', 'active'),
('en', 'common', '0', 'continue', 'Continue', '', '0', '', 'active'),
('en', 'common', '0', 'subscription_period', 'Period', '', '0', '', 'active'),
('en', 'common', '0', 'subscription_period_day', 'Day', '', '0', '', 'active'),
('en', 'common', '0', 'subscription_period_week', 'Week', '', '0', '', 'active'),
('en', 'common', '0', 'subscription_period_month', 'Month', '', '0', '', 'active'),
('en', 'common', '0', 'subscription_period_year', 'Year', '', '0', '', 'active'),
('en', 'common', '0', 'subscription_period_total', 'Number of periods', '', '0', '', 'active'),
('en', 'common', '0', 'subscription_id', 'Subscription ID', '', '0', '', 'active'),
('en', 'common', '0', 'subscribe', 'Subscribe', '', '0', '', 'active'),
('en', 'common', '0', 'no_payment_gateways', 'There are no available gateways; please contact the Administrator.', '', '0', '', 'active'),
('en', 'common', '0', 'required_payment_option_error', 'The {option} payment parameter is missing; please contact the Administrator.', '', '0', '', 'active'),
('en', 'common', '0', 'payment_option_service', 'Service', '', '0', '', 'active'),
('en', 'common', '0', 'payment_option_total', 'Price', '', '0', '', 'active'),
('en', 'common', '0', 'payment_option_item_id', 'Item', '', '0', '', 'active'),
('en', 'common', '0', 'payment_option_account_id', 'Account', '', '0', '', 'active'),
('en', 'common', '0', 'gateway_not_configured', 'The {gateway} gateway is not yet set up; please contact the Administrator.', '', '0', '', 'active'),
('en', 'common', '0', 'not_available_payment_gateways', 'No payment gateway is yet set up, please contact the Administrator.', '', '0', '', 'active'),
('en', 'common', '0', 'order_details', 'Order details', '', '0', '', 'active'),
('en', 'common', '0', 'dp_months_list', 'January,February,March,April,May,June,July,August,September,October,November,December', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_service', 'Service', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_recurring', 'Recurring', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_plugin', 'Plugin', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_payment_gateways_manager', 'Gateway Manager', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_paid', 'Paid', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_unpaid', 'Unpaid', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_subscription', 'Recurring', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_subscription_manager', 'Subscription Manager', '', '0', '', 'active'),
('en', 'admin', '0', 'base_unit', 'base', '', '0', '', 'active'),
('en', 'admin', '0', 'lt_subdomain_denied', 'You cannot enable \"Locations on Subdomains\" because subdomains are already enabled for locations.', '', '0', '', 'active'),
('en', 'admin', '0', 'h1_heading', 'Heading (H1)', '', '0', '', 'active'),
('en', 'common', '0', 'any_field_value', 'Any {field}', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'menu', 'Menu', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'plan_option_using_limit_hint', 'You\'ve exceeded the usage limit for the option, please select another option or plan.', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'view_larger', 'View Larger', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'plugins_changelog_denied', 'You don\'t have access to plugin changelogs.', '', '0', '', 'active'),
('en', 'common', '0', 'stripe_unsubscripbe_confirmation', 'Do you want to cancel the subscription?', '', '0', '', 'active'),
('en', 'common', '0', 'not_selected', 'Not Selected', '', '0', '', 'active'),
('en', 'admin', '0', 'plugin_update_denied', 'The plugin is not available to your site; please click the Buy button to purchase the plugin.', '', '0', '', 'active'),
('en', 'common', '0', 'email_site_name', '{advanced_site_name}', '', '0', '', 'active'),
('en', 'admin', '0', 'config+name+category_alphabet_box', 'Alphabetic box for categories on Home page', 'settings', '0', '', 'active'),
('en', 'common', '0', 'upgrade_profile', 'Your membership plan has expired; please follow the [link] to renew the plan or buy a new one.', '', '0', '', 'active'),
('en', 'admin', '0', 'config+name+cache_method', 'Caching method', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+cache_divided', 'Divide cache into fragments', 'settings', '0', '', 'active'),
('en', 'common', '0', 'youtube_check_failed', 'The video is not available.', '', '0', '', 'active'),
('en', 'admin', '0', 'cache_method', 'Cache method', '', '0', '', 'active'),
('en', 'admin', '0', 'cache_method_denied', 'The caching method you\'ve selected is not supported by your server.', '', '0', '', 'active'),
('en', 'admin', '0', 'config+name+home_page_h1', 'H1 on Home page', 'settings', '0', '', 'active'),
('en', 'common', '0', 'notice_field_not_valid', '{field} is not valid', '', '0', '', 'active'),
('en', 'common', '0', 'contact_details', 'Contact Details', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'contact_details_hint', 'To see the contact details please', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'watch_video_hint', 'To watch the video please', '', '0', '', 'active'),
('en', 'admin', '0', 'config+name+price_separator', 'Cents separator', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+url_transliteration', 'URL transliteration', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+des+url_transliteration', 'When disabled it generates non-utf8 language URLs in Cyrillic, Arabic etc.', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'notice_smtp_ok', 'SMTP details were verified and found to be correct.', '', '0', '', 'active'),
('en', 'admin', '0', 'notice_smtp_failed', 'SMTP test failed, see log', '', '0', '', 'active'),
('en', 'admin', '0', 'smtp_error_log', 'SMTP error log', '', '0', '', 'active'),
('en', 'common', '0', 'listing_type_search_box_pattern', '{type} Search', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'notice_membership_plan_does_not_chose', 'Please select a <b>Membership Plan</b> below.', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'profile_upgrade_fail', 'The payment has been canceled.', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'ms_number_of_videos', 'Number of videos', '', '0', '', 'active'),
('en', 'admin', '0', 'config+name+membership_divider', 'Membership Settings', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+membership_module', 'Membership plans', 'settings', '0', '', 'active'),
('en', 'common', '0', 'profile_upgrade_success', 'Your profile has been successfully upgraded.', '', '0', '', 'active'),
('en', 'common', '0', 'purchase_membership_plan', 'Buy Plan', '', '0', '', 'active'),
('en', 'common', '0', 'membership_services', 'Plan Services', '', '0', '', 'active'),
('en', 'admin', '0', 'admin_controllers+name+membership_plans', 'Membership Plans', '', '0', '', 'active'),
('en', 'admin', '0', 'admin_controllers+name+membership_services', 'Membership Services', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_membership_services_manager', 'Service Manager', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_membership_plans_manager', 'Membership Plan Manager', '', '0', '', 'active'),
('en', 'admin', '0', 'contact_field', 'Fake value', '', '0', '', 'active');
INSERT INTO `{db_prefix}lang_keys` (`Code`, `Module`, `JS`, `Key`, `Value`, `Target_key`, `Modified`, `Plugin`, `Status`) VALUES
('en', 'admin', '0', 'contact_field_for_membership', 'Replaces a real field value with a fake one when access to the contact field is regulated by a membership plan.', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'account_membership', 'Membership', '', '0', '', 'active'),
('en', 'common', '0', 'change_plan', 'Change Package', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'notice_no_membership_plans_related', 'The Administrator hasn\'t yet assigned any membership plans to the account type, please contact the Administrator.', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'notice_no_membership_plans_selected', 'You haven\'t yet selected a plan; click the button to select a membership plan.', '', '0', '', 'active'),
('en', 'admin', '0', 'options', 'Options', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'fake_value', '{field} is hidden', '', '0', '', 'active'),
('en', 'admin', '0', 'locale_code', 'Locale code', '', '0', '', 'active'),
('en', 'admin', '0', 'locale_code_incorrect', 'Please make sure that the locale code is 5 characters long and complies with the format.', '', '0', '', 'active'),
('en', 'admin', '0', 'locale_code_hint', 'e.g. en_US, es_AR. More info <a href=\"https://en.wikipedia.org/wiki/Language_localisation#Language_tags_and_codes\">here</a>', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'proceed_checkout', 'Proceed to checkout', '', '0', '', 'active'),
('en', 'common', '0', 'membership', 'Membership Plan', '', '0', '', 'active'),
('en', 'box', '0', 'blocks+name+get_more_details', 'Get More Details', 'get_more_details', '0', '', 'active'),
('en', 'frontEnd', '1', 'count_more_pictures', '{count} pics<br />more', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'keyword_search_hint', 'I\'m looking for...', '', '0', '', 'active'),
('en', 'common', '0', 'more', 'More', '', '0', '', 'active'),
('en', 'admin', '0', 'h1_heading_restriction_note', 'H1 heading is disabled on the Home page, click the button to enable it.', '', '0', '', 'active'),
('en', 'email_tpl', '0', 'email_templates+subject+cron_membership_expired', 'Your membership plan at {site_name} expired', '', '0', '', 'active'),
('en', 'email_tpl', '0', 'email_templates+body+cron_membership_expired', 'Your membership plan expired at {site_name}\r\n\r\nHello {name},\r\n\r\nYour account at {site_name} has expired.\r\n\r\nPlease log into your account and renew it.', '', '0', '', 'active'),
('en', 'admin', '0', 'reg_settings', 'Registration Settings', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_uneditable', 'Uneditable; please go to the Account Manager to change the plan.', '', '0', '', 'active'),
('en', 'admin', '0', 'membership_type', 'Membership', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'contacts_not_available', 'The membership plan doesn\'t allow you to view contact details.', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'watch_video_not_available', 'The membership plan doesn\'t allow you to watch this video.', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'send_message_not_available', 'Please sign in and make sure your membership plan allows you to contact users.', '', '0', '', 'active'),
('en', 'admin', '0', 'select_plan_later', 'Select a plan later', '', '0', '', 'active'),
('en', 'admin', '0', 'need_select_account_type', 'Please select an account type above to see all available membership plans.', '', '0', '', 'active'),
('en', 'admin', '0', 'notice_delete_membership_plan', 'Are you sure you want to remove the plan irretrievably and disable all related accounts?', '', '0', '', 'active'),
('en', 'admin', '0', 'notice_drop_membership_plan', 'Are you sure you want to remove the selected plan and disable all related accounts?', '', '0', '', 'active'),
('en', 'email_tpl', '0', 'email_templates+subject+membership_plan_removed', 'Your account at {site_name} suspended', '', '0', '', 'active'),
('en', 'email_tpl', '0', 'email_templates+body+membership_plan_removed', 'Hello {name},\r\n\r\nYour account added to {site_name} has been suspended as the plan of your account was removed.\r\n\r\nThe reason for removing: {reason}\r\n\r\nYou may [contact] the Administrator for more details.', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'notice_has_active_membership_subscription', 'You already have a subscription for the membership plan. To purchase another plan; please cancel recurring payments for your current membership plan.', '', '0', '', 'active'),
('en', 'common', '0', 'services_list', 'Back to List', '', '0', '', 'active'),
('en', 'admin', '0', 'lt_links_subdomain_hint', 'Please make sure wildcard subdomains are enabled on your server.', '', '0', '', 'active'),
('en', 'common', '0', 'featured_off', 'Featured Off', '', '0', '', 'active'),
('en', 'common', '0', 'featured_on', 'Featured On', '', '0', '', 'active'),
('en', 'admin', '0', 'config+name+featured_accounts_in_box', 'Number of featured accounts in a box', 'settings', '0', '', 'active'),
('en', 'frontEnd', '0', 'fake_value_notice', 'please {link}', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'sing_in', 'sign in', '', '0', '', 'active'),
('en', 'admin', '0', 'add_membership_plan', 'Add a Plan', '', '0', '', 'active'),
('en', 'admin', '0', 'edit_membership_plan', 'Edit Plan', '', '0', '', 'active'),
('en', 'admin', '0', 'membership_plans_list', 'All Plans', '', '0', '', 'active'),
('en', 'admin', '0', 'membership_plan_live_for', 'Plan live for', '', '0', '', 'active'),
('en', 'admin', '0', 'membership_plan_live_for_hint', 'Enter 0 to make the plan active for an unlimited period.', '', '0', '', 'active'),
('en', 'admin', '0', 'subscription_box', 'Subscription', '', '0', '', 'active'),
('en', 'system', '0', 'plugin_denied', 'The plugin you are trying to update is not available to your license.<br />You should purchase the plugin if you want to use it.', '', '0', '', 'active'),
('en', 'admin', '0', 'cron_broken', 'Please check the cron configuration; it hasn\'t been run since {date}.', '', '0', '', 'active'),
('en', 'admin', '0', 'use_custom_phrases', 'Use custom field names for category levels', '', '0', '', 'active'),
('en', 'admin', '0', 'number_of_levels', 'Number of category levels', '', '0', '', 'active'),
('en', 'admin', '0', 'level_number', 'Level {number}', '', '0', '', 'active'),
('en', 'common', '0', 'subcategory', 'Subcategory', '', '0', '', 'active'),
('en', 'common', '0', 'message_from', 'Message from {name}', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'remember_me', 'Stay signed in', '', '0', '', 'active'),
('en', 'admin', '0', 'field_data_formats_hint', '[Manage data entry] that is linked to the field.', '', '0', '', 'active'),
('en', 'admin', '0', 'not_membership_plans', 'There are no membership plans; please click [here] to add a plan.', '', '0', '', 'active'),
('en', 'admin', '0', 'config+name+google_server_map_key', 'Google API key', 'settings', '0', '', 'active'),
('en', 'common', '0', 'show_in_category', 'Show in category', '', '0', '', 'active'),
('en', 'common', '0', 'form_type', 'Form type', '', '0', '', 'active'),
('en', 'admin', '0', 'notice_no_type_chose', 'Please select a type.', '', '0', '', 'active'),
('en', 'admin', '0', 'system_form', 'System Form', '', '0', '', 'active'),
('en', 'admin', '0', 'in_category_form', 'In a category', '', '0', '', 'active'),
('en', 'admin', '0', 'custom_form', 'Custom form', '', '0', '', 'active'),
('en', 'admin', '0', 'error_search_form_for_category_exists', 'The search form for the {name} category has already been added; click [here] to populate it with search fields.', '', '0', '', 'active'),
('en', 'admin', '0', 'google_map_keys_missing', 'The \"Google API key\" value is missing in Basic Settings. Please check <a target=\"_blank\" href=\"https://developers.google.com/maps/documentation/javascript/get-api-key\">Google API Keys</a>.', '', '0', '', 'active'),
('en', 'admin', '0', 'change_controller_notice', 'Warning: If you\'re not sure don\'t manage the system field!', '', '0', '', 'active'),
('en', 'admin', '0', 'config+name+remember_me', 'Allow users to stay signed in', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+des+cron_incompl_listings_notify_days', 'day(s)', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'with', 'with', '', '0', '', 'active'),
('en', 'admin', '0', 'notice_controller_no_files', 'The page controller is incorrect; please make sure all necessary controller files have been uploaded: ({inc_file} and {tpl_file}).', '', '0', '', 'active'),
('en', 'admin', '0', 'add_edit_page_tpl', '[page] page', '', '0', '', 'active'),
('en', 'admin', '0', 'add_amenity', 'Add an Amenity', '', '0', '', 'active'),
('en', 'admin', '0', 'config+name+amp_divider', 'User Location Mapping Settings', 'settings', '0', '', 'active');

/* Added in 4.5.2 */
INSERT INTO `{db_prefix}lang_keys` (`Code`, `Module`, `JS`, `Key`, `Value`, `Target_key`, `Modified`, `Plugin`, `Status`) VALUES
('en', 'common', '0', 'listing_package', 'Listing Package', '', '0', '', 'active'),
('en', 'admin', '0', 'info_account_type_mplans', 'Leave the field empty to make the plan available to all account types.', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'listing_removed', 'Your incomplete listing has been successfully removed.', '', '0', '', 'active'),
('en', 'admin', '0', 'searches_list', 'All Alerts', '', '0', '', 'active'),
('en', 'admin', '0', 'search_and_send', 'Search & Send', '', '0', '', 'active'),
('en', 'admin', '0', 'config+name+preffered_lang_redirect', 'Preferred language redirect', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'alphabetic_field', 'Alphabetic search priority field', '', '0', '', 'active'),
('en', 'admin', '0', 'alphabetic_field_desc', 'The first letter of the field value selected will be used in the alphabetic search for sellers. The list offers only required fields.', '', '0', '', 'active'),
('en', 'admin', '0', 'atype_quick_registration_option', 'Offer the account type to visitors on the Post an Ad page for quick sign-up.', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_build_sorting', 'Build Sorting Form', '', '0', '', 'active'),
('en', 'admin', '0', 'sorting_form_builder', 'Sorting Form Builder', '', '0', '', 'active'),
('en', 'admin', '0', 'build_sorting_form', 'Build Sorting Form of the {category} category', '', '0', '', 'active'),
('en', 'admin', '0', 'sorting_form', 'Sorting Form', '', '0', '', 'active'),
('en', 'admin', '0', 'geocode_request_limit_reached_notice', 'You\'ve exceeded the limit of Google Maps Geocoding requests; you may find an instruction <a target=\"_blank\" href=\"https://developers.google.com/maps/documentation/geocoding/usage-limits\">here</a>.', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_disallow_disable_lang', 'You must have at least one active language on the site.', '', '0', '', 'active'),
('en', 'admin', '0', 'limit_use_of_ms_plan', 'Limit use of plan', '', '0', '', 'active'),
('en', 'admin', '0', 'limit_use_of_ms_plan_hint', 'Enter 0 to enable unlimited use of the plan', '', '0', '', 'active'),
('en', 'admin', '0', 'config+des+flynax_news_number', 'Enter 0 to hide Flynax feeds in admin panel', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+thumbnails_x2', 'Enable 2x thumbnail upscale', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+des+thumbnails_x2', 'Offers sharper thumbnails in mobile view, but takes more server space.', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+accounts_checking', 'Checking for Accounts', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+cron_incomplete_account_days', 'Remove incomplete accounts in', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+des+cron_incomplete_account_days', 'day(s)', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+cron_incompl_accounts_notify_days', 'Send notifications about incomplete accounts in', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+des+cron_incompl_accounts_notify_days', 'day(s)', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+accounts_number', 'Number of accounts to be checked per task', 'settings', '0', '', 'active'),
('en', 'frontEnd', '0', 'remote_delete_account_removed', 'Your account has been successfully removed; thank you for using our site!', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'remote_delete_account_confirm', 'Are you sure you want to remove the account irretrievably?', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'account_removed', 'Your account has been successfully removed.', '', '0', '', 'active'),
('en', 'email_tpl', '0', 'email_templates+subject+cron_incomplete_account', 'Re: your incomplete account at {site_name}', '', '0', '', 'active'),
('en', 'email_tpl', '0', 'email_templates+body+cron_incomplete_account', 'Hello {name},\r\n\r\nChecking our records for new user accounts we found that you haven\'t finished adding your account.\r\n\r\nIf you were unable to complete your account for some reason, you can do it within <b>{number_days}</b> days, otherwise it will be removed if no action is taken.\r\n\r\nPlease follow the link below to complete your account and enjoy the opportunities that our site offers you:\r\n{complete_link}\r\n\r\nIf you are no longer interested in completing the account you may remove it at the link below:\r\n{delete_link}\r\n\r\n______________\r\nThank you,\r\n{site_name}', '', '0', '', 'active');

/* Added in 4.6.0 */
INSERT INTO `{db_prefix}lang_keys` (`Code`, `Module`, `JS`, `Key`, `Value`, `Target_key`, `Modified`, `Plugin`, `Status`) VALUES
('en', 'common', '0', 'add_video_link', 'Add a YouTube Link', '', '0', '', 'active'),
('en', 'common', '0', 'error_wrong_file_type', 'The {ext} file type is incompatible, please consider using {types}.', '', '0', '', 'active'),
('en', 'common', '0', 'no_photo_uploaded', 'Please upload a picture to continue.', '', '0', '', 'active'),
('en', 'common', '0', 'drag_drop_or_browse_file', '<span>Drag & Drop Files Here or </span><mark>Browse Media</mark>', '', '0', '', 'active'),
('en', 'admin', '0', 'config+name+add_listing_single_step', 'Posting ads in one step', 'settings', '0', '', 'active'),
('en', 'common', '0', 'single_step_select_plan', 'Please select a Plan at the top of the form to Upload the Media.', '', '0', '', 'active'),
('en', 'common', '0', 'error_listing_type_picture_restricted', 'The listing type of the category doesn\'t allow you to add pictures to listings.', '', '0', '', 'active'),
('en', 'common', '0', 'error_listing_type_video_restricted', 'The listing type of the category doesn\'t allow you to add video to listings.', '', '0', '', 'active'),
('en', 'common', '0', 'view_plans_chart', 'View Plans Chart', '', '0', '', 'active'),
('en', 'common', '1', 'delete_file', 'Delete File', '', '0', '', 'active'),
('en', 'common', '0', 'add_media', 'Add Media', '', '0', '', 'active'),
('en', 'common', '0', 'error', 'Error', '', '0', '', 'active'),
('en', 'common', '0', 'unlimited_pictures', 'Unlimited Pictures', '', '0', '', 'active'),
('en', 'common', '0', 'unlimited_videos', 'Unlimited Videos', '', '0', '', 'active'),
('en', 'admin', '0', 'account_type_disabling_warning', 'The type is given by default to visitors posting ads without signing up. To remove or disable it, please enable the option for another type and try again.', '', '0', '', 'active'),
('en', 'admin', '0', 'config+name+one_my_listings_page', 'User listings on one page', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+des+one_my_listings_page', 'Shows user ads of different types on one page in account area under My Listings.', 'settings', '0', '', 'active'),
('en', 'frontEnd', '0', 'any_of_listing_type', '- Any Listing Type -', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'search_form_empty', 'The admin hasn\'t yet populated the search form with fields, please contact the admin.', '', '0', '', 'active'),
('en', 'common', '0', 'pages+name+my_all_ads', 'My Listings', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'pages+title+my_all_ads', 'My Listings', '', '0', '', 'active'),
('en', 'box', '0', 'blocks+name+search_in_my_ads', 'Search in My Listings', 'search_in_my_ads', '0', '', 'active'),
('en', 'common', '0', 'stick_category', 'Stick Category', '', '0', '', 'active'),
('en', 'admin', '0', 'config+name+default_grid_in_tab', 'Default listing grid view', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+des+default_grid_in_tab', 'Sets default grid view for listings on pages unless overridden by user selection.', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'notice_account_type_deactivated', 'The account type with all its user accounts and listings has been successfully disabled.', '', '0', '', 'active'),
('en', 'admin', '0', 'confirm_deactivate_account_type', 'Disabling the account type will disable all the active user accounts and listings that were added under it; are you sure you want to proceed?', '', '0', '', 'active'),
('en', 'common', '0', 'integrated_banner', 'Banner In Grid', '', '0', '', 'active'),
('en', 'admin', '0', 'config+name+banner_in_grid_position', 'Banner space after every', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+des+banner_in_grid_position', 'listing(s) but not last', 'settings', '0', '', 'active'),
('en', 'frontEnd', '0', 'banner_in_grid_phrase', 'Banner Space', '', '0', '', 'active'),
('en', 'common', '0', 'billing_country', 'Country', '', '0', '', 'active'),
('en', 'common', '0', 'billing_state', 'State', '', '0', '', 'active'),
('en', 'common', '0', 'billing_city', 'City', '', '0', '', 'active'),
('en', 'common', '0', 'billing_zip', 'Postal Code', '', '0', '', 'active'),
('en', 'common', '0', 'billing_address', 'Address', '', '0', '', 'active'),
('en', 'admin', '1', 'plugin_not_compatible', 'Incompatible', '', '0', '', 'active'),
('en', 'system', '0', 'plugin_not_compatible_notice', 'The Plugin is incompatible with the current version. You\'ll need to update your site.', '', '0', '', 'active'),
('en', 'admin', '0', 'plugin_have_not_compatible_update', 'The <b>{plugin}</b> plugin has been updated to <b>{plugin_version}</b>, and is no longer compatible with the version of your software. To use the Plugin you will need to update your site to <b>{software_version}</b> and later.', '', '0', '', 'active'),
('en', 'admin', '0', 'grant_plan_fill_username', 'Enter username first', '', '0', '', 'active'),
('en', 'admin', '0', 'mp_not_selected_package', 'Please select a listing package.', '', '0', '', 'active'),
('en', 'admin', '0', 'config+name+messages_notification_in_chat', 'Email users about new messages sent via chat', 'settings', '0', '', 'active'),
('en', 'common', '0', 'standard_stat_label', 'Standard left', '', '0', '', 'active'),
('en', 'common', '0', 'featured_stat_label', 'Featured left', '', '0', '', 'active'),
('en', 'admin', '0', 'prevent_disabling_lt_page', 'You can disable the [listing type], but you cannot disable the system page of the listing type only.', '', '0', '', 'active');

/* Added in 4.6.1 */
INSERT INTO `{db_prefix}lang_keys` (`Code`, `Module`, `JS`, `Key`, `Value`, `Target_key`, `Modified`, `Plugin`, `Status`) VALUES
('en', 'frontEnd', '0', 'edit_listing_wrong_owner', 'Unfortunately, you don\'t have permission to view the page.', '', '0', '', 'active'),
('en', 'common', '0', 'upgrade_plan', 'Renew/Upgrade Package', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'save_search_hint', 'Add an alert and get emails about new listings matching your search criteria.', '', '0', '', 'active');

/* Added in 4.6.2 */
INSERT INTO `{db_prefix}lang_keys` (`Code`, `Module`, `JS`, `Key`, `Value`, `Target_key`, `Modified`, `Plugin`, `Status`) VALUES
('en', 'admin', '0', 'thumb_width_desc', 'Select in the range of 100 to 260 pixels.', '', '0', '', 'active'),
('en', 'admin', '0', 'thumb_height_desc', 'Select in the range of 100 to 260 pixels.', '', '0', '', 'active'),
('en', 'admin', '0', 'rebuild_avatars_promt', 'Thumbnail dimensions have been changed. Do you want to resize all thumbnails now?', '', '0', '', 'active');

/* Added in 4.7.0 */
INSERT INTO `{db_prefix}lang_keys` (`Code`, `Module`, `JS`, `Key`, `Value`, `Target_key`, `Modified`, `Plugin`, `Status`) VALUES
('en', 'admin', '0', 'notice_php_need_update', 'The PHP version installed on your server is outdated! Please update it to <b>{min_version}</b> or later.', '', '0', '', 'active'),
('en', 'common', '0', 'pages+name+listings', 'Recently Added', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'pages+title+listings', 'Recently Added {listing_type}', '', '0', '', 'active'),
('en', 'admin', '0', 'agreement_page', 'Agreement page', '', '0', '', 'active'),
('en', 'common', '0', 'color', 'Color', '', '0', '', 'active'),
('en', 'admin', '0', 'agreement_page_notice', 'You may select any existing page or [Add a new page].', '', '0', '', 'active'),
('en', 'admin', '0', 'agreement_atypes_hint', 'Leave the field empty to make it available to all account types.', '', '0', '', 'active'),
('en', 'admin', '0', 'agreement_first_step', 'Enable Agreement on 1st registration step', '', '0', '', 'active'),
('en', 'admin', '0', 'agreement_first_step_hint', 'If enabled the field will be hidden from the registration form builder.', '', '0', '', 'active'),
('en', 'common', '0', 'agree', 'I agree with ', '', '0', '', 'active'),
('en', 'admin', '0', 'config+name+map_provider', 'Service provider', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+map_static', 'Static maps', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+static_map_provider', 'Service provider', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+option+map_provider_yandex', 'Yandex.Maps', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+option+map_provider_google', 'Google Maps', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+option+map_provider_openstreetmap', 'OpenStreetMap', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+option+map_provider_alternative', 'Carto', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+option+static_map_provider_yandex', 'Yandex Static Maps', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+option+static_map_provider_google', 'Google Static Maps', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+geocoding', 'Geocoding', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+geocoding_provider', 'Service provider', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+option+geocoding_provider_arcgis', 'ArcGIS', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+option+geocoding_provider_nominatim', 'OpenStreetMap', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+option+geocoding_provider_google', 'Google Places', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+option+geocoding_provider_yandex', 'Yandex Geocoder', 'settings', '0', '', 'active'),
('en', 'common', '0', 'notice_field_not_accepted', 'You must read and agree with <b>{field}</b>.', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_accept_must_be_required', 'The option cannot be disabled for the Agreement field.', '', '0', '', 'active'),
('en', 'frontEnd', '1', 'account_remove_notice_pass', 'Your account will be terminated permanently including your profile data, listings and other settings; please enter your password to proceed with termination.', '', '0', '', 'active'),
('en', 'frontEnd', '1', 'account_remove_notice', 'Your account will be terminated permanently including your profile data, listings and other settings.', '', '0', '', 'active'),
('en', 'admin', '0', 'config+name+account_removing', 'Termination of user accounts', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+des+account_removing', 'Enables \"Remove Account\" button in user profiles allowing them to remove their accounts.', 'settings', '0', '', 'active'),
('en', 'frontEnd', '1', 'account_remove_in_process', 'The account removal is in process; please do not close the pop-up.', '', '0', '', 'active');

/* Added in 4.7.1 */
INSERT INTO `{db_prefix}lang_keys` (`Code`, `Module`, `JS`, `Key`, `Value`, `Target_key`, `Modified`, `Plugin`, `Status`) VALUES
('en', 'admin', '0', 'recommended_resolution', 'Recommended Resolution', '', '0', '', 'active'),
('en', 'admin', '0', 'admin_controllers+name+slides', 'Slides', '', '0', '', 'active'),
('en', 'common', '0', 'personal_address_length_error', 'The name of your individual page is too short; please enter 3 or more characters.', '', '0', '', 'active'),
('en', 'email_tpl', '0', 'email_templates+subject+smtp_configuration_success', 'SMTP set up and sending emails enabled', '', '0', '', 'active'),
('en', 'email_tpl', '0', 'email_templates+body+smtp_configuration_success', 'Congratulations! You\'ve configured SMTP correctly and now sending emails from your site works fine.', '', '0', '', 'active'),
('en', 'admin', '0', 'removing_english_notice', 'Before removing English, the source language, we recommend comparing and copying missing<br />phrases from English to the other language(s) in case there are untranslated phrases, so you could fix them later.<br />Do you want to copy the missing phrases?', '', '0', '', 'active'),
('en', 'admin', '0', 'remove_listing_type', 'Remove Listing Type', '', '0', '', 'active'),
('en', 'admin', '0', 'show_cents', 'Zero cents in prices', '', '0', '', 'active'),
('en', 'admin', '0', 'refresh_listing_pictures', 'Updating pictures in listings', '', '0', '', 'active'),
('en', 'admin', '0', 'refresh_account_pictures', 'Updating account thumbnails', '', '0', '', 'active'),
('en', 'admin', '0', 'config+name+img_account_crop_divider', 'Cropping of Pictures in Accounts', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+img_account_crop_thumbnail', 'Autocropping of account thumbnails', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+img_account_crop_interface', 'Cropping by users', 'settings', '0', '', 'active');

/* Added in 4.7.2 */
INSERT INTO `{db_prefix}lang_keys` (`Code`, `Module`, `JS`, `Key`, `Value`, `Target_key`, `Modified`, `Plugin`, `Status`) VALUES
('en', 'admin', '0', 'zoom_world', 'World', '', '0', '', 'active'),
('en', 'admin', '0', 'zoom_city', 'City', '', '0', '', 'active'),
('en', 'admin', '0', 'zoom_street', 'Street', '', '0', '', 'active'),
('en', 'admin', '0', 'on_map_search', 'Search form on map', '', '0', '', 'active'),
('en', 'admin', '0', 'on_map_form', 'On Map', '', '0', '', 'active'),
('en', 'admin', '0', 'comparing_phrases_popup_title', 'Missing phrases found', '', '0', '', 'active'),
('en', 'admin', '0', 'comparing_phrases_popup_content', '<h3>{count} missing phrases found. You\'ll need to import them to set the language as default.</h3><br><p>Are you sure you want to import them?</p><br>', '', '0', '', 'active'),
('en', 'admin', '0', 'config+name+sending_account_password', 'Send user account passwords in emails', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+des+sending_account_password', 'When disabled, passwords to user accounts will be replaced with a dummy text for security reasons.', 'settings', '0', '', 'active'),
('en', 'common', '0', 'text_for_password', '<i>Your_password<i>', '', '0', '', 'active'),
('en', 'admin', '0', 'notice_admin_email_exist', 'The {email} email address is already in use by another Administrator.', '', '0', '', 'active');

/* Added in 4.8.0 */
INSERT INTO `{db_prefix}lang_keys` (`Code`, `Module`, `JS`, `Key`, `Value`, `Target_key`, `Modified`, `Plugin`, `Status`) VALUES
('en', 'admin', '0', 'config+name+banner_in_grid_position_option', 'Banner space in listings', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+multilingual_paths', 'Multilingual paths', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+des+multilingual_paths', '<div style=\"display: inline-block;\"><div>Allows you to build paths of pages and categories in other languages, e.g. www.site.com/المحركات/السيارات/...html</div><div>The option can be enabled with 2 and more active languages on the site.</div></div>', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'template_incompatible_hint', 'Incompatible with current the template', '', '0', '', 'active');

/* Added in 4.8.1 */
INSERT INTO `{db_prefix}lang_keys` (`Code`, `Module`, `JS`, `Key`, `Value`, `Target_key`, `Modified`, `Plugin`, `Status`) VALUES
('en', 'admin', '0', 'config+des+map_provider', '<div style=\"line-height: 17px;margin-top: 5px;\">\r\n<b>Google Maps</b> - Multilingual<br />\r\n<b>OpenSteetMaps</b> - EN and DE<br />\r\n<b>CartoDB</b> - English only<br />\r\n<b>Yandex.Maps</b> - EN and RU\r\n</div>', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'subscribers_by_plan_no', 'There are no subscribers for the plan.', '', '0', '', 'active'),
('en', 'admin', '0', 'get_subscribers_empty_params', 'Required parameters are empty.', '', '0', '', 'active'),
('en', 'admin', '0', 'module_category', 'Category', '', '0', '', 'active'),
('en', 'admin', '0', 'module_system', 'System', '', '0', '', 'active'),
('en', 'admin', '0', 'module_box', 'Box', '', '0', '', 'active'),
('en', 'admin', '1', 'not_installed', 'To be installed', '', '0', '', 'active'),
('en', 'admin', '0', 'last_date_update', 'The date of recent subscription renewal', 'subscriptions', '0', '', 'active'),
('en', 'admin', '0', 'subscription_not_found', 'The transaction details is unavailable on the payment provider side anymore.', 'subscriptions', '0', '', 'active'),
('en', 'admin', '1', 'check_subscription', 'Check the subscription in the payment gateway', 'subscriptions', '0', '', 'active'),
('en', 'common', '0', 'listing_fields+name+country', 'Country', '', '0', '', 'active'),
('en', 'common', '0', 'listing_fields+name+country_level1', 'State/Region', '', '0', '', 'active'),
('en', 'common', '0', 'listing_fields+name+country_level2', 'City', '', '0', '', 'active'),
('en', 'common', '0', 'account_fields+name+country_level1', 'State/Region', '', '0', '', 'active'),
('en', 'common', '0', 'account_fields+name+country_level2', 'City', '', '0', '', 'active'),
('en', 'admin', '0', 'config+name+address_on_map_country', 'Country', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+address_on_map_address', 'Address', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+address_on_map_zip', 'ZIP code', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+address_on_map_country_level1', 'State/Region', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+address_on_map_country_level2', 'City', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'refresh_account_coordinates', 'Refresh account locations', 'controls', '0', '', 'active'),
('en', 'admin', '0', 'accounts_locations_refreshed', 'Account locations refreshed, account locations updated: {updated}, failed: {failed}', 'controls', '0', '', 'active'),
('en', 'system', '0', 'deny_update_custom_plugin', 'You cannot update the Plugin because it was customized.<br> Please contact Flynax helpdesk if you still need the new version.', '', '0', '', 'active'),
('en', 'system', '0', 'wrong_locale_configuration', 'Please set up the localization correctly on your server to use the following modifiers for the Date format field: %a, %A, %b, %B, %h.', '', '0', '', 'active'),
('en', 'common', '0', 'keyword_search', 'Keyword Search', '', '0', '', 'active');

/* Added in 4.8.2 */
INSERT INTO `{db_prefix}lang_keys` (`Code`, `Module`, `JS`, `Key`, `Value`, `Target_key`, `Modified`, `Plugin`, `Status`) VALUES
('en', 'admin', '0', 'account_meta_title', 'Account title', 'account_types', '0', '', 'active'),
('en', 'admin', '0', 'account_meta_h1', 'Account H1', 'account_types', '0', '', 'active'),
('en', 'admin', '0', '2co_direct', 'Direct', 'payment_gateways', '0', '', 'active'),
('en', 'admin', '0', '2co_simple', 'Simple', 'payment_gateways', '0', '', 'active'),
('en', 'admin', '0', '2co_notice', 'Please set up the following URL\"<b>http://domain.com/payment/post.html?gateway=2co</b>\" to \"Integrations > Webhooks & API > Approved URL\" field in your account.', 'payment_gateways', '0', '', 'active'),
('en', 'admin', '0', 'config+des+2co_secret_word', 'You can find the Secret word in your account: Integrations  > Webhooks & API > Secret word', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+des+2co_id', 'You can find the Merchant Code in your account: Integrations  > Webhooks & API > Merchant Code', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+des+2co_method', '', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+des+2co_secret_key', 'You can find the Secret Key in your account: Integrations  > Webhooks & API > Secret Key', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+2co_method', 'Payment method', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+2co_secret_key', 'Secret key', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+geocoding_restrict_by_country', 'Show geocoding results only for', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+watermark_position', 'Position', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+option+watermark_position_top-left', 'Top left', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+option+watermark_position_top', 'Top', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+option+watermark_position_top-right', 'Top right', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+option+watermark_position_left', 'Left', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+option+watermark_position_center', 'Center', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+option+watermark_position_right', 'Right', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+option+watermark_position_bottom-left', 'Bottom Left', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+option+watermark_position_bottom', 'Bottom', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+option+watermark_position_bottom-right', 'Bottom right', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+option+watermark_position_tiled', 'Tiled', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+watermark_image_width', 'Image width', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+des+watermark_image_width', 'px. To keep the dimensions of the watermark uniform on photos with different dimensions, the Autocropping of large pictures must be enabled.', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+watermark_text_font', 'Text font', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+des+watermark_text_font', 'You may use your own True Type fonts, which can be found at /libs/fonts/.', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+watermark_text_size', 'Font size', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+des+watermark_text_size', 'To keep the dimensions of the watermark uniform on photos with different dimensions, the Autocropping of large pictures must be enabled.', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+watermark_text_color', 'Text color', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+watermark_angle', 'Angle', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+des+watermark_angle', 'To rotate the watermark on pictures you may set an angle between -360 and 360 degrees.', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+watermark_opacity', 'Opacity', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+des+watermark_opacity', 'Allows to you to change opacity of the watermark in the range from 100 - 0%, from opaque to fully transparent.', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+option+watermark_type_text', 'Text', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+option+watermark_type_image', 'Image', 'settings', '0', '', 'active'),
('en', 'system', '0', 'watermark_image_is_not_available', 'Please make sure you have entered a correct image URL and the image is available at the link.', 'settings', '0', '', 'active'),
('en', 'system', '0', 'watermark_image_is_not_png', 'Please make sure you are loading a PNG image.', 'settings', '0', '', 'active'),
('en', 'system', '0', 'watermark_wrong_width', 'The image width value must be positive.', 'settings', '0', '', 'active'),
('en', 'system', '0', 'watermark_wrong_opacity', 'The opacity value must be positive in the range from 100 - 0%.', 'settings', '0', '', 'active'),
('en', 'system', '0', 'watermark_wrong_text_size', 'The text size value must be positive.', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'show_in_stat_block', 'Show in statistics box', 'listing_types', '0', '', 'active'),
('en', 'admin', '0', 'config+name+home_special_box', 'Box right of gallery', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+output_image_format', 'Output image format', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+des+pre_days_membership', 'days', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+pre_days_membership', 'Send notifications about expiration of membership plan in advance', 'settings', '0', '', 'active'),
('en', 'email_tpl', '0', 'email_templates+body+cron_membership_pre_expired', 'Hello {name},\r\n\r\nYour membership plan will expire in {days} days.\r\nExpire date: {expire_date}.\r\n\r\nPlease log in to {site_name} to renew your plan, or use the link below:\r\n\r\n{renew_link}', '', '1', '', 'active'),
('en', 'email_tpl', '0', 'email_templates+subject+cron_membership_pre_expired', 'Your plan will soon expire at {site_name}', '', '1', '', 'active'),
('en', 'admin', '0', 'config+name+force_canonical', 'Force canonical tag', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+des+force_canonical', 'Adds the canonical tag to all the site pages. When disabled, it adds the tag to the pagination pages only.', 'settings', '0', '', 'active'),

/* Added in 4.9.0 */
('en', 'admin', '0', 'config+name+keyword_search_type', 'Default keyword search mode', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'search_form_on_account', 'Search form on the Account page', 'listing_types', '0', '', 'active'),
('en', 'box', '0', 'blocks+name+account_page_search_listings', 'Listing Search', 'account_page_search_listings', '0', '', 'active'),
('en', 'frontEnd', '0', 'account_already_confirmed_login', 'The account is already activated, please login.', 'confirm', '0', '', 'active'),
('en', 'admin', '0', 'field_autocomplete_option', 'Autocomplete', '', '0', '', 'active'),
('en', 'common', '1', 'field_autocomplete_no_results', 'Nothing found', '', '0', '', 'active'),
('en', 'admin', '0', 'autocomplete_not_allowed', 'The option is unavailable for the field.', '', '0', '', 'active'),
('en', 'common', '0', 'rotate_picture', 'Rotate picture', '', '0', '', 'active'),
('en', 'frontEnd', '1', 'confirm_sent_message_to_visitor', 'You might not receive the user’s answer to the site messenger because the user did not sign in when contacting you. Your message will be sent to the user by email.', 'my_messages', '0', '', 'active'),
('en', 'admin', '0', 'multilingual_path_denied', 'This page does not support the option of Multilingual paths.', 'pages', '0', '', 'active'),
('en', 'admin', '1', 'deny_change_ex_date', 'You cannot change the date because the system calculates it based on the payment date and listing life within a package.', 'listings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+hidden_phone_numbers', 'Number of hidden digits in numbers', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+des+hidden_phone_numbers', 'The system will replace the last digits in phone numbers with X. If set to 0, numbers will be hidden completely.', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'phone_hide_number', 'Hide phone numbers', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'phone_show_number', 'Show number', '', '0', '', 'active'),
('en', 'frontEnd', '1', 'call_owner', 'Call Seller', '', '0', '', 'active'),
('en', 'system', '0', 'call_owner_additional_numbers', 'Extra Numbers', '', '0', '', 'active'),
('en', 'admin', '0', 'config+name+show_call_owner_button', 'Call Owner button in listing details', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'atype_agency_option', 'Allow users to create subaccounts', 'account_types', '0', '', 'active'),
('en', 'admin', '0', 'atype_agent_option', 'Give users the ability to join agencies', 'account_types', '0', '', 'active'),
('en', 'admin', '0', 'atype_agency_option_membership', 'You can manage the option as a service of the [membership plans].', 'account_types', '0', '', 'active'),
('en', 'common', '0', 'membership_services+name+agency', 'Agency account', '', '0', '', 'active'),
('en', 'common', '0', 'pages+name+my_agents', 'My Agents', '', '0', '', 'active'),
('en', 'common', '0', 'pages+title+my_agents', 'My Agents', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'invite_for_new_agents', 'Invite Agent', 'my_agents', '0', '', 'active'),
('en', 'frontEnd', '0', 'placeholder_invite_agent', 'Add an email address of the agent', 'my_agents', '0', '', 'active'),
('en', 'email_tpl', '0', 'email_templates+subject+send_invite_to_agent', 'You\'ve got an invitation to join an agency', '', '0', '', 'active'),
('en', 'email_tpl', '0', 'email_templates+body+send_invite_to_agent', 'Hello,\r\n\r\nYou\'ve got an invitation to join the {agency} agency at {website}.\r\n\r\nPlease, use the link below to accept the invitation.\r\n\r\n{link}\r\n\r\n', '', '0', '', 'active'),
('en', 'system', '0', 'agency_invite_sent', 'You\'ve successfully sent an invitation.', '', '0', '', 'active'),
('en', 'frontEnd', '1', 'agency_invite_accepted', 'The invitation has been successfully accepted.', '', '0', '', 'active'),
('en', 'system', '0', 'account_cannot_be_agent', 'The account doesn\'t have permission to be an agent.', '', '0', '', 'active'),
('en', 'system', '0', 'invite_already_sent', 'You\'ve already invited the agent.', '', '0', '', 'active'),
('en', 'system', '0', 'agent_invited_to_another_agency', 'The agent has already been invited by another Agency.', '', '0', '', 'active'),
('en', 'common', '0', 'decline', 'Decline', '', '0', '', 'active'),
('en', 'frontEnd', '1', 'confirmation_invite_notice', 'You\'ve got an invitation to join the "<b>{agency}</b>" agency. Please, confirm or decline it.', 'home', '0', '', 'active'),
('en', 'frontEnd', '1', 'agency_invite_declined', 'You\'ve successfully declined the invitation.', 'home', '0', '', 'active'),
('en', 'frontEnd', '1', 'invite_is_invalid', 'The invitation is invalid because you\'ve already confirmed or declined it.', 'home', '0', '', 'active'),
('en', 'frontEnd', '0', 'agent_registration_title', 'Agent registration', 'registration', '0', '', 'active'),
('en', 'frontEnd', '0', 'agent_registration_notice', 'Please, enter all the necessary details in your Agent profile.', 'registration', '0', '', 'active'),
('en', 'common', '0', 'invites', 'Invitations', '', '0', '', 'active'),
('en', 'common', '1', 'accepted', 'Accepted', '', '0', '', 'active'),
('en', 'common', '1', 'declined', 'Declined', '', '0', '', 'active'),
('en', 'frontEnd', '1', 'resend_invite', 'Resend', 'my_agents', '0', '', 'active'),
('en', 'frontEnd', '1', 'resend_confirm', 'Are you sure you want to resend the invitation?', 'my_agents', '0', '', 'active'),
('en', 'frontEnd', '1', 'invite_resent_successfully', 'You\'ve successfully resent the invitation.', 'my_agents', '0', '', 'active'),
('en', 'system', '0', 'invite_removed_successfully', 'You\'ve successfully disengaged the agent.', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'no_agents', 'You haven\'t yet added any agents.', 'my_agents', '0', '', 'active'),
('en', 'box', '0', 'blocks+name+invite_search', 'Search for Invitations', 'invite_search', '0', '', 'active'),
('en', 'frontEnd', '1', 'delete_invite_confirmation', 'Are you sure you want to disengage the agent?', 'my_agents', '0', '', 'active'),
('en', 'frontEnd', '1', 'deny_use_invite', 'You cannot use the link with the invitation because it was created for another account.', 'home', '0', '', 'active'),
('en', 'email_tpl', '0', 'email_templates+subject+agent_accepted_invite', '{agent} has accepted your invitation at {site_name}', '', '0', '', 'active'),
('en', 'email_tpl', '0', 'email_templates+body+agent_accepted_invite', 'Hello {agency},\r\n\r\n{agent} has accepted the invitation to join your agency.\r\n\r\nGo to My Agents - {link}\r\n\r\n', '', '0', '', 'active'),
('en', 'email_tpl', '0', 'email_templates+subject+agent_declined_invite', 'The agent has declined your invitation at {site_name}', '', '0', '', 'active'),
('en', 'email_tpl', '0', 'email_templates+body+agent_declined_invite', 'Hello {agency},\r\n\r\nThe agent has declined the invitation to join your agency.\r\n\r\nGo to My Agents - {link}\r\n\r\n', '', '0', '', 'active'),
('en', 'common', '0', 'agents', 'Agents', '', '0', '', 'active'),
('en', 'common', '0', 'agency', 'Agency', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'agency_not_have_agents', 'The agency hasn\'t yet added any agents.', 'account_type', '0', '', 'active'),
('en', 'common', '0', 'agency_listings', 'Agency\'s listings', '', '0', '', 'active'),
('en', 'admin', '1', 'accepted_date', 'Accepted date', 'accounts', '0', '', 'active'),
('en', 'admin', '1', 'declined_date', 'Declined date', 'accounts', '0', '', 'active'),
('en', 'email_tpl', '0', 'email_templates+subject+agency_removed_agent', 'Your account disengaged from the {agency}', '', '0', '', 'active'),
('en', 'email_tpl', '0', 'email_templates+body+agency_removed_agent', 'Hello {agent},\r\n\r\nYou are no longer part of the {agency} because the {agency} has removed your account from its corporate profile.\r\n\r\nIf you believe your disengagement happened by accident, please contact the {agency} to get the issue resolved.\r\n\r\nYou keep all the listings that you added from your account.\r\n\r\n', '', '0', '', 'active'),
('en', 'common', '0', 'slides+title+1', 'Cat Walk', '', '0', '', 'active'),
('en', 'common', '0', 'slides+description+1', 'The first slide with Cat Walk by Peter Arn', '', '0', '', 'active'),
('en', 'common', '0', 'slides+title+2', 'Tree and Morning Mist', '', '0', '', 'active'),
('en', 'common', '0', 'slides+description+2', 'The second slide with tree and morning mist by Jos Buurmans', '', '0', '', 'active');

/* Added in 4.9.1 */
INSERT INTO `{db_prefix}lang_keys` (`Code`, `Module`, `JS`, `Key`, `Value`, `Target_key`, `Modified`, `Plugin`, `Status`) VALUES
('en', 'admin', '0', 'config+name+main_menu_home_page', 'Main menu on the Home page', 'settings', '0', '', 'active'),
('en', 'admin', '1', 'build_account_grid_form', 'Build Grid Form', 'account_types', '0', '', 'active'),
('en', 'admin', '0', 'account_grid_form_builder', 'Account Grid Form Builder', 'account_types', '0', '', 'active'),
('en', 'admin', '0', 'grid_form', 'Grid Form', 'account_types', '0', '', 'active'),
('en', 'frontEnd', '0', 'plan_not_expired', 'You cannot renew your plan because it hasn\'t yet expired.', 'profile', '0', '', 'active'),
('en', 'admin', '0', 'drop_static_data_cache', 'Update static data cache', 'controls', '0', '', 'active'),
('en', 'admin', '1', 'update_static_files_notice', 'You have successfully updated the static files.', 'controls', '0', '', 'active'),
('en', 'admin', '0', 'config+name+google_translation_api_key', 'Google Translation API Key', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+des+google_translation_api_key', 'Use the Google Cloud Translation - Basic (v2). Setup link <a target="_blank" href="https://cloud.google.com/translate/docs/setup">here</a>', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'translate_phrases_by_google', 'Translate phrases', 'languages', '0', '', 'active'),
('en', 'admin', '0', 'translate_phrases_by_google_hint', 'Add a Translation API Key to the <a href="index.php?controller=settings">Basic Settings</a> to enable translation of phrases', 'languages', '0', '', 'active'),
('en', 'admin', '1', 'translate_phrases_popup_title', 'Translation of phrases in progress...', '', '0', '', 'active'),
('en', 'admin', '1', 'translate_phrases_completed', 'All the phrases have been successfully translated.', '', '0', '', 'active'),
('en', 'system', '0', 'complete_translation', 'Complete Translating', '', '0', '', 'active'),
('en', 'system', '0', 'confirm_phrases_translating', 'Are you sure you want to translate all the untranslated phrases with the Translation API?', '', '0', '', 'active'),
('en', 'admin', '0', 'config+name+yandex_geocoder_api_key', 'Yandex Geocoder API Key', 'settings', '0', '', 'active'),

/* Added in 4.9.2 */
('en', 'admin', '0', 'notice_comma_usage', 'You may use comma as a separator.', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'footer_menu_mobile_apps', 'Mobile Apps', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'footer_menu_1', 'About Classifieds', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'footer_menu_2', 'Help & Contact', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'footer_menu_3', 'More Helpful Links', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'load_more_listings', 'Load More Listings', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'header_contact_email', 'sales@flynax.com', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'header_contact_phone_number', '+1 (994) 546-1212', '', '0', '', 'active'),
('en', 'admin', '0', 'config+name+ios_app_url', 'iOS application url', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+android_app_url', 'Android application url', 'settings', '0', '', 'active'),
('en', 'frontEnd', '0', 'footer_newsletter_text', 'Subscribe for our newsletters and stay updated about the latest news and special offers.', '', '0', '', 'active'),
('en', 'admin', '1', 'use_icon_in_menu', 'Use icon in menu', '', '0', '', 'active'),
('en', 'admin', '1', 'use_icon_in_form', 'Use icon in search form', '', '0', '', 'active'),
('en', 'admin', '1', 'svg_icon_file', 'SVG icon file', '', '0', '', 'active'),
('en', 'common', '1', 'load_more', 'Load More', '', '0', '', 'active'),
('en', 'admin', '1', 'page_login_required_hint', 'Logging in is required for this system page', 'pages', '0', '', 'active'),
('en', 'admin', '0', 'config+name+phone_messengers_icons', 'Messaging App Settings For Phone Number Fields', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+whatsapp_phone_icon', 'WhatsApp icon', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+viber_phone_icon', 'Viber icon', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+telegram_phone_icon', 'Telegram icon', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'messenger_icons', 'Messaging App icons', '', '0', '', 'active'),
('en', 'common', '0', 'profile_has_whatsapp', 'Used for WhatsApp', '', '0', '', 'active'),
('en', 'common', '0', 'profile_has_viber', 'Used for Viber', '', '0', '', 'active'),
('en', 'common', '0', 'profile_has_telegram', 'Used for Telegram', '', '0', '', 'active');

/* Added in 4.9.3 */
INSERT INTO `{db_prefix}lang_keys` (`Code`, `Module`, `JS`, `Key`, `Value`, `Target_key`, `Modified`, `Plugin`, `Status`) VALUES
('en', 'admin', '0', 'file_multipart_upload', 'Multifile upload', '', '0', '', 'active'),
('en', 'common', '0', 'files_limit_hint', '{number} files maximum', '', '0', '', 'active'),
('en', 'common', '0', 'files_limit_exceeded', 'You\'ve exceeded the file upload limit.', '', '0', '', 'active'),
('en', 'admin', '0', 'files_limit', 'File limit', '', '0', '', 'active'),
('en', 'admin', '0', 'category_block_on_page', 'Category box on listing type page', 'listing_types', '0', '', 'active'),
('en', 'admin', '0', 'blocks+option+group_categories', 'Merge with other category boxes', 'blocks', '0', '', 'active'),
('en', 'admin', '0', 'blocks+option+categories_style', 'Category box format', 'blocks', '0', '', 'active'),
('en', 'admin', '0', 'blocks+option_value+column_fill', 'Column', 'blocks', '0', '', 'active'),
('en', 'admin', '0', 'blocks+option_value+grid', 'Grid', 'blocks', '0', '', 'active'),
('en', 'admin', '0', 'blocks+option+visible_categories', 'Number of visible categories', 'blocks', '0', '', 'active'),
('en', 'admin', '0', 'blocks+option_hint+visible_categories', 'Leave the field empty to display all categories.', 'blocks', '0', '', 'active'),
('en', 'admin', '0', 'blocks+option+display_subcategories', 'Display subcategories', 'blocks', '0', '', 'active'),
('en', 'admin', '0', 'blocks+option+subcategories_number', 'Number of subcategories', 'blocks', '0', '', 'active'),
('en', 'admin', '0', 'blocks+option_hint+subcategories_number', 'Leave the field empty to display all subcategories.', 'blocks', '0', '', 'active'),
('en', 'admin', '0', 'blocks+option+display_counter', 'Listing counter', 'blocks', '0', '', 'active'),
('en', 'admin', '0', 'blocks+option+more_subcategories_style', '"View more" button style', 'blocks', '0', '', 'active'),
('en', 'admin', '0', 'blocks+option_value+more_subcategories_popup', 'Pop-up', 'blocks', '0', '', 'active'),
('en', 'admin', '0', 'blocks+option_value+more_subcategories_link', 'Link', 'blocks', '0', '', 'active'),
('en', 'admin', '0', 'group_categories_hint', 'The block settings are disabled because you merged it with other boxes; click [here] to manage the primary category box settings.', 'blocks', '0', '', 'active'),
('en', 'system', '0', 'call_owner_forbidden_login_hint', 'You should have an account and be logged in to call the owner.', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'join_us_on_social_network', 'Join us on {network_name}', '', '0', '', 'active'),
('en', 'admin', '0', 'config+name+vk_page', 'Your VK account URL', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+whatsapp_page', 'Your WhatsApp call link', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+instagram_page', 'Your Instagram account URL', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+telegram_page', 'Your Telegram call link', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'translate_text', 'Translate text', '', '0', '', 'active'),
('en', 'admin', '0', 'translate_listings', 'Translate text fields in listings', 'controls', '0', '', 'active'),
('en', 'admin', '0', 'translate_accounts', 'Translate text fields in accounts', 'controls', '0', '', 'active'),
('en', 'admin', '1', 'translate', 'Translate', '', '0', '', 'active'),
('en', 'system', '', 'missing_translation_fields', 'No multilingual fields found with the enabled translation option.', '', '0', '', 'active'),
('en', 'admin', '0', 'config+name+news_image_width', 'Image width (in pixels)', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+news_image_height', 'Image height (in pixels)', 'settings', '0', '', 'active'),
('en', 'box', '0', 'blocks+name+news_categories', 'News Categories', 'news_categories', '0', '', 'active'),
('en', 'box', '0', 'blocks+name+more_news_block', 'Read more news', 'more_news_block', '0', '', 'active'),
('en', 'common', '0', 'news_categories+name+12', 'Fashion', '', '0', '', 'active'),
('en', 'common', '0', 'news_categories+name+11', 'Lifestyle', '', '0', '', 'active'),
('en', 'common', '0', 'news_categories+name+10', 'Arts', '', '0', '', 'active'),
('en', 'common', '0', 'news_categories+name+9', 'Economy', '', '0', '', 'active'),
('en', 'common', '0', 'news_categories+name+8', 'Tech', '', '0', '', 'active'),
('en', 'common', '0', 'news_categories+name+7', 'Business', '', '0', '', 'active'),
('en', 'common', '0', 'news_categories+name+6', 'Sports', '', '0', '', 'active'),
('en', 'common', '0', 'news_categories+name+5', 'Climate', '', '0', '', 'active'),
('en', 'common', '0', 'news_categories+name+4', 'Science', '', '0', '', 'active'),
('en', 'common', '0', 'news_categories+name+3', 'Health', '', '0', '', 'active'),
('en', 'common', '0', 'news_categories+name+2', 'Education', '', '0', '', 'active'),
('en', 'common', '0', 'news_categories+name+1', 'Politics', '', '0', '', 'active'),
('en', 'admin', '0', 'config+name+translation_api', 'Translation API', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+option+translation_api_google', 'Google Translation API', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+option+translation_api_deepl', 'DeepL API', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+deepl_translation_api_key', 'DeepL API Key', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+des+deepl_translation_api_key', 'Setup link <a target="_blank" href="https://developers.deepl.com/docs/getting-started/auth#authentication">here</a>', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+gallery_max_zoom_level', 'Maximum zoom level in gallery', 'settings', '0', '', 'active');

/* Added in 4.10.0 */
INSERT INTO `{db_prefix}lang_keys` (`Code`, `Module`, `JS`, `Key`, `Value`, `Target_key`, `Modified`, `Plugin`, `Status`) VALUES
('en', 'admin', '1', 'divide_into_columns', 'Divide into columns', 'listing_groups', '0', '', 'active'),
('en', 'admin', '1', 'group_heading', 'Group heading', 'listing_groups', '0', '', 'active'),
('en', 'frontEnd', '0', 'profile_upgrade_payment_accepted', 'Your payment has successfully gone through.<br />The plan details and account status will be updated in a minute.', 'profile', '0', '', 'active'),
('en', 'frontEnd', '1', 'warning_one_picture_is_required', 'Since images are required, you cannot remove the last picture; at least one must remain.', '', '0', '', 'active'),
('en', 'admin', '0', 'box_sticky_type_categories_only', 'The box will be shown only in the categories of the selected listing type page(s).', 'blocks', '0', '', 'active'),
('en', 'admin', '0', 'config+name+cache_phrases', 'Language phrase caching', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'metadata', 'Metadata', '', '0', '', 'active'),
('en', 'admin', '0', 'listing_metadata', 'Listing Metadata', '', '0', '', 'active'),
('en', 'admin', '0', 'child_category_metadata', 'Child Category Metadata', '', '0', '', 'active'),
('en', 'admin', '0', 'child_category_metadata_hint', 'Using the variables below, you can set up a pattern for populating child categories with metadata:<br />- {category} - Name of the child category;<br />- {parent} - Name of the parent category;<br />- {parent-exclude-{key}} - The name of the parent category, {name} will be excluded from the pattern when generating metadata.', '', '0', '', 'active'),
('en', 'admin', '0', 'price_options_hint', 'Allows you to enable price labels as an alternative to numeric price values, e.g. free, negotiable, contact for price, etc. You can set it up [here].', '', '0', '', 'active'),
('en', 'common', '0', 'data_formats+name+price_options', 'Price labels', '', '0', '', 'active'),
('en', 'common', '0', 'data_formats+name+price_options_free', 'Free', '', '0', '', 'active'),
('en', 'common', '0', 'data_formats+name+price_options_negotiable', 'Negotiable', '', '0', '', 'active'),
('en', 'common', '0', 'data_formats+name+price_options_on_request', 'Contact for price', '', '0', '', 'active'),
('en', 'common', '0', 'starting_price', 'Starting price', '', '0', '', 'active'),
('en', 'admin', '1', 'with_popup', 'In contact form', '', '0', '', 'active'),
('en', 'frontEnd', '1', 'price_contact_form_template', 'I am interested in your item, can you name your price?', '', '0', '', 'active'),
('en', 'common', '0', 'price_from', 'from', '', '0', '', 'active'),
('en', 'admin', '0', 'with_popup_admin_desc', 'Enables a pop-up contact form for buyers. Clicking the price label triggers the form to contact the seller about pricing.', 'data_formats', '0', '', 'active'),
('en', 'common', '0', 'with_popup_desc', 'Enables a pop-up contact form for buyers. They will be able to contact you about pricing by clicking the price label.', '', '0', '', 'active'),
('en', 'frontEnd', '1', 'deny_contact_with_own_account', 'You cannot send messages to yourself.', '', '0', '', 'active');

/* Added in 4.10.1 */
INSERT INTO `{db_prefix}lang_keys` (`Code`, `Module`, `JS`, `Key`, `Value`, `Target_key`, `Modified`, `Plugin`, `Status`) VALUES
('en', 'admin', '0', 'blocks+option+header_link', 'Link in box header', 'blocks', '0', '', 'active'),
('en', 'admin', '0', 'blocks+option+header_link_page_key', 'Page assigned to link', 'blocks', '0', '', 'active'),
('en', 'admin', '0', 'config+name+seo', 'SEO', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+html_in_pages', '".html" for page and listing URLs', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+html_in_categories', '".html" for category URLs', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+async_mail', 'Send emails in the background', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+des+async_mail', 'Emails will be sent in the background to prevent page loading delays and improve response time.', 'settings', '0', '', 'active'),
('en', 'common', '0', 'country', 'Country', '', '0', '', 'active'),
('en', 'common', '0', 'worldwide', 'Worldwide', '', '0', '', 'active'),
('en', 'admin', '0', 'phone_show_dial', 'Show dial code', '', '0', '', 'active'),
('en', 'admin', '0', 'phone_show_flag', 'Show flag', '', '0', '', 'active'),
('en', 'common', '1', 'invalid_number', 'Invalid number', '', '0', '', 'active'),
('en', 'common', '1', 'too_short', 'Too short', '', '0', '', 'active');

DROP TABLE IF EXISTS `{db_prefix}listings`;
CREATE TABLE `{db_prefix}listings` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `Category_ID` int(11) NOT NULL DEFAULT '0',
  `Account_ID` int(11) NOT NULL DEFAULT '0',
  `Plan_ID` int(11) NOT NULL DEFAULT '0',
  `Plan_type` enum('listing','account') NOT NULL DEFAULT 'listing',
  `Pay_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `Featured_ID` int(11) NOT NULL DEFAULT '0',
  `Featured_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `Last_show` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `Last_step` varchar(15) NOT NULL,
  `Last_type` set('featured','standard') NOT NULL,
  `Crossed` mediumtext NOT NULL,
  `Shows` int(11) NOT NULL DEFAULT '0',
  `Main_photo` varchar(80) NOT NULL,
  `Main_photo_x2` varchar(80) NOT NULL,
  `Photos_count` int(3) NOT NULL,
  `Status` enum('active','approval','pending','incomplete','expired','trash') NOT NULL DEFAULT 'approval',
  `Date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `Cron` enum('0','1') NOT NULL DEFAULT '0',
  `Cron_notified` enum('0','1') NOT NULL DEFAULT '0',
  `Cron_featured` enum('0','1') NOT NULL DEFAULT '0',
  `Loc_latitude` double NOT NULL,
  `Loc_longitude` double NOT NULL,
  `Loc_address` varchar(128) NOT NULL,
  `country` varchar(100) NOT NULL DEFAULT '',
  `country_level1` varchar(100) NOT NULL DEFAULT '',
  `country_level2` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `Category_ID` (`Category_ID`),
  KEY `Account_ID` (`Account_ID`),
  KEY `Status` (`Status`),
  KEY `Last_show` (`Last_show`),
  KEY `Featured_date` (`Featured_date`),
  KEY `Date` (`Date`),
  KEY `Loc_latitude` (`Loc_latitude`),
  KEY `Loc_longitude` (`Loc_longitude`),
  KEY `country` (`country`),
  KEY `country_level1` (`country_level1`),
  KEY `country_level2` (`country_level2`),
  KEY `Category_status` (`Category_ID`, `Status`),
  KEY `FeaturedDate_date` (`Featured_date`, `Date`)
) ENGINE=InnoDB CHARSET=utf8 COLLATE=utf8_general_ci;

DROP TABLE IF EXISTS `{db_prefix}listings_data`;
CREATE TABLE `{db_prefix}listings_data` (
    `Listing_ID` INT(11),
    `Key` VARCHAR(128) NOT NULL DEFAULT '',
    `Value` TEXT,
    INDEX `Listing_ID` (`Listing_ID`),
    CONSTRAINT `Listing_data_fk` FOREIGN KEY (`Listing_ID`)
    REFERENCES `{db_prefix}listings`(`ID`) ON DELETE CASCADE
) ENGINE=InnoDB CHARSET=utf8 COLLATE=utf8_general_ci;

DROP TABLE IF EXISTS `{db_prefix}listings_shows`;
CREATE TABLE `{db_prefix}listings_shows` (
  `Listing_ID` int(11) NOT NULL DEFAULT '0',
  `IP` varchar(20) NOT NULL DEFAULT '',
  `Date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  KEY `IP` (`IP`),
  KEY `Listing_ID` (`Listing_ID`)
) ENGINE=InnoDB CHARSET=utf8 COLLATE=utf8_general_ci;

DROP TABLE IF EXISTS `{db_prefix}listing_fields`;
CREATE TABLE `{db_prefix}listing_fields` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `Key` varchar(255) NOT NULL DEFAULT '',
  `Type` enum('bool','text','textarea','number','date','phone','mixed','price','select','radio','checkbox','file','accept','image') NOT NULL DEFAULT 'text',
  `Default` varchar(255) NOT NULL DEFAULT '',
  `Values` mediumtext NOT NULL,
  `Condition` varchar(50) NOT NULL DEFAULT '',
  `Multilingual` enum('0','1') NOT NULL DEFAULT '0',
  `Details_page` enum('0','1') NOT NULL DEFAULT '1',
  `Add_page` enum('0','1') NOT NULL DEFAULT '1',
  `Required` enum('0','1') NOT NULL DEFAULT '0',
  `Map` enum('0','1') NOT NULL DEFAULT '0',
  `Opt1` enum('0','1') NOT NULL DEFAULT '0',
  `Opt2` varchar(255) NOT NULL DEFAULT '',
  `Opt3` VARCHAR(255) NOT NULL DEFAULT '0',
  `Autocomplete` enum('0','1') NOT NULL DEFAULT '0',
  `Status` enum('active','approval','trash') NOT NULL DEFAULT 'active',
  `Readonly` enum('0','1') NOT NULL DEFAULT '0',
  `Contact` enum('0','1') NOT NULL DEFAULT '0',
  `Hidden` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `Key` (`Key`),
  KEY `Status` (`Status`),
  KEY `Map` (`Map`)
) ENGINE=InnoDB CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `{db_prefix}listing_fields` (`ID`, `Key`, `Type`, `Default`, `Values`, `Condition`, `Multilingual`, `Details_page`, `Add_page`, `Required`, `Map`, `Opt1`, `Opt2`, `Autocomplete`, `Status`, `Readonly`) VALUES
('-1', 'sf_status', 'select', '', '', '', '0', '0', '0', '0', '0', '0', '0', '0', 'active', '1'),
('-2', 'sf_active_till', 'select', '', '', '', '0', '0', '0', '0', '0', '0', '0', '0', 'active', '1'),
('-3', 'sf_plan', 'select', '', '', '', '0', '0', '0', '0', '0', '0', '0', '0', 'active', '1'),
('-4', 'sf_featured', 'bool', '', '', '', '0', '0', '0', '0', '0', '0', '0', '0', 'active', '1'),
(37, 'country', 'select', '', '', 'countries', '0', '1', '1', '0', '1', '0', 0, '1', 'active', '0'),
(191, 'country_level1', 'select', '', '', 'countries', '0', '1', '1', '0', '1', '0', 0, '1', 'active', '1'),
(192, 'country_level2', 'select', '', '', 'countries', '0', '1', '1', '0', '1', '0', 0, '1', 'active', '1');

DROP TABLE IF EXISTS `{db_prefix}listing_groups`;
CREATE TABLE `{db_prefix}listing_groups` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `Key` varchar(255) NOT NULL DEFAULT '',
  `Display` enum('0','1') NOT NULL DEFAULT '1',
  `Columns` enum('0','1') NOT NULL DEFAULT '0',
  `Header` enum('0','1') NOT NULL DEFAULT '1',
  `Status` enum('active','approval','trash') NOT NULL DEFAULT 'active',
  PRIMARY KEY (`ID`),
  KEY `Key` (`Key`,`Status`)
) ENGINE=InnoDB CHARSET=utf8 COLLATE=utf8_general_ci;

DROP TABLE IF EXISTS `{db_prefix}listing_packages`;
CREATE TABLE `{db_prefix}listing_packages` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `Account_ID` int(11) NOT NULL DEFAULT '0',
  `Plan_ID` int(11) NOT NULL DEFAULT '0',
  `Listings_remains` int(4) NOT NULL DEFAULT '0',
  `Standard_remains` int(4) NOT NULL,
  `Featured_remains` int(4) NOT NULL,
  `Type` enum('listing','package','limited','featured','account') NOT NULL DEFAULT 'package',
  `Date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `IP` varchar(40) NOT NULL DEFAULT '',
  `Count_used` int(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `Account_ID` (`Account_ID`),
  KEY `Plan_ID` (`Plan_ID`)
) ENGINE=InnoDB CHARSET=utf8 COLLATE=utf8_general_ci;

DROP TABLE IF EXISTS `{db_prefix}listing_photos`;
CREATE TABLE `{db_prefix}listing_photos` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `Listing_ID` bigint NOT NULL DEFAULT '0',
  `Position` int(11) NOT NULL DEFAULT '0',
  `Photo` varchar(255) NOT NULL DEFAULT '',
  `Thumbnail` varchar(255) NOT NULL DEFAULT '',
  `Thumbnail_x2` varchar(255) NOT NULL DEFAULT '',
  `Original` varchar(255) NOT NULL DEFAULT '',
  `Description` varchar(255) NOT NULL DEFAULT '',
  `Type` enum('picture','video') NOT NULL DEFAULT 'picture',
  `Angle` enum('0','-90','-180','-270') NOT NULL DEFAULT '0',
  `Crop` varchar(100) NOT NULL,
  `Status` enum('active','approval') NOT NULL DEFAULT 'active',
  PRIMARY KEY (`ID`),
  KEY `Listing_ID` (`Listing_ID`),
  KEY `Type` (`Type`),
  KEY `Status` (`Status`)
) ENGINE=InnoDB CHARSET=utf8 COLLATE=utf8_general_ci;

DROP TABLE IF EXISTS `{db_prefix}listing_plans`;
CREATE TABLE `{db_prefix}listing_plans` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `Key` varchar(200) NOT NULL DEFAULT '',
  `Position` int(3) NOT NULL DEFAULT '0',
  `Type` enum('listing','package','featured') NOT NULL DEFAULT 'listing',
  `Allow_for` set('visitor','dealer','buyer') NOT NULL,
  `Sticky` enum('0','1') NOT NULL DEFAULT '0',
  `Category_ID` mediumtext NOT NULL,
  `Subcategories` enum('0','1') NOT NULL DEFAULT '0',
  `Featured` enum('0','1') NOT NULL DEFAULT '0',
  `Advanced_mode` enum('0','1') NOT NULL DEFAULT '0',
  `Standard_listings` int(4) NOT NULL,
  `Featured_listings` int(4) NOT NULL,
  `Color` varchar(6) NOT NULL,
  `Limit` int(8) NOT NULL DEFAULT '0',
  `Price` float NOT NULL DEFAULT '0',
  `Listing_period` int(5) NOT NULL,
  `Plan_period` int(5) NOT NULL,
  `Image` int(5) NOT NULL DEFAULT '0',
  `Image_unlim` enum('0','1') NOT NULL DEFAULT '0',
  `Video` int(5) NOT NULL,
  `Video_unlim` enum('0','1') NOT NULL DEFAULT '0',
  `Listing_number` int(11) NOT NULL DEFAULT '0',
  `Cross` int(6) NOT NULL DEFAULT '0',
  `Status` enum('active','approval','trash') NOT NULL DEFAULT 'active',
  PRIMARY KEY  (`ID`),
  KEY `Type` (`Type`),
  KEY `Listing_period` (`Listing_period`),
  KEY `Status` (`Status`),
  KEY `Cross` (`Cross`)
) ENGINE=InnoDB CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `{db_prefix}listing_plans` (`ID`, `Key`, `Position`, `Type`, `Allow_for`, `Sticky`, `Category_ID`, `Subcategories`, `Featured`, `Advanced_mode`, `Standard_listings`, `Featured_listings`, `Color`, `Limit`, `Price`, `Listing_period`, `Plan_period`, `Image`, `Image_unlim`, `Video`, `Video_unlim`, `Listing_number`, `Cross`, `Status`) VALUES
(1, 'bronze', 1, 'listing', '', '1', '', '1', '0', '0', 0, 0, 'f59a39', 0, 0, 31, 0, 3, '0', 1, '0', 0, 0, 'active'),
(4, 'gold_plan', 3, 'listing', '', '1', '', '1', '1', '0', 0, 0, 'ffe354', 0, 12, 30, 0, 10, '0', 3, '0', 0, 0, 'active'),
(24, 'featured', 5, 'package', '', '1', '', '0', '1', '1', 6, 4, '', 0, 5.95, 31, 90, 10, '0', 10, '0', 10, 0, 'active'),
(38, 'silver', 2, 'listing', '', '1', '', '0', '0', '0', 0, 0, '', 0, 5, 31, 0, 5, '0', 3, '0', 0, 0, 'active'),
(26, 'free_package', 4, 'package', '', '1', '', '0', '1', '1', 1, 1, '', 0, 0, 15, 7, 5, '0', 1, '0', 2, 0, 'active'),
(29, 'featured_paid', 6, 'featured', '', '1', '', '0', '0', '0', 0, 0, '', 0, 4.95, 31, 0, 0, '0', 0, '0', 0, 0, 'active');

DROP TABLE IF EXISTS `{db_prefix}listing_relations`;
CREATE TABLE `{db_prefix}listing_relations` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `Position` int(3) NOT NULL DEFAULT '0',
  `Category_ID` int(11) NOT NULL DEFAULT '0',
  `Group_ID` int(11) NOT NULL DEFAULT '0',
  `Fields` mediumtext NOT NULL,
  PRIMARY KEY (`ID`),
  KEY `Position` (`Position`,`Category_ID`,`Group_ID`)
) ENGINE=InnoDB CHARSET=utf8 COLLATE=utf8_general_ci;

DROP TABLE IF EXISTS `{db_prefix}listing_titles`;
CREATE TABLE `{db_prefix}listing_titles` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `Position` int(3) NOT NULL DEFAULT '0',
  `Category_ID` int(5) NOT NULL DEFAULT '0',
  `Field_ID` int(5) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `Kind_ID` (`Category_ID`)
) ENGINE=InnoDB CHARSET=utf8 COLLATE=utf8_general_ci;

DROP TABLE IF EXISTS `{db_prefix}listing_types`;
CREATE TABLE `{db_prefix}listing_types` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `Key` varchar(100) NOT NULL,
  `Order` int(11) NOT NULL,
  `Add_page` enum('0','1') NOT NULL DEFAULT '0',
  `Photo` enum('0','1') NOT NULL DEFAULT '1',
  `Photo_required` enum('0','1') NOT NULL DEFAULT '1',
  `Video` enum('0','1') NOT NULL DEFAULT '1',
  `Admin_only` enum('0','1') NOT NULL DEFAULT '0',
  `Statistics` enum('0','1') NOT NULL DEFAULT '1',
  `Links_type` enum('full','short','subdomain') NOT NULL DEFAULT 'full',
  `Color` varchar(6) NOT NULL,
  `Cat_general_cat` int(5) NOT NULL,
  `Cat_general_only` enum('0','1') NOT NULL DEFAULT '1',
  `Cat_position` varchar(50) NOT NULL DEFAULT 'left', /*todo remove -> box side*/
  `Cat_listing_counter` enum('0','1') NOT NULL DEFAULT '1', /*todo remove -> box options -> display_counter*/
  `Cat_order_type` enum('position','alphabetic') NOT NULL DEFAULT 'position',
  `Cat_custom_adding` enum('0','1') NOT NULL DEFAULT '0',
  `Cat_show_subcats` enum('0','1') NOT NULL DEFAULT '1', /*todo remove -> box options -> display_subcategories*/
  `Cat_hide_empty` enum('0','1') DEFAULT '0',
  `Cat_single_ID` int(6) NOT NULL,
  `Menu` ENUM('1','0') NOT NULL DEFAULT '0',
  `Menu_icon` VARCHAR(100) NOT NULL,
  `Ablock_pages` varchar(255) NOT NULL, /*todo remove -> box pages*/
  `Ablock_position` varchar(50) NOT NULL, /*todo remove -> box side*/
  `Ablock_visible_number` int(3) NOT NULL, /*todo remove -> box options -> visible_categories*/
  `Ablock_show_subcats` enum('0','1') NOT NULL, /*todo remove -> box options -> display_subcategories*/
  `Ablock_subcat_number` int(3) NOT NULL, /*todo remove -> box options -> subcategories_number*/
  `Ablock_scrolling` enum('0','1') NOT NULL DEFAULT '1', /*todo remove*/
  `Search` enum('0','1') NOT NULL DEFAULT '1',
  `Search_home` enum('0','1') NOT NULL DEFAULT '0',
  `Search_page` enum('0','1') NOT NULL DEFAULT '0',
  `Search_type` enum('0','1') NOT NULL DEFAULT '0',
  `Search_account` enum('0','1') NOT NULL DEFAULT '0',
  `Advanced_search` enum('0','1') NOT NULL DEFAULT '1',
  `On_map_search` enum('0','1') NOT NULL DEFAULT '0',
  `Myads_search` enum('0','1') NOT NULL DEFAULT '0',
  `Submit_method` enum('post','get') NOT NULL DEFAULT 'post',
  `Featured_blocks` enum('0','1') NOT NULL DEFAULT '1', /*todo remove*/
  `Arrange_field` varchar(50) NOT NULL,
  `Arrange_values` varchar(20) NOT NULL,
  `Arrange_search` enum('0','1') NOT NULL DEFAULT '0',
  `Arrange_featured` enum('0','1') NOT NULL DEFAULT '0', /*todo remove*/
  `Search_multi_categories` enum('0','1') NOT NULL DEFAULT '0',
  `Search_multicat_levels` int(2) DEFAULT NULL,
  `Search_multicat_phrases` enum('0','1') NOT NULL DEFAULT '0',
  `Count` int(11) NOT NULL DEFAULT '0',
  `Show_cents` ENUM('0','1') NOT NULL DEFAULT '1',
  `Status` enum('active','approval','trash') NOT NULL DEFAULT 'active',
  PRIMARY KEY (`ID`),
  KEY `Key` (`Key`)
) ENGINE=InnoDB CHARSET=utf8 COLLATE=utf8_general_ci;

DROP TABLE IF EXISTS `{db_prefix}categories`;
CREATE TABLE `{db_prefix}categories` (
  `ID` int(3) NOT NULL AUTO_INCREMENT,
  `Position` int(3) NOT NULL DEFAULT '0',
  `Path` varchar(255) NOT NULL DEFAULT '',
  `Level` int(3) NOT NULL DEFAULT '0',
  `Tree` mediumtext NOT NULL,
  `Parent_ID` int(11) NOT NULL DEFAULT '0',
  `Parent_IDs` varchar(255) NOT NULL,
  `Parent_keys` varchar(255) NOT NULL,
  `Type` enum('listings') NOT NULL DEFAULT 'listings',
  `Key` varchar(255) NOT NULL DEFAULT '',
  `Count` int(9) NOT NULL DEFAULT '0',
  `Lock` enum('0','1') NOT NULL DEFAULT '0',
  `Add` enum('0','1') NOT NULL DEFAULT '0',
  `Add_sub` enum('0','1') NOT NULL DEFAULT '0',
  `Modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `Menu` ENUM('1','0') NOT NULL DEFAULT '0',
  `Menu_icon` VARCHAR(100) NOT NULL,
  `Status` enum('active','approval','trash') NOT NULL DEFAULT 'active',
  PRIMARY KEY  (`ID`),
  KEY `Type` (`Type`),
  KEY `Key` (`Key`),
  KEY `Path` (`Path`),
  KEY `Parent_ID` (`Parent_ID`),
  KEY `Level` (`Level`),
  KEY `Lock` (`Lock`),
  KEY `Parent_IDs` (`Parent_IDs`)
) ENGINE=InnoDB CHARSET=utf8 COLLATE=utf8_general_ci;

DROP TABLE IF EXISTS `{db_prefix}map_amenities`;
CREATE TABLE `{db_prefix}map_amenities` (
  `ID` int(3) NOT NULL AUTO_INCREMENT,
  `Key` varchar(50) NOT NULL,
  `Default` enum('0','1') NOT NULL DEFAULT '0',
  `Position` int(3) NOT NULL,
  `Status` enum('active','approval') NOT NULL DEFAULT 'active',
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `{db_prefix}map_amenities` (`Key`, `Default`, `Position`, `Status`) VALUES
('cafe', '1', 2, 'active'),
('hospital', '1', 3, 'active'),
('night-club', '0', 4, 'active');

DROP TABLE IF EXISTS `{db_prefix}messages`;
CREATE TABLE `{db_prefix}messages` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `From` int(11) NOT NULL DEFAULT '0',
  `To` int(11) NOT NULL DEFAULT '0',
  `Admin` int(7) NOT NULL,
  `Message` text NOT NULL,
  `Date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `Status` enum('new','readed') NOT NULL DEFAULT 'new',
  `Remove` set('from','to') NOT NULL DEFAULT '',
  `Visitor_mail` varchar( 255 ) NOT NULL,
  `Visitor_phone` varchar( 255 ) NOT NULL,
  `Visitor_name` varchar( 255 ) NOT NULL,
  `Visitor_hash` varchar( 32 ) NOT NULL,
  `Listing_ID` int( 11 ) NOT NULL,
  `System` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `From` (`From`,`To`)
) ENGINE=InnoDB CHARSET=utf8 COLLATE=utf8_general_ci;

DROP TABLE IF EXISTS `{db_prefix}news`;
CREATE TABLE `{db_prefix}news` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `Category_ID` int(3) NOT NULL,
  `Date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `Path` varchar(255) NOT NULL DEFAULT '0',
  `Picture` varchar(32) NOT NULL,
  `Views` int NOT NULL,
  `Status` enum('active','approval','trash') NOT NULL DEFAULT 'active',
  PRIMARY KEY (`ID`),
  KEY `Status` (`Status`)
) ENGINE=InnoDB CHARSET=utf8 COLLATE=utf8_general_ci;

DROP TABLE IF EXISTS `{db_prefix}pages`;
CREATE TABLE `{db_prefix}pages` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `Parent_ID` int(5) NOT NULL DEFAULT '0',
  `Page_type` enum('system','static','external') NOT NULL DEFAULT 'static',
  `Login` enum('0','1') NOT NULL DEFAULT '0',
  `Key` varchar(255) NOT NULL DEFAULT '',
  `Position` int(3) NOT NULL DEFAULT '0',
  `Path` varchar(255) NOT NULL DEFAULT '',
  `Get_vars` varchar(255) NOT NULL DEFAULT '',
  `Controller` varchar(100) NOT NULL DEFAULT '',
  `Tpl` enum('0','1') NOT NULL DEFAULT '1',
  `Menus` varchar(20) NOT NULL DEFAULT '0',
  `Deny` mediumtext NOT NULL,
  `Plugin` varchar(100) NOT NULL DEFAULT '',
  `No_follow` enum('0','1') NOT NULL DEFAULT '0',
  `Modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `Status` enum('active','approval','trash') NOT NULL DEFAULT 'active',
  `Readonly` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `ID` (`ID`,`Page_type`),
  KEY `Reedonly` (`Readonly`),
  KEY `No_follow` (`No_follow`)
) ENGINE=InnoDB CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `{db_prefix}pages` (`ID`, `Parent_ID`, `Page_type`, `Login`, `Key`, `Position`, `Path`, `Get_vars`, `Controller`, `Tpl`, `Menus`, `Deny`, `Plugin`, `No_follow`, `Modified`, `Status`, `Readonly`) VALUES
(1, 0, 'system', '0', 'home', 1, '', '', 'home', '1', '1,3,5,7', '', '', '0', NOW(), 'active', '1'),
(2, 0, 'static', '0', 'about_us', 7, 'about-us', '', 'static', '1', '3,7', '', '', '0', NOW(), 'active', '0'),
(3, 0, 'system', '1', 'my_all_ads', 12, 'my-ads', '', 'my_listings', '1', '2', '', '', '1', NOW(), 'active', '1'),
(8, 0, 'system', '0', 'contact_us', 8, 'contact-us', '', 'contact_us', '1', '3', '', '', '0', NOW(), 'active', '0'),
(9, 0, 'static', '0', 'terms_of_use', 9, 'terms-of-use', '', 'static', '1', '3,7', '', '', '0', NOW(), 'active', '0'),
(10, 0, 'static', '0', 'privacy_policy', 10, 'privacy-policy', '', 'static', '1', '3,7', '', '', '0', NOW(), 'active', '0'),
(11, 0, 'system', '0', 'search', 3, 'search', '', 'search', '1', '3', '', '', '0', NOW(), 'active', '1'),
(12, 0, 'system', '0', 'registration', 0, 'registration', '', 'registration', '1', '0', '', '', '1', NOW(), 'active', '1'),
(13, 0, 'system', '0', 'login', 0, 'login', '', 'login', '1', '0', '', '', '1', NOW(), 'active', '1'),
(15, 0, 'system', '1', 'my_profile', 7, 'my-profile', '', 'profile', '1', '2', '1', '', '1', NOW(), 'active', '1'),
(16, 0, 'system', '0', 'add_listing', 10, 'add-listing', '', 'add_listing', '1', '1,2', '', '', '1', NOW(), 'active', '1'),
(20, 0, 'system', '0', 'confirm', 12, 'confirm', '', 'confirm', '1', '', '', '', '1', NOW(), 'active', '1'),
(21, 0, 'system', '0', 'remind', 13, 'reset-password', '', 'remind', '1', '', '', '', '1', NOW(), 'active', '1'),
(22, 0, 'system', '0', 'payment', 0, 'payment', '', 'payment', '1', '', '', '', '1', NOW(), 'active', '1'),
(25, 0, 'system', '0', 'view_details', 15, 'listing-details', '', 'listing_details', '1', '', '', '', '0', NOW(), 'active', '1'),
(28, 0, 'system', '1', 'edit_listing', 17, 'edit-listing', '', 'edit_listing', '1', '', '', '', '1', NOW(), 'active', '1'),
(29, 0, 'system', '1', 'upgrade_listing', 18, 'upgrade-listing', '', 'upgrade_listing', '1', '', '', '', '1', NOW(), 'active', '1'),
(30, 0, 'system', '0', 'news', 8, 'news', '', 'news', '1', '3,7', '', '', '0', NOW(), 'active', '1'),
(35, 0, 'system', '0', 'my_favorites', 8, 'my-favorites', '', 'my_favorite', '1', '2,3,5', '', '', '1', NOW(), 'active', '1'),
(37, 0, 'system', '1', 'saved_search', 9, 'saved-search', '', 'saved_search', '1', '2', '', '', '1', NOW(), 'active', '1'),
(38, 0, 'system', '0', 'rss_feed', 19, 'rss-feed', '', 'rss_feed', '0', '', '', '', '0', NOW(), 'active', '1'),
(39, 0, 'system', '0', 'print', 20, 'print', '', 'print', '0', '', '', '', '1', NOW(), 'active', '1'),
(40, 0, 'system', '1', 'my_messages', 6, 'my-messages', '', 'my_messages', '1', '2', '', '', '1', NOW(), 'active', '1'),
(42, 0, 'system', '0', 'listings', 5, 'recently-added', '', 'recently_added', '1', '3', '', '', '0', NOW(), 'active', '1'),
(43, 0, 'static', '0', '404', 73, '404', '', 'static', '1', '', '', '', '1', NOW(), 'active', '1'),
(312, 0, 'system', '1', 'my_packages', 50, 'my-packages', '', 'my_packages', '1', '2', '', '', '1', NOW(), 'active', '0'),
(309, 0, 'system', '0', 'at_dealer', 47, 'dealer-accounts', '', 'account_type', '1', '1,6', '', '', '0', NOW(), 'active', '1'),
(327, 0, 'system', '0', 'listing_remove', 53, 'listing-remove', '', 'listing_remove', '1', '', '', '', '1', NOW(), 'active', '0'),
(328, 0, 'system', '1', 'payment_history', 54, 'payment-history', '', 'payment_history', '1', '2', '', '', '1', NOW(), 'active', '0'),
(340, 0, 'system', '1', 'my_agents', 55, 'my-agents', '', 'my_agents', '1', '2', '', '', '1', NOW(), 'active', '0');

DROP TABLE IF EXISTS `{db_prefix}plugins`;
CREATE TABLE `{db_prefix}plugins` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `Key` varchar(50) NOT NULL DEFAULT '',
  `Class` varchar(25) NOT NULL DEFAULT '',
  `Name` varchar(100) NOT NULL DEFAULT '',
  `Description` varchar(255) NOT NULL DEFAULT '',
  `Version` varchar(20) NOT NULL DEFAULT '',
  `Controller` varchar(100) NOT NULL DEFAULT '',
  `Fcontroller` varchar(50) NOT NULL DEFAULT '',
  `Files` text NOT NULL,
  `Uninstall` text NOT NULL,
  `Status` enum('active','approval') NOT NULL DEFAULT 'approval',
  `Install` enum('0','1') NOT NULL DEFAULT '0',
  `Custom` ENUM('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `Key` (`Key`,`Status`)
) ENGINE=InnoDB CHARSET=utf8 COLLATE=utf8_general_ci;

DROP TABLE IF EXISTS `{db_prefix}search_forms_relations`;
CREATE TABLE `{db_prefix}search_forms_relations` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `Position` int(3) NOT NULL DEFAULT '0',
  `Category_ID` int(11) NOT NULL DEFAULT '0',
  `Group_ID` int(11) NOT NULL DEFAULT '0',
  `Fields` mediumtext NOT NULL,
  PRIMARY KEY (`ID`),
  KEY `Position` (`Position`,`Category_ID`,`Group_ID`)
) ENGINE=InnoDB CHARSET=utf8 COLLATE=utf8_general_ci;

DROP TABLE IF EXISTS `{db_prefix}short_forms`;
CREATE TABLE `{db_prefix}short_forms` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `Position` int(3) NOT NULL DEFAULT '0',
  `Category_ID` int(11) NOT NULL DEFAULT '0',
  `Field_ID` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `Kind_ID` (`Category_ID`)
) ENGINE=InnoDB CHARSET=utf8 COLLATE=utf8_general_ci;

DROP TABLE IF EXISTS `{db_prefix}sorting_forms`;
CREATE TABLE `{db_prefix}sorting_forms` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `Position` int(3) NOT NULL DEFAULT '0',
  `Category_ID` int(11) NOT NULL DEFAULT '0',
  `Field_ID` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `Kind_ID` (`Category_ID`)
) ENGINE=InnoDB CHARSET=utf8 COLLATE=utf8_general_ci;

DROP TABLE IF EXISTS `{db_prefix}tmp_categories`;
CREATE TABLE `{db_prefix}tmp_categories` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `Parent_ID` int(11) DEFAULT NULL,
  `Account_ID` int(11) DEFAULT NULL,
  `Session_hash` varchar(32) DEFAULT NULL,
  `Listing_ID` int(11) DEFAULT NULL,
  `Name` varchar(255) DEFAULT NULL,
  `Date` datetime DEFAULT NULL,
  `Status` enum('active','approval','trash') DEFAULT 'approval',
  PRIMARY KEY (`ID`),
  KEY `Parent_ID` (`Parent_ID`,`Status`)
) ENGINE=InnoDB CHARSET=utf8 COLLATE=utf8_general_ci;

DROP TABLE IF EXISTS `{db_prefix}transactions`;
CREATE TABLE `{db_prefix}transactions` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `Service` varchar(50) NOT NULL,
  `Account_ID` int(8) NOT NULL,
  `Item_ID` int(11) NOT NULL DEFAULT '0',
  `Plan_ID` int(11) NOT NULL DEFAULT '0',
  `Txn_ID` varchar(32) NOT NULL DEFAULT '0',
  `Total` double NOT NULL DEFAULT '0',
  `Gateway` varchar(50) NOT NULL DEFAULT '',
  `Date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `Status` enum('paid','unpaid','trash') NOT NULL DEFAULT 'unpaid',
  `Item_name` varchar(255) NOT NULL,
  `Plan_key` varchar(100) NOT NULL,
  `Item_data` text NOT NULL,
  PRIMARY KEY (`ID`),
  KEY `Listing_ID` (`Item_ID`,`Plan_ID`)
) ENGINE=InnoDB CHARSET=utf8 COLLATE=utf8_general_ci;

DROP TABLE IF EXISTS `{db_prefix}trash_box`;
CREATE TABLE `{db_prefix}trash_box` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `Zones` mediumtext NOT NULL,
  `Key` varchar(255) NOT NULL DEFAULT '0',
  `Criterion` mediumtext NOT NULL,
  `Class_name` varchar(20) NOT NULL,
  `Restore_method` varchar(35) NOT NULL,
  `Remove_method` varchar(35) NOT NULL,
  `Lang_keys` text NOT NULL,
  `Admin_ID` int(11) NOT NULL DEFAULT '0',
  `Date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `Plugin` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB CHARSET=utf8 COLLATE=utf8_general_ci;

DROP TABLE IF EXISTS `{db_prefix}login_attempts`;
CREATE TABLE `{db_prefix}login_attempts` (
  `IP` varchar(25) NOT NULL,
  `Date` datetime NOT NULL,
  `Status` enum('fail','success') NOT NULL DEFAULT 'success',
  `Interface` enum('admin','user') NOT NULL DEFAULT 'user',
  `Username` varchar(50) NOT NULL,
  KEY `IP` (`IP`),
  KEY `Status` (`Status`)
) ENGINE=InnoDB CHARSET=utf8 COLLATE=utf8_general_ci;

DROP TABLE IF EXISTS `{db_prefix}payment_gateways`;
CREATE TABLE `{db_prefix}payment_gateways` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `Key` varchar(255) NOT NULL,
  `Position` int(11) NOT NULL DEFAULT '0',
  `Plugin` varchar(50) NOT NULL,
  `Default` enum('0','1') NOT NULL,
  `Recurring` enum('0','1') NOT NULL DEFAULT '0',
  `Recurring_editable` enum('0','1') NOT NULL DEFAULT '0',
  `Type` enum('online','offline') NOT NULL DEFAULT 'online',
  `Status` enum('active','approval','trash') NOT NULL DEFAULT 'active',
  `Required_options` text NOT NULL,
  `Form_type` enum('offsite','default','custom') NOT NULL DEFAULT 'offsite',
  `Parallel` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `Key` (`Key`),
  KEY `Status` (`Status`),
  KEY `Position` (`Position`)
) ENGINE=InnoDB CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `{db_prefix}payment_gateways` (`ID`,`Key`,`Position`,`Plugin`,`Status`,`Recurring`,`Recurring_editable`,`Default`,`Type`) VALUES
(1, 'paypal', 1, '', 'active', '0', '1', '1', 'online'),
(2, '2co', 2, '', 'active', '0', '0', '0', 'online');

DROP TABLE IF EXISTS `{db_prefix}phone_clicks`;
CREATE TABLE `{db_prefix}phone_clicks` (
  `ID` INT(11) NOT NULL AUTO_INCREMENT,
  `Listing_ID` INT(11) NOT NULL DEFAULT 0,
  `Account_ID` INT(11) NOT NULL DEFAULT 0,
  `Date` DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00',
  `IP` VARCHAR(30) NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  INDEX (`Listing_ID`),
  INDEX (`Date`)
) ENGINE=InnoDB CHARSET=utf8 COLLATE=utf8_general_ci;

DROP TABLE IF EXISTS `{db_prefix}subscription_plans`;
CREATE TABLE `{db_prefix}subscription_plans` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `Service` enum('listing','membership','banner') NOT NULL DEFAULT 'listing',
  `Plan_ID` int(11) NOT NULL DEFAULT '0',
  `Status` enum('active','approval','trash') NOT NULL DEFAULT 'active',
  `Total` double NOT NULL DEFAULT '0',
  `Period` enum('day','week','month','year','') NOT NULL DEFAULT 'month',
  `Period_total` int(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB CHARSET=utf8 COLLATE=utf8_general_ci;

DROP TABLE IF EXISTS `{db_prefix}subscriptions`;
CREATE TABLE `{db_prefix}subscriptions` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `Service` varchar(30) NOT NULL DEFAULT '',
  `Account_ID` int(11) NOT NULL DEFAULT '0',
  `Item_ID` int(11) NOT NULL DEFAULT '0',
  `Plan_ID` int(4) NOT NULL DEFAULT '0',
  `Total` double NOT NULL DEFAULT '0',
  `Gateway_ID` int(4) NOT NULL DEFAULT '0',
  `Date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `Txn_ID` text NOT NULL,
  `Status` enum('active','canceled','approval','trash') NOT NULL DEFAULT 'active',
  `Subscription_ID` varchar(255) NOT NULL DEFAULT '',
  `Customer_ID` varchar(100) NOT NULL DEFAULT '',
  `Count` int(11) NOT NULL DEFAULT '0',
  `Item_name` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB CHARSET=utf8 COLLATE=utf8_general_ci;

DROP TABLE IF EXISTS `{db_prefix}membership_plans`;
CREATE TABLE `{db_prefix}membership_plans` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `Key` varchar(255) NOT NULL DEFAULT '',
  `Allow_for` varchar(255) NOT NULL DEFAULT '',
  `Price` double DEFAULT NULL,
  `Services` text NOT NULL,
  `Status` enum('active','approval','trash') NOT NULL DEFAULT 'active',
  `Plan_period` int(5) NOT NULL,
  `Image` int(5) NOT NULL DEFAULT '0',
  `Image_unlim` enum('0','1') NOT NULL DEFAULT '0',
  `Video` int(5) NOT NULL,
  `Video_unlim` enum('0','1') NOT NULL DEFAULT '0',
  `Listing_number` int(11) NOT NULL DEFAULT '0',
  `Color` varchar(6) NOT NULL,
  `Position` int(4) NOT NULL DEFAULT '0',
  `Subscription` enum('0','1') NOT NULL DEFAULT '0',
  `Featured_listing` enum('0','1') NOT NULL DEFAULT '0',
  `Advanced_mode` enum('0','1') NOT NULL DEFAULT '0',
  `Standard_listings` int(4) NOT NULL,
  `Featured_listings` int(4) NOT NULL,
  `Limit` int(8) NOT NULL DEFAULT '0',
  `Cross` int(6) NOT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB CHARSET=utf8 COLLATE=utf8_general_ci;

DROP TABLE IF EXISTS `{db_prefix}membership_services`;
CREATE TABLE `{db_prefix}membership_services` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `Key` varchar(255) NOT NULL DEFAULT '',
  `Price` double NOT NULL DEFAULT '0',
  `Position` int(4) NOT NULL DEFAULT '0',
  `Status` enum('active','approval','trash') NOT NULL DEFAULT 'active',
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `{db_prefix}membership_services` (`ID`, `Key`, `Price`, `Position`, `Status`) VALUES
(1, 'add_listing', 0, 1, 'active'),
(2, 'view_contacts', 0, 2, 'active'),
(3, 'contact_owner', 0, 3, 'active'),
(4, 'view_photos', 0, 4, 'active'),
(5, 'featured', 0, 5, 'active'),
(6, 'agency', 0, 6, 'active');

DROP TABLE IF EXISTS `{db_prefix}auth_tokens`;
CREATE TABLE `{db_prefix}auth_tokens` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `Selector` varchar(12) DEFAULT NULL,
  `Token` varchar(64) DEFAULT NULL,
  `Account_ID` int(11) NOT NULL,
  `Expires` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
   PRIMARY KEY (`ID`)
) ENGINE=InnoDB CHARSET=utf8 COLLATE=utf8_general_ci;

DROP TABLE IF EXISTS `{db_prefix}slides`;
CREATE TABLE `{db_prefix}slides` (
  `ID` int(4) NOT NULL AUTO_INCREMENT,
  `Picture` varchar(32) NOT NULL,
  `URL` varchar(256) NOT NULL,
  `Position` int(4) NOT NULL,
  `Status` enum('active','approval') NOT NULL DEFAULT 'active',
  PRIMARY KEY (`ID`),
  KEY `Status` (`Status`)
) ENGINE=InnoDB CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `{db_prefix}slides` (`ID`, `Picture`, `URL`, `Position`, `Status`) VALUES
(1, '927788009.webp', 'https://www.flynax.com', 1, 'active'),
(2, '157761828.webp', 'https://www.flynax.com', 2, 'active');

DROP TABLE IF EXISTS `{db_prefix}2co_products`;
CREATE TABLE `{db_prefix}2co_products` (
  `ID` int(6) NOT NULL AUTO_INCREMENT,
  `Item_ID` int(6) NOT NULL,
  `Service` varchar(20) NOT NULL DEFAULT '',
  `Code` varchar(20) NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `Group_index` (`Item_ID`,`Service`)
) ENGINE=InnoDB CHARSET=utf8 COLLATE=utf8_general_ci;

DROP TABLE IF EXISTS `{db_prefix}async_tasks`;
CREATE TABLE `{db_prefix}async_tasks` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `Created_at` DATETIME DEFAULT CURRENT_TIMESTAMP,
  `Type` ENUM('translate_listing', 'translate_account', 'send_email', 'other'),
  `Task` TEXT,
  `Data` TEXT,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB CHARSET=utf8 COLLATE=utf8_general_ci;

DROP TABLE IF EXISTS `{db_prefix}news_categories`;
CREATE TABLE `{db_prefix}news_categories` (
  `ID` INT(3) NOT NULL AUTO_INCREMENT,
  `Path` VARCHAR(255) NOT NULL DEFAULT '',
  `Status` ENUM('active','approval','trash') NOT NULL DEFAULT 'active',
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `{db_prefix}news_categories` (`ID`, `Path`, `Status`) VALUES
(1, 'politics', 'active'),
(2, 'education', 'active'),
(3, 'health', 'active'),
(4, 'science', 'active'),
(5, 'climate', 'active'),
(6, 'sports', 'active'),
(7, 'business', 'active'),
(8, 'tech', 'active'),
(9, 'economy', 'active'),
(10, 'arts', 'active'),
(11, 'lifestyle', 'active'),
(12, 'fashion', 'active');

DROP TABLE IF EXISTS `{db_prefix}listings_incomplete`;
CREATE TABLE `{db_prefix}listings_incomplete` (
  `Listing_ID` BIGINT NOT NULL,
  `Date` DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`Listing_ID`)
) ENGINE=InnoDB CHARSET=utf8 COLLATE=utf8_general_ci;


-- Dumping data for realty package

INSERT INTO `{db_prefix}lang_keys` (`Code`, `Module`, `JS`, `Key`, `Value`, `Target_key`, `Modified`, `Plugin`, `Status`) VALUES
('en', 'common', '0', 'visit_owner_page', 'Visit Agent\'s Page', '', '0', '', 'active'),
('en', 'common', '0', 'contact_owner', 'Contact Agent', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'contact_owner_hint', 'To contact the agent please', '', '0', '', 'active'),
('en', 'common', '0', 'membership_services+name+contact_owner', 'Contact agents', '', '0', '', 'active'),
('en', 'common', '0', 'account_types+name+buyer', 'Buyer', '', '0', '', 'active'),
('en', 'common', '0', 'account_types+desc+buyer', 'It is a buyer <span style=\"color:#a52a2a;\"><span style=\"background-color: rgb(215, 0);\">account!</span></span>', '', '0', '', 'active'),
('en', 'common', '0', 'account_types+name+visitor', 'Visitor', '', '0', '', 'active'),
('en', 'common', '0', 'account_types+name+dealer', 'Agent', '', '0', '', 'active'),
('en', 'common', '0', 'account_types+desc+dealer', '<p>Using the agent account type gives you a number of additional options and benefits!</p>', '', '0', '', 'active'),
('en', 'common', '0', 'other_owner_listings', 'Other listings of the Agent', '', '0', '', 'active'),
('en', 'common', '0', 'seller_info', 'Agent Info', '', '0', '', 'active'),
('en', 'common', '0', 'seller_thumbnail', 'Agent Thumbnail', '', '0', '', 'active'),
('en', 'common', '0', 'account_listings', 'Agent\'s other Ads', '', '0', '', 'active'),
('en', 'admin', '1', 'ext_owner', 'Agent', '', '0', '', 'active'),
('en', 'common', '0', 'owner', 'Agent', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'add_listing_notice', 'Please select a property type and category for your listing.', '', '0', '', 'active'),
('en', 'common', '0', 'contact_the_owner', 'Contact Agent', '', '0', '', 'active'),
('en', 'admin', '0', 'config+name+messages_save_visitor_message', 'Send visitors\' messages to sellers to \'My Messages\' box.', 'settings', '0', '', 'active'),
('en', 'frontEnd', '0', 'dealer_name_a_z', 'Agent Name A-Z', '', '0', '', 'active'),
('en', 'box', '0', 'blocks+name+account_search', 'Search for Agents', 'account_search', '0', '', 'active'),
('en', 'box', '0', 'blocks+name+account_page_info', 'Agent Info', 'account_page_info', '0', '', 'active'),
('en', 'box', '0', 'blocks+name+account_page_location', 'Agent Location', 'account_page_location', '0', '', 'active'),
('en', 'frontEnd', '0', 'contact_form_not_available', 'The membership plan doesn\'t allow you to contact the agent.', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'no_accounts_created', 'There are no featured agents. [click] here to be the first.', '', '0', '', 'active'),
('en', 'admin', '0', 'config+des+alphabetic_field', 'search for Agents will be done based on a field selected from the list.', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+alphabetic_field', 'Agents search priority', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+dealers_per_page', 'Number of agents per page', 'settings', '0', '', 'active'),
('en', 'frontEnd', '0', 'no_dealers_found', 'No agents found by your search criteria.', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'no_dealers', 'There are no agents in the category.', '', '0', '', 'active'),
('en', 'admin', '0', 'config+name+security_img_contact_seller', 'Captcha on the Contact Agent form', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+messages_allow_free', 'Allow visitors to contact agents through the contact form', 'settings', '0', '', 'active'),
('en', 'common', '0', 'no_dealer_listings', 'The agent hasn\'t added any listings yet.', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'show_map', 'Show the Map', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'show_states', 'Show a list of States', '', '0', '', 'active'),
('en', 'box', '0', 'blocks+name+ltcb_listings', 'Browse by Property Type', 'ltcb_listings', '0', '', 'active'),
('en', 'box', '0', 'blocks+name+ltcb_services', 'Services', 'ltcb_services', '0', '', 'active'),
('en', 'box', '0', 'blocks+name+ltsb_services', 'Refine search', 'ltsb_services', '0', '', 'active'),
('en', 'common', '0', 'pages+name+at_dealer', 'Agents', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'pages+title+at_dealer', 'Agents', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'pages+title+lt_listings', 'Property', '', '0', '', 'active'),
('en', 'common', '0', 'pages+name+lt_listings', 'Property', '', '0', '', 'active'),
('en', 'common', '0', 'pages+name+my_listings', 'My Properties', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'pages+title+search', 'Search for property', '', '0', '', 'active'),
('en', 'common', '0', 'pages+name+lt_services', 'Services', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'pages+title+lt_services', 'Services', '', '0', '', 'active'),
('en', 'common', '0', 'pages+name+my_services', 'My Services', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'pages+title+my_services', 'My Services', '', '0', '', 'active'),
('en', 'common', '0', 'search_forms+name+listings_quick', 'Listings', '', '0', '', 'active'),
('en', 'common', '0', 'search_forms+name+services_quick', 'Services', '', '0', '', 'active'),
('en', 'common', '0', 'search_forms+name+services_advanced', 'Services', '', '0', '', 'active'),
('en', 'common', '0', 'listing_groups+name+location', 'Location', '', '0', '', 'active'),
('en', 'common', '0', 'listing_types+name+listings', 'Property', '', '0', '', 'active'),
('en', 'common', '0', 'listing_fields+name+condition_2', 'Used', '', '0', '', 'active'),
('en', 'common', '0', 'listing_fields+name+condition_1', 'New', '', '0', '', 'active'),
('en', 'common', '0', 'listing_fields+name+posted_by', 'Posted by', '', '0', '', 'active'),
('en', 'common', '0', 'listing_fields+name+keyword_search', 'Keyword Search', '', '0', '', 'active'),
('en', 'common', '0', 'listing_fields+description+account_address_on_map', 'You will not have to enter your address every time when posting ads but the system will show your account address on the Google Map in your listings', '', '0', '', 'active'),
('en', 'common', '0', 'listing_fields+name+Category_ID', 'Category', '', '0', '', 'active'),
('en', 'common', '0', 'listing_fields+name+address', 'Address', '', '0', '', 'active'),
('en', 'common', '0', 'listing_fields+name+zip', 'ZIP code', '', '0', '', 'active'),
('en', 'common', '0', 'listing_fields+name+account_address_on_map', 'Account Address on the Maps', '', '0', '', 'active'),
('en', 'common', '0', 'listing_fields+name+additional_information', 'Description', '', '0', '', 'active'),
('en', 'common', '0', 'listing_fields+name+time_frame', 'Rental Period', '', '0', '', 'active'),
('en', 'common', '0', 'listing_fields+name+title', 'Title', '', '0', '', 'active'),
('en', 'common', '0', 'listing_fields+name+price', 'Price', '', '0', '', 'active'),
('en', 'common', '0', 'listing_fields+name+condition', 'Condition', '', '0', '', 'active'),
('en', 'common', '0', 'listing_fields+name+sale_rent', 'Property for', '', '0', '', 'active'),
('en', 'common', '0', 'listing_fields+name+sale_rent_2', 'Rent', '', '0', '', 'active'),
('en', 'common', '0', 'listing_fields+name+sale_rent_1', 'Sale', '', '0', '', 'active'),
('en', 'common', '0', 'listing_fields+name+bedrooms', 'Bedrooms', '', '0', '', 'active'),
('en', 'common', '0', 'listing_fields+name+bathrooms', 'Bathrooms', '', '0', '', 'active'),
('en', 'common', '0', 'listing_fields+name+square_feet', 'Square Feet', '', '0', '', 'active'),
('en', 'common', '0', 'listing_fields+name+built_in', 'Built', '', '0', '', 'active'),
('en', 'common', '0', 'listing_fields+name+garage', 'Garage', '', '0', '', 'active'),
('en', 'common', '0', 'listing_fields+name+number_of_floors', 'Number of Floors', '', '0', '', 'active'),
('en', 'common', '0', 'listing_fields+name+property_features', 'Property Features', '', '0', '', 'active'),
('en', 'common', '0', 'listing_fields+name+property_features_3', 'Dining Room', '', '0', '', 'active'),
('en', 'common', '0', 'listing_fields+name+property_features_2', 'Central Air', '', '0', '', 'active'),
('en', 'common', '0', 'listing_fields+name+property_features_1', 'Basement', '', '0', '', 'active'),
('en', 'common', '0', 'listing_fields+name+property_features_4', 'Disability Features', '', '0', '', 'active'),
('en', 'common', '0', 'listing_fields+name+property_features_5', 'Laundry Room', '', '0', '', 'active'),
('en', 'common', '0', 'listing_fields+name+property_features_6', 'Fireplace', '', '0', '', 'active'),
('en', 'common', '0', 'listing_fields+name+property_features_7', 'Main Floor Bathroom', '', '0', '', 'active'),
('en', 'common', '0', 'listing_fields+name+property_features_8', 'Main Floor Bedroom', '', '0', '', 'active'),
('en', 'common', '0', 'listing_fields+name+property_features_9', 'Spa/Hot Tub', '', '0', '', 'active'),
('en', 'common', '0', 'listing_fields+name+property_features_10', 'Swimming Pool', '', '0', '', 'active'),
('en', 'common', '0', 'listing_fields+name+property_features_11', 'Family Room', '', '0', '', 'active'),
('en', 'common', '0', 'listing_fields+name+lot_size', 'Lot Size', '', '0', '', 'active'),
('en', 'common', '0', 'listing_fields+name+phone', 'Phone', '', '0', '', 'active'),
('en', 'common', '0', 'listing_fields+name+website_url', 'Website URL', '', '0', '', 'active'),
('en', 'common', '0', 'listing_fields+description+website_url', 'Please add the Website URL with http://', '', '0', '', 'active'),
('en', 'common', '0', 'listing_fields+name+time_frame_1', 'Per hour', '', '0', '', 'active'),
('en', 'common', '0', 'listing_fields+name+time_frame_2', 'Per day', '', '0', '', 'active'),
('en', 'common', '0', 'listing_fields+name+time_frame_3', 'Per week', '', '0', '', 'active'),
('en', 'common', '0', 'listing_fields+name+time_frame_4', 'Per month', '', '0', '', 'active'),
('en', 'common', '0', 'listing_fields+name+time_frame_5', 'Per year', '', '0', '', 'active'),
('en', 'common', '0', 'listing_types+name+services', 'Services', '', '0', '', 'active'),
('en', 'common', '0', 'listing_plans+des+silver', 'The bronze plan allows you to add one single listing with 10 images and 3 videos.', '', '0', '', 'active'),
('en', 'common', '0', 'listing_plans+des+featured', 'The plans package allows you to add 15 standard listings and 5 featured listings.', '', '0', '', 'active'),
('en', 'category', '0', 'categories+name+chateau', 'Chateau', '', '0', '', 'active'),
('en', 'category', '0', 'categories+title+chateau', 'Chateau', '', '0', '', 'active'),
('en', 'category', '0', 'categories+name+castle', 'Castle', '', '0', '', 'active'),
('en', 'category', '0', 'categories+title+castle', 'Castle', '', '0', '', 'active'),
('en', 'category', '0', 'categories+name+cabin_cottage', 'Cabin/Cottage', '', '0', '', 'active'),
('en', 'category', '0', 'categories+title+cabin_cottage', 'Cabin/Cottage', '', '0', '', 'active'),
('en', 'category', '0', 'categories+name+business', 'Business', '', '0', '', 'active'),
('en', 'category', '0', 'categories+title+business', 'Business', '', '0', '', 'active'),
('en', 'category', '0', 'categories+name+bungalow', 'Bungalow', '', '0', '', 'active'),
('en', 'category', '0', 'categories+title+bungalow', 'Bungalow', '', '0', '', 'active'),
('en', 'category', '0', 'categories+name+bed_and_breakfast', 'Bed and Breakfast', '', '0', '', 'active'),
('en', 'category', '0', 'categories+title+bed_and_breakfast', 'Bed and Breakfast', '', '0', '', 'active'),
('en', 'category', '0', 'categories+name+beach_property', 'Beach Property', '', '0', '', 'active'),
('en', 'category', '0', 'categories+title+beach_property', 'Beach Property', '', '0', '', 'active'),
('en', 'category', '0', 'categories+name+apartment_complex', 'Apartment Complex', '', '0', '', 'active'),
('en', 'category', '0', 'categories+title+apartment_complex', 'Apartment Complex', '', '0', '', 'active'),
('en', 'category', '0', 'categories+name+apartment', 'Apartment', '', '0', '', 'active'),
('en', 'category', '0', 'categories+title+apartment', 'Apartment', '', '0', '', 'active'),
('en', 'category', '0', 'categories+name+coastal_property', 'Coastal Property', '', '0', '', 'active'),
('en', 'category', '0', 'categories+title+coastal_property', 'Coastal Property', '', '0', '', 'active'),
('en', 'category', '0', 'categories+name+commercial_property', 'Commercial Property', '', '0', '', 'active'),
('en', 'category', '0', 'categories+title+commercial_property', 'Commercial Property', '', '0', '', 'active'),
('en', 'category', '0', 'categories+name+condo', 'Condo', '', '0', '', 'active'),
('en', 'category', '0', 'categories+title+condo', 'Condo', '', '0', '', 'active'),
('en', 'category', '0', 'categories+name+condo_hotel', 'Condo Hotel', '', '0', '', 'active'),
('en', 'category', '0', 'categories+title+condo_hotel', 'Condo Hotel', '', '0', '', 'active'),
('en', 'category', '0', 'categories+name+duplex', 'Duplex', '', '0', '', 'active'),
('en', 'category', '0', 'categories+title+duplex', 'Duplex', '', '0', '', 'active'),
('en', 'category', '0', 'categories+name+farm_ranch', 'Farm/Ranch', '', '0', '', 'active'),
('en', 'category', '0', 'categories+title+farm_ranch', 'Farm/Ranch', '', '0', '', 'active'),
('en', 'category', '0', 'categories+name+guest_house', 'Guest House', '', '0', '', 'active'),
('en', 'category', '0', 'categories+title+guest_house', 'Guest House', '', '0', '', 'active'),
('en', 'category', '0', 'categories+name+hotel', 'Hotel', '', '0', '', 'active'),
('en', 'category', '0', 'categories+title+hotel', 'Hotel', '', '0', '', 'active'),
('en', 'category', '0', 'categories+name+house', 'House', '', '0', '', 'active'),
('en', 'category', '0', 'categories+title+house', 'House', '', '0', '', 'active'),
('en', 'category', '0', 'categories+name+inn_lodge', 'Inn/Lodge', '', '0', '', 'active'),
('en', 'category', '0', 'categories+title+inn_lodge', 'Inn/Lodge', '', '0', '', 'active'),
('en', 'category', '0', 'categories+name+island', 'Island', '', '0', '', 'active'),
('en', 'category', '0', 'categories+title+island', 'Island', '', '0', '', 'active'),
('en', 'category', '0', 'categories+name+loft', 'Loft', '', '0', '', 'active'),
('en', 'category', '0', 'categories+title+loft', 'Loft', '', '0', '', 'active'),
('en', 'category', '0', 'categories+name+villa', 'Villa', '', '0', '', 'active'),
('en', 'category', '0', 'categories+title+villa', 'Villa', '', '0', '', 'active'),
('en', 'category', '0', 'categories+name+other', 'Other', '', '0', '', 'active'),
('en', 'category', '0', 'categories+title+other', 'Other', '', '0', '', 'active'),
('en', 'category', '0', 'categories+name+additions_remodels', 'Additions & Remodels', '', '0', '', 'active'),
('en', 'category', '0', 'categories+title+additions_remodels', 'Additions & Remodels', '', '0', '', 'active'),
('en', 'category', '0', 'categories+name+appliances', 'Appliances', '', '0', '', 'active'),
('en', 'category', '0', 'categories+title+appliances', 'Appliances', '', '0', '', 'active'),
('en', 'category', '0', 'categories+name+builders_architects_desig', 'Builders, Architects & Desig', '', '0', '', 'active'),
('en', 'category', '0', 'categories+title+builders_architects_desig', 'Builders, Architects & Desig', '', '0', '', 'active'),
('en', 'category', '0', 'categories+name+carpentry_cabinets', 'Carpentry & Cabinets', '', '0', '', 'active'),
('en', 'category', '0', 'categories+title+carpentry_cabinets', 'Carpentry & Cabinets', '', '0', '', 'active'),
('en', 'category', '0', 'categories+name+cleaning_services', 'Cleaning Services', '', '0', '', 'active'),
('en', 'category', '0', 'categories+title+cleaning_services', 'Cleaning Services', '', '0', '', 'active'),
('en', 'category', '0', 'categories+name+concrete_brick_stone', 'Concrete, Brick & Stone', '', '0', '', 'active'),
('en', 'category', '0', 'categories+title+concrete_brick_stone', 'Concrete, Brick & Stone', '', '0', '', 'active'),
('en', 'category', '0', 'categories+name+consumer_guides', 'Consumer Guides', '', '0', '', 'active'),
('en', 'category', '0', 'categories+title+consumer_guides', 'Consumer Guides', '', '0', '', 'active'),
('en', 'category', '0', 'categories+name+design_ideas', 'Design Ideas', '', '0', '', 'active'),
('en', 'category', '0', 'categories+title+design_ideas', 'Design Ideas', '', '0', '', 'active'),
('en', 'category', '0', 'categories+name+electrical_telephone_data', 'Electrical, Telephone & Data', '', '0', '', 'active'),
('en', 'category', '0', 'categories+title+electrical_telephone_data', 'Electrical, Telephone & Data', '', '0', '', 'active'),
('en', 'category', '0', 'categories+name+expert_advice', 'Expert Advice', '', '0', '', 'active'),
('en', 'category', '0', 'categories+title+expert_advice', 'Expert Advice', '', '0', '', 'active'),
('en', 'category', '0', 'categories+name+home_construction', 'Home Construction', '', '0', '', 'active'),
('en', 'category', '0', 'categories+title+home_construction', 'Home Construction', '', '0', '', 'active'),
('en', 'category', '0', 'categories+name+painting_staining', 'Painting & Staining', '', '0', '', 'active'),
('en', 'category', '0', 'categories+title+painting_staining', 'Painting & Staining', '', '0', '', 'active'),
('en', 'category', '0', 'categories+name+plumbing', 'Plumbing', '', '0', '', 'active'),
('en', 'category', '0', 'categories+title+plumbing', 'Plumbing', '', '0', '', 'active'),
('en', 'category', '0', 'categories+name+handyman_services', 'Handyman Services', '', '0', '', 'active'),
('en', 'category', '0', 'categories+title+handyman_services', 'Handyman Services', '', '0', '', 'active'),
('en', 'category', '0', 'categories+name+other_services', 'Other Services', '', '0', '', 'active'),
('en', 'category', '0', 'categories+title+other_services', 'Other Services', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'number_caption_min', 'Min. {field_name}', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'map_listings_request_fail', 'Failed to extract listings to the map.', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'map_listings_request_empty', 'The properties found are no longer available.', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'number_property_found', '{count} properties found', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'count_properties', '{count} properties', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'count_properties_in_location', '{count} properties in this location', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'group_location_hint', 'There is more than one property found in the location, click here to view all properties.', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'no_properties_found', 'No properties found', '', '0', '', 'active'),
('en', 'common', '0', 'map_search_limit_warning', 'Too many ads have been found, please try to narrow down your search criteria or zoom in the map.', '', '0', '', 'active'),
('en', 'admin', '0', 'config+name+map_search_divider', 'Search on Map page', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+map_search_listings_limit', 'Limit of markers on map', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+map_search_listings_limit_mobile', 'Limit of markers on map (mobile)', 'settings', '0', '', 'active'),
('en', 'common', '1', 'short_price_k', 'k', '', '0', '', 'active'),
('en', 'common', '1', 'short_price_m', 'm', '', '0', '', 'active'),
('en', 'common', '1', 'short_price_b', 'b', '', '0', '', 'active'),
('en', 'common', '0', 'search_address', 'Address', '', '0', '', 'active'),
('en', 'common', '0', 'pages+name+search_on_map', 'Search on Map', '', '0', '', 'active'),
('en', 'frontEnd', '0', 'pages+title+search_on_map', 'Search for property on map', '', '0', '', 'active'),
('en', 'common', '0', 'search_forms+name+listings_on_map', 'Search on Map', '', '0', '', 'active'),
('en', 'common', '0', 'search_forms+name+listings_advanced', 'Listings Advanced', '', '0', '', 'active'),
('en', 'common', '0', 'account_fields+name+service_type', 'Service Type', '', '0', '', 'active'),
('en', 'common', '0', 'account_fields+name+service_type_1', 'Buying or Selling', '', '0', '', 'active'),
('en', 'common', '0', 'account_fields+name+service_type_2', 'Buying a Home', '', '0', '', 'active'),
('en', 'common', '0', 'account_fields+name+service_type_3', 'Selling a Home', '', '0', '', 'active'),
('en', 'box', '0', 'blocks+name+ltcategories_listings', 'Property Types', 'ltcategories_listings', '0', '', 'active'),
('en', 'box', '0', 'blocks+name+ltcategories_services', 'Service Categories', 'ltcategories_services', '0', '', 'active'),
('en', 'common', '0', 'search_forms+name+listings_tab1', 'Sale', '', '0', '', 'active'),
('en', 'common', '0', 'search_forms+name+listings_tab2', 'Rent', '', '0', '', 'active'),
('en', 'admin', '0', 'config+name+search_map_location_name', 'Default location', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+des+search_map_location_name', 'Leave the field empty to use visitor location for listings on the Maps.', 'settings', '0', '', 'active'),
('en', 'admin', '0', 'config+name+search_map_location_zoom', 'Default zoom', 'settings', '0', '', 'active');
INSERT INTO `{db_prefix}lang_keys` (`Code`, `Module`, `JS`, `Key`, `Value`, `Target_key`, `Modified`, `Plugin`, `Status`) VALUES
('en', 'common', '0', 'search_forms+name+listings_myads', 'Property', '', '0', '', 'active'),
('en', 'box', '0', 'blocks+name+ltma_listings', 'Search in My Property', 'ltma_listings', '0', '', 'active'),
('en', 'common', '0', 'search_forms+name+services_myads', 'Services', '', '0', '', 'active'),
('en', 'box', '0', 'blocks+name+ltma_services', 'Search in My Services', 'ltma_services', '0', '', 'active'),
('en', 'admin', '0', 'config+name+home_gallery_box', 'Ads in gallery on home page', 'settings', '0', '', 'active'),
('en', 'box', '0', 'blocks+name+ltma_listings', 'Search in My Property', 'ltma_listings', '0', '', 'active'),
('en', 'box', '0', 'blocks+name+ltpb_listings', 'Property Search', 'ltpb_listings', '0', '', 'active'),
('en', 'common', '0', 'enter_a_location', 'Location Filter', '', '0', '', 'active'),
('en', 'common', '0', 'account_types+name+agency', 'Agency', '', '0', '', 'active'),
('en', 'common', '0', 'pages+name+at_agency', 'Agencies', '', '0', '', 'active'),
('en', 'common', '0', 'pages+title+at_agency', 'Agencies', '', '0', '', 'active');

/**
 * @since 4.10.1
 */
INSERT INTO `{db_prefix}lang_keys` (`Code`, `Module`, `JS`, `Key`, `Value`, `Target_key`, `Modified`, `Plugin`, `Status`) VALUES
('en', 'common', '0', 'listing_groups+name+description', 'Description', '', '0', '', 'active');

ALTER TABLE `{db_prefix}listings`
ADD COLUMN `condition` varchar(20) NOT NULL DEFAULT '',
ADD COLUMN `price` varchar(50) NOT NULL DEFAULT '',
ADD COLUMN `address` varchar(250) NOT NULL DEFAULT '',
ADD COLUMN `zip` varchar(11) NOT NULL DEFAULT '',
ADD COLUMN `additional_information` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
ADD COLUMN `time_frame` varchar(50) NOT NULL DEFAULT '',
ADD COLUMN `title` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
ADD COLUMN `categories` varchar(255) NOT NULL DEFAULT '',
ADD COLUMN `posted_by` varchar(50) NOT NULL,
ADD COLUMN `account_address_on_map` enum('0','1') NOT NULL DEFAULT '0',
ADD COLUMN `sale_rent` varchar(255) NOT NULL,
ADD COLUMN `bedrooms` double NOT NULL,
ADD COLUMN `bathrooms` double NOT NULL,
ADD COLUMN `square_feet` varchar(255) NOT NULL,
ADD COLUMN `built_in` varchar(255) NOT NULL,
ADD COLUMN `garage` enum('0','1') NOT NULL DEFAULT '0',
ADD COLUMN `number_of_floors` double NOT NULL,
ADD COLUMN `property_features` varchar(255) NOT NULL,
ADD COLUMN `lot_size` varchar(255) NOT NULL,
ADD COLUMN `phone` varchar(45) NOT NULL,
ADD COLUMN `website_url` varchar(50) NOT NULL;

INSERT INTO `{db_prefix}account_search_relations` (`Position`, `Category_ID`, `Group_ID`, `Field_ID`) VALUES
(1, 19, 0, 53),
(2, 19, 0, 1),
(3, 19, 0, 51),
(4, 19, 0, 52),
(1, 41, 0, 48),
(2, 41, 0, 1),
(3, 41, 0, 51),
(4, 41, 0, 52);

INSERT INTO `{db_prefix}account_grid_form` (`Position`, `Category_ID`, `Group_ID`, `Field_ID`) VALUES
(1, 19, 0, 1),
(2, 19, 0, 52),
(4, 41, 0, 28),
(3, 41, 0, 52),
(2, 41, 0, 51),
(1, 41, 0, 1),
(5, 41, 0, 30);

INSERT INTO `{db_prefix}account_short_form` (`Position`, `Category_ID`, `Group_ID`, `Field_ID`) VALUES
(1, 19, 0, 1),
(2, 19, 0, 52),
(4, 41, 0, 28),
(3, 41, 0, 52),
(2, 41, 0, 51),
(1, 41, 0, 1),
(5, 41, 0, 30);

INSERT INTO `{db_prefix}account_submit_form` (`Position`, `Category_ID`, `Group_ID`, `Field_ID`) VALUES
(1, 19, 0, 46),
(2, 19, 0, 47),
(3, 19, 0, 48),
(4, 19, 0, 53),
(5, 19, 0, 28),
(6, 19, 0, 30),
(7, 19, 0, 1),
(8, 19, 0, 51),
(9, 19, 0, 52),
(10, 19, 0, 25),
(11, 19, 0, 27),
(12, 19, 0, 3),
(8, 41, 0, 27),
(7, 41, 0, 25),
(6, 41, 0, 52),
(5, 41, 0, 51),
(4, 41, 0, 1),
(3, 41, 0, 30),
(2, 41, 0, 28),
(1, 41, 0, 48);

INSERT INTO `{db_prefix}blocks` (`Page_ID`, `Category_ID`, `Subcategories`, `Sticky`, `Cat_sticky`, `Key`, `Position`, `Side`, `Type`, `Content`, `Tpl`, `Header`, `Plugin`, `Status`, `Readonly`, `Options`) VALUES
('307', '', '0', '0', '0', 'ltsb_listings', 55, 'left', 'smarty', '{include file=$refine_block_controller}', '1', '1', '', 'active', '1', ''),
('1', '', '0', '0', '0', 'ltcb_listings', 54, 'middle', 'smarty', 'listings', '1', '1', '', 'active', '1', '{"group_categories":{"type":"boolean","default":false},"categories_style":{"type":"select","default":"grid","values":["column_fill","grid"]},"visible_categories":{"type":"number","default":0,"values":0},"display_subcategories":{"type":"boolean","default":false},"subcategories_number":{"type":"number","default":0,"values":0},"more_subcategories_style":{"type":"select","default":"more_subcategories_popup","values":["more_subcategories_popup","more_subcategories_link"]},"display_counter":{"type":"boolean","default":true}}'),
('307', '', '1', '0', '1', 'ltcategories_listings', 2, 'left', 'smarty', '{include file=$componentDir|cat:"category-box/_category-box.tpl" typePage=true}', '1', '1', '', 'active', '1', '{"categories_style":{"type":"select","default":"column_fill","values":["column_fill","grid"]},"visible_categories":{"type":"number","default":0,"values":0},"display_subcategories":{"type":"boolean","default":true},"subcategories_number":{"type":"number","default":0,"values":0},"more_subcategories_style":{"type":"select","default":"more_subcategories_popup","values":["more_subcategories_popup","more_subcategories_link"]},"display_counter":{"type":"boolean","default":true}}'),
('1', '', '0', '0', '0', 'ltcb_services', 1, 'left', 'smarty', 'services', '1', '1', '', 'active', '1', '{"group_categories":{"type":"boolean","default":false},"categories_style":{"type":"select","default":"grid","values":["column_fill","grid"]},"visible_categories":{"type":"number","default":0,"values":0},"display_subcategories":{"type":"boolean","default":false},"subcategories_number":{"type":"number","default":0,"values":0},"more_subcategories_style":{"type":"select","default":"more_subcategories_popup","values":["more_subcategories_popup","more_subcategories_link"]},"display_counter":{"type":"boolean","default":true}}'),
('329', '', '0', '0', '0', 'ltsb_services', 59, 'left', 'smarty', '{include file=$refine_block_controller}', '1', '1', '', 'active', '1', ''),
('329', '', '1', '0', '1', 'ltcategories_services', 0, 'left', 'smarty', '{include file=$componentDir|cat:"category-box/_category-box.tpl" typePage=true}', '1', '1', '', 'active', '1', '{"categories_style":{"type":"select","default":"column_fill","values":["column_fill","grid"]},"visible_categories":{"type":"number","default":0,"values":0},"display_subcategories":{"type":"boolean","default":true},"subcategories_number":{"type":"number","default":0,"values":0},"more_subcategories_style":{"type":"select","default":"more_subcategories_popup","values":["more_subcategories_popup","more_subcategories_link"]},"display_counter":{"type":"boolean","default":true}}'),
('310', '', '0', '0', '0', 'ltma_listings', 59, 'left', 'smarty', '{include file=\'blocks\'|cat:$smarty.const.RL_DS|cat:\'refine_search.tpl\'}', '1', '1', '', 'active', '1', ''),
('307', '', '0', '0', '1', 'ltpb_listings', 59, 'left', 'smarty', '{include file=\'blocks\'|cat:$smarty.const.RL_DS|cat:\'side_bar_search.tpl\'}', '1', '1', '', 'active', '1', '');

UPDATE `{db_prefix}blocks` SET `Status` = 'trash' WHERE `Key` LIKE 'ltma\_%';

ALTER TABLE `{db_prefix}categories` CHANGE `Type` `Type` ENUM('listings','services') NOT NULL DEFAULT 'listings';

INSERT INTO `{db_prefix}categories` (`ID`, `Position`, `Path`, `Level`, `Tree`, `Parent_ID`, `Type`, `Key`, `Count`, `Lock`, `Add`, `Add_sub`, `Modified`, `Status`) VALUES
(1, 1, 'apartment', 0, '.1', 0, 'listings', 'apartment', 0, '0', '0', '0', NOW(), 'active'),
(2, 2, 'apartment-complex', 0, '.2', 0, 'listings', 'apartment_complex', 0, '0', '0', '0', NOW(), 'active'),
(3, 3, 'beach-property', 0, '.3', 0, 'listings', 'beach_property', 0, '0', '0', '0', NOW(), 'active'),
(4, 4, 'bed-and-breakfast', 0, '.4', 0, 'listings', 'bed_and_breakfast', 0, '0', '0', '0', NOW(), 'active'),
(5, 5, 'bungalow', 0, '.5', 0, 'listings', 'bungalow', 0, '0', '0', '0', NOW(), 'active'),
(6, 6, 'business', 0, '.6', 0, 'listings', 'business', 0, '0', '0', '0', NOW(), 'active'),
(7, 7, 'cabin-cottage', 0, '.7', 0, 'listings', 'cabin_cottage', 0, '0', '0', '0', NOW(), 'active'),
(8, 8, 'castle', 0, '.8', 0, 'listings', 'castle', 0, '0', '0', '0', NOW(), 'active'),
(9, 9, 'chateau', 0, '.9', 0, 'listings', 'chateau', 0, '0', '0', '0', NOW(), 'active'),
(10, 10, 'coastal-property', 0, '.10', 0, 'listings', 'coastal_property', 0, '0', '0', '0', NOW(), 'active'),
(11, 11, 'commercial-property', 0, '.11', 0, 'listings', 'commercial_property', 0, '0', '0', '0', NOW(), 'active'),
(12, 12, 'condo', 0, '.12', 0, 'listings', 'condo', 0, '0', '0', '0', NOW(), 'active'),
(13, 13, 'condo-hotel', 0, '.13', 0, 'listings', 'condo_hotel', 0, '0', '0', '0', NOW(), 'active'),
(14, 14, 'duplex', 0, '.14', 0, 'listings', 'duplex', 0, '0', '0', '0', NOW(), 'active'),
(15, 15, 'farm-ranch', 0, '.15', 0, 'listings', 'farm_ranch', 0, '0', '0', '0', NOW(), 'active'),
(16, 16, 'guest-house', 0, '.16', 0, 'listings', 'guest_house', 0, '0', '0', '0', NOW(), 'active'),
(17, 17, 'hotel', 0, '.17', 0, 'listings', 'hotel', 0, '0', '0', '0', NOW(), 'active'),
(18, 18, 'house', 0, '.18', 0, 'listings', 'house', 0, '0', '0', '0', NOW(), 'active'),
(19, 19, 'inn-lodge', 0, '.19', 0, 'listings', 'inn_lodge', 0, '0', '0', '0', NOW(), 'active'),
(20, 20, 'island', 0, '.20', 0, 'listings', 'island', 0, '0', '0', '0', NOW(), 'active'),
(21, 21, 'loft', 0, '.21', 0, 'listings', 'loft', 0, '0', '0', '0', NOW(), 'active'),
(22, 22, 'villa', 0, '.22', 0, 'listings', 'villa', 0, '0', '0', '0', NOW(), 'active'),
(23, 23, 'other', 0, '.23', 0, 'listings', 'other', 0, '0', '0', '0', NOW(), 'active'),
(55, 55, 'additions-remodels', 0, '.55', 0, 'services', 'additions_remodels', 0, '0', '0', '0', '2012-01-10 19:44:56', 'active'),
(56, 56, 'appliances', 0, '.56', 0, 'services', 'appliances', 0, '0', '0', '0', '2012-01-10 19:54:06', 'active'),
(57, 57, 'builders-architects-desig', 0, '.57', 0, 'services', 'builders_architects_desig', 0, '0', '0', '0', '2012-01-10 19:54:36', 'active'),
(58, 58, 'carpentry-cabinets', 0, '.58', 0, 'services', 'carpentry_cabinets', 0, '0', '0', '0', '2012-01-10 19:55:05', 'active'),
(59, 59, 'cleaning-services', 0, '.59', 0, 'services', 'cleaning_services', 0, '0', '0', '0', '2012-01-10 19:55:27', 'active'),
(60, 60, 'concrete-brick-stone', 0, '.60', 0, 'services', 'concrete_brick_stone', 0, '0', '0', '0', '2012-01-10 19:55:51', 'active'),
(61, 61, 'consumer-guides', 0, '.61', 0, 'services', 'consumer_guides', 0, '0', '0', '0', '2012-01-10 19:56:13', 'active'),
(62, 62, 'design-ideas', 0, '.62', 0, 'services', 'design_ideas', 0, '0', '0', '0', '2012-01-10 19:56:35', 'active'),
(63, 63, 'electrical-telephone-data', 0, '.63', 0, 'services', 'electrical_telephone_data', 0, '0', '0', '0', '2012-01-10 19:56:57', 'active'),
(64, 64, 'expert-advice', 0, '.64', 0, 'services', 'expert_advice', 0, '0', '0', '0', '2012-01-10 19:57:29', 'active'),
(65, 65, 'home-construction', 0, '.65', 0, 'services', 'home_construction', 0, '0', '0', '0', '2012-01-10 19:57:59', 'active'),
(66, 66, 'painting-staining', 0, '.66', 0, 'services', 'painting_staining', 0, '0', '0', '0', '2012-01-10 19:58:24', 'active'),
(67, 67, 'plumbing', 0, '.67', 0, 'services', 'plumbing', 0, '0', '0', '0', '2012-01-10 19:58:51', 'active'),
(68, 68, 'handyman-services', 0, '.68', 0, 'services', 'handyman_services', 0, '0', '0', '0', '2012-01-10 19:59:22', 'active'),
(69, 69, 'other-services', 0, '.69', 0, 'services', 'other_services', 0, '0', '0', '0', '2012-01-10 19:59:44', 'active');

INSERT INTO `{db_prefix}featured_form` (`Position`, `Category_ID`, `Field_ID`) VALUES
(1, 1, 81),
(2, 1, 171),
(3, 1, 2),
(4, 1, 192),
(5, 1, 172),
(6, 1, 193),
(7, 1, 194),
(8, 1, 80),
(1, 55, 81),
(2, 55, 201);

INSERT INTO `{db_prefix}listing_fields` (`ID`, `Key`, `Type`, `Default`, `Values`, `Condition`, `Multilingual`, `Details_page`, `Add_page`, `Required`, `Map`, `Opt1`, `Opt2`, `Autocomplete`, `Status`, `Readonly`) VALUES
(1, 'condition', 'radio', '', '1,2', '', '0', '1', '1', '1', '0', '0', 0, '0', 'active', '0'),
(2, 'price', 'price', '', '', '', '0', '1', '1', '1', '0', '0', 0, '0', 'active', '0'),
(39, 'address', 'text', '0', '254', '', '0', '1', '1', '0', '1', '0', 0, '0', 'active', '0'),
(40, 'zip', 'text', '0', '8', '', '0', '1', '1', '0', '1', '0', 0, '0', 'active', '0'),
(76, 'additional_information', 'textarea', '', '2000', '', '0', '1', '1', '0', '0', '0', 0, '0', 'active', '0'),
(80, 'time_frame', 'radio', '0', '1,2,3,4,5', '', '0', '1', '1', '0', '0', '0', 0, '0', 'active', '0'),
(81, 'title', 'text', '1', '100', '', '0', '0', '1', '1', '0', '0', 0, '0', 'active', '0'),
(88, 'Category_ID', 'select', '', '', '', '0', '1', '1', '0', '0', '0', 0, '1', 'active', '1'),
(107, 'keyword_search', 'text', '', '50', '', '0', '0', '0', '0', '0', '0', 0, '0', 'active', '1'),
(189, 'posted_by', 'select', '', '', '', '0', '1', '1', '0', '0', '0', 0, '0', 'active', '1'),
(190, 'account_address_on_map', 'bool', '0', '', '', '0', '0', '1', '0', '0', '0', 0, '0', 'active', '1'),
(171, 'sale_rent', 'radio', '', '1,2', '', '0', '1', '1', '1', '0', '0', 0, '0', 'active', '0'),
(172, 'bedrooms', 'number', '0', '3', '', '0', '1', '1', '0', '0', '0', 0, '0', 'active', '0'),
(193, 'bathrooms', 'number', '0', '3', '', '0', '1', '1', '0', '0', '0', 0, '0', 'active', '0'),
(194, 'square_feet', 'mixed', '', '', 'unit', '0', '1', '1', '0', '0', '0', 0, '0', 'active', '0'),
(195, 'built_in', 'select', '', '', 'years', '0', '1', '1', '0', '0', '0', 0, '0', 'active', '0'),
(196, 'garage', 'bool', '0', '', '', '0', '1', '1', '0', '0', '0', 0, '0', 'active', '0'),
(197, 'number_of_floors', 'number', '0', '3', '', '0', '1', '1', '0', '0', '0', 0, '0', 'active', '0'),
(198, 'property_features', 'checkbox', '', '1,2,3,4,5,6,7,8,9,10,11', '', '0', '1', '1', '0', '0', '1', 3, '0', 'active', '0'),
(199, 'lot_size', 'mixed', '', '', 'unit', '0', '1', '1', '0', '0', '0', 0, '0', 'active', '0'),
(201, 'phone', 'phone', '4', '7', '1', '0', '1', '1', '0', '0', '1', '', '0', 'active', '0'),
(202, 'website_url', 'text', '', '50', 'isUrl', '0', '1', '1', '0', '0', '0', 0, '0', 'active', '0');

INSERT INTO `{db_prefix}account_fields` (`ID`, `Key`, `Type`, `Default`, `Values`, `Condition`, `Multilingual`, `Details_page`, `Add_page`, `Required`, `Map`, `Opt1`, `Opt2`, `Status`, `Readonly`) VALUES
(53, 'service_type', 'radio', '0', '1,2,3', '', '0', '1', '1', '0', '0', '0', 0, 'active', '0');

ALTER TABLE `{db_prefix}accounts` ADD `service_type` varchar(55) NOT NULL;

INSERT INTO `{db_prefix}listing_groups` (`ID`, `Key`, `Display`, `Columns`, `Header`, `Status`) VALUES
(1, 'common', '1', '1', '1', 'active'),
(8, 'additional_information', '1', '0', '1', 'active'),
(21, 'location', '1', '0', '1', 'active'),
(22, 'description', '1', '0', '0', 'active');

INSERT INTO `{db_prefix}listing_relations` (`Position`, `Category_ID`, `Group_ID`, `Fields`) VALUES
(1, 1, 22, '76'),
(2, 1, 1, '81,171,2,80,172,193,194,197,195,199,196'),
(3, 1, 21, '37,191,192,39,40,190'),
(4, 1, 8, '198'),
(1, 55, 0, '76'),
(2, 55, 1, '81,201,202'),
(3, 55, 21, '37,191,192,40,39,190');

INSERT INTO `{db_prefix}listing_titles` (`Position`, `Category_ID`, `Field_ID`) VALUES
(1, 55, 81),
(1, 1, 81);

INSERT INTO `{db_prefix}listing_types` (`Key`, `Order`, `Add_page`, `Photo`, `Photo_required`, `Video`, `Admin_only`, `Links_type`, `Cat_general_cat`, `Cat_general_only`, `Cat_order_type`, `Cat_custom_adding`, `Cat_show_subcats`, `Cat_hide_empty`, `Search`, `Search_home`, `Search_page`, `Search_type`, `Advanced_search`, `On_map_search`, `Myads_search`, `Submit_method`, `Featured_blocks`, `Arrange_field`, `Arrange_values`, `Arrange_search`, `Arrange_featured`, `Search_multi_categories`, `Search_multicat_levels`, `Search_multicat_phrases`, `Count`, `Show_cents`, `Status`) VALUES
('listings', 1, '0', '1', '1', '1', '0', 'full', 1, '1', 'alphabetic', '1', '1', '0', '1', '1', '1', '1', '1', '1', '1', 'post', '1', 'sale_rent', '1,2', '1', '0', '0', 2, '0', 0, '0', 'active'),
('services', 2, '0', '1', '0', '0', '0', 'full', 55, '1', 'position', '1', '1', '0', '1', '0', '1', '0', '1', '0', '1', 'post', '1', '0', '', '0', '0', '0', 1, '0', 0, '1', 'active');

INSERT INTO `{db_prefix}pages` (`ID`, `Parent_ID`, `Page_type`, `Login`, `Key`, `Position`, `Path`, `Get_vars`, `Controller`, `Tpl`, `Menus`, `Deny`, `Plugin`, `No_follow`, `Modified`, `Status`) VALUES
(310, 0, 'system', '1', 'my_listings', 48, 'my-listings', '', 'my_listings', '1', '2', '', '', '1', NOW(), 'trash'),
(307, 0, 'system', '0', 'lt_listings', 46, 'properties', '', 'listing_type', '1', '1,6', '', '', '0', NOW(), 'active'),
(329, 0, 'system', '0', 'lt_services', 55, 'services', '', 'listing_type', '1', '1', '', '', '0', NOW(), 'active'),
(330, 0, 'system', '1', 'my_services', 56, 'my-services', '', 'my_listings', '1', '2', '', '', '1', NOW(), 'trash'),
(333, 0, 'system', '0', 'search_on_map', 2, 'search-on-map', '', 'search_map', '1', '1,3', '', '', '0', NOW(), 'active'),
(336, 0, 'system', '0', 'at_agency', 74, 'agency-accounts', '', 'account_type', '1', '1', '', '', '0', NOW(), 'active');

DROP TABLE IF EXISTS `{db_prefix}search_forms`;
CREATE TABLE `{db_prefix}search_forms` (
  `ID` int(4) NOT NULL AUTO_INCREMENT,
  `Key` varchar(255) NOT NULL DEFAULT '',
  `Type` enum('listings','services') NOT NULL DEFAULT 'listings',
  `Category_ID` int(11) NOT NULL,
  `Subcategories` enum('0','1') NOT NULL DEFAULT '0',
  `In_tab` enum('0','1') NOT NULL DEFAULT '0',
  `Value` varchar(15) NOT NULL,
  `Order` int(3) NOT NULL,
  `Mode` enum('quick','advanced','myads','custom','in_category','on_map') NOT NULL DEFAULT 'quick',
  `Groups` enum('0','1') NOT NULL DEFAULT '1',
  `With_picture` enum('0','1') NOT NULL DEFAULT '1',
  `Readonly` enum('0','1') NOT NULL DEFAULT '0',
  `Status` enum('active','approval','trash') NOT NULL DEFAULT 'active',
  PRIMARY KEY (`ID`),
  KEY `Key` (`Key`)
) ENGINE=InnoDB CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `{db_prefix}search_forms` (`ID`, `Key`, `Type`, `In_tab`, `Value`, `Order`, `Mode`, `Groups`, `With_picture`, `Readonly`, `Status`) VALUES
(15, 'listings_quick', 'listings', '0', '', 0, 'quick', '0', '1', '1', 'active'),
(16, 'listings_advanced', 'listings', '0', '', 0, 'advanced', '1', '1', '1', 'active'),
(49, 'services_quick', 'services', '0', '', 0, 'quick', '0', '1', '1', 'active'),
(50, 'services_advanced', 'services', '0', '', 0, 'advanced', '1', '1', '1', 'active'),
(51, 'listings_on_map', 'listings', '0', '', 0, 'on_map', '0', '1', '1', 'active'),
(53, 'listings_tab1', 'listings', '1', '1', 1, 'quick', '0', '1', '1', 'active'),
(54, 'listings_tab2', 'listings', '1', '2', 2, 'quick', '0', '0', '1', 'active'),
(56, 'listings_myads', 'listings', '0', '', 0, 'myads', '0', '1', '1', 'active'),
(57, 'services_myads', 'services', '0', '', 0, 'myads', '0', '1', '1', 'active');

INSERT INTO `{db_prefix}search_forms_relations` (`Position`, `Category_ID`, `Group_ID`, `Fields`) VALUES
(1, 50, 0, '189'),
(2, 50, 21, '40,'),
(3, 50, 1, '81,2'),
(1, 51, 0, '39'),
(2, 51, 0, '171'),
(3, 51, 0, '88'),
(4, 51, 0, '172'),
(5, 51, 0, '193'),
(1, 49, 0, '88'),
(2, 49, 0, '37'),
(3, 49, 0, '191'),
(4, 49, 0, '192'),
(1, 16, 0, '88'),
(2, 16, 21, '37,191,192,40'),
(3, 16, 1, '171,2,195,81,197'),
(4, 16, 8, '172,193,196,189'),
(1, 53, 0, '88'),
(2, 53, 0, '37'),
(3, 53, 0, '191'),
(4, 53, 0, '192'),
(5, 53, 0, '2'),
(1, 54, 0, '37'),
(2, 54, 0, '191'),
(3, 54, 0, '192'),
(4, 54, 0, '2'),
(5, 54, 0, '80'),
(1, 15, 0, '88'),
(2, 15, 0, '171'),
(3, 15, 0, '80'),
(4, 15, 0, '37'),
(5, 15, 0, '191'),
(6, 15, 0, '192'),
(7, 15, 0, '2'),
(8, 15, 0, '193'),
(9, 15, 0, '172'),
(1, 56, 0, '88'),
(2, 56, 0, '171'),
(3, 56, 0, '2'),
(4, 56, 0, '195'),
(5, 56, 0, '-3'),
(6, 56, 0, '-1'),
(7, 56, 0, '-2'),
(1, 57, 0, '88'),
(2, 57, 0, '-3'),
(3, 57, 0, '-1'),
(4, 57, 0, '-2');

INSERT INTO `{db_prefix}short_forms` (`Position`, `Category_ID`, `Field_ID`) VALUES
(1, 1, 81),
(2, 1, 2),
(3, 1, 171),
(4, 1, 192),
(5, 1, 172),
(6, 1, 193),
(7, 1, 194),
(8, 1, 80),
(1, 55, 81),
(2, 55, 37),
(3, 55, 191),
(4, 55, 192),
(5, 55, 39),
(6, 55, 201);

DROP TABLE IF EXISTS `{db_prefix}account_types`;
CREATE TABLE `{db_prefix}account_types` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `Key` varchar(255) NOT NULL,
  `Position` int(11) NOT NULL DEFAULT '0',
  `Abilities` set('listings','services') NOT NULL,
  `Page` enum('0','1') NOT NULL,
  `Own_location` enum('0','1') NOT NULL DEFAULT '0',
  `Email_confirmation` enum('0','1') NOT NULL DEFAULT '0',
  `Admin_confirmation` enum('0','1') NOT NULL DEFAULT '0',
  `Auto_login` enum('0','1') NOT NULL DEFAULT '0',
  `Status` enum('active','approval','trash') NOT NULL DEFAULT 'active',
  `Featured_blocks` enum('0','1') NOT NULL DEFAULT '0',
  `Ablock_position` varchar(50) NOT NULL,
  `Alphabetic_field` varchar(255) NOT NULL DEFAULT '',
  `Quick_registration` enum('0','1') NOT NULL DEFAULT '0',
  `Thumb_width` int(3) NOT NULL DEFAULT 110,
  `Thumb_height` int(3) NOT NULL DEFAULT 140,
  `Agency` enum('0','1') NOT NULL DEFAULT '0',
  `Agent` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `Key` (`Key`),
  KEY `Status` (`Status`),
  KEY `Position` (`Position`)
) ENGINE=InnoDB CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `{db_prefix}account_types` (`ID`, `Key`, `Position`, `Abilities`, `Page`, `Own_location`, `Email_confirmation`, `Admin_confirmation`, `Auto_login`, `Status`, `Featured_blocks`, `Ablock_position`, `Alphabetic_field`, `Quick_registration`, `Agency`, `Agent`) VALUES
(1, 'visitor', 9, 'listings,services', '0', '0', '0', '0', '0', 'active', '0', '', '', '0', '0', '0'),
(19, 'dealer', 7, 'listings,services', '1', '1', '1', '1', '0', 'active', '0', '', 'First_name', '1', '0', '1'),
(40, 'buyer', 10, 'listings,services', '0', '0', '1', '0', '0', 'active', '0', '', '', '0', '0', '0'),
(41, 'agency', 11, 'listings,services', '1', '1', '1', '0', '0', 'active', '0', '', '', '0', '1', '0');

DROP TABLE IF EXISTS `{db_prefix}saved_search`;
CREATE TABLE `{db_prefix}saved_search` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `Account_ID` int(11) NOT NULL DEFAULT '0',
  `Form_key` varchar(50) NOT NULL,
  `Listing_type` enum('listings','services') NOT NULL DEFAULT 'listings',
  `Content` text NOT NULL,
  `Date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `Matches` text NOT NULL,
  `Cron` enum('0','1') NOT NULL DEFAULT '0',
  `Status` enum('active','approval','trash') NOT NULL DEFAULT 'active',
  PRIMARY KEY (`ID`),
  KEY `Account_ID` (`Account_ID`,`Status`),
  KEY `Cron` (`Cron`)
) ENGINE=InnoDB CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO  `{db_prefix}config` (`Group_ID`, `Position`, `Key`, `Default`, `Values`, `Type`, `Data_type`, `Plugin`) VALUES
('0', '0', 'search_map_location', '37.7577627,-122.4726194', '', 'text', 'varchar', ''),
('14', '20', 'map_search_divider', '', '', 'divider', '', ''),
('14', '21', 'search_map_location_name', 'San Francisco, CA, USA', '', 'text', 'varchar', ''),
('14', '22', 'search_map_location_zoom', '14', '', 'select', 'int', ''),
('14', '23', 'map_search_listings_limit', '500', '', 'text', 'int', ''),
('14', '24', 'map_search_listings_limit_mobile', '75', '', 'text', 'int', '');

UPDATE `{db_prefix}config` SET `Default` = '0' WHERE `Key` = 'show_cents' LIMIT 1;

INSERT INTO `{db_prefix}hooks` (`Name`, `Class`, `Plugin`, `Code`, `Status`) VALUES
('apTplFooter', 'Realty', '', '', 'active'),
('listingsModifyFieldSearch', 'Realty', '', '', 'active'),
('listingsModifyWhereSearch', 'Realty', '', '', 'active'),
('listingsModifyGroupSearch', 'Realty', '', '', 'active'),
('phpSearchBuildSearchGetRelations', 'Realty', '', '', 'active'),
('phpSearchBuildSearchTop', 'Realty', '', '', 'active'),
('homeBottom', 'Realty', '', '', 'active');

UPDATE `{db_prefix}account_fields` SET `Required` = '1' WHERE `Key` = 'address' LIMIT 1;

UPDATE `{db_prefix}blocks`
SET `Page_ID` = CONCAT(`Page_ID`, ',336')
WHERE `Key` = 'account_page_location';

UPDATE `{db_prefix}blocks`
SET `Page_ID` = CONCAT(`Page_ID`, ',336')
WHERE `Key` = 'account_page_info';

UPDATE `{db_prefix}blocks`
SET `Page_ID` = CONCAT(`Page_ID`, ',336')
WHERE `Key` = 'account_alphabetic_filter';

UPDATE `{db_prefix}blocks`
SET `Page_ID` = CONCAT(`Page_ID`, ',336')
WHERE `Key` = 'account_search';

INSERT INTO `{db_prefix}config` (`Group_ID`, `Position`, `Key`, `Default`, `Values`, `Type`, `Data_type`, `Plugin`) VALUES
(0, 0, 'package_name', 'realty', '', 'text', 'varchar', ''),
(1, 41, 'home_gallery_box', 'listing_box_2', '', 'select', '', '');

UPDATE `{db_prefix}config` SET `Default` = 'ltcb_services' WHERE `Key` = 'home_special_box' LIMIT 1;
