<!-- listing details -->

{if !$errors}

{if $config.map_module && $location.direct}
    {mapsAPI assign='mapAPI'}

    <script>
    rlConfig['mapAPI'] = [];
    rlConfig['mapAPI']['css'] = JSON.parse('{$mapAPI.css|@json_encode}');
    rlConfig['mapAPI']['js']  = JSON.parse('{$mapAPI.js|@json_encode}');
    </script>
{/if}

<div class="listing-details details {if $config.map_module && $location.direct && $photos}loc-exists{/if}">

    {rlHook name='listingDetailsTopTpl'}

    <section class="main-section">
        <div class="top-navigation d-flex justify-content-center">
            {rlHook name='tplListingDetailsNavLeft'}
            {include file=$controllerDir|cat:'listing_details/navigation.tpl'}
            {rlHook name='tplListingDetailsNavRight'}
        </div>

        {if $photos}
            {include file=$componentDir|cat:'listing-details-gallery/_listing-details-gallery.tpl'}
        {/if}
    </section>

    <section class="content-section clearfix">
        <!-- tabs -->
        {if $tabs|@count > 1}
            <ul class="tabs tabs-hash">
                {foreach from=$tabs item='tab' name='tabF'}{strip}
                    <li {if $smarty.foreach.tabF.first}class="active"{/if} id="tab_{$tab.key}">
                        <a href="#{$tab.key}" data-target="{$tab.key}">{$tab.name}</a>
                    </li>
                {/strip}{/foreach}
            </ul>
        {/if}
        <!-- tabs end -->

        <!-- listing details -->
        <div id="area_listing" class="tab_area">
            <h1>{$pageInfo.name}</h1>

            <div class="d-flex flex-wrap align-items-center justify-content-between">
                <!-- price tag -->
                {if $price_tag.value}
                    {foreach from=$listing item='field_group'}
                        {if isset($field_group.Fields.time_frame) && $field_group.Fields.time_frame.value}
                            {assign var='time_frame_value' value=$field_group.Fields.time_frame.value}
                        {/if}

                        {if isset($field_group.Fields.bedrooms) && $field_group.Fields.bedrooms.value}
                            {assign var='bedrooms_name' value=$field_group.Fields.bedrooms.name}
                            {assign var='bedrooms_value' value=$field_group.Fields.bedrooms.value}
                        {/if}

                        {if isset($field_group.Fields.bathrooms) && $field_group.Fields.bathrooms.value}
                            {assign var='bathrooms_name' value=$field_group.Fields.bathrooms.name}
                            {assign var='bathrooms_value' value=$field_group.Fields.bathrooms.value}
                        {/if}

                        {if isset($field_group.Fields.square_feet) && $field_group.Fields.square_feet.value}
                            {assign var='square_feet_name' value=$field_group.Fields.square_feet.name}
                            {assign var='square_feet_value' value=$field_group.Fields.square_feet.value}
                        {/if}
                    {/foreach}

                    <div class="price-tag mb-3" id="df_field_price">
                        {if $price_tag.Options.from}{$lang.price_from}{/if}
                        <span>
                            {if $price_contact_form}
                                <a href="javascript://"
                                    class="contact-owner price-contact-form"
                                    data-listing-id="{$listing_data.ID}"
                                    data-account-id="{$listing_data.Account_ID}"
                                >
                            {/if}
                            {$price_tag.value}
                            {if $price_contact_form}</a>{/if}
                        </span>
                        {if $listing_data.sale_rent == 2 && $time_frame_value}/ {$time_frame_value}{/if}
                    </div>
                {/if}
                <!-- price tag end -->

                {if $bedrooms_value || $bathrooms_value || $square_feet_value}
                    <ul class="card-info mb-3">
                        <li class="services">{strip}
                            {if $bedrooms_value}
                                <span title="{$bedrooms_name}" class="badrooms">{$bedrooms_value}</span>
                            {/if}

                            {if $bathrooms_value}
                                <span title="{$bathrooms_name}" class="bathrooms">{$bathrooms_value}</span>
                            {/if}

                            {if $square_feet_value}
                                <span title="{$square_feet_name}" class="square_feet">{$square_feet_value}</span>
                            {/if}
                        {/strip}</li>
                    </ul>
                {/if}

                <div class="mb-3">
                    {rlHook name='tplListingDetailsRating'}
                </div>
            </div>

            {rlHook name='listingDetailsPreFields'}

            {include file=$controllerDir|cat:'listing_details/details.tpl'}
            {include file=$controllerDir|cat:'listing_details/statistics.tpl'}
        </div>
        <!-- listing details end -->

        {if $config.tell_a_friend_tab}
            <!-- tell a friend tab -->
            <div id="area_tell_friend" class="tab_area hide">
                <div class="content-padding">
                    <div class="submit-cell">
                        <div class="name">{$lang.friend_name} <span class="red">*</span></div>
                        <div class="field"><input class="wauto" type="text" id="friend_name" name="friend_name" maxlength="50" size="30" value="{$smarty.post.friend_name}" /></div>
                    </div>

                    <div class="submit-cell">
                        <div class="name">{$lang.friend_email} <span class="red">*</span></div>
                        <div class="field"><input class="wauto" type="text" id="friend_email" name="friend_email" maxlength="50" size="30" value="{$smarty.post.friend_email}" /></div>
                    </div>

                    <div class="submit-cell">
                        <div class="name">{$lang.your_name}</div>
                        <div class="field"><input class="wauto" type="text" id="your_name" name="your_name" maxlength="100" size="30" value="{$account_info.Full_name}" /></div>
                    </div>

                    <div class="submit-cell">
                        <div class="name">{$lang.your_email}</div>
                        <div class="field"><input class="wauto" type="text" id="your_email" name="your_email" maxlength="30" size="30" value="{$account_info.Mail}" /></div>
                    </div>

                    <div class="submit-cell">
                        <div class="name">{$lang.message}</div>
                        <div class="field"><textarea id="message" name="message" rows="6" cols="50">{$smarty.post.message}</textarea></div>
                    </div>

                    {if $config.security_img_tell_friend}
                    <div class="submit-cell">
                        <div class="name">{$lang.security_code} <span class="red">*</span></div>
                        <div class="field">
                            {include file='captcha.tpl' no_caption=true}
                        </div>
                    </div>
                    {/if}

                    <div class="submit-cell buttons">
                        <div class="name"></div>
                        <div class="field"><input onclick="xajax_tellFriend($('#friend_name').val(), $('#friend_email').val(), $('#your_name').val(), $('#your_email').val(), $('#message').val(), $('#security_code').val(), '{$print.id}');$(this).val('{$lang.loading}');" type="button" name="finish" value="{$lang.send}" /></div>
                    </div>
                </div>
            </div>
            <!-- tell a friend tab end -->
        {/if}

        <!-- tabs content -->
        {rlHook name='listingDetailsBottomTpl'}
        <!-- tabs content end -->
    </section>

    <script class="fl-js-dynamic">
    {if isset($smarty.get.highlight)}
        flynaxTpl.highlightResults("{$smarty.session.keyword_search_data.keyword_search}", true);
    {/if}

    var ld_inactive = {if $pageInfo.Listing_details_inactive}'{$lang.ld_inactive_notice}'{else}false{/if};

    {literal}
        if ($('#df_field_vin .value').length > 0) {
            var html = '<a style="font-size: 14px;" href="javascript:void(0);">{/literal}{if $lang.check_vin}{$lang.check_vin}{else}Check Vin{/if}{literal}</a>';
            var vin = trim( $('#df_field_vin .value').text() );
            var frame = '<iframe scrolling="auto" height="600" frameborder="0" width="100%" src="http://www.carfax.com/cfm/check_order.cfm?vin='+vin+'" style="border: 0pt none;overflow-x: hidden; overflow-y: auto;background: white;"></iframe>';
            var source = '';
        }
    {/literal}
    </script>

    {rlHook name='listingDetailsBottomJs'}

    <script class="fl-js-dynamic">
    {literal}
    $(document).ready(function(){
        if (ld_inactive) {
            printMessage('warning', ld_inactive, false, true);
        }

        $('#df_field_vin .value').append(html);

        $('#df_field_vin .value a').flModal({
            content: frame,
            source: source,
            width: 900,
            height: 640
        });

        flynaxTpl.setupTextarea();
    });

    {/literal}
    </script>

</div>
{else}
    <!-- TODO HERE -->
{/if}

<!-- listing details end -->
